/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.storage.cli.FoundIdentifiables;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.delegation.server.storage.uuc.UUCConfiguration;
import org.oa4mp.server.admin.oauth2.base.BaseClientStoreCommands;
import org.oa4mp.server.admin.oauth2.base.ClientApprovalStoreCommands;
import org.oa4mp.server.admin.oauth2.base.ClientStoreCommands;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.servlet.OA2ClientUtils;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;

public class OA2ClientCommands
extends ClientStoreCommands {
    PermissionsStore permissionsStore;
    UUCConfiguration uucConfiguration;
    boolean refreshTokensEnabled;
    Collection<String> supportedScopes = null;
    public static String NO_STILE_FLAG = "-noStile";
    public static String END_COMMENT_INPUT_CHAR = ".";
    public static String ABORT_COMMENT_INPUT_CHAR = ")";
    public static final String USE_NONSTRICT_SCOPES = "-nonstrict";
    public static String E_CREATE_FLAG = "-create";
    public static String E_LINK_FLAG = "-link";
    public static String E_LIST_FLAG = "-list";
    public static String E_LIST_AS_ARRAY_FLAG = "-array";
    public static String E_LIST_AS_JSON_FLAG = "-json";
    public static String E_LIST_AS_MULTILINE_FLAG = "-m";
    public static String E_UNLINK_FLAG = "-unlink";
    public static String E_ADMIN_ID_FLAG = "-adminID";
    public static final int ERSATZ_CREATE_MAGIC_NUMBER = 1;

    public OA2ClientCommands(CLIDriver driver, String defaultIndent, Store clientStore, ClientApprovalStoreCommands clientApprovalStoreCommands, PermissionsStore permissionsStore) throws Throwable {
        super(driver, defaultIndent, clientStore, clientApprovalStoreCommands);
        this.setPermissionsStore(permissionsStore);
    }

    public PermissionsStore getPermissionsStore() {
        return this.permissionsStore;
    }

    public void setPermissionsStore(PermissionsStore permissionsStore) {
        this.permissionsStore = permissionsStore;
    }

    public UUCConfiguration getUucConfiguration() {
        return this.uucConfiguration;
    }

    public void setUucConfiguration(UUCConfiguration uucConfiguration) {
        this.uucConfiguration = uucConfiguration;
    }

    public boolean isRefreshTokensEnabled() {
        return this.refreshTokensEnabled;
    }

    public void setRefreshTokensEnabled(boolean refreshTokensEnabled) {
        this.refreshTokensEnabled = refreshTokensEnabled;
    }

    public Collection<String> getSupportedScopes() {
        return this.supportedScopes;
    }

    public void setSupportedScopes(Collection<String> supportedScopes) {
        this.supportedScopes = supportedScopes;
    }

    @Override
    public void print_help() throws Exception {
        super.print_help();
        this.say("-- Client specific commands:");
        this.sayi("cb = manage the callbacks directly");
    }

    protected void showCBHelp() {
        this.say("cb -add [cb1, cb2,...] index =  add a list of callbacks to the given list of callbacks. If no list is given, you will be prompted");
        this.say("cb -list /index = list the callbacks for a given client");
        this.say("cb -rm [cb1, cb2,...] /index = remove the given callbacks from the client.");
        this.say("Note that you must supply a list of callbacks");
        this.say("\nE.g. to add a a few callbacks you would invoke");
        this.say("cb -add [https://foo1, https://foo2,https://foo3 /oa4mp:client/id/234234234234]");
        this.say("\nThis adds the three urls to the current list for the client with the given id.");
        this.printIndexHelp(true);
    }

    public void cb(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showCBHelp();
            return;
        }
        boolean gotOne = false;
        OA2Client client = (OA2Client)this.findSingleton(inputLine);
        if (inputLine.hasArg("-add")) {
            gotOne = true;
            List cbs = inputLine.getArgList("-add");
            client.getCallbackURIs().addAll(cbs);
            this.getStore().save((Identifiable)client);
            return;
        }
        if (inputLine.hasArg("-rm")) {
            gotOne = true;
            List cbs = inputLine.getArgList("-rm");
            Collection storedCBs = client.getCallbackURIs();
            ArrayList<String> target = new ArrayList<String>(storedCBs.size());
            for (String cb : storedCBs) {
                if (cbs.contains(cb)) continue;
                target.add(cb);
            }
            client.setCallbackURIs(target);
            this.getStore().save((Identifiable)client);
            return;
        }
        if (inputLine.hasArg("-list")) {
            gotOne = true;
            this.say("list of callbacks for this client:");
            for (String x : client.getCallbackURIs()) {
                this.say("  " + x);
            }
            return;
        }
        if (!gotOne) {
            this.say("Sorry, no command found. Show help for this topic if you need to.");
        }
    }

    @Override
    public void extraUpdates(Identifiable identifiable, int magicNumber) throws IOException {
        JSONObject newConfig;
        boolean doCfg;
        String uris;
        String scopes;
        OA2ClientKeys keys = (OA2ClientKeys)this.getSerializationKeys();
        OA2Client oa2Client = (OA2Client)identifiable;
        super.extraUpdates((Identifiable)oa2Client, magicNumber);
        String DEFAULT_SERVER_VALUE = "default";
        String rawAT = oa2Client.getAtLifetime() == -1L ? "default" : Long.toString(oa2Client.getAtLifetime());
        rawAT = this.getPropertyHelp(keys.atLifetime(new String[0]), "enter access token lifetime in seconds or default", rawAT);
        if (rawAT.equals("default")) {
            oa2Client.setAtLifetime(-1L);
        } else {
            try {
                oa2Client.setAtLifetime(Long.parseLong(rawAT) * 1000L);
            }
            catch (Throwable t) {
                this.say("  could not parse " + rawAT + ", using server default");
                oa2Client.setAtLifetime(-1L);
            }
        }
        rawAT = oa2Client.getMaxATLifetime() == -1L ? "default" : Long.toString(oa2Client.getMaxATLifetime());
        rawAT = this.getPropertyHelp(keys.maxATLifetime(new String[0]), "  enter max access token lifetime in seconds or default", rawAT);
        if (rawAT.equals("default")) {
            oa2Client.setMaxRTLifetime(-1L);
        } else {
            try {
                oa2Client.setMaxATLifetime(Long.parseLong(rawAT) * 1000L);
            }
            catch (Throwable tt) {
                this.say("  could not parse " + rawAT + ", using server default");
                oa2Client.setMaxATLifetime(-1L);
            }
        }
        if (this.isRefreshTokensEnabled()) {
            String RT_DISABLED = "none";
            String rtString = oa2Client.getRtLifetime() == -1L ? "default" : (oa2Client.getRtLifetime() == 0L ? "none" : Long.toString(oa2Client.getMaxRTLifetime()));
            Object rawLifetime = this.getPropertyHelp(keys.rtLifetime(new String[0]), "enter the refresh lifetime in sec., none, or default", rtString);
            switch (rawLifetime) {
                case "none": {
                    oa2Client.setRtLifetime(0L);
                    break;
                }
                case "default": {
                    oa2Client.setRtLifetime(-1L);
                    break;
                }
                default: {
                    try {
                        oa2Client.setRtLifetime(Long.parseLong((String)rawLifetime) * 1000L);
                        break;
                    }
                    catch (Throwable t) {
                        this.sayi("Could not parse \"" + (String)rawLifetime + "\", no change.");
                    }
                }
            }
            rawLifetime = oa2Client.getMaxRTLifetime() == -1L ? "default" : Long.toString(oa2Client.getMaxRTLifetime());
            rawLifetime = this.getPropertyHelp(keys.maxRTLifetime(new String[0]), "  enter max refresh token lifetime in seconds or default", (String)rawLifetime);
            if (((String)rawLifetime).equals("default")) {
                oa2Client.setMaxRTLifetime(-1L);
            } else {
                try {
                    oa2Client.setMaxRTLifetime(Long.parseLong((String)rawLifetime));
                }
                catch (Throwable t) {
                    this.say(" could not parse \"" + (String)rawLifetime + "\", no change");
                }
            }
            long rtGracePeriod = oa2Client.getRtGracePeriod();
            rawLifetime = rtGracePeriod == OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_DISABLED ? "none" : (rtGracePeriod == OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_USE_SERVER_DEFAULT ? "default" : (rtGracePeriod == OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_NOT_CONFIGURED ? Long.toString(OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_DEFAULT) : Long.toString(rtGracePeriod)));
            switch (rawLifetime = this.getPropertyHelp(keys.rtGracePeriod(new String[0]), "  enter grace period in sec., none, or default", (String)rawLifetime)) {
                case "none": {
                    oa2Client.setRtGracePeriod(OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_DISABLED);
                    break;
                }
                case "default": {
                    oa2Client.setRtGracePeriod(OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_USE_SERVER_DEFAULT);
                    break;
                }
                default: {
                    try {
                        oa2Client.setRtGracePeriod(Long.parseLong((String)rawLifetime));
                        break;
                    }
                    catch (Throwable t) {
                        this.say("could not parse \"" + (String)rawLifetime + "\", no change");
                    }
                }
            }
        }
        oa2Client.setPublicClient(this.getPropertyHelp(keys.publicClient(new String[0]), "is this client public (y/n)?", Boolean.toString(oa2Client.isPublicClient())).equalsIgnoreCase("y"));
        Object currentScopes = null;
        if (oa2Client.getScopes() != null) {
            boolean firstPass = true;
            for (String x : oa2Client.getScopes()) {
                if (firstPass) {
                    firstPass = false;
                    currentScopes = x;
                    continue;
                }
                currentScopes = currentScopes + "," + x;
            }
        }
        if ((scopes = this.getPropertyHelp(keys.scopes(new String[0]), "enter a comma separated list of scopes. Other scopes to this server will be rejected.", (String)currentScopes)) != null && !scopes.isEmpty()) {
            LinkedList<String> list = new LinkedList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(scopes, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String raw = stringTokenizer.nextToken().trim();
                if (this.getSupportedScopes().contains(raw)) {
                    list.add(raw);
                    continue;
                }
                this.say("Unknown scope \"" + raw + "\" rejected.");
            }
            oa2Client.setScopes(list);
        }
        oa2Client.setStrictscopes(this.getPropertyHelp(keys.strictScopes(new String[0]), "strict scopes (y/n)", "y").equalsIgnoreCase("y"));
        Object currentUris = null;
        if (oa2Client.getCallbackURIs() != null) {
            boolean firstPass = true;
            for (String x : oa2Client.getCallbackURIs()) {
                if (firstPass) {
                    firstPass = false;
                    currentUris = x;
                    continue;
                }
                currentUris = currentUris + "," + x;
            }
        }
        if (!StringUtils.isTrivial((String)(uris = this.getPropertyHelp(keys.callbackUri(new String[0]), "enter a comma separated list of callback uris. These must start with https or they will be ignored.", (String)currentUris)))) {
            StringTokenizer stringTokenizer = new StringTokenizer(uris, ",");
            LinkedList<String> rawCBs = new LinkedList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                rawCBs.add(stringTokenizer.nextToken().trim());
            }
            LinkedList dudURIs = new LinkedList();
            LinkedList foundURIs = null;
            try {
                foundURIs = OA2ClientUtils.createCallbacks(rawCBs, dudURIs);
            }
            catch (IOException iox) {
                this.say("Sorry, there was an error processing the uris:\"" + iox.getMessage() + "\"");
                return;
            }
            if (0 < dudURIs.size()) {
                this.say(dudURIs.size() + " uris rejected:");
                for (String dud : dudURIs) {
                    this.say("  " + dud);
                }
            }
            if (foundURIs == null) {
                this.say("There was an error processing the URIs");
                return;
            }
            oa2Client.setCallbackURIs((Collection)foundURIs);
        }
        if (this.getInput("do advanced options (y/n)?", "n").equalsIgnoreCase("y")) {
            JSONArray newLDAPS;
            String signTokens;
            String issuer;
            boolean configProxies;
            boolean isServiceClient = this.getPropertyHelp(keys.rfc7523Client(new String[0]), "service client (y/n)?", "n").equalsIgnoreCase("y");
            if (isServiceClient) {
                oa2Client.setServiceClient(true);
                oa2Client.setServiceClientUsers(this.processCommaSeparatedList(keys.rfc7523ClientUsers(new String[0]), "allowed users", "*"));
            }
            if (configProxies = this.isOk(this.getInput("configure proxies (y/n)?", "n"))) {
                oa2Client.setForwardScopesToProxy(this.isOk(keys.forwardScopesToProxy(new String[0]) + " (y/n)?"));
                if (!oa2Client.isForwardScopesToProxy()) {
                    oa2Client.setProxyRequestScopes(this.processCommaSeparatedList(keys.proxyRequestScopes(new String[0]), "scopes", "*"));
                }
                oa2Client.setProxyClaimsList(this.processCommaSeparatedList(keys.proxyClaimsList(new String[0]), "claims", "*"));
            }
            if (!this.isEmpty(issuer = this.getPropertyHelp(keys.issuer(new String[0]), "enter the issuer (optional)", oa2Client.getIssuer()))) {
                oa2Client.setIssuer(issuer);
            }
            if (this.getPropertyHelp(keys.ersatzClient(new String[0]), "is ersatz client (y/n)?", "n").equalsIgnoreCase("y")) {
                oa2Client.setErsatzClient(true);
                oa2Client.setExtendsProvisioners(this.getPropertyHelp(keys.extendsProvisioners(new String[0]), "  extends the provisioner (y/n)?", "y").equalsIgnoreCase("y"));
                oa2Client.setErsatzInheritIDToken(this.getPropertyHelp(keys.ersatzInheritIDToken(new String[0]), "  inherit the ID token from the provisioner on fork(y/n)?", "y").equalsIgnoreCase("y"));
                this.say("  To link this client to its provisioners, use the ersatz command");
            } else {
                oa2Client.setErsatzClient(false);
            }
            List<String> prototypes = this.processCommaSeparatedList(keys.prototypes(new String[0]), "prototypes", "");
            if (!prototypes.isEmpty()) {
                ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
                ArrayList<String> bad = new ArrayList<String>();
                for (String p : prototypes) {
                    try {
                        identifiers.add(BasicIdentifier.newID((String)p));
                    }
                    catch (Throwable t) {
                        bad.add(p);
                    }
                }
                oa2Client.setPrototypes(identifiers);
                if (!bad.isEmpty()) {
                    this.say("  rejected the following bad identifier(s):" + String.valueOf(bad));
                }
            }
            if (!this.isEmpty(signTokens = this.getPropertyHelp(keys.signTokens(new String[0]), "Enable ID token signing (true/false)?", Boolean.toString(oa2Client.isSignTokens())))) {
                try {
                    oa2Client.setSignTokens(Boolean.parseBoolean(signTokens));
                }
                catch (Throwable t) {
                    this.sayi("Unknown response of \"" + signTokens + "\". Must be \"true\" or \"false\", ignoring.");
                }
            }
            JSONArray currentLDAPs = null;
            LDAPConfigurationUtil ldapConfigurationUtil = new LDAPConfigurationUtil();
            if (oa2Client.getLdaps() != null && !oa2Client.getLdaps().isEmpty() && (newLDAPS = (JSONArray)this.inputJSON((JSON)(currentLDAPs = ldapConfigurationUtil.toJSON(oa2Client.getLdaps())), "ldap configuration", true)) != null) {
                oa2Client.setLdaps(ldapConfigurationUtil.fromJSON(newLDAPS));
            }
        }
        if ((doCfg = this.getPropertyHelp(keys.cfg(new String[0]), "edit \"" + keys.cfg(new String[0]) + "\" (as JSON)? (y/n)", "n").equalsIgnoreCase("y")) && (newConfig = this.inputJSON(oa2Client.getConfig(), "client configuration")) != null) {
            oa2Client.setConfig(newConfig);
        }
    }

    protected List<String> processCommaSeparatedList(String key, String moniker, String defaultValue) throws IOException {
        return this.processCommaSeparatedList(key, null, moniker, defaultValue);
    }

    protected List<String> processCommaSeparatedList(String key, List<String> legalValues, String moniker, String defaultValue) throws IOException {
        String rawValues = this.getPropertyHelp(key, "enter a comma separated list of " + moniker + ".", defaultValue);
        LinkedList<String> list = new LinkedList<String>();
        if (StringUtils.isTrivial((String)rawValues)) {
            return list;
        }
        if (rawValues.equals(defaultValue)) {
            list.add(defaultValue);
            return list;
        }
        LinkedList<String> omitted = new LinkedList<String>();
        if (rawValues != null && !rawValues.isEmpty()) {
            StringTokenizer stringTokenizer = new StringTokenizer(rawValues, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String raw = stringTokenizer.nextToken().trim();
                if (legalValues != null) {
                    if (legalValues.contains(raw)) {
                        list.add(raw);
                        continue;
                    }
                    omitted.add(raw);
                    continue;
                }
                list.add(raw);
            }
        }
        if (!omitted.isEmpty()) {
            this.say("  omitted values:" + String.valueOf(omitted));
        }
        return list;
    }

    protected void showDeserializeHelp() {
        super.showDeserializeHelp();
        this.say("NOTE that for clients, the assumption is that you are supplying the hashed secret, not the actual secret.");
        this.say("If you need to create a hash of a secret, invoke the create_hash method on the secret");
    }

    public OA2ClientCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    protected Object updateSingleValue(XMLMap map, String key) throws IOException {
        String currentValue = map.getString(key);
        OA2ClientKeys keys = (OA2ClientKeys)this.getSerializationKeys();
        if (currentValue == null && key.equals(keys.cfg(new String[0]))) {
            map.put(key, (Object)"{}");
        }
        return super.updateSingleValue(map, key);
    }

    public void get_comment(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("get_comment [" + NO_STILE_FLAG + "] index- display the comment for a give object");
            this.say(NO_STILE_FLAG + " - do not show the stile (|) when printing comments");
            this.printIndexHelp(false);
            this.say("See also: set_comment");
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null) {
            this.say("Object not found");
            return;
        }
        boolean noStile = inputLine.hasArg(NO_STILE_FLAG);
        for (Identifiable identifiable : identifiables) {
            OA2Client oa2Client = (OA2Client)identifiable;
            this.say(oa2Client.getIdentifierString());
            List comments = oa2Client.getComment();
            if (comments == null || comments.isEmpty()) {
                this.say("(no comments)");
                return;
            }
            for (String comment : comments) {
                this.say((noStile ? "" : "|") + comment);
            }
            if (1 >= identifiables.size()) continue;
            this.say("");
        }
    }

    public void set_comment(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("set_comment index- input a comment line by line");
            this.say("Note that input ends when the very first character on a line is a " + END_COMMENT_INPUT_CHAR);
            this.say("Note that if you want to abort, the first character on a line is a " + ABORT_COMMENT_INPUT_CHAR);
            this.printIndexHelp(true);
            this.say("See also: get_comment");
            return;
        }
        OA2Client oa2Client = (OA2Client)this.findSingleton(inputLine);
        this.say("Input your comment. Starting a line with a " + END_COMMENT_INPUT_CHAR + " ends input, " + ABORT_COMMENT_INPUT_CHAR + " aborts input.");
        ArrayList<String> comments = new ArrayList<String>();
        String comment = this.readline();
        while (!comment.startsWith(END_COMMENT_INPUT_CHAR)) {
            if (comment.startsWith(ABORT_COMMENT_INPUT_CHAR)) {
                this.say("input aborted. returning...");
                return;
            }
            comments.add(comment);
            comment = this.readline();
        }
        oa2Client.setComment(comments);
        this.getStore().save((Identifiable)oa2Client);
    }

    public void resolve(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.sayi("resolve index - resolve a client from its prototypes (if any) and show it");
            this.printIndexHelp(false);
            this.sayi("See also: serialize");
            return;
        }
        OA2Client oa2Client = OA2ClientUtils.resolvePrototypes((ClientStore)((ClientStore)this.getStore()), (OA2Client)((OA2Client)this.findSingleton(inputLine)));
        this.longFormat((Identifiable)oa2Client, true);
    }

    protected void showSerializeHelp() {
        this.say("serialize  [-file path] [-resolve] index");
        this.sayi("Usage: XML serializes an object and either shows it on the ");
        this.sayi("   command line or put it in a file. Cf. deserialize.");
        this.sayi("-resolve - if this has prototypes, resolve them all and serialize the ");
        this.sayi("   resulting object");
        this.printIndexHelp(true);
        this.sayi("See also: deserialize.");
    }

    public void serialize(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showSerializeHelp();
            return;
        }
        Identifiable identifiable = this.findSingleton(inputLine, "client not found");
        if (inputLine.hasArg("-resolve")) {
            identifiable = OA2ClientUtils.resolvePrototypes((ClientStore)((ClientStore)this.getStore()), (OA2Client)((OA2Client)this.findSingleton(inputLine)));
        }
        this.serialize(inputLine, identifiable);
    }

    public void ea_support(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("ea_support [arg] index - show or toggle client extended attribute support");
            this.say(" if arg is missing, show the current value");
            this.say(" if arg is present it must be one of on|true or off|false");
            this.say("extended attributes are namespace qualified attributes that a client may");
            this.say("pass in and are simply forwarded to the scripting engine in the variable xas.");
            this.say("EA support is not stored in a regular DB column but ina special structure.");
            this.say("This utility is the only to reliably interact with it.");
            this.say("The effect is to toggle whether EAs in a request are passed along to the runtime envirnoment");
            this.say("or not. You do not set EAs here, but let the policy handle what it gets.");
            this.printIndexHelp(false);
            this.say("E.g.");
            this.say("A typical use would be to pass along the parameter oa4mp:/tokens/access/lifetime=900000");
            this.say("which would result in the value for xas. of ");
            this.say("{oa4mp:\n  {/tokens/access/lifetime:900000}\n}");
            this.say("in the QDL runtime environment. OA4MP does nothing with these except pass them through.");
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null) {
            this.say("object not found");
            return;
        }
        if (!inputLine.hasArgs()) {
            for (Identifiable identifiable : identifiables) {
                if (identifiables.isRS()) {
                    identifiable = (Identifiable)this.getStore().get((Object)identifiable.getIdentifier());
                }
                this.say("(" + ((OA2Client)identifiable).hasExtendedAttributeSupport() + ")  " + identifiable.getIdentifierString());
            }
            return;
        }
        String action = "";
        String ACTION_ENABLE = "enabled";
        String ACTION_DISABLE = "disabled";
        action = inputLine.getLastArg().equalsIgnoreCase("on") || inputLine.getLastArg().equalsIgnoreCase("true") ? "enabled" : (inputLine.getLastArg().equalsIgnoreCase("off") || inputLine.getLastArg().equalsIgnoreCase("false") ? "disabled" : inputLine.getLastArg());
        for (Identifiable identifiable : identifiables) {
            if (identifiables.isRS()) {
                identifiable = (Identifiable)this.getStore().get((Object)identifiable.getIdentifier());
            }
            OA2Client client = (OA2Client)identifiable;
            switch (action) {
                case "enabled": {
                    client.setExtendedAttributeSupport(true);
                    break;
                }
                case "disabled": {
                    client.setExtendedAttributeSupport(false);
                    break;
                }
                default: {
                    this.say("unknown action \"" + action + "\", aborting");
                    return;
                }
            }
            this.getStore().save((Identifiable)client);
        }
        this.say(identifiables.size() + " clients ea_support " + action);
    }

    protected void initHelp() throws Throwable {
        super.initHelp();
        this.getHelpUtil().load("/help/client_help.xml");
    }

    @Override
    protected BaseClientStoreCommands.ApprovalModsConfig createApprovalModsConfig(InputLine inputLine, BaseClient client, boolean doPrompt) {
        boolean useStrictScopes = !inputLine.hasArg(USE_NONSTRICT_SCOPES);
        inputLine.removeSwitch(USE_NONSTRICT_SCOPES);
        return new OA2ClientApprovalMods(client, doPrompt, useStrictScopes);
    }

    @Override
    protected BaseClient doApprovalMods(BaseClientStoreCommands.ApprovalModsConfig approvalModsConfig) throws IOException {
        OA2Client oa2Client = (OA2Client)approvalModsConfig.client;
        if (approvalModsConfig.doPrompt) {
            OA2ClientKeys keys = (OA2ClientKeys)this.getSerializationKeys();
            oa2Client.setStrictscopes(this.getPropertyHelp(keys.strictScopes(new String[0]), "strict scopes?(y/n)", oa2Client.useStrictScopes() ? "y" : "n").equalsIgnoreCase("y"));
        } else {
            oa2Client.setStrictscopes(((OA2ClientApprovalMods)approvalModsConfig).useStrictScopes);
        }
        return oa2Client;
    }

    @Override
    protected void showApproveHelp() {
        this.say("approve item -- interactively approve a single client");
        this.say("approve [-approved true | false] [-nonstrict ] -approver username item --  approve/unapprove a result set");
        this.say("-nonstrict = if present, grant the client non-strict scopes. Default si strict scopes.");
        this.say("-approved = true (default), set the client as approved. If false, unapprove it.");
        this.say("-approver userName = (required) the name of the approver. If missing you will be prompted.");
        this.printIndexHelp(false);
    }

    protected void showErsatzHelp() {
        this.say("Create, link, unlink or list ersatz clients");
        this.say("ersatz " + E_CREATE_FLAG + " [new_id] [" + E_LINK_FLAG + "] [" + E_ADMIN_ID_FLAG + " admin_id] [provisioner_id] - create a new ersatz client, ");
        this.say("     optionally linking it to the provisioner. Note that if you do not supply an admin id and the provisioner is administered,");
        this.say("     then the new ersatz client will be added to the admin. If there is no admin, then none will be specified");
        this.say("     Finally, if the provisioner has multiple admins, this specifies which to use or the request will be rejected.");
        this.say("ersatz " + E_LIST_FLAG + " [" + E_LIST_AS_MULTILINE_FLAG + " | " + E_LIST_AS_ARRAY_FLAG + " | " + E_LIST_AS_JSON_FLAG + "] [provisioner_id] - list the ersatz clients associated with this provisioner");
        this.say("     Optionally list any chains as arrays, a json array or the (default) multi-line format");
        this.say("ersatz " + E_LINK_FLAG + " ersatz_id | [e0,e1,...] [" + E_ADMIN_ID_FLAG + " adminID] [provisioner_id]- link an existing ersatz client/chain to the current one");
        this.say("ersatz " + E_UNLINK_FLAG + " ersatz_id | [e0,e1,...] [" + E_ADMIN_ID_FLAG + " adminID] [provisioner_id] - unlink the ersatz client from this client. It does not do anything to the ersatz client.");
        this.printIndexHelp(true);
        this.say();
        this.say("Note that listing the ersatz clients lists the chains of them, so a typical output might be");
        this.say("client_id_1");
        this.say("  client_id_2");
        this.say("    client_id_3");
        this.say("client_id_1");
        this.say("  client_id_1a");
        this.say("    client_id_5");
        this.say("which means that for this client the chains are client_id_1->client_id_2->client_id_3 and ");
        this.say("client_is_1->client_id_1a->client_id_5.");
        this.say("Note that indenting sets off the chain, no indents means there is simply the client without others");
        this.say("Note that the " + E_LINK_FLAG + " and " + E_UNLINK_FLAG + " commands take either a single ersatz id");
        this.say("or an ordered chain (as a  list) of them. Note that if linking, each ersatz client will be added to the");
        this.say("admin's client list.");
    }

    public void ersatz(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showErsatzHelp();
            return;
        }
        boolean createClient = inputLine.hasArg(E_CREATE_FLAG);
        inputLine.removeSwitch(E_CREATE_FLAG);
        boolean hasAdminID = inputLine.hasArg(E_ADMIN_ID_FLAG);
        Identifier adminID = null;
        if (hasAdminID) {
            adminID = BasicIdentifier.newID((String)inputLine.getNextArgFor(E_ADMIN_ID_FLAG));
        }
        inputLine.removeSwitch(E_ADMIN_ID_FLAG);
        boolean listAsJSON = inputLine.hasArg(E_LIST_AS_JSON_FLAG);
        inputLine.removeSwitch(E_LIST_AS_JSON_FLAG);
        boolean listAsArray = inputLine.hasArg(E_LIST_AS_ARRAY_FLAG);
        inputLine.removeSwitch(E_LIST_AS_ARRAY_FLAG);
        boolean listAsMultiline = inputLine.hasArg(E_LIST_AS_MULTILINE_FLAG);
        inputLine.removeSwitch(E_LIST_AS_MULTILINE_FLAG);
        boolean linkClient = inputLine.hasArg(E_LINK_FLAG);
        ArrayList<Object> linkList = null;
        if (linkClient) {
            if (!createClient) {
                if (inputLine.hasArgList(E_LINK_FLAG)) {
                    List rawIDs = inputLine.getArgList(E_LINK_FLAG);
                    linkList = new ArrayList();
                    for (Object s : rawIDs) {
                        linkList.add(BasicIdentifier.newID((String)s));
                    }
                } else {
                    linkList = new ArrayList<Identifier>();
                    linkList.add(BasicIdentifier.newID((String)inputLine.getNextArgFor(E_LINK_FLAG)));
                }
            }
            inputLine.removeSwitch(E_LINK_FLAG);
        }
        boolean unlinkClient = inputLine.hasArg(E_UNLINK_FLAG);
        if (linkClient && unlinkClient) {
            this.say("you cannot both link and unlink a client at the same time");
            return;
        }
        if (unlinkClient) {
            if (inputLine.hasArgList(E_UNLINK_FLAG)) {
                List rawIDs = inputLine.getArgList(E_UNLINK_FLAG);
                linkList = new ArrayList();
                for (String s : rawIDs) {
                    linkList.add(BasicIdentifier.newID((String)s));
                }
            } else {
                linkList = new ArrayList();
                linkList.add(BasicIdentifier.newID((String)inputLine.getNextArgFor(E_UNLINK_FLAG)));
            }
            inputLine.removeSwitch(E_UNLINK_FLAG);
        }
        if (createClient) {
            unlinkClient = false;
        }
        boolean listClients = inputLine.hasArg(E_LIST_FLAG);
        inputLine.removeSwitch(E_LIST_FLAG);
        OA2Client provisioner = (OA2Client)this.findSingleton(inputLine);
        inputLine.removeSwitch(provisioner.getIdentifierString());
        if (provisioner == null) {
            this.say("could not find the provisioner...");
            return;
        }
        if (adminID == null) {
            List admins = this.getPermissionsStore().getAdmins(provisioner.getIdentifier());
            if (1 < admins.size()) {
                this.say("ambiguous case: too many admins for this client. Cannot tell which to link to");
                return;
            }
            if (1 == admins.size()) {
                adminID = (Identifier)admins.get(0);
            }
        }
        if (listClients) {
            boolean arrayOutput;
            if (provisioner == null) {
                this.say("no such client");
                return;
            }
            boolean bl = arrayOutput = listAsArray || listAsJSON;
            if (!arrayOutput && !listAsMultiline) {
                listAsMultiline = true;
            }
            PermissionList pList = this.getPermissionsStore().getErsatzChains(adminID, provisioner.getIdentifier());
            for (Permission permission : pList) {
                JSONArray jsonArray = new JSONArray();
                Object cliArray = "[";
                boolean firstPass = true;
                if (permission.canSubstitute()) {
                    List eChain = permission.getErsatzChain();
                    int indent = 0;
                    for (Identifier ee : eChain) {
                        if (listAsJSON) {
                            jsonArray.add((Object)ee.toString());
                        }
                        if (listAsArray) {
                            if (firstPass) {
                                firstPass = false;
                            }
                            cliArray = (String)cliArray + ee.toString();
                        }
                        if (!listAsMultiline) continue;
                        this.say(StringUtils.getBlanks((int)(2 * indent++)) + String.valueOf(ee));
                    }
                }
                if (listAsArray) {
                    this.say((String)cliArray + "]");
                }
                if (listAsJSON) {
                    this.say(jsonArray.toString());
                }
                if (!listAsMultiline) continue;
                this.say();
            }
            return;
        }
        if (createClient) {
            OA2Client createdClient;
            OA2Client c = (OA2Client)this.getStore().create();
            if (0 < inputLine.getArgCount()) {
                c = (OA2Client)this.setIDFromInputLine((Identifiable)c, inputLine);
            }
            if ((createdClient = (OA2Client)this.create((Identifiable)c, 1)) == null) {
                return;
            }
            if (linkClient) {
                linkList = new ArrayList();
                linkList.add(createdClient.getIdentifier());
                this.linkErsatz(provisioner, adminID, linkList);
                this.say("ersatz client linked, done.");
            } else {
                this.say("client created, not linked. done.");
            }
            return;
        }
        if (linkClient) {
            this.linkErsatz(provisioner, adminID, linkList);
            this.say("linking done!");
            return;
        }
        if (unlinkClient) {
            this.unlinkErsatz(provisioner, adminID, linkList);
            this.say("unlink done!");
            return;
        }
        this.say("unknown/missing option");
    }

    protected void linkErsatz(OA2Client provisioner, Identifier adminID, List<Identifier> ersatz) {
        for (Identifier id : ersatz) {
            PermissionList permissions;
            PermissionList pList = this.getPermissionsStore().get(adminID, id);
            OA2Client e = (OA2Client)this.getEnvironment().getClientStore().get((Object)id);
            if (e != null && !e.isErsatzClient()) {
                e.setErsatzClient(true);
                this.getStore().save((Identifiable)e);
            }
            if (pList.isEmpty()) {
                Permission newErsatzPermission = (Permission)this.getPermissionsStore().create();
                newErsatzPermission.setAdminID(adminID);
                newErsatzPermission.setClientID(id);
                newErsatzPermission.setApprove(true);
                newErsatzPermission.setCreate(true);
                newErsatzPermission.setDelete(true);
                newErsatzPermission.setRead(true);
                newErsatzPermission.setWrite(true);
                this.getPermissionsStore().save((Identifiable)newErsatzPermission);
            }
            if (this.hasEChain(permissions = this.getPermissionsStore().getErsatzChains(adminID, provisioner.getIdentifier()), ersatz)) continue;
            Permission p = (Permission)this.getPermissionsStore().create();
            p.setAdminID(adminID);
            p.setClientID(provisioner.getIdentifier());
            p.setSubstitute(true);
            p.setErsatzChain(ersatz);
            this.getPermissionsStore().save((Identifiable)p);
        }
    }

    protected boolean hasEChain(PermissionList permissions, List<Identifier> eChain) {
        if (permissions.isEmpty()) {
            return false;
        }
        for (Permission p : permissions) {
            List eee;
            if (!p.canSubstitute() || (eee = p.getErsatzChain()).size() != eChain.size()) continue;
            for (int i = 0; i < eee.size(); ++i) {
                if (((Identifier)eee.get(i)).equals(eChain.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected void unlinkErsatz(OA2Client provisioner, Identifier adminID, List<Identifier> ersatz) {
        PermissionList permissions = this.getPermissionsStore().getErsatzChains(adminID, provisioner.getIdentifier());
        for (Permission p : permissions) {
            List eChain = p.getErsatzChain();
            if (eChain.size() != ersatz.size()) continue;
            boolean notFound = true;
            for (int i = 0; i < eChain.size(); ++i) {
                if (((Identifier)eChain.get(i)).equals(ersatz.get(i))) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            this.getPermissionsStore().remove((Object)p.getIdentifier());
        }
    }

    protected Identifiable preCreation(Identifiable identifiable, int magicNumber) {
        OA2Client client = (OA2Client)identifiable;
        if (magicNumber == 1) {
            client.setErsatzClient(true);
            client.setExtendsProvisioners(this.isOk("extends the provisioners?"));
        }
        return client;
    }

    @Override
    protected void rmCleanup(FoundIdentifiables foundIdentifiables) {
        super.rmCleanup(foundIdentifiables);
        int adminCount = 0;
        int permissionCount = 0;
        int skippedCount = 0;
        block4: for (Identifiable x : foundIdentifiables) {
            List admins = this.getPermissionsStore().getAdmins(x.getIdentifier());
            switch (admins.size()) {
                case 0: {
                    ++skippedCount;
                    continue block4;
                }
                case 1: {
                    PermissionList permissions = this.getPermissionsStore().get((Identifier)admins.get(0), x.getIdentifier());
                    this.getPermissionsStore().remove((List)permissions);
                    this.sayi("permissions removed:" + permissions.size());
                    ++adminCount;
                    permissionCount = permissions.size() + permissionCount;
                    continue block4;
                }
            }
            ++skippedCount;
            this.sayi("too many admins for \"" + x.getIdentifierString() + "\". Remove permission manually and specify both admin and client ids");
        }
        this.say("admins removed: " + adminCount + ", total permissions removed: " + permissionCount + ", skipped (not administered): " + skippedCount);
    }

    public void service_client(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("service_client [on | true | off | false] index query or set if this client is a service client.");
            this.say("A service client is a client that is run by a service, typically this replaces the authorization ");
            this.say("leg of OAuth and is a token request. The two major RFC's that cover this are");
            this.say("RFC 7523, which specifies using keys generally too and");
            this.say("RFC 6749 \u00a74.4, the client credentials flow");
            this.printIndexHelp(false);
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null) {
            this.say("Sorry, client not found");
            return;
        }
        if (inputLine.getArgCount() == 0) {
            for (Identifiable identifiable : identifiables) {
                OA2Client client = (OA2Client)identifiable;
                this.say("client " + client.getIdentifierString() + (client.isServiceClient() ? " is" : " is not") + " a service client");
            }
            return;
        }
        Boolean newValue = null;
        if (inputLine.hasArg("true") || inputLine.hasArg("on")) {
            newValue = true;
        }
        if (inputLine.hasArg("false") || inputLine.hasArg("off")) {
            newValue = false;
        }
        if (newValue == null) {
            this.say("unknown value");
            return;
        }
        for (Identifiable identifiable : identifiables) {
            OA2Client client = (OA2Client)identifiable;
            boolean oldValue = client.isServiceClient();
            if (oldValue == newValue) {
                this.say("client " + client.getIdentifierString() + " already has " + (newValue != false ? "on" : "off"));
                continue;
            }
            client.setServiceClient(newValue.booleanValue());
            this.getStore().save((Identifiable)client);
            this.say("client " + client.getIdentifierString() + " has been set to " + (newValue != false ? "on" : "off"));
        }
    }

    protected int updateStorePermissions(Identifier newID, Identifier oldID, boolean copy) {
        List permissions = this.getEnvironment().getPermissionStore().getByClientID(oldID);
        int updateCount = permissions.size();
        this.updateP(oldID, newID, copy, false, permissions);
        permissions = this.getEnvironment().getPermissionStore().getByErsatzID(oldID);
        this.updateP(oldID, newID, copy, true, permissions);
        return updateCount += permissions.size();
    }

    private int updateP(Identifier oldID, Identifier newID, boolean copyOnly, boolean doErsatzID, List<Permission> permissions) {
        int count = 0;
        if (!copyOnly) {
            this.getEnvironment().getPermissionStore().remove(permissions);
        }
        for (Permission p : permissions) {
            if (doErsatzID) {
                if (!p.getErsatzChain().contains(oldID)) continue;
                int ndx = p.getErsatzChain().indexOf(oldID);
                p.getErsatzChain().set(ndx, newID);
                this.getEnvironment().getPermissionStore().save((Identifiable)p);
                ++count;
                continue;
            }
            p.setClientID(newID);
            this.getEnvironment().getPermissionStore().save((Identifiable)p);
            ++count;
        }
        return count;
    }

    public static class OA2ClientApprovalMods
    extends BaseClientStoreCommands.ApprovalModsConfig {
        public boolean useStrictScopes = true;

        public OA2ClientApprovalMods(BaseClient client, boolean doPrompt, boolean useStrictScopes) {
            super(client, doPrompt);
            this.useStrictScopes = useStrictScopes;
        }
    }
}

