/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.ConfigurableCommandsImpl2;
import edu.uiuc.ncsa.security.util.cli.FormatUtil;
import edu.uiuc.ncsa.security.util.cli.IOInterface;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import org.oa4mp.server.admin.oauth2.tools.ConfigLoaderTool;
import org.oa4mp.server.admin.oauth2.tools.OA2CLCCommands;

public class OA2CommandLineClient
extends ConfigurableCommandsImpl2 {
    ConfigurationLoader<? extends AbstractEnvironment> loader;
    static OA2CommandLineClient instance = null;

    public String getComponentName() {
        return "client";
    }

    public void useHelp() {
    }

    public String getPrompt() {
        return this.getName() + ">";
    }

    public String getName() {
        return "clc";
    }

    public OA2CommandLineClient(CLIDriver driver) {
        super(driver);
    }

    public void setLoader(ConfigurationLoader<? extends AbstractEnvironment> loader) {
        this.loader = loader;
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() {
        return this.loader;
    }

    public static OA2CommandLineClient getInstance() {
        if (instance == null) {
            instance = new OA2CommandLineClient(null);
        }
        return instance;
    }

    public static void setInstance(OA2CommandLineClient instance) {
        OA2CommandLineClient.instance = instance;
    }

    public static void main(String[] args) {
        try {
            OA2CommandLineClient clc = new OA2CommandLineClient(null);
            OA2CommandLineClient.setInstance(clc);
            clc.runnit(args, clc);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void runnit(String[] args, OA2CommandLineClient clc) throws Throwable {
        InputLine inputLine = new InputLine(((Object)((Object)this)).getClass().getSimpleName(), args);
        CLIDriver cli = new CLIDriver(new Commands[]{clc});
        OA2CLCCommands usc = new OA2CLCCommands(cli, clc);
        usc.setConfigFile(clc.getConfigFile());
        FormatUtil.setIoInterface((IOInterface)cli.getIOInterface());
        cli.addCommands(new Commands[]{usc});
        usc.bootstrap(inputLine);
        cli.start();
    }

    public void start(String[] args) throws Exception {
        block3: {
            try {
                this.initialize();
                this.about();
            }
            catch (Throwable mc) {
                Throwable t = mc;
                if (mc.getCause() != null) {
                    t = mc.getCause();
                }
                if (mc instanceof ConnectionException) break block3;
                this.say("Could not load the configuration:\"" + t.getMessage() + "\"");
            }
        }
    }

    protected ConfigurationLoader<? extends AbstractEnvironment> figureOutLoader(String fileName, String configName) throws Throwable {
        ConfigLoaderTool configLoaderTool = new ConfigLoaderTool();
        return configLoaderTool.figureOutClientLoader(fileName, configName, this.getComponentName());
    }

    protected void banner() {
        this.say("                                                              \n  .g8\"\"8q.      db                 `7MMM.     ,MMF'`7MM\"\"\"Mq. \n.dP'    `YM.   ;MM:                  MMMb    dPMM    MM   `MM.\ndM'      `MM  ,V^MM.         ,AM     M YM   ,M MM    MM   ,M9 \nMM        MM ,M  `MM        AVMM     M  Mb  M' MM    MMmmdM9  \nMM.      ,MP AbmmmqMA     ,W' MM     M  YM.P'  MM    MM       \n`Mb.    ,dP'A'     VML  ,W'   MM     M  `YM'   MM    MM       \n  `\"bmmd\"'.AMA.   .AMMA.AmmmmmMMmm .JML. `'  .JMML..JMML.     \n                              MM                              \n                              MM                             ");
    }

    public void about() {
        int width = 60;
        this.banner();
        String stars = StringUtils.repeatString((String)"*", (int)(width + 1));
        this.say(stars);
        this.say(StringUtils.pad2((String)"* OA4MP CLC (command line client)", (int)width) + "*");
        this.say(StringUtils.pad2((String)"* Version 6.2.1", (int)width) + "*");
        this.say(StringUtils.pad2((String)"* By Jeff Gaynor  NCSA", (int)width) + "*");
        this.say(StringUtils.pad2((String)"*  (National Center for Supercomputing Applications)", (int)width) + "*");
        this.say(StringUtils.pad2((String)"*", (int)width) + "*");
        this.say(StringUtils.pad2((String)"* type 'help' for a list of commands", (int)width) + "*");
        this.say(StringUtils.pad2((String)"*      'exit' or 'quit' to end this session.", (int)width) + "*");
        this.say(stars);
    }

    public boolean use(InputLine inputLine) throws Exception {
        return false;
    }

    public void about(boolean showBanner, boolean showHeader) {
    }
}

