/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.sas.StringIO;
import edu.uiuc.ncsa.sas.cli.SASCLIDriver;
import edu.uiuc.ncsa.sas.thing.response.LogonResponse;
import edu.uiuc.ncsa.sas.webclient.Client;
import edu.uiuc.ncsa.sas.webclient.ResponseDeserializer;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.CLIReflectionUtil;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.CommonCommands2;
import edu.uiuc.ncsa.security.util.cli.IOInterface;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import edu.uiuc.ncsa.security.util.terminal.ISO6429IO;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.admin.oauth2.Banners;
import org.oa4mp.server.admin.oauth2.base.BaseCommands2;
import org.oa4mp.server.admin.oauth2.base.ClientStoreCommands;
import org.oa4mp.server.admin.oauth2.base.CopyCommands;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;
import org.oa4mp.server.admin.oauth2.tools.ConfigLoaderTool;
import org.oa4mp.server.admin.oauth2.tools.OA2AdminClientCommands;
import org.oa4mp.server.admin.oauth2.tools.OA2ClientCommands;
import org.oa4mp.server.admin.oauth2.tools.OA2CopyTool;
import org.oa4mp.server.admin.oauth2.tools.OA2CopyToolVerifier;
import org.oa4mp.server.admin.oauth2.tools.OA2PermissionCommands;
import org.oa4mp.server.admin.oauth2.tools.TokenStoreCommands;
import org.oa4mp.server.admin.oauth2.tools.TransactionStoreCommands;
import org.oa4mp.server.admin.oauth2.tools.VICommands;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;

public class OA2Commands
extends BaseCommands2 {
    public static final String PERMISSIONS = "permissions";
    public static final String ADMINS = "admins";
    public static final String TOKENS = "tokens";
    public static final String VIRTUAL_ISSUER = "vi";
    protected ConfigurationLoader<? extends AbstractEnvironment> loader = null;
    OA2ClientCommands oa2ClientCommands = null;
    TokenStoreCommands tokenStoreCommands = null;
    VICommands VICommands;
    TransactionStoreCommands transactionStoreCommands = null;
    OA2AdminClientCommands oa2AdminClientCommands = null;
    OA2PermissionCommands oa2PermissionCommands = null;

    protected ArrayList<String> getCommandCompletions() {
        HashSet<String> commandCompletions = new HashSet<String>();
        String[] cc = CLIReflectionUtil.getCommandsNameList((Commands[])new Commands[]{this});
        for (String x : cc) {
            commandCompletions.add(x);
        }
        for (String name : this.drivers.keySet()) {
            CLIDriver cli = (CLIDriver)this.drivers.get(name);
            for (Commands commands : cli.getCLICommands()) {
                for (String x : cc = CLIReflectionUtil.getCommandsNameList((Commands[])new Commands[]{commands})) {
                    commandCompletions.add(x);
                }
            }
        }
        ArrayList<String> result = new ArrayList<String>(commandCompletions.size());
        result.addAll(commandCompletions);
        return result;
    }

    @Override
    public void initialize() {
        super.initialize();
        try {
            if (!this.drivers.containsKey(ADMINS)) {
                this.drivers.put(ADMINS, this.createCLIDriver((CommonCommands2)this.getAdminClientCommands()));
                this.drivers.put(PERMISSIONS, this.createCLIDriver((CommonCommands2)this.getPermissionCommands()));
                this.drivers.put(TOKENS, this.createCLIDriver((CommonCommands2)this.getTokenCommands()));
                this.drivers.put(VIRTUAL_ISSUER, this.createCLIDriver((CommonCommands2)this.getVICommands()));
            }
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GeneralException("Unable to initialize CLI components", t);
        }
        if (this.getIOInterface() instanceof ISO6429IO) {
            ISO6429IO iso6429IO = (ISO6429IO)this.getIOInterface();
            iso6429IO.setCommandCompletion(this.getCommandCompletions());
        }
    }

    public OA2Commands(CLIDriver driver) {
        super(driver);
    }

    public String getPrompt() {
        return this.getName() + ">";
    }

    public String getName() {
        return "oa4mp";
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() {
        if (this.loader == null) {
            ConfigurationNode node = XMLConfigUtil.findConfiguration((String)this.getConfigFile(), (String)this.getConfigName(), (String)this.getComponentName());
            this.loader = new OA2ConfigurationLoader(node, this.getDriver().getLogger());
        }
        return this.loader;
    }

    OA2SE getOA2SE() throws Exception {
        return (OA2SE)this.getServiceEnvironment();
    }

    public static void main(String[] args) {
        OA2Commands.newMain(args);
    }

    protected static void newMain(String[] args) {
        try {
            InputLine inputLine = new InputLine(OA2Commands.class.getSimpleName(), args);
            if (inputLine.hasArg("-sas")) {
                OA2Commands.setupSAS(inputLine);
                return;
            }
            CLIDriver cli = new CLIDriver();
            OA2Commands oa2Commands = new OA2Commands(cli);
            try {
                cli.addCommands(new Commands[]{oa2Commands});
                oa2Commands.bootstrap(inputLine);
            }
            catch (Throwable t) {
                if (cli.isVerbose()) {
                    t.printStackTrace();
                }
                oa2Commands.say("Warning: could not load configuration:" + t.getMessage());
            }
            cli.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static void setupSAS(InputLine inputLine) throws Throwable {
        Client sasClient = Client.newInstance((InputLine)inputLine);
        sasClient.setResponseDeserializer(new ResponseDeserializer());
        LogonResponse logonResponse = (LogonResponse)sasClient.doLogon();
        SASCLIDriver sascliDriver = new SASCLIDriver((IOInterface)new StringIO(""));
        OA2Commands oa2Commands = new OA2Commands(null);
        sascliDriver.addCommands(new Commands[]{oa2Commands});
        sascliDriver.start();
    }

    @Override
    public void useHelp() {
        this.say("Choose the component you wish to use.");
        this.say("you specify the component as use + name. Supported components are");
        this.say("clients - edit client records");
        this.say("approvals - edit client approval records");
        this.say("permissions - basic permission management.");
        this.say("admins - create or manage administrative clients.");
        this.say("tokens - manage tokens created in the token exchange endpoint");
        this.say("vi - manage virtual issuers");
        this.say("e.g.\n\nuse clients\n\nwill call up the client management component.");
        this.say("Type 'exit' or /q when you wish to exit the component and return to the main menu");
        this.say(" --> and /h prints your command history, /r runs the last command");
    }

    @Override
    public void about() {
        this.about(this.showLogo, this.showHeader);
    }

    public void about(boolean showBanner, boolean showHeader) {
        int width = 60;
        String banner = Banners.TIMES;
        if (this.logoName.equals("roman")) {
            banner = Banners.ROMAN;
        }
        if (this.logoName.equals("os2")) {
            banner = Banners.OS2;
        }
        if (this.logoName.equals("times")) {
            banner = Banners.TIMES;
        }
        if (this.logoName.equals("fraktur")) {
            banner = Banners.FRAKTUR;
        }
        if (this.logoName.equals("plain")) {
            banner = Banners.PLAIN;
        }
        if (this.logoName.equals("none")) {
            showBanner = false;
        }
        String stars = StringUtils.repeatString((String)"*", (int)(width + 1));
        if (showBanner) {
            this.say(banner);
        }
        if (showHeader) {
            this.say(stars);
            this.say(StringUtils.pad2((String)"* OA4MP CLI (Command Line Interpreter)", (int)width) + "*");
            this.say(StringUtils.pad2((String)"* Version 6.2.1", (int)width) + "*");
            this.say(StringUtils.pad2((String)"* By Jeff Gaynor  NCSA", (int)width) + "*");
            this.say(StringUtils.pad2((String)"* type 'help' for a list of commands", (int)width) + "*");
            this.say(StringUtils.pad2((String)"*      'exit', 'quit' or '/q' to end this session.", (int)width) + "*");
            this.say(stars);
        }
    }

    @Override
    public ClientStoreCommands getClientCommands() throws Throwable {
        if (this.oa2ClientCommands == null) {
            this.oa2ClientCommands = new OA2ClientCommands(this.getDriver(), "  ", (Store)this.getServiceEnvironment().getClientStore(), this.getClientApprovalCommands(), this.getOA2SE().getPermissionStore());
            this.oa2ClientCommands.setRefreshTokensEnabled(this.getOA2SE().isRefreshTokenEnabled());
            this.oa2ClientCommands.setSupportedScopes(this.getOA2SE().getScopes());
            this.oa2ClientCommands.setEnvironment((AbstractEnvironment)this.getOA2SE());
        }
        return this.oa2ClientCommands;
    }

    @Override
    public CopyCommands getCopyCommands() throws Throwable {
        return new CopyCommands(this.getDriver(), new OA2CopyTool(), new OA2CopyToolVerifier(), this.getConfigFile());
    }

    protected TokenStoreCommands getTokenCommands() throws Throwable {
        if (this.tokenStoreCommands == null) {
            this.tokenStoreCommands = new TokenStoreCommands(this.getDriver(), "  ", (Store)this.getOA2SE().getTxStore());
            this.tokenStoreCommands.setEnvironment((AbstractEnvironment)this.getOA2SE());
        }
        return this.tokenStoreCommands;
    }

    protected VICommands getVICommands() throws Throwable {
        if (this.VICommands == null) {
            this.VICommands = new VICommands(this.getDriver(), "  ", (Store)this.getOA2SE().getVIStore());
            this.VICommands.setEnvironment((AbstractEnvironment)this.getOA2SE());
        }
        return this.VICommands;
    }

    @Override
    protected TransactionStoreCommands getTransactionCommands() throws Throwable {
        if (this.transactionStoreCommands == null) {
            this.transactionStoreCommands = new TransactionStoreCommands(this.getDriver(), "  ", this.getOA2SE());
            this.transactionStoreCommands.setEnvironment((AbstractEnvironment)this.getOA2SE());
            this.transactionStoreCommands.initHelp();
        }
        return this.transactionStoreCommands;
    }

    public OA2AdminClientCommands getAdminClientCommands() throws Throwable {
        if (this.oa2AdminClientCommands == null) {
            this.oa2AdminClientCommands = new OA2AdminClientCommands(this.getDriver(), "  ", (Store)this.getOA2SE().getAdminClientStore(), this.getClientApprovalCommands(), this.getOA2SE().getPermissionStore(), this.getOA2SE().getClientStore());
            this.oa2AdminClientCommands.setEnvironment((AbstractEnvironment)this.getOA2SE());
        }
        return this.oa2AdminClientCommands;
    }

    public OA2PermissionCommands getPermissionCommands() throws Throwable {
        if (this.oa2PermissionCommands == null) {
            this.oa2PermissionCommands = new OA2PermissionCommands(this.getDriver(), "  ", (Store)this.getOA2SE().getPermissionStore());
            this.oa2PermissionCommands.setEnvironment((AbstractEnvironment)this.getOA2SE());
        }
        return this.oa2PermissionCommands;
    }

    @Override
    public boolean use(InputLine inputLine) throws Throwable {
        OA4MPStoreCommands commands = null;
        if (inputLine.hasArg(ADMINS)) {
            commands = this.getAdminClientCommands();
        }
        if (inputLine.hasArg(PERMISSIONS)) {
            commands = this.getPermissionCommands();
        }
        if (inputLine.hasArg(TOKENS)) {
            commands = this.getTokenCommands();
        }
        if (inputLine.hasArg(VIRTUAL_ISSUER)) {
            commands = this.getVICommands();
        }
        if (commands != null) {
            return this.switchOrRun(inputLine, (CommonCommands2)commands);
        }
        if (super.use(inputLine)) {
            return true;
        }
        this.say("(no such component)");
        return false;
    }

    public void setLoader(ConfigurationLoader<? extends AbstractEnvironment> loader) {
        this.loader = loader;
    }

    protected ConfigurationLoader<? extends AbstractEnvironment> figureOutLoader(String fileName, String configName) throws Throwable {
        ConfigLoaderTool configLoaderTool = new ConfigLoaderTool();
        return configLoaderTool.figureOutServerLoader(fileName, configName, this.getComponentName());
    }
}

