/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.IOException;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionKeys;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;

public class OA2PermissionCommands
extends OA4MPStoreCommands {
    public OA2PermissionCommands(CLIDriver driver, String defaultIndent, Store store) throws Throwable {
        super(driver, defaultIndent, store);
    }

    public OA2PermissionCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    protected PermissionsStore getPStore() {
        return (PermissionsStore)this.getStore();
    }

    public String getName() {
        return "permissions";
    }

    protected String format(Identifiable identifiable) {
        Permission p = (Permission)identifiable;
        String output = "admin=" + String.valueOf(p.getAdminID()) + ", client=" + String.valueOf(p.getClientID()) + ", ersatz id=" + String.valueOf(p.getErsatzChain()) + ", id=" + p.getIdentifierString();
        return output;
    }

    public boolean update(Identifiable identifiable) throws IOException {
        Permission p = (Permission)identifiable;
        PermissionKeys keys = (PermissionKeys)this.getSerializationKeys();
        String input = p.getClientID() == null ? this.getPropertyHelp(keys.clientID(new String[0]), "Enter new client id", "") : this.getPropertyHelp(keys.clientID(new String[0]), "Enter new client id", p.getClientID().toString());
        if (!this.isEmpty(input)) {
            p.setClientID(BasicIdentifier.newID((String)input));
        }
        if (!this.isEmpty(input = p.getAdminID() == null ? this.getPropertyHelp(keys.adminID(new String[0]), "Enter new admin id", "") : this.getPropertyHelp(keys.adminID(new String[0]), "Enter new admin id", p.getAdminID().toString()))) {
            p.setAdminID(BasicIdentifier.newID((String)input));
        }
        if (!this.isEmpty(input = this.getPropertyHelp("permissions", "set all permissions (y/n):", "y"))) {
            if (input.toLowerCase().equals("y")) {
                p.setApprove(true);
                p.setCreate(true);
                p.setDelete(true);
                p.setRead(true);
                p.setWrite(true);
            } else {
                p.setApprove(false);
                p.setCreate(false);
                p.setDelete(false);
                p.setRead(false);
                p.setWrite(false);
            }
        }
        return false;
    }

    protected void removeEntry(Identifiable identifiable, JSONObject json) {
        HashMap map = new HashMap();
        this.getPStore().getXMLConverter().toMap(identifiable, map);
        MapConverter mc = (MapConverter)this.getPStore().getXMLConverter();
        json.remove(mc.keys.identifier(new String[0]));
        for (Object key : json.keySet()) {
            map.remove(key);
        }
        Permission p = (Permission)mc.fromMap(map, identifiable);
        this.getPStore().save((Identifiable)p);
    }

    protected void initHelp() throws Throwable {
        super.initHelp();
        this.getHelpUtil().load("/help/permission_help.xml");
    }

    public void change_id(InputLine inputLine) throws Throwable {
        this.say("Changing ids for permissions is not supported");
    }

    protected int updateStorePermissions(Identifier newID, Identifier oldID, boolean copy) {
        throw new UnsupportedOperationException("Not supported for permissions.");
    }
}

