/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;

public class TokenStoreCommands
extends OA4MPStoreCommands {
    public TokenStoreCommands(CLIDriver driver, String defaultIndent, Store store) throws Throwable {
        super(driver, defaultIndent, store);
    }

    public TokenStoreCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    public String getName() {
        return "  tokens";
    }

    public boolean update(Identifiable identifiable) throws IOException {
        this.say("update for all properties not implemented yet. You can still update individual properties");
        return false;
    }

    protected String format(Identifiable identifiable) {
        TXRecord txRecord = (TXRecord)identifiable;
        Date issuedAt = new Date();
        Date expiresAt = new Date();
        issuedAt.setTime(txRecord.getIssuedAt());
        expiresAt.setTime(txRecord.getExpiresAt());
        String r = txRecord.getIdentifierString() + "\n    parent= " + String.valueOf(txRecord.getParentID()) + "\n    issued at " + String.valueOf(issuedAt) + ", expires at " + String.valueOf(expiresAt);
        return r;
    }

    protected TXStore<? extends TXRecord> getTXStore() {
        return (TXStore)this.getStore();
    }

    public void get_by_parent(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("get_by_parent index - get a simple list of the exchange records for a given transaction id");
            this.printIndexHelp(true);
            return;
        }
        Identifier parentID = this.findSingleton(inputLine).getIdentifier();
        List txRecords = this.getTXStore().getByParentID(parentID);
        int i = 0;
        for (TXRecord txRecord : txRecords) {
            this.say(i++ + ". " + String.valueOf(new Date(txRecord.getExpiresAt())) + ": " + txRecord.getIdentifierString());
        }
        this.say(i + " exchange records found");
    }

    protected void initHelp() throws Throwable {
        super.initHelp();
        this.getHelpUtil().load("/help/token_help.xml");
    }

    public void change_id(InputLine inputLine) throws Throwable {
        throw new UnsupportedOperationException("Not supported for exchange records.");
    }

    protected int updateStorePermissions(Identifier newID, Identifier oldID, boolean copy) {
        throw new UnsupportedOperationException("Not supported for exchange records.");
    }
}

