/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.cache.LockingCleanup;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.core.util.FileUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.cli.FoundIdentifiables;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.TokenExchangeRecordRetentionPolicy;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenRetentionPolicy;
import org.oa4mp.server.loader.oauth2.storage.RefreshTokenStore;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TStoreInterface;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordSerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;

public class TransactionStoreCommands
extends OA4MPStoreCommands {
    OA2SE oa2se;
    TXStore<? extends TXRecord> txStore;
    public static final String LS_AT_FLAG = "-at";
    public static final String LS_RT_FLAG = "-rt";
    public static final String LS_IDT_FLAG = "-idt";
    public static String GC_SAFE_MODE_FLAG = "-safe_gc";
    public static String GC_TEST_FLAG = "-test";
    public static String GC_SIZE_FLAG = "-size";
    public static String GC_FILE_FLAG = "-file";

    public TransactionStoreCommands(CLIDriver driver, String defaultIndent, OA2SE oa2se) throws Throwable {
        super(driver, defaultIndent, (Store)oa2se.getTransactionStore());
        this.oa2se = oa2se;
        this.txStore = oa2se.getTxStore();
    }

    public TXStore getTxStore() {
        return this.txStore;
    }

    public TransactionStoreCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    public String getName() {
        return "transactions";
    }

    public boolean update(Identifiable identifiable) throws IOException {
        this.say("update for all properties not implemented yet. You can still update individual properties");
        return false;
    }

    protected String format(Identifiable identifiable) {
        OA2ServiceTransaction t = (OA2ServiceTransaction)identifiable;
        return "id : " + t.getIdentifierString() + " | auth time : " + String.valueOf(t.getAuthTime());
    }

    public void tokens(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showExpHelp();
            return;
        }
        FoundIdentifiables foundIdentifiables = this.findItem(inputLine);
        int width = 30;
        String stile = " | ";
        String plus = "-+-";
        boolean showAG = true;
        boolean showAT = true;
        boolean showRT = true;
        if (0 < inputLine.getArgCount()) {
            showAG = inputLine.hasArg("-ag");
            showAT = inputLine.hasArg(LS_AT_FLAG);
            showRT = inputLine.hasArg(LS_RT_FLAG);
            if (!(showAG || showAT || showRT)) {
                this.say("unrecognized option(s). ");
                return;
            }
        }
        this.say(StringUtils.pad2((String)"token type", (int)15) + stile + "jwt" + stile + StringUtils.pad2((String)"valid", (int)7) + stile + StringUtils.pad2((String)"issued at", (int)width) + stile + StringUtils.pad2((String)"expires at", (int)width) + stile + "lifetime (ms.)");
        String hLine = StringUtils.hLine((String)"-", (int)15) + plus + StringUtils.hLine((String)"-", (int)3) + plus + StringUtils.hLine((String)"-", (int)7) + plus + StringUtils.hLine((String)"-", (int)width) + plus + StringUtils.hLine((String)"-", (int)width) + plus + StringUtils.hLine((String)"-", (int)width);
        this.say(hLine);
        for (Identifiable identifiable : foundIdentifiables) {
            OA2ServiceTransaction t = (OA2ServiceTransaction)identifiable;
            if (1 < foundIdentifiables.size()) {
                this.say(t.getIdentifierString());
                this.say(hLine);
            }
            if (showAG) {
                this.showExp("auth grant", DateUtils.MAX_TIMEOUT, t.isAuthGrantValid(), (TokenImpl)t.getAuthorizationGrant(), width, stile);
            }
            if (showAT) {
                if (!t.hasAccessToken()) {
                    this.say(StringUtils.pad2((String)"access token", (int)15) + stile + "-----");
                } else {
                    this.showExp("access token", t.getAccessTokenLifetime(), t.isAccessTokenValid(), (TokenImpl)t.getAccessToken(), width, stile);
                }
            }
            if (showRT) {
                if (!t.hasRefreshToken()) {
                    this.say(StringUtils.pad2((String)"refresh token", (int)15) + stile + "-----");
                } else {
                    this.showExp("refresh token", t.getRefreshTokenLifetime(), t.isRefreshTokenValid(), (TokenImpl)t.getRefreshToken(), width, stile);
                }
            }
            this.say(hLine);
        }
    }

    protected void showExp(String tokenName, long lifetime, boolean isValid, TokenImpl token, int width, String stile) {
        Date d = DateUtils.getDate((String)token.getToken());
        Date expDate = new Date();
        long exp = d.getTime() + lifetime;
        boolean isExpired = expDate.getTime() < exp;
        expDate.setTime(exp);
        boolean isJWT = false;
        try {
            JSONObject j = JSONObject.fromObject((Object)token.getToken());
            isJWT = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.say(StringUtils.pad2((String)((isExpired ? "" : "*") + tokenName), (int)15) + stile + (isJWT ? " y " : " n ") + stile + StringUtils.pad2((String)("   " + (isValid ? "y" : "n")), (int)7) + stile + StringUtils.pad2((Date)d, (boolean)false, (int)width) + stile + StringUtils.pad2((Date)expDate, (boolean)false, (int)width) + stile + lifetime);
    }

    private void showExpHelp() {
        this.say("tokens [-at | -rt | -ag] index");
        this.sayi("Show information about tokens such as if its a jwt, validity, issue time, expiration times, etc. in human readable format");
        this.sayi("No arguments means show everything. Flags are");
        this.sayi("-ag = authorization grant");
        this.sayi("-at = access token");
        this.sayi("-rt = refresh token");
        this.sayi("If the tokens are not set, that is shown too with a set of ----");
        this.sayi("An asterisk before the token name means that that token has expired.");
        this.printIndexHelp(false);
    }

    public void claims(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showClaimsHelp();
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        for (Identifiable identifiable : identifiables) {
            OA2ServiceTransaction t = (OA2ServiceTransaction)identifiable;
            if (1 < identifiables.size()) {
                this.say(t.getIdentifierString());
                this.say(StringUtils.hLine((String)"-", (int)t.getIdentifierString().length()));
            }
            if (t.getUserMetaData() != null) {
                this.say(t.getUserMetaData().toString(1));
            } else {
                this.say("(no claims found)");
            }
            if (1 >= identifiables.size()) continue;
            this.say();
        }
    }

    private void showClaimsHelp() {
        this.say("claims index");
        this.sayi("Show the claims associated with this transaction. These are mostly used to create the id token");
        this.printIndexHelp(false);
    }

    protected Identifier getIDbyAT(InputLine inputLine) {
        String rawAT = inputLine.getNextArgFor(LS_AT_FLAG);
        if (StringUtils.isTrivial((String)rawAT)) {
            return null;
        }
        AccessTokenImpl at = new AccessTokenImpl(URI.create(rawAT));
        OA2ServiceTransaction serviceTransaction = null;
        try {
            serviceTransaction = (OA2ServiceTransaction)((TransactionStore)this.getStore()).get((AccessToken)at);
        }
        catch (TransactionNotFoundException transactionNotFoundException) {
            // empty catch block
        }
        if (serviceTransaction != null) {
            return serviceTransaction.getIdentifier();
        }
        TXRecord txRecord = (TXRecord)this.getTxStore().get((Object)BasicIdentifier.newID((String)rawAT));
        if (txRecord != null) {
            return txRecord.getParentID();
        }
        return null;
    }

    protected Identifier getIDByIDT(InputLine inputLine) {
        OA2TransactionKeys tKeys = (OA2TransactionKeys)this.getMapConverter().getKeys();
        TXRecordSerializationKeys txKeys = (TXRecordSerializationKeys)this.getTxStore().getMapConverter().getKeys();
        String rawIDT = inputLine.getNextArgFor(LS_IDT_FLAG);
        OA2ServiceTransaction serviceTransaction = null;
        List tStoreList = this.getStore().search(tKeys.idTokenIdentifier(new String[0]), rawIDT, false);
        if (!tStoreList.isEmpty()) {
            serviceTransaction = (OA2ServiceTransaction)tStoreList.get(0);
            return serviceTransaction.getIdentifier();
        }
        List txStoreList = this.getTxStore().search(txKeys.token(new String[0]), rawIDT, false);
        if (!txStoreList.isEmpty()) {
            TXRecord txRecord = (TXRecord)txStoreList.get(0);
            return txRecord.getParentID();
        }
        return null;
    }

    protected Identifier getIDByRT(InputLine inputLine) {
        String rawRT = inputLine.getNextArgFor(LS_RT_FLAG);
        if (StringUtils.isTrivial((String)rawRT)) {
            return null;
        }
        RefreshTokenImpl rt = new RefreshTokenImpl(URI.create(rawRT));
        OA2ServiceTransaction serviceTransaction = null;
        try {
            serviceTransaction = ((RefreshTokenStore)this.getStore()).get((RefreshToken)rt);
        }
        catch (TransactionNotFoundException transactionNotFoundException) {
            // empty catch block
        }
        if (serviceTransaction != null) {
            return serviceTransaction.getIdentifier();
        }
        TXRecord txRecord = (TXRecord)this.getTxStore().get((Object)BasicIdentifier.newID((String)rawRT));
        if (txRecord != null) {
            return txRecord.getParentID();
        }
        return null;
    }

    public void ls(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showLSHelp();
            this.say("For transaction stores, you may also specify listing by using the access, identity or refresh token:");
            this.say("ls [-at | -idt | -rt token]");
            this.say("Note that other switches, such as -v work as well.");
            this.say("See also: set_id, which takes flags in this component.");
            return;
        }
        Identifier identifier = null;
        boolean getByToken = inputLine.hasArg(new String[]{LS_AT_FLAG, LS_RT_FLAG, LS_IDT_FLAG});
        if (getByToken) {
            identifier = this.getTokenByType(inputLine);
            if (identifier == null) {
                String tokenType = "(unknown)";
                if (inputLine.hasArg(LS_AT_FLAG)) {
                    tokenType = "access";
                }
                if (inputLine.hasArg(LS_RT_FLAG)) {
                    tokenType = "refresh";
                }
                if (inputLine.hasArg(LS_IDT_FLAG)) {
                    tokenType = "identity";
                }
                this.say("Sorry but no such " + tokenType + " token found.");
                return;
            }
            inputLine.removeSwitchAndValue(new String[]{LS_AT_FLAG, LS_RT_FLAG, LS_IDT_FLAG});
            inputLine.appendArg("/" + String.valueOf(identifier));
        }
        List oldIDs = null;
        if (getByToken) {
            oldIDs = this.getID();
            this.setID(null);
        }
        try {
            super.ls(inputLine);
        }
        catch (Throwable t) {
            this.say("uh-oh... there wasn an error:" + t.getMessage());
            return;
        }
        if (getByToken) {
            this.setID(oldIDs);
        }
    }

    protected Identifier getTokenByType(InputLine inputLine) {
        Identifier identifier = null;
        if (inputLine.hasArg(LS_AT_FLAG)) {
            identifier = this.getIDbyAT(inputLine);
        }
        if (inputLine.hasArg(LS_RT_FLAG)) {
            identifier = this.getIDByRT(inputLine);
        }
        if (inputLine.hasArg(LS_IDT_FLAG)) {
            identifier = this.getIDByIDT(inputLine);
        }
        return identifier;
    }

    public void set_id(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("set_id [-at | -idt | -rt] token]");
            this.say("-at search as the access token");
            this.say("-idtsearch as the id token");
            this.say("-rtsearch as the refresh token");
            this.say("Otherwise, try to find the identifier of the record for the given type");
            this.say("If only the token given, that is the identifier and use that.");
            this.say("This will also snoop through exchange records and resolve tokens off of those.");
            this.say("E.g.");
            this.say("set_id oa4mp:/rfc7523/transaction/9373267");
            this.say("would set the token identifier");
            this.say("set_id -at oa4mp:/790064?type=accessToken&ts=1745336738943&version=v2.0&lifetime=900000");
            this.say("would look up the transaction by the given (in this case) access token, then set the identifier");
            this.say("to the found transactions id.");
        }
        Identifier identifier = null;
        boolean getByToken = inputLine.hasArg(new String[]{LS_AT_FLAG, LS_RT_FLAG, LS_IDT_FLAG});
        if (getByToken) {
            identifier = this.getTokenByType(inputLine);
            if (identifier == null) {
                String tokenType = "(unknown)";
                if (inputLine.hasArg(LS_AT_FLAG)) {
                    tokenType = "access";
                }
                if (inputLine.hasArg(LS_RT_FLAG)) {
                    tokenType = "refresh";
                }
                if (inputLine.hasArg(LS_IDT_FLAG)) {
                    tokenType = "identity";
                }
                this.say("Sorry but no such " + tokenType + " token found.");
            } else {
                ArrayList<Identifier> x = new ArrayList<Identifier>();
                x.add(identifier);
                this.setID(x);
            }
        } else {
            super.set_id(inputLine);
        }
    }

    public void set_qdl_state(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("set_qdl_state " + this.CL_INPUT_FILE_FLAG + " file_path index");
            this.say("replace the qdl state in the transaction with the contents of the file.");
            this.say("Note that the file is XML and will be converted as needed.");
            this.printIndexHelp(false);
            this.say("See also: show_qdl_state");
            return;
        }
        FoundIdentifiables foundIdentifiables = this.findItem(inputLine);
        if (!inputLine.hasArg(this.CL_INPUT_FILE_FLAG)) {
            this.say("sorry, but you must specify a file");
            return;
        }
        String f = inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG);
        inputLine.removeSwitchAndValue(this.CL_OUTPUT_FILE_FLAG);
        String rawFile = FileUtil.readFileAsString((String)f);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
        gzipOutputStream.write(rawFile.getBytes("UTF-8"));
        gzipOutputStream.flush();
        gzipOutputStream.close();
        String encoded = Base64.encodeBase64URLSafeString((byte[])baos.toByteArray());
        for (Identifiable i : foundIdentifiables) {
            OA2ServiceTransaction t = (OA2ServiceTransaction)i;
            t.setScriptState(encoded);
        }
        this.say(foundIdentifiables.size() + " processed, done!");
    }

    public void show_qdl_state(InputLine inputLine) throws Throwable {
        int rsz;
        Object lastArg;
        Identifier identifier;
        if (this.showHelp(inputLine)) {
            this.say("show_qdl_state [-at|-rt " + this.CL_OUTPUT_FILE_FLAG + " file_path] index");
            this.say("Find the given transaction, get the current state from QDL and decode it.");
            this.say(this.CL_OUTPUT_FILE_FLAG + " file_path = You may optionally save it to a file.");
            this.printIndexHelp(false);
            return;
        }
        String f = null;
        boolean saveFile = false;
        if (inputLine.hasArg(this.CL_OUTPUT_FILE_FLAG)) {
            saveFile = true;
            f = inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG);
            inputLine.removeSwitchAndValue(this.CL_OUTPUT_FILE_FLAG);
        }
        if (inputLine.hasArg(LS_AT_FLAG)) {
            identifier = this.getIDbyAT(inputLine);
            if (identifier == null) {
                this.say("sorry, but no argument supplied.");
                return;
            }
            inputLine.removeSwitchAndValue(LS_AT_FLAG);
            inputLine.appendArg("/" + String.valueOf(identifier));
        } else if (inputLine.hasArg(LS_RT_FLAG)) {
            identifier = this.getIDByRT(inputLine);
            if (identifier == null) {
                this.say("sorry, but no argument supplied.");
                return;
            }
            inputLine.removeSwitchAndValue(LS_RT_FLAG);
            inputLine.appendArg("/" + String.valueOf(identifier));
        } else if (0 < inputLine.getArgCount() && !((String)(lastArg = inputLine.getLastArg())).startsWith("/") && !((String)lastArg).matches("^[0-9]*$")) {
            inputLine.removeArgAt(inputLine.getArgCount());
            lastArg = "/" + (String)lastArg;
            inputLine.appendArg((String)lastArg);
        }
        OA2ServiceTransaction transaction = (OA2ServiceTransaction)this.findSingleton(inputLine, "transaction not found");
        String rawState = transaction.getScriptState();
        if (StringUtils.isTrivial((String)rawState)) {
            return;
        }
        byte[] xx = Base64.decodeBase64((String)rawState);
        ByteArrayInputStream bais = new ByteArrayInputStream(xx);
        GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)bais, 65536);
        InputStreamReader in = new InputStreamReader(gzipInputStream);
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, rsz);
        }
        if (saveFile) {
            try {
                FileUtil.writeStringToFile((String)f, (String)out.toString());
                this.say("saved QDL state to '" + f + "'");
            }
            catch (Throwable e) {
                this.say("saving to '" + f + " failed:" + e.getMessage());
                if (this.isVerbose() && this.getDriver().isOutputOn()) {
                    e.printStackTrace();
                }
            }
        } else {
            this.say(out.toString());
        }
    }

    public void get_by_at(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("get_by_at access_token - get a transaction by its access token");
            return;
        }
        AccessTokenImpl at = new AccessTokenImpl(URI.create(inputLine.getLastArg()));
        OA2ServiceTransaction serviceTransaction = (OA2ServiceTransaction)((TransactionStore)this.getStore()).get((AccessToken)at);
        if (serviceTransaction == null) {
            TXRecord txRecord = (TXRecord)this.getTxStore().get((Object)at);
            Identifier parentID = txRecord.getParentID();
            serviceTransaction = (OA2ServiceTransaction)this.getStore().get((Object)parentID);
        }
        if (serviceTransaction == null) {
            this.say("no transaction found");
            return;
        }
        this.say(this.format((Identifiable)serviceTransaction));
    }

    public void get_by_proxy_id(InputLine inputLine) throws Exception {
        String proxyID;
        if (this.showHelp(inputLine)) {
            this.say("get_by_proxy_id proxy_id - get a transaction by its proxy_id");
            return;
        }
        if (!(this.getStore() instanceof OA2TStoreInterface)) {
            this.say("wrong store type");
            return;
        }
        OA2TStoreInterface tStoreInterface = (OA2TStoreInterface)this.getStore();
        OA2ServiceTransaction serviceTransaction = tStoreInterface.getByProxyID(BasicIdentifier.newID((String)(proxyID = inputLine.getLastArg())));
        if (serviceTransaction == null) {
            this.say("no transaction found");
            return;
        }
        this.say(this.format((Identifiable)serviceTransaction));
    }

    public void gc_check(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("gc_check index = check if the transaction would get garbage collected");
            this.say("                      in the current environment.");
            this.say("Note that the check is done assuming safe GC mode on the server is false.");
            this.printIndexHelp(false);
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null) {
            this.say("Sorry, transaction not found");
            return;
        }
        RefreshTokenRetentionPolicy refreshTokenRetentionPolicy = new RefreshTokenRetentionPolicy((RefreshTokenStore)this.getStore(), this.getTxStore(), "", false);
        String retainTitle = "retain?";
        int retainTitleWidth = retainTitle.length();
        String idTitle = "id";
        this.say(retainTitle + " | " + idTitle);
        for (Identifiable identifiable : identifiables) {
            Object out = StringUtils.center((String)(refreshTokenRetentionPolicy.retain((Object)identifiable.getIdentifier(), (Object)identifiable) ? "y" : "n"), (int)retainTitleWidth);
            out = (String)out + " | " + String.valueOf(identifiable.getIdentifier());
            this.say((String)out);
        }
    }

    public void gc_run(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("gc_run [" + GC_SAFE_MODE_FLAG + " address] [" + GC_TEST_FLAG + "]  [" + GC_FILE_FLAG + " output_file]  [" + GC_SIZE_FLAG + "] - run garbage collection on the transaction store");
            this.say(GC_SAFE_MODE_FLAG + " - if present, run in safe mode so that only those transactions in the ");
            this.say("        correct scheme and host will be garbage collected");
            this.say(GC_TEST_FLAG + " - if present, only test which would be garbage collected");
            this.say(GC_SIZE_FLAG + " - if present, print  number of transactions found ");
            this.say(GC_FILE_FLAG + " file - writes the ids to the output file.");
            this.say("E.g.");
            this.say("gc_run " + GC_SAFE_MODE_FLAG + " https://cilogon.org");
            this.say("would only remove transactions that start with https://cilogon.org ");
            this.say("\nThe default is to apply garbage collection to every entry in the transaction store");
            return;
        }
        boolean printSize = inputLine.hasArg(GC_SIZE_FLAG);
        inputLine.removeSwitch(GC_SIZE_FLAG);
        boolean testMode = inputLine.hasArg(GC_TEST_FLAG);
        inputLine.removeSwitch(GC_TEST_FLAG);
        boolean doOutput = inputLine.hasArg(GC_FILE_FLAG);
        String outFile = null;
        if (doOutput) {
            outFile = inputLine.getNextArgFor(GC_FILE_FLAG);
            inputLine.removeSwitchAndValue(GC_FILE_FLAG);
        }
        if (!testMode && !this.readline("Are you SURE? (Yes/no)").equals("Yes")) {
            this.say("aborting...");
            return;
        }
        boolean safeGC = false;
        String address = "";
        if (inputLine.hasArg(GC_SAFE_MODE_FLAG)) {
            safeGC = true;
            address = inputLine.getNextArgFor(GC_SAFE_MODE_FLAG);
            inputLine.removeSwitchAndValue(GC_SAFE_MODE_FLAG);
        }
        if (testMode) {
            this.say("testing transaction record cleanup");
        } else {
            this.say("cleaning up transaction records");
        }
        LockingCleanup transactionCleanup = new LockingCleanup(null, "transaction cleanup");
        transactionCleanup.setCleanupInterval(0L);
        transactionCleanup.setStore(this.getStore());
        transactionCleanup.setTestMode(testMode);
        transactionCleanup.addRetentionPolicy((RetentionPolicy)new RefreshTokenRetentionPolicy((RefreshTokenStore)this.getStore(), this.getTxStore(), address, safeGC));
        transactionCleanup.setStopThread(false);
        List transactions = transactionCleanup.age();
        FileWriter fileWriter = null;
        File file = null;
        if (doOutput) {
            file = new File(outFile);
            fileWriter = new FileWriter(file);
            for (OA2ServiceTransaction t : transactions) {
                fileWriter.write(t.getIdentifierString() + "\n");
            }
            this.say("wrote transaction ids to " + file.getAbsolutePath());
            if (printSize) {
                this.say(transactions.size() + " transactions found of " + this.getStore().size() + " to garbage collect");
            }
        } else {
            if (!printSize) {
                for (OA2ServiceTransaction t : transactions) {
                    this.say(t.getIdentifierString());
                }
            }
            this.say(transactions.size() + " transactions found of " + this.getStore().size() + " to garbage collect");
        }
        if (testMode) {
            this.say("testing token exchange record cleanup");
        } else {
            this.say("cleaning up token exchange records");
        }
        Cleanup txRecordCleanup = new Cleanup(null, "TX record cleanup");
        txRecordCleanup.setCleanupInterval(1L);
        txRecordCleanup.setStopThread(false);
        txRecordCleanup.setStore((Store)this.getTxStore());
        txRecordCleanup.setTestMode(testMode);
        txRecordCleanup.addRetentionPolicy((RetentionPolicy)new TokenExchangeRecordRetentionPolicy(address, safeGC));
        List txRecords = txRecordCleanup.age();
        if (doOutput) {
            fileWriter.write("");
            for (TXRecord t : txRecords) {
                fileWriter.write(t.getIdentifierString() + "\n");
            }
            fileWriter.flush();
            fileWriter.close();
            this.say("wrote tx record ids to " + file.getAbsolutePath());
            if (printSize) {
                this.say(txRecords.size() + " tx records found of " + this.getTxStore().size() + " to garbage collect");
            }
        } else {
            if (!printSize) {
                for (TXRecord t : txRecords) {
                    this.say(t.getIdentifierString());
                }
            }
            this.say(txRecords.size() + " tx records found of " + this.getTxStore().size() + " to garbage collect");
        }
    }

    public void gc_lock(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("gc_lock [-rm | ? | -alarms]");
            this.say("-set [T|TX|all] - lock the transaction and TX stores");
            this.say("-rm [T|TX|all] - remove given locks");
            this.say("? - report if stores are locked.");
            this.say("-alarms - show configured alarms");
            return;
        }
        boolean hasSet = inputLine.hasArg("-set");
        if (hasSet) {
            Identifiable tLock;
            String arg = inputLine.getNextArgFor("-set");
            inputLine.removeSwitchAndValue("-set");
            boolean lockT = false;
            boolean lockTX = false;
            switch (arg) {
                case "T": {
                    lockT = true;
                    break;
                }
                case "TX": {
                    lockTX = true;
                    break;
                }
                case "all": {
                    lockTX = true;
                    lockT = true;
                    break;
                }
                default: {
                    this.say("sorry, unknown option to set lock:\"" + arg + "\"");
                    return;
                }
            }
            if (lockT) {
                tLock = this.getStore().create();
                tLock.setIdentifier(LockingCleanup.lockID);
                this.getStore().save(tLock);
                this.say("transaction store locked");
            }
            if (lockTX) {
                tLock = this.getTxStore().create();
                tLock.setIdentifier(LockingCleanup.lockID);
                this.getTxStore().save(tLock);
                this.say("TX store locked");
            }
            return;
        }
        if (inputLine.hasArg("-alarms")) {
            if (this.oa2se.hasCleanupAlarms()) {
                this.say("alarms set for " + String.valueOf(this.oa2se.getCleanupAlarms()));
            } else {
                this.say("no configured alarms. Cleanup interval is " + this.oa2se.getCleanupInterval());
            }
            return;
        }
        if (inputLine.hasArg("-rm")) {
            String arg;
            boolean unlockT = false;
            boolean unlockTX = false;
            switch (arg = inputLine.getNextArgFor("-rm")) {
                case "T": {
                    unlockT = true;
                    break;
                }
                case "TX": {
                    unlockTX = true;
                    break;
                }
                case "all": {
                    unlockTX = true;
                    unlockT = true;
                    break;
                }
                default: {
                    this.say("sorry, unknown option to unlock:\"" + arg + "\"");
                    return;
                }
            }
            this.say("removing locks...");
            if (unlockT) {
                boolean t = null == this.getStore().remove((Object)LockingCleanup.lockID);
                this.say((t ? "did not remove" : "removed") + " transaction store lock");
            }
            if (unlockTX) {
                boolean tx = null == this.getTxStore().remove((Object)LockingCleanup.lockID);
                this.say((tx ? "did not remove" : "removed") + " TX store store lock");
            }
            return;
        }
        this.say("transactions locked? " + this.getStore().containsKey((Object)LockingCleanup.lockID));
        this.say("TX store locked? " + this.getTxStore().containsKey((Object)LockingCleanup.lockID));
    }

    protected void initHelp() throws Throwable {
        super.initHelp();
        this.getHelpUtil().load("/help/transaction_help.xml");
    }

    public void rm_by_client_id(InputLine inputLine) throws Exception {
        Identifier clientID;
        if (this.showHelp(inputLine)) {
            this.say("rm_by_client_id client_id - remove all current transactions for the given client.");
            this.say("client_id = the unique identifier for a client");
            this.say("Note that this cannot be undone and any operations for clients on these");
            this.say("will start failing instantly. This kills all pending transactions for the client");
            this.say("and is normally only used if there is a security breach that requires it shutting the client off asap.");
            return;
        }
        if (!inputLine.hasArgs()) {
            this.say("missing client id.");
            return;
        }
        OA2TStoreInterface tStore = (OA2TStoreInterface)this.getStore();
        List ids = tStore.getByClientID(clientID = BasicIdentifier.newID((String)inputLine.getLastArg()));
        if (ids.isEmpty()) {
            this.say("no transactions found for client id: " + String.valueOf(clientID));
        }
        tStore.removeByID(ids);
        this.say("removed " + ids.size() + " transactions");
        long counter = 0L;
        for (Identifier id : ids) {
            List txValues = this.getTxStore().getIDsByParentID(id);
            counter += (long)txValues.size();
            this.getTxStore().removeByID(txValues);
        }
        if (counter == 0L) {
            this.say("no refresh/exchange records found");
        } else {
            this.say("removed " + counter + "  exchange/refresh records");
        }
        this.say("total items removed from all stores:" + (counter + (long)ids.size()));
    }

    /*
     * WARNING - void declaration
     */
    public void stats(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("stats [-client client_id] [-v] [-top n] = prints report on the number of tokens currently help by this client.");
            this.say("-client client_id = the unique identifier for a client");
            this.say("-v = verbose mode for -client. Print numbers of refresh/exchanges per id, otherwise print a single number");
            this.say("-top n = n is an integer. Print the top n most used client ids with counts and percents");
            return;
        }
        if (!inputLine.hasArgs()) {
            this.say("no arguments");
            return;
        }
        boolean isTop = inputLine.hasArg("-top");
        int n = 0;
        String rawN = "";
        if (isTop) {
            try {
                rawN = inputLine.getNextArgFor("-top");
                n = Integer.parseInt(rawN);
                if (n <= 0) {
                    this.say("top n should be positive");
                    return;
                }
                inputLine.removeSwitchAndValue("-top");
            }
            catch (Throwable t) {
                n = 10;
                this.say("sorry, but \"" + rawN + "\" did not parse as a number");
            }
        }
        OA2TStoreInterface tStore = (OA2TStoreInterface)this.getStore();
        if (isTop) {
            List ids = tStore.getAllClientID();
            long total = ids.size();
            if (total == 0L) {
                this.say("no transactions found");
                return;
            }
            HashMap<Identifier, Long> counts = new HashMap<Identifier, Long>();
            for (Identifier id : ids) {
                if (counts.containsKey(id)) {
                    counts.put(id, (Long)counts.get(id) + 1L);
                    continue;
                }
                counts.put(id, 0L);
            }
            ArrayList list = new ArrayList(counts.entrySet());
            list.sort(Map.Entry.comparingByValue());
            Collections.reverse(list);
            LinkedHashMap<Identifier, Long> sortedCounts = new LinkedHashMap<Identifier, Long>();
            for (Map.Entry entry : list) {
                sortedCounts.put((Identifier)entry.getKey(), (Long)entry.getValue());
            }
            int max = Math.min(n, sortedCounts.size());
            boolean bl = false;
            int fieldWidth = 10;
            this.say(StringUtils.center((String)"count", (int)fieldWidth) + "|" + StringUtils.center((String)"percent", (int)fieldWidth) + "|  client id");
            this.say("----------+----------+------------------------------");
            for (Identifier id : sortedCounts.keySet()) {
                void var13_21;
                if (max < ++var13_21) break;
                this.say(StringUtils.center((String)((Long)sortedCounts.get(id)).toString(), (int)fieldWidth) + "|" + StringUtils.center((String)(String.format("%.3f", 100.0 * (double)((Long)sortedCounts.get(id)).longValue() / (double)total) + "%"), (int)fieldWidth) + "|  " + String.valueOf(id));
            }
            this.say("total transactions:" + total);
            return;
        }
        boolean isVerbose = inputLine.hasArg("-v");
        inputLine.removeSwitch("-v");
        Identifier clientID = BasicIdentifier.newID((String)inputLine.getLastArg());
        List ids = tStore.getByClientID(clientID);
        if (ids.isEmpty()) {
            this.say("no transactions found for client id: " + String.valueOf(clientID));
            return;
        }
        this.say(ids.size() + " base transaction count");
        long counter = 0L;
        for (Identifier id : ids) {
            List list = this.getTxStore().getByParentID(id);
            counter += (long)list.size();
            if (!isVerbose) continue;
            this.say(StringUtils.pad((String)String.valueOf(list.size()), (int)10) + " | " + String.valueOf(id));
        }
        if (counter == 0L) {
            this.say("no refresh/exchange records found");
        } else {
            this.say(counter + " total exchange/refresh records");
        }
        this.say("total transactions and other records:" + (counter + (long)ids.size()));
    }

    public void change_id(InputLine inputLine) throws Throwable {
        this.say("Changing transaction ids is not supported at this time.");
    }

    protected int updateStorePermissions(Identifier newID, Identifier oldID, boolean copy) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

