/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.cli.FoundIdentifiables;
import edu.uiuc.ncsa.security.storage.cli.StoreCommands2;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientKeys;
import org.oa4mp.server.loader.oauth2.storage.vi.VISerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.vi.VIStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;
import org.oa4mp.server.loader.qdl.util.SigningCommands;

public class VICommands
extends OA4MPStoreCommands {
    public static final String EC_FLAG = "-ec";
    public static final String RSA_SIZE_FLAG = "-size";
    public static final String EC_CURVE_FLAG = "-curve";

    public VICommands(CLIDriver driver, String defaultIndent, Store store) throws Throwable {
        super(driver, defaultIndent, store);
    }

    protected VIStore getVIS() {
        return (VIStore)this.getStore();
    }

    public VICommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    public String getName() {
        return "  vi";
    }

    @Override
    public void extraUpdates(Identifiable identifiable, int magicNumber) throws IOException {
        super.extraUpdates(identifiable, magicNumber);
        VirtualIssuer vi = (VirtualIssuer)identifiable;
        VISerializationKeys keys = (VISerializationKeys)this.getSerializationKeys();
        if (vi.getCreationTS() == null) {
            vi.setCreationTS(new Date());
        }
        vi.setTitle(this.getPropertyHelp(keys.title(new String[0]), "enter the title", vi.getTitle()));
        vi.setIssuer(this.getPropertyHelp(keys.issuer(new String[0]), "enter the issuer", vi.getIssuer()));
        String iss = vi.getAtIssuer();
        if (iss == null) {
            iss = vi.getIssuer();
        }
        vi.setAtIssuer(this.getPropertyHelp(keys.atIssuer(new String[0]), "enter the access token issuer", iss));
        vi.setDiscoveryPath(this.getPropertyHelp(keys.discoveryPath(new String[0]), "enter the discovery path. NOTE this should be of the form host/path e.g.cilogon.org/ligo:", vi.getDiscoveryPath()));
        String ok = this.getInput("Did you want to specify a file with the JSON web keys(y/n)", "n");
        if (!StringUtils.isTrivial((String)ok)) {
            if (ok.trim().toLowerCase().equals("y")) {
                String filePath = this.readline("Enter full path to the file:");
                File f = new File(filePath);
                if (f.exists()) {
                    if (f.isFile()) {
                        if (f.canRead()) {
                            try {
                                JSONWebKeys jsonWebKeys = JSONWebKeyUtil.fromJSON((File)f);
                                vi.setJsonWebKeys(jsonWebKeys);
                                this.printJWK(jsonWebKeys);
                            }
                            catch (Throwable e) {
                                if (DebugUtil.isEnabled()) {
                                    e.printStackTrace();
                                }
                                this.say("Sorry, there was a problem reading the file::" + e.getMessage());
                            }
                        } else {
                            this.say("Sorry but you don't have permission to read \"" + f.getAbsolutePath() + "\".");
                        }
                    } else {
                        this.say("Sorry but \"" + f.getAbsolutePath() + "\" is not a file.");
                    }
                } else {
                    this.say("Sorry but \"" + f.getAbsolutePath() + "\" does not exist.");
                }
            } else {
                String rc = this.getPropertyHelp(keys.jsonWebKeys(new String[0]), "Did you want to create a new set?", "n");
                if (rc.trim().toLowerCase().equals("y")) {
                    String type = this.getInput("enter type RSA or EC:", "RSA");
                    if ((type = type.toUpperCase()).equals("RSA")) {
                        int keySize = 2048;
                        String raw = this.readline("Enter key size (default is " + keySize + ")");
                        try {
                            if (!StringUtils.isTrivial((String)raw)) {
                                keySize = Integer.parseInt(raw);
                            }
                        }
                        catch (Throwable t) {
                            this.say("sorry but \"" + raw + "\" is not an integer");
                            return;
                        }
                        try {
                            this.newKeys(vi, keySize);
                        }
                        catch (Throwable t) {
                            this.say("That did not work:" + t.getMessage());
                            if (DebugUtil.isEnabled()) {
                                t.printStackTrace();
                            }
                            return;
                        }
                    }
                    if (type.equals("EC")) {
                        String curve = this.readline("If you do not want the default curves used, enter a specific one:");
                        try {
                            this.newKeys(vi, curve);
                        }
                        catch (Throwable e) {
                            this.say("That did not work:" + e.getMessage());
                            if (DebugUtil.isEnabled()) {
                                e.printStackTrace();
                            }
                            return;
                        }
                    } else {
                        this.say("Sorry but \"" + type + "\" is not a valid type of key");
                    }
                }
            }
        }
        String defaultKey = null;
        if (vi.getJsonWebKeys() != null) {
            defaultKey = vi.getJsonWebKeys().getDefaultKeyID();
        }
        vi.setDefaultKeyID(this.getPropertyHelp(keys.defaultKeyID(new String[0]), "enter the default key id", defaultKey));
        vi.setCreationTS(new Date());
        vi.setLastModifiedTS(new Date());
        vi.setValid(true);
    }

    public void new_keys(InputLine inputLine) throws Throwable {
        VirtualIssuer vo;
        if (this.showHelp(inputLine)) {
            this.say("new_keys [id]");
            this.sayi("Create a completely new set of keys for a virtual issuer.");
            this.sayi("You can create a default set of RSA keys with no arguments");
            this.sayi("A complete set of default elliptic curve keys is done with the -ec");
            this.sayi("E.g: Generate a new set of default elliptic curve keys");
            this.sayi("new_keys -ec");
            this.sayi("This creates a set of keys for the P-256 curve and algorithm ES256, P-384 and ES384, and P-521 and ES512");
            this.sayi("E.g: Generate a new set of RSA keys of 4096 bits");
            this.sayi("new_keys -size 4096");
            this.sayi("E.g: Generate a new set of elliptic curve keys for a specific curve");
            this.sayi("new_keys -ec -curve P-384");
            this.sayi("This creates a set of keys using the curve P-384 and the algorithms ES256, ES384 and ES512");
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null) {
            this.say("sorry, no such virtual issuer");
            return;
        }
        if (!identifiables.isSingleton()) {
            this.say("only a single object is supported by this operation");
            return;
        }
        int keySize = 2048;
        boolean isEllipticCurve = inputLine.hasArg(EC_FLAG);
        String curve = null;
        inputLine.removeSwitch(EC_FLAG);
        if (isEllipticCurve) {
            if (inputLine.hasArg(EC_CURVE_FLAG)) {
                curve = inputLine.getNextArgFor(EC_CURVE_FLAG);
                inputLine.removeSwitchAndValue(EC_CURVE_FLAG);
            }
        } else if (inputLine.hasArg(RSA_SIZE_FLAG)) {
            try {
                keySize = inputLine.getNextIntArg(new String[]{RSA_SIZE_FLAG});
                inputLine.removeSwitchAndValue(RSA_SIZE_FLAG);
            }
            catch (Throwable t) {
                this.say("sorry, but " + inputLine.getNextArgFor(RSA_SIZE_FLAG) + " is not a number");
                return;
            }
        }
        if ((vo = (VirtualIssuer)identifiables.get(0)).getJsonWebKeys() != null) {
            String ok = this.getInput("Did you want to overwrite the current set of keys?(y/n)", "n");
            if (ok.trim().equalsIgnoreCase("y")) {
                if (isEllipticCurve) {
                    this.newKeys(vo, curve);
                } else {
                    this.newKeys(vo, keySize);
                }
                String defaultId = null;
                for (JSONWebKey key : vo.getJsonWebKeys().values()) {
                    if (!key.algorithm.equals("RS256") && !key.algorithm.equals("ES256")) continue;
                    defaultId = key.id;
                }
                String newID = this.getInput("Set the new default key", defaultId == null ? "" : defaultId);
                vo.setDefaultKeyID(newID);
                this.getStore().save((Identifiable)vo);
                this.say("new keys saved");
            } else {
                this.say("aborted...");
                this.info("new keys aborted by user.");
            }
        }
    }

    protected void newKeys(VirtualIssuer vo, int keySize) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        JSONWebKeys jsonWebKeys = SigningCommands.createRSAJsonWebKeys((int)keySize, null);
        vo.setJsonWebKeys(jsonWebKeys);
        this.printJWK(jsonWebKeys);
    }

    protected void newKeys(VirtualIssuer vo, String curve) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        JSONWebKeys jsonWebKeys = StringUtils.isTrivial((String)curve) ? SigningCommands.createECJsonWebKeys(null) : SigningCommands.createECJsonWebKeys((String)curve, null);
        vo.setJsonWebKeys(jsonWebKeys);
        this.printJWK(jsonWebKeys);
    }

    protected void newKeys(VirtualIssuer vo) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.newKeys(vo, null);
    }

    public void print_keys(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("print_keys");
            this.sayi("Print a quick summary of the JSON Web keys");
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null) {
            this.say("sorry, no such virtual issuer");
            return;
        }
        if (!identifiables.isSingleton()) {
            this.say("only single object are supported");
            return;
        }
        VirtualIssuer vo = (VirtualIssuer)identifiables.get(0);
        if (vo.getJsonWebKeys() == null) {
            this.say("sorry, no JSON web keys set.");
            return;
        }
        this.printJWK(vo.getJsonWebKeys());
    }

    private void printJWK(JSONWebKeys jsonWebKeys) {
        this.say("Found keys are:");
        for (String key_id : jsonWebKeys.keySet()) {
            JSONWebKey jsonWebKey = (JSONWebKey)jsonWebKeys.get((Object)key_id);
            String out = jsonWebKey.id + ": alg =" + jsonWebKey.algorithm;
            if (!StringUtils.isTrivial((String)jsonWebKey.use)) {
                out = out + ", use=" + jsonWebKey.use;
            }
            this.sayi(out);
        }
    }

    protected String format(Identifiable identifiable) {
        VirtualIssuer vo = (VirtualIssuer)identifiable;
        return vo.getIdentifierString() + " (" + vo.getTitle() + ") created on " + String.valueOf(vo.getCreationTS());
    }

    protected void initHelp() throws Throwable {
        super.initHelp();
        this.getHelpUtil().load("/help/vi_help.xml");
    }

    public void add_admin(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("add_admin admin_id [vi_id] - add the admin client or a result set of them ");
            this.say("to the current or given virtual issuer");
            this.printIndexHelp(true);
            return;
        }
        FoundIdentifiables identifiables = this.findByIDOrRS((Store)this.getEnvironment().getAdminClientStore(), inputLine.getArg(1));
        if (identifiables == null) {
            this.say("no admin id could be found.");
            return;
        }
        int count = 0;
        Identifiable vi = this.findSingleton(inputLine, "virtual issuer not found");
        for (Identifiable identifiable : identifiables) {
            AdminClient adminClient = (AdminClient)identifiable;
            adminClient.setVirtualIssuer(vi.getIdentifier());
            adminClient.setExternalVIName(vi.getIdentifierString());
            this.getEnvironment().getAdminClientStore().save((Identifiable)adminClient);
            ++count;
        }
        this.say(count + " admin clients added to virtual issuer \"" + vi.getIdentifierString() + "\"");
    }

    protected int updateStorePermissions(Identifier newID, Identifier oldID, boolean copy) {
        return 0;
    }

    public StoreCommands2.ChangeIDRecord doChangeID(Identifiable identifiable, Identifier newID, boolean updatePermissions) {
        StoreCommands2.ChangeIDRecord changeIDRecord = super.doChangeID(identifiable, newID, updatePermissions);
        Identifier oldID = changeIDRecord.oldID;
        AdminClientKeys adminClientKeys = new AdminClientKeys();
        List admins = this.getEnvironment().getAdminClientStore().search(adminClientKeys.vo(new String[0]), oldID.toString(), false);
        for (AdminClient adminClient : admins) {
            adminClient.setVirtualIssuer(newID);
            if (adminClient.getExternalVIName().equals(oldID.toString())) {
                adminClient.setExternalVIName(newID.toString());
            }
            this.getEnvironment().getAdminClientStore().save((Identifiable)adminClient);
        }
        changeIDRecord.updateCount += admins.size();
        return changeIDRecord;
    }

    public void list_admins(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("list_admins [-rs name] id - list the admin IDs for the current VI.");
            this.say("You may save them in a result set if you want.");
            this.say("This is restricted to a single VI.");
            return;
        }
        Identifiable identifiable = this.findSingleton(inputLine);
        if (identifiable == null) {
            this.say("no VI found.");
            return;
        }
        String rsName = null;
        boolean hasRS = inputLine.hasArg("-rs");
        if (hasRS) {
            rsName = inputLine.getNextArgFor("-rs");
            inputLine.removeSwitchAndValue("-rs");
        }
        AdminClientKeys adminClientKeys = new AdminClientKeys();
        List admins = this.getEnvironment().getAdminClientStore().search(adminClientKeys.vo(new String[0]), identifiable.getIdentifierString(), false);
        if (hasRS) {
            ArrayList hackyList = new ArrayList(admins.size());
            hackyList.addAll(admins);
            StoreCommands2.RSRecord rsRecord = new StoreCommands2.RSRecord(hackyList, adminClientKeys.allKeys());
            this.getResultSets().put(rsName, rsRecord);
        }
        for (AdminClient adminClient : admins) {
            this.say(adminClient.getIdentifierString());
        }
        this.say("found " + admins.size() + " admin clients");
    }
}

