/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools.migrate;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.Pacer;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.MonitoredStoreInterface;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.storage.monitored.Monitored;
import edu.uiuc.ncsa.security.storage.monitored.upkeep.UpkeepConfiguration;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLDatabase;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrateStore;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrationConstants;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrationEntry;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TStoreInterface;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VIStore;

public class FSMigrater
implements MigrationConstants {
    MigrateStore migrateStore;
    long ingestionCounter = 0L;
    long badIngestionCounter = 0L;
    long totalByteCount = 0L;
    boolean DEEP_DEBUG = true;
    String caput = "  ";
    long pacerIncrement = 1000L;
    HashSet<Identifier> adminIDs = new HashSet();
    HashSet<Identifier> clientID = new HashSet();
    boolean pacerOn = true;
    Pacer pacer = new Pacer(20);
    String spacer = ": ";
    Writer echoWriter = null;

    public FSMigrater(MigrateStore migrateStore, Writer echoWriter) {
        this.migrateStore = migrateStore;
        this.echoWriter = echoWriter;
    }

    String getImportMessage(Throwable t) {
        String message = t.getClass().getSimpleName() + this.spacer + t.getMessage();
        if (t.getCause() != null) {
            message = message + ", cause[" + t.getCause().getClass().getSimpleName() + this.spacer + t.getCause().getMessage() + "]";
        }
        return message;
    }

    public void setImportMessage(MigrationEntry me, int code, Throwable t) {
        me.setImportCode(code);
        me.setErrorMessage(this.getImportMessage(code) + this.spacer + this.getImportMessage(t));
    }

    public void setImportMessage(MigrationEntry me, int code) {
        me.setImportCode(code);
        me.setErrorMessage(this.getImportMessage(code));
    }

    public void setImportMessage(MigrationEntry me, Throwable t) {
        me.setErrorMessage(this.getImportMessage(me.getImportCode()) + this.spacer + t.getMessage());
    }

    @Override
    public String getImportMessage(int importCode) {
        return MigrationConstants.getImportMessage(importCode);
    }

    protected boolean isFS(Store store, boolean noTransactions) {
        if (!(store instanceof FileStore)) {
            return false;
        }
        return !noTransactions || !(store instanceof OA2TStoreInterface) && !(store instanceof TXStore);
    }

    protected boolean isSQLStore(Store store, boolean noTransactions) {
        if (!(store instanceof SQLStore)) {
            return false;
        }
        return !noTransactions || !(store instanceof OA2TStoreInterface) && !(store instanceof TXStore);
    }

    public void ingest(OA2SE source, boolean noTransactions, int batchSize, boolean pacerOn) throws SQLException {
        List stores = source.getAllStores();
        this.ingestionCounter = 0L;
        this.badIngestionCounter = 0L;
        this.totalByteCount = 0L;
        this.dbg("starting to ingest ");
        long startTime = System.currentTimeMillis();
        for (Store store : stores) {
            if (!this.isFS(store, noTransactions)) continue;
            this.ingest((FileStore)store, batchSize, pacerOn);
        }
        this.dbg();
        this.dbg("elapsed ingestion time : " + StringUtils.formatElapsedTime((long)(System.currentTimeMillis() - startTime)));
        this.dbg("      total file count : " + this.ingestionCounter);
        this.dbg("       total bad files : " + this.badIngestionCounter);
        this.dbg("      total byte count : " + this.totalByteCount);
        this.dbg("             files/sec : " + this.computeHerz(this.ingestionCounter, startTime));
    }

    void dbg() {
        if (this.DEEP_DEBUG) {
            System.err.println("");
        }
    }

    void dbg(String x) {
        if (this.DEEP_DEBUG) {
            String message = this.caput + ":" + x;
            System.err.println(message);
            if (this.hasEchoWriter()) {
                try {
                    this.echoWriter.write(message + "\n");
                }
                catch (IOException e) {
                    System.err.println("warning: echoing failed. echo is disabled:" + e.getMessage());
                    this.echoWriter = null;
                }
            }
        }
    }

    protected String getStoreComponent(Store s) {
        if (s instanceof OA2TStoreInterface) {
            return "transactions";
        }
        if (s instanceof TXStore) {
            return "txStore";
        }
        if (s instanceof AdminClientStore) {
            return "adminClients";
        }
        if (s instanceof ClientStore) {
            return "clients";
        }
        if (s instanceof VIStore) {
            return "voStore";
        }
        if (s instanceof PermissionsStore) {
            return "permissions";
        }
        if (s instanceof ClientApprovalStore) {
            return "clientApprovals";
        }
        throw new GeneralException("unknown store type");
    }

    protected int[] ingest(FileStore fileStore, int batchSize, boolean pacerOn) throws SQLException {
        String component = this.getStoreComponent((Store)fileStore);
        File dir = fileStore.getStorageDirectory();
        String dString = dir.getAbsolutePath();
        ConnectionRecord cr = this.migrateStore.getConnectionPool().pop();
        Connection c = cr.connection;
        c.setAutoCommit(false);
        File[] fileList = dir.listFiles();
        this.dbg("processing " + fileList.length + " files from " + dString + ".");
        long totalBytes = 0L;
        long localBadCount = 0L;
        long startTime = System.currentTimeMillis();
        int[] importErrorCodes = new int[1 + ALL_FAILURE_CODES.length];
        long hzTime = startTime;
        try {
            PreparedStatement pStmt = c.prepareStatement(this.migrateStore.getIngestStatement());
            for (int i = 0; i < fileList.length; ++i) {
                File f = fileList[i];
                totalBytes += f.length();
                ++this.ingestionCounter;
                pStmt.setString(1, dString);
                pStmt.setString(2, f.getName());
                pStmt.setString(3, component.toLowerCase());
                int importCode = FSMigrater.getImportCode(f);
                if (importCode < 0) {
                    int index = Math.abs(importCode);
                    importErrorCodes[index] = 1 + importErrorCodes[index];
                    ++localBadCount;
                }
                pStmt.setInt(4, importCode);
                String importMessage = this.getImportMessage(importCode);
                if (importMessage == null) {
                    pStmt.setNull(5, 2005);
                } else {
                    pStmt.setString(5, importMessage);
                }
                pStmt.addBatch();
                if (!pacerOn || 1 >= i || 0L != (long)i % this.pacerIncrement) continue;
                this.pacer.pace((long)i, " files read @ " + this.computeHerz((int)this.pacerIncrement, hzTime));
                hzTime = System.currentTimeMillis();
            }
            this.dbg();
            if (pacerOn && 1L < this.ingestionCounter && 0L == this.ingestionCounter % this.pacerIncrement) {
                this.pacer.pace(this.ingestionCounter, " files read @ " + this.computeHerz((int)this.pacerIncrement, hzTime));
                hzTime = System.currentTimeMillis();
            }
            this.totalByteCount += totalBytes;
            long startBatch = System.currentTimeMillis();
            this.dbg("ingesting...");
            int[] rcs = pStmt.executeBatch();
            int width = 12;
            String spacer = " : ";
            this.dbg(StringUtils.RJustify((String)"store", (int)width) + spacer + component);
            this.dbg(StringUtils.RJustify((String)"total", (int)width) + spacer + rcs.length);
            this.dbg(StringUtils.RJustify((String)"rejected", (int)width) + spacer + localBadCount);
            this.dbg(StringUtils.RJustify((String)"update speed", (int)width) + spacer + this.computeHerz(rcs.length, startBatch));
            this.dbg(StringUtils.RJustify((String)"bytes", (int)width) + spacer + StringUtils.formatByteCount((long)totalBytes));
            this.dbg(StringUtils.RJustify((String)"total time", (int)width) + spacer + StringUtils.formatElapsedTime((long)(System.currentTimeMillis() - startTime)));
            List<String> err = this.interpretErrorCode(importErrorCodes);
            if (!err.isEmpty()) {
                String indent = StringUtils.getBlanks((int)(width + spacer.length()));
                this.dbg(StringUtils.RJustify((String)"error codes", (int)width) + spacer + err.get(0));
                for (int i = 1; i < err.size(); ++i) {
                    this.dbg(indent + err.get(i));
                }
            }
            c.commit();
            pStmt.close();
            c.setAutoCommit(true);
            this.migrateStore.releaseConnection(cr);
            this.badIngestionCounter += localBadCount;
            return rcs;
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            System.out.println("JDBC URL = " + this.migrateStore.getConnectionPool().getConnectionParameters().getJdbcUrl());
            if (sqlException.getCause() != null) {
                sqlException.getCause().printStackTrace();
            }
            this.migrateStore.getConnectionPool().destroy(cr);
            throw sqlException;
        }
    }

    protected boolean hasErrorCodes(int[] importErrorCodes) {
        for (int i = 0; i < importErrorCodes.length; ++i) {
            if (0 >= importErrorCodes[i]) continue;
            return true;
        }
        return false;
    }

    protected String computeHerz(long value, long startTime) {
        return StringUtils.formatHerz((long)value, (long)startTime) + "          ";
    }

    List<String> interpretErrorCode(int[] errorCodes) {
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < errorCodes.length; ++i) {
            if (0 >= errorCodes[i]) continue;
            out.add(this.getImportMessage(-i) + ":" + errorCodes[i]);
        }
        return out;
    }

    private static int getImportCode(File f) {
        int importCode = 0;
        if (f.isDirectory()) {
            importCode = -3;
        }
        if (!f.canRead()) {
            importCode = -2;
        }
        if (!f.exists()) {
            importCode = -1;
        }
        if (f.length() == 0L) {
            importCode = -6;
        }
        return importCode;
    }

    public void migrate(OA2SE targetSE, int batchSize, boolean runUpkeep, String name, boolean pacerOn) {
        TransactionStore store = null;
        if (name.equalsIgnoreCase("transactions")) {
            store = targetSE.getTransactionStore();
        }
        if (name.equalsIgnoreCase("clients")) {
            store = targetSE.getClientStore();
        }
        if (name.equalsIgnoreCase("clientApprovals")) {
            store = targetSE.getClientApprovalStore();
        }
        if (name.equalsIgnoreCase("adminClients")) {
            store = targetSE.getAdminClientStore();
        }
        if (name.equalsIgnoreCase("voStore")) {
            store = targetSE.getVIStore();
        }
        if (name.equalsIgnoreCase("txStore")) {
            store = targetSE.getTxStore();
        }
        if (name.equalsIgnoreCase("permissions")) {
            store = targetSE.getPermissionStore();
        }
        if (store == null) {
            this.dbg("sorry, but " + name + " is not a recognized store");
            return;
        }
        if (!(store instanceof SQLStore)) {
            this.dbg("sorry, but " + name + " is not an SQL store");
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            this.migrate((SQLStore)store, runUpkeep, this.getStoreComponent((Store)store), batchSize, pacerOn);
        }
        catch (Throwable t) {
            this.dbg("Error migrating " + name + ": " + t.getMessage());
        }
        this.dbg("total elapsed time : " + StringUtils.formatElapsedTime((long)(System.currentTimeMillis() - startTime)));
    }

    public void migrateAll(OA2SE targetSE, boolean noTransactions, int batchSize, boolean runUpkeep, boolean pacerOn) {
        long startTime = System.currentTimeMillis();
        this.dbg("starting to migrate...");
        List stores = targetSE.getAllStores();
        for (Store store : stores) {
            try {
                if (!this.isSQLStore(store, noTransactions)) continue;
                this.migrate((SQLStore)store, runUpkeep, this.getStoreComponent(store), batchSize, pacerOn);
                if (store instanceof ClientStore) {
                    this.clientID = new HashSet();
                    this.setIDs((SQLStore)store, this.clientID);
                }
                if (!(store instanceof AdminClientStore)) continue;
                this.adminIDs = new HashSet();
                this.setIDs((SQLStore)store, this.adminIDs);
            }
            catch (SQLException sqlException) {
                sqlException.printStackTrace();
            }
        }
        this.dbg();
        this.dbg("total elapsed migration time : " + StringUtils.formatElapsedTime((long)(System.currentTimeMillis() - startTime)));
    }

    protected String getAllIDs(SQLStore sqlStore) {
        return "select " + sqlStore.getMapConverter().getKeys().identifier(new String[0]) + " from " + sqlStore.getTable().getFQTablename();
    }

    protected void setIDs(SQLStore sqlStore, HashSet<Identifier> ids) throws SQLException {
        ConnectionRecord connectionRecord = sqlStore.getConnection();
        Connection connection = connectionRecord.connection;
        try {
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(this.getAllIDs(sqlStore));
            while (rs.next()) {
                Identifier id = BasicIdentifier.newID((String)rs.getString(1));
                ids.add(id);
            }
            rs.close();
            statement.close();
            sqlStore.releaseConnection(connectionRecord);
        }
        catch (SQLException sqlException) {
            sqlStore.destroyConnection(connectionRecord);
            if (this.DEEP_DEBUG) {
                sqlException.printStackTrace();
            }
            throw sqlException;
        }
    }

    protected void migrate(SQLStore targetStore, boolean runUpkeep, String component, int batchSize, boolean pacerOn) throws SQLException {
        String stmt = this.migrateStore.getFetchStatement(batchSize);
        ConnectionRecord cr = this.migrateStore.getConnectionPool().pop();
        Connection migrateConnection = cr.connection;
        long startTime = System.currentTimeMillis();
        ConnectionRecord targetCR = targetStore.getConnectionPool().pop();
        Connection targetConnection = targetCR.connection;
        long totalRecords = 0L;
        int[] importErrorCodes = new int[1 + ALL_FAILURE_CODES.length];
        long localBadCount = 0L;
        int[] rcs = new int[]{};
        int upkept = 0;
        long hzTime = startTime;
        int importCount = 0;
        int attemptedCount = 0;
        long notImportedCount = 0L;
        try {
            String countStmt = this.migrateStore.countFetchStatement();
            PreparedStatement counterStmt = migrateConnection.prepareStatement(countStmt);
            counterStmt.setBoolean(1, false);
            counterStmt.setInt(2, 0);
            counterStmt.setString(3, component.toLowerCase());
            ResultSet rs = counterStmt.executeQuery();
            if (rs.next()) {
                totalRecords = rs.getInt(1);
            }
            rs.close();
            counterStmt.close();
            if (totalRecords == 0L) {
                this.migrateStore.releaseConnection(cr);
                return;
            }
            this.dbg();
            this.dbg("migrating " + totalRecords + " items for " + component);
            migrateConnection.setAutoCommit(false);
            targetConnection.setAutoCommit(false);
            PreparedStatement meStmt = migrateConnection.prepareStatement(stmt);
            meStmt.setBoolean(1, false);
            meStmt.setInt(2, 0);
            meStmt.setString(3, component.toLowerCase());
            PreparedStatement meUpdateStmt = migrateConnection.prepareStatement(this.migrateStore.getUpdateStatement());
            PreparedStatement registerEntryStmt = targetConnection.prepareStatement(targetStore.getTable().createInsertStatement());
            rs = meStmt.executeQuery();
            while (rs.next()) {
                ++attemptedCount;
                ColumnMap map = SQLDatabase.rsToMap((ResultSet)rs);
                MigrationEntry me = (MigrationEntry)this.migrateStore.create();
                this.migrateStore.populate(map, (Identifiable)me);
                File f = new File(me.path, me.filename);
                me.setErrorMessage(null);
                me.setImportCode(FSMigrater.getImportCode(f));
                me.setImportTS(new java.util.Date());
                try {
                    MonitoredStoreInterface monitoredStoreInterface;
                    FileInputStream fis = new FileInputStream(f);
                    XMLMap entryMap = new XMLMap();
                    entryMap.fromXML((InputStream)fis);
                    Identifiable value = targetStore.getXMLConverter().fromMap((Map)entryMap, null);
                    if (value.getIdentifier() == null) {
                        System.out.println(value);
                        me.setImportCode(-10);
                        me.setErrorMessage(this.getImportMessage(-10));
                    }
                    if (0 == me.getImportCode() && !this.doCheck(value)) {
                        this.setImportMessage(me, -12);
                    }
                    if (0 == me.getImportCode() && runUpkeep && targetStore instanceof MonitoredStoreInterface && (monitoredStoreInterface = (MonitoredStoreInterface)targetStore).hasUpkeepConfiguration()) {
                        this.doUpkeep(monitoredStoreInterface.getUpkeepConfiguration(), me, (Monitored)value);
                        if (me.getImportCode() < 0) {
                            ++upkept;
                            --localBadCount;
                        }
                    }
                    if (0 <= me.getImportCode()) {
                        targetStore.doRegisterStatement(registerEntryStmt, value);
                        registerEntryStmt.addBatch();
                        if (0 == me.getImportCode()) {
                            me.setImportCode(1);
                        }
                        me.setIdentifier(value.getIdentifier());
                        me.setDescription(value.getDescription());
                        ++importCount;
                    }
                    if (pacerOn && 0 < attemptedCount && 0 == attemptedCount % 100) {
                        this.pacer.pace((long)attemptedCount, (long)(100 * attemptedCount) / totalRecords + "% of files read in " + component + " @ " + 100000L / (System.currentTimeMillis() - hzTime) + " Hz" + (String)(runUpkeep ? " upkept=" + upkept : ""));
                        hzTime = System.currentTimeMillis();
                    }
                }
                catch (FileNotFoundException fnf) {
                    this.setImportMessage(me, -1, fnf);
                }
                catch (SecurityException securityException) {
                    this.setImportMessage(me, -2, securityException);
                }
                catch (IOException e) {
                    this.setImportMessage(me, -7, e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.setImportMessage(me, -9, t);
                }
                meUpdateStmt.setBoolean(1, 0 < me.getImportCode());
                meUpdateStmt.setInt(2, me.getImportCode());
                if (StringUtils.isTrivial((String)me.getErrorMessage())) {
                    meUpdateStmt.setNull(3, 2005);
                } else {
                    meUpdateStmt.setString(3, me.getErrorMessage());
                }
                meUpdateStmt.setDate(4, new Date(me.getImportTS().getTime()));
                meUpdateStmt.setString(5, me.getFilename());
                meUpdateStmt.setString(6, me.getStoreType().toLowerCase());
                meUpdateStmt.addBatch();
                if (me.getImportCode() < 0) {
                    int index = Math.abs(me.getImportCode());
                    importErrorCodes[index] = 1 + importErrorCodes[index];
                    ++localBadCount;
                }
                if (0 >= batchSize || 0 >= importCount || importCount % batchSize != 0) continue;
                if (pacerOn) {
                    this.pacer.clear();
                    this.pacer.pace((long)batchSize, "updating store...");
                }
                registerEntryStmt.executeBatch();
                rcs = meUpdateStmt.executeBatch();
                migrateConnection.commit();
                targetConnection.commit();
                registerEntryStmt.clearBatch();
                meUpdateStmt.clearBatch();
                System.gc();
            }
            rs.close();
            if (pacerOn) {
                this.pacer.pace((long)importCount, " files migrated in " + component + ", rejected=" + localBadCount + " @ " + 100000L / (System.currentTimeMillis() - hzTime) + " Hz" + (String)(runUpkeep ? " upkept=" + upkept : ""));
                hzTime = System.currentTimeMillis();
            }
            if (0 < importCount) {
                registerEntryStmt.executeBatch();
                rcs = meUpdateStmt.executeBatch();
            }
            migrateConnection.commit();
            targetConnection.commit();
            registerEntryStmt.close();
            meUpdateStmt.close();
            migrateConnection.setAutoCommit(true);
            targetConnection.setAutoCommit(true);
            this.migrateStore.releaseConnection(cr);
            targetStore.releaseConnection(targetCR);
        }
        catch (SQLException sqlException) {
            if (this.DEEP_DEBUG) {
                sqlException.printStackTrace();
            }
            this.migrateStore.getConnectionPool().destroy(cr);
            targetStore.getConnectionPool().destroy(targetCR);
            throw sqlException;
        }
        this.dbg();
        int width = 12;
        String spacer = " : ";
        this.dbg(StringUtils.RJustify((String)"total", (int)width) + spacer + attemptedCount);
        this.dbg(StringUtils.RJustify((String)"upkept", (int)width) + spacer + upkept);
        this.dbg(StringUtils.RJustify((String)"bad files", (int)width) + spacer + localBadCount);
        this.dbg(StringUtils.RJustify((String)"net files", (int)width) + spacer + importCount);
        this.dbg(StringUtils.RJustify((String)"time", (int)width) + spacer + StringUtils.formatElapsedTime((long)(System.currentTimeMillis() - startTime)));
        this.dbg(StringUtils.RJustify((String)"av. speed", (int)width) + spacer + this.computeHerz(attemptedCount, startTime));
        List<String> err = this.interpretErrorCode(importErrorCodes);
        if (!err.isEmpty()) {
            String indent = StringUtils.getBlanks((int)(width + spacer.length()));
            this.dbg(StringUtils.RJustify((String)"error codes", (int)width) + spacer + err.get(0));
            for (int i = 1; i < err.size(); ++i) {
                this.dbg(indent + err.get(i));
            }
        }
    }

    protected boolean doCheck(Identifiable identifiable) {
        if (identifiable instanceof Permission) {
            return this.permissionCheck((Permission)identifiable);
        }
        if (identifiable instanceof ClientApproval) {
            return this.approvalCheck((ClientApproval)identifiable);
        }
        return true;
    }

    protected boolean permissionCheck(Permission permission) {
        return this.clientID.contains(permission.getClientID()) || this.adminIDs.contains(permission.getAdminID());
    }

    protected boolean approvalCheck(ClientApproval clientApproval) {
        return this.clientID.contains(clientApproval.getIdentifier());
    }

    protected boolean doUpkeep(UpkeepConfiguration upkeepConfiguration, MigrationEntry me, Monitored monitored) throws SQLException {
        if (upkeepConfiguration == null) {
            return false;
        }
        String[] rcs = upkeepConfiguration.applies(monitored);
        switch (rcs[0]) {
            case "none": {
                return false;
            }
            case "archive": {
                me.setImportCode(3);
                me.setErrorMessage(rcs[1]);
                String oldID = monitored.getIdentifierString();
                String newID = oldID + "#version=0";
                monitored.setIdentifier(BasicIdentifier.newID((String)newID));
                return true;
            }
            case "delete": {
                me.setImportCode(-11);
                me.setErrorMessage(rcs[1]);
                return true;
            }
            case "retain": {
                return false;
            }
            case "test": {
                me.setImportCode(2);
                me.setErrorMessage(rcs[1]);
                return false;
            }
        }
        return false;
    }

    protected boolean hasEchoWriter() {
        return this.echoWriter != null;
    }
}

