/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools.migrate;

import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.FileUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.cli.CLITool2;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.admin.oauth2.tools.migrate.FSMigrater;
import org.oa4mp.server.admin.oauth2.tools.migrate.MEProvider;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrateKeys;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrateStore;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrateTable;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrationEntryConverter;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;

public class FSMigrationTool
extends CLITool2 {
    public static final int DEFAULT_BATCH_SIZE = 15000;
    FSMigrater migrater = null;
    String storeName = null;
    OA2SE sourceSE;
    OA2SE targetSE;
    MigrateStore migrateStore;
    int batchSize = 15000;
    boolean pacerOn = true;
    String sourceFile;
    String targetFile;
    String sourceConfigName;
    String targetConfigName;
    public static String INGESTION_FILE_NAME = "ingest";
    boolean doIngest = false;
    boolean isVerbose = false;
    boolean upkeepOn = true;
    public static final String CONFIG_SOURCE_CFG = "-src";
    public static final String CONFIG_TARGET_CFG = "-target";
    public static final String CONFIG_TARGET_CFG_NAME = "-targetName";
    public static final String CONFIG_SOURCE_CFG_NAME = "-srcName";
    public static final String CONFIG_BATCH_SIZE = "-batchSize";
    public static final String CONFIG_NO_TRANSACTIONS = "-noTransactions";
    public static final String CONFIG_DO_UPKEEP = "-upkeepOn";
    public static final String CONFIG_VERBOSE = "-v";
    public static final String CONFIG_PACE_OFF = "-noPacer";
    public static final String CONFIG_CLEANUP = "-cleanup";
    public static final String CONFIG_SHOW_CONNECT = "-showConnect";
    public static final String CONFIG_HELP = "--help";
    public static final String CONFIG_SETUP = "-setup";
    public static final String CONFIG_RESET = "-reset";
    public static final String CONFIG_STORE_NAME = "-storeName";
    public static final String CONFIG_ECHO_FILE = "-echoFile";
    public static final String CONFIG_ECHO_APPEND = "-echoAppend";
    String echoFileName = null;
    static Writer echoWriter = null;
    protected static Map<String, HelpEntry> helpMap = null;
    boolean setup = false;
    boolean noTransactions = false;
    boolean doCleanup = false;
    boolean resetIngestDB = false;
    protected static String RunSpacer = "===================================================";
    boolean showConnect = false;
    boolean echoAppend = true;
    static List<String> ALL_CONFIG_NAMES = null;

    public String getComponentName() {
        return null;
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() throws Exception {
        return null;
    }

    public FSMigrater getMigrater() {
        if (this.migrater == null) {
            this.migrater = new FSMigrater(this.migrateStore, echoWriter);
        }
        return this.migrater;
    }

    public void setMigrater(FSMigrater migrater) {
        this.migrater = migrater;
    }

    public void doIt() throws Exception {
        long now = System.currentTimeMillis();
        if (this.doIngest) {
            this.getMigrater().ingest(this.sourceSE, this.isNoTransactions(), this.getBatchSize(), this.isPacerOn());
        }
        if (this.storeName == null) {
            this.getMigrater().migrateAll(this.targetSE, this.isNoTransactions(), this.getBatchSize(), this.isUpkeepOn(), this.isPacerOn());
        } else {
            this.getMigrater().migrate(this.targetSE, this.getBatchSize(), this.isUpkeepOn(), this.storeName, this.isPacerOn());
        }
        FSMigrationTool.say("TOTAL Processing time for all operations:" + StringUtils.formatElapsedTime((long)(System.currentTimeMillis() - now)));
    }

    public void help() {
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public void setSourceConfigName(String sourceConfigName) {
        this.sourceConfigName = sourceConfigName;
    }

    public void setTargetConfigName(String targetConfigName) {
        this.targetConfigName = targetConfigName;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isPacerOn() {
        return this.pacerOn;
    }

    public void setPacerOn(boolean pacerOn) {
        this.pacerOn = pacerOn;
    }

    public void setNoTransactions(boolean noTransactions) {
        this.noTransactions = noTransactions;
    }

    public OA2SE getSourceSE() {
        return this.sourceSE;
    }

    public OA2SE getTargetSE() {
        return this.targetSE;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public String getSourceConfigName() {
        return this.sourceConfigName;
    }

    public String getTargetConfigName() {
        return this.targetConfigName;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    protected boolean loadEnvironments() {
        List createScript = null;
        try {
            ConfigurationNode node = XMLConfigUtil.findConfiguration((String)this.getSourceFile(), (String)this.getSourceConfigName(), (String)"service");
            OA2ConfigurationLoader sourceLoader = new OA2ConfigurationLoader(node);
            this.sourceSE = (OA2SE)sourceLoader.load();
            node = XMLConfigUtil.findConfiguration((String)this.getTargetFile(), (String)this.getTargetConfigName(), (String)"service");
            OA2ConfigurationLoader targetLoader = new OA2ConfigurationLoader(node);
            this.targetSE = (OA2SE)targetLoader.load();
            if (this.targetSE.getClientStore() instanceof SQLStore && ((SQLStore)this.targetSE.getClientStore()).getConnectionPool() instanceof DerbyConnectionPool) {
                DerbyConnectionPool dcp = (DerbyConnectionPool)((SQLStore)this.targetSE.getClientStore()).getConnectionPool();
                if (this.showConnect) {
                    FSMigrationTool.say("target database connection string:");
                    FSMigrationTool.say("  " + dcp.getConnectionParameters().getDerbyConnectionString());
                }
                if (dcp.getConnectionParameters().isCreateOne()) {
                    FSMigrationTool.say("creating target store");
                    dcp.createStore();
                    FSMigrationTool.say("...done!");
                    if (this.setup) {
                        FSMigrationTool.say("...exiting.");
                        return false;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            FSMigrationTool.say("Could not load migration creation");
            return false;
        }
        if (!(this.sourceSE.getClientStore() instanceof FileStore)) {
            FSMigrationTool.say("the source client store is not a file store, but a" + this.sourceSE.getClientStore().getClass().getSimpleName());
            return false;
        }
        FileStore clientStore = (FileStore)this.sourceSE.getClientStore();
        File dbDir = new File(clientStore.getStorageDirectory().getParentFile().getParentFile(), INGESTION_FILE_NAME);
        DerbyConnectionPoolProvider derbyConnectionPoolProvider = DerbyConnectionPoolProvider.newInstance().setStoreType("file").setRootDirectory(clientStore.getStorageDirectory().getParentFile().getParent()).setDatabase(dbDir.getAbsolutePath());
        DerbyConnectionPool pool = (DerbyConnectionPool)derbyConnectionPoolProvider.get();
        if (this.showConnect) {
            FSMigrationTool.say("ingestion database connection string:");
            FSMigrationTool.say("  " + pool.getConnectionParameters().getDerbyConnectionString());
        }
        if (dbDir.exists()) {
            this.sayv("ingestion database exists");
        } else {
            FSMigrationTool.say("ingestion database not found");
            try {
                InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("derby-migrate.sql");
                createScript = SQLStore.crappySQLParser((List)FileUtil.readFileAsLines((InputStream)inputStream));
                pool.setCreateScript(createScript);
                FSMigrationTool.say("creating ingestion database");
                pool.createStore();
                FSMigrationTool.say("...done!");
                this.doIngest = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                FSMigrationTool.say("could not create ingestion store \"" + dbDir.getAbsolutePath() + "\":" + t.getMessage());
                return false;
            }
        }
        MigrateKeys migrateKeys = new MigrateKeys();
        MigrateTable migrateTable = new MigrateTable(migrateKeys, "oauth2", "", INGESTION_FILE_NAME);
        MEProvider meProvider = new MEProvider();
        MigrationEntryConverter converter = new MigrationEntryConverter(migrateKeys, meProvider);
        this.migrateStore = new MigrateStore((ConnectionPool)pool, migrateTable, (Provider)new MEProvider(), converter);
        if (this.resetIngestDB) {
            try {
                this.sayv("resetting ingest DB...");
                int updateCount = this.migrateStore.resetImportCodes(this.storeName);
                this.sayv("...done! Update " + updateCount + " records.");
            }
            catch (Throwable t) {
                if (this.isVerbose) {
                    t.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    protected void vsay(String x) {
        if (this.isVerbose) {
            FSMigrationTool.say(x);
        }
    }

    public MigrateStore getMigrateStore() {
        return this.migrateStore;
    }

    public void setMigrateStore(MigrateStore migrateStore) {
        this.migrateStore = migrateStore;
    }

    public boolean isUpkeepOn() {
        return this.upkeepOn;
    }

    public void setUpkeepOn(boolean upkeepOn) {
        this.upkeepOn = upkeepOn;
    }

    public static void say(String x) {
        FSMigrationTool.getIoInterface().println((Object)x);
        if (FSMigrationTool.echoOn()) {
            try {
                echoWriter.write(x + "\n");
            }
            catch (IOException e) {
                echoWriter = null;
                FSMigrationTool.getIoInterface().println((Object)("warning: echoing failed. echo is disabled:" + e.getMessage()));
            }
        }
    }

    protected static boolean echoOn() {
        return echoWriter != null;
    }

    protected static Map<String, HelpEntry> getHelpMap() {
        if (helpMap == null) {
            helpMap = new HashMap<String, HelpEntry>();
            FSMigrationTool.addHelpEntry(CONFIG_BATCH_SIZE, "I", "0", "The number of files to process at once. Default (0) is no batching.");
            FSMigrationTool.addHelpEntry(CONFIG_CLEANUP, "F", "-", "Removes the ingestion database. This will be executed, then the application will exit.", new String[]{"Since Derby does not have a nice way to clean databases up, it is included as a utility."});
            FSMigrationTool.addHelpEntry(CONFIG_ECHO_APPEND, "B", "true", "If echoing, append to the echo file. Default is true. If false, the file is overwritten.");
            FSMigrationTool.addHelpEntry(CONFIG_ECHO_FILE, "S", "Path to a file (always overwritten) that echos the console output.");
            FSMigrationTool.addHelpEntry(CONFIG_HELP, "F", "Show the help. Overrides all other flags. Note double hypen!");
            FSMigrationTool.addHelpEntry(CONFIG_NO_TRANSACTIONS, "F", "Does not migrate any pending transfers. This means", new String[]{"any pending transfers are lost. Default is false."});
            FSMigrationTool.addHelpEntry(CONFIG_PACE_OFF, "B", "true", "Disables the pacer (status bar thingy.) default is true");
            FSMigrationTool.addHelpEntry(CONFIG_RESET, "F", "If the ingest table exists, reset all of the entries to being un-imported.", new String[]{"This is useful if the import failed and you want to restart all over without re-ingesting", "Note that this may be used with -storeName to do a single component."});
            FSMigrationTool.addHelpEntry(CONFIG_SETUP, "F", "Creates any required databases. This creates any databases then exits.", new String[]{"If omitted, the databases are created as needed and the migration is done."});
            FSMigrationTool.addHelpEntry(CONFIG_SHOW_CONNECT, "F", "false", "Show the Derby connection strings. Useful if you have Derby installed. Default is not to show.");
            FSMigrationTool.addHelpEntry(CONFIG_SOURCE_CFG, "S", "The full path to the source config file.");
            FSMigrationTool.addHelpEntry(CONFIG_SOURCE_CFG_NAME, "S", "The name of the configuration. Must be a file store.");
            FSMigrationTool.addHelpEntry(CONFIG_STORE_NAME, "S", "The name of a single store component (these are the tag names in the XML", new String[]{"file). If you supply this, exactly that one component will be imported and nothing else.", "Used in conjuntion with -reset, resets only that named components."});
            FSMigrationTool.addHelpEntry(CONFIG_TARGET_CFG, "S", "The full path to the configuration file.", new String[]{"If omitted, assumed to be the same as -src"});
            FSMigrationTool.addHelpEntry(CONFIG_TARGET_CFG_NAME, "F", "The name of the target configuration");
            FSMigrationTool.addHelpEntry(CONFIG_DO_UPKEEP, "B", "true", "Applies upkeep in the target store to all entries on import. Default is true");
            FSMigrationTool.addHelpEntry(CONFIG_VERBOSE, "F", "Makes the operation much chattier. Default is none.");
        }
        return helpMap;
    }

    protected static void addHelpEntry(String name, String type, String description) {
        FSMigrationTool.addHelpEntry(name, type, "-", description, null);
    }

    protected static void addHelpEntry(String name, String type, String description, String[] description2) {
        FSMigrationTool.addHelpEntry(name, type, "-", description, description2);
    }

    protected static void addHelpEntry(String name, String type, String defaultValue, String description) {
        FSMigrationTool.addHelpEntry(name, type, defaultValue, description, null);
    }

    protected static void addHelpEntry(String name, String type, String defaultValue, String description, String[] description2) {
        HelpEntry helpEntry = new HelpEntry(name, type, defaultValue, description);
        if (description2 != null && 0 < description2.length) {
            helpEntry.description2 = description2;
        }
        helpMap.put(name, helpEntry);
    }

    public static void showHelp() throws IllegalAccessException {
        FSMigrationTool.say(FSMigrationTool.class.getSimpleName() + ": a tool to migrate an existing filestore to another store");
        FSMigrationTool.say("The scenario is that you have a possible enormous filestore with thousands of entries and need");
        FSMigrationTool.say("to move the contents to a different type of OA4MP store. Such a migration should be done separately, ");
        FSMigrationTool.say("not when the server is running since the load could be quite high. ");
        FSMigrationTool.say("Type key: I = integer, F = flag (no arg), B = boolean (true | false), S = string");
        FSMigrationTool.say("If there is a default value, given, otherwise there is a \"-\"");
        FSMigrationTool.say("");
        FSMigrationTool.newHelp();
    }

    private static void newHelp() throws IllegalAccessException {
        FSMigrationTool.getAllConfigNames();
        FSMigrationTool.getHelpMap();
        int width = 0;
        for (String name : ALL_CONFIG_NAMES) {
            width = Math.max(width, name.length());
        }
        String spacer = "|";
        int typeWidth = 3;
        int defaultWidth = 5;
        String indent = StringUtils.getBlanks((int)(width + typeWidth + defaultWidth + 3 * spacer.length() - 1));
        String title = StringUtils.center((String)"Name", (int)width) + spacer + StringUtils.center((String)"T", (int)typeWidth) + spacer + StringUtils.center((String)"Def", (int)defaultWidth) + spacer + StringUtils.center((String)"Description", (int)40);
        FSMigrationTool.say(title);
        for (String configName : ALL_CONFIG_NAMES) {
            HelpEntry he = helpMap.get(configName);
            String line = StringUtils.RJustify((String)configName, (int)width) + spacer + StringUtils.center((String)he.type, (int)typeWidth) + spacer + StringUtils.center((String)he.defaultValue, (int)defaultWidth) + spacer + " " + he.description;
            FSMigrationTool.say(line);
            if (he.description2 == null) continue;
            for (String d : he.description2) {
                FSMigrationTool.say(indent + spacer + " " + d);
            }
        }
        FSMigrationTool.say("Column Key:");
        FSMigrationTool.say("T = type, Def = default");
        FSMigrationTool.say("Table entry key:");
        FSMigrationTool.say("B = boolean, true or false");
        FSMigrationTool.say("F = flag (present or not)");
        FSMigrationTool.say("S = String. Double quote as needed");
        FSMigrationTool.say("**************************************************************");
        FSMigrationTool.say("* Be sure to read the documentation either on the website at *");
        FSMigrationTool.say("*      https://oa4mp.org/pdf/filestore-migration.pdf         *");
        FSMigrationTool.say("* or included in the standard distribution in                *");
        FSMigrationTool.say("*      $OA4MP_SERVER/docs/filestore-migration.pdf            *");
        FSMigrationTool.say("**************************************************************");
    }

    private static void oldHelp() {
        int width = 20;
        String eq = " : ";
        String indent = StringUtils.getBlanks((int)(width + 1 + 2 * eq.length()));
        FSMigrationTool.say("Type key: I = integer, F = flag (no arg), B = boolean (true | false), S = string");
        FSMigrationTool.say("");
        FSMigrationTool.say(StringUtils.RJustify((String)"     Flag     ", (int)20) + eq + "T" + eq + "                           Description");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_BATCH_SIZE, (int)20) + eq + "I" + eq + "The number of files to process at once. Default is no batching.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_CLEANUP, (int)20) + eq + "F" + eq + "Removes the ingestion database. This will be executed, then the application will exit.");
        FSMigrationTool.say(indent + "Since Derby does not have a nice way to clean databases up, it is included as a utility.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_ECHO_APPEND, (int)20) + eq + "B" + eq + "If echoing, append to the echo file. Default is true. If false, the file is overwritten.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_ECHO_FILE, (int)20) + eq + "S" + eq + "Path to a file (always overwritten) that echos the console output.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_HELP, (int)20) + eq + "F" + eq + "Show the help. Overrides all other flags. Note double hypen!");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_NO_TRANSACTIONS, (int)20) + eq + "F" + eq + "Does not migrate any pending transfers. This means");
        FSMigrationTool.say(indent + "any pending transfers are lost. Default is false.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_PACE_OFF, (int)20) + eq + "B" + eq + "Disables the pacer (status bar thingy.) default is true");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_RESET, (int)20) + eq + "F" + eq + "If the ingest table exists, reset all of the entries to being un-imported.");
        FSMigrationTool.say(indent + "This is useful if the import failed and you want to restart all over without re-ingesting");
        FSMigrationTool.say(indent + "Note that this may be used with -storeName to do a single component.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_SETUP, (int)20) + eq + "F" + eq + "Creates any required databases. This creates any databases then exits.");
        FSMigrationTool.say(indent + "If omitted, the databases are created as needed and the migration is done.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_SHOW_CONNECT, (int)20) + eq + "F" + eq + "Show the Derby connection strings. Useful if you have Derby installed. Default is not to show.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_SOURCE_CFG, (int)20) + eq + "S" + eq + "The full path to the source config file.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_SOURCE_CFG_NAME, (int)20) + eq + "S" + eq + "The name of the configuration. Must be a file store.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_STORE_NAME, (int)20) + eq + "S" + eq + "The name of a single store component (these are the tag names in the XML");
        FSMigrationTool.say(indent + "file). If you supply this, exactly that one component will be imported and nothing else. Used in conjuntion with");
        FSMigrationTool.say(indent + "-reset, resets only that named components.");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_TARGET_CFG, (int)20) + eq + "S" + eq + "The full path to the configuration file.");
        FSMigrationTool.say(indent + "If omitted, assumed to be the same as -src");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_TARGET_CFG_NAME, (int)20) + eq + "F" + eq + "The name of the target configuration");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_DO_UPKEEP, (int)20) + eq + "B" + eq + "Applies upkeep in the target store to all entries on import. Default is true");
        FSMigrationTool.say(StringUtils.RJustify((String)CONFIG_VERBOSE, (int)20) + eq + "F" + eq + "Makes the operation much chattier. Default is none.");
    }

    public boolean isNoTransactions() {
        return this.noTransactions;
    }

    protected void removeMigrationDB(InputLine inputLine) {
        File dbDir;
        if (inputLine.hasArg(CONFIG_HELP)) {
            FSMigrationTool.say("The migration database is created in the source storage directory");
            FSMigrationTool.say("and is a Derby database. This facility will remove one completely.");
            FSMigrationTool.say("Note that this runs in stages, in that the migration database is created");
            FSMigrationTool.say("and contains all of the information to import the source to the target.");
            FSMigrationTool.say("In this way, if the actual import is interrupted, it can simply resume.");
            FSMigrationTool.say("Also, if for some reason the ingestion is interrupted so that the migration ");
            FSMigrationTool.say("database is incomplete, run this method and restart the whole process.");
            FSMigrationTool.say("This is done in stages since some file stores have gotten immense and");
            FSMigrationTool.say("migrating them is a very serious task that must be done carefully and");
            FSMigrationTool.say("atomically.");
            return;
        }
        if (!inputLine.hasArg(CONFIG_SOURCE_CFG)) {
            FSMigrationTool.say("missing -src parameter.");
            return;
        }
        this.setSourceFile(inputLine.getNextArgFor(CONFIG_SOURCE_CFG));
        inputLine.removeSwitchAndValue(CONFIG_SOURCE_CFG);
        if (inputLine.hasArg(CONFIG_SOURCE_CFG_NAME)) {
            this.setSourceConfigName(inputLine.getNextArgFor(CONFIG_SOURCE_CFG_NAME));
            inputLine.removeSwitchAndValue(CONFIG_SOURCE_CFG_NAME);
        } else {
            FSMigrationTool.say("missing -srcName parameter.");
        }
        if (inputLine.hasArg(CONFIG_STORE_NAME)) {
            this.storeName = inputLine.getNextArgFor(CONFIG_STORE_NAME).toLowerCase();
            inputLine.removeSwitchAndValue(CONFIG_STORE_NAME);
        }
        if (!(dbDir = this.getDBDir()).exists()) {
            FSMigrationTool.say("no database found to remove at \"" + dbDir.getAbsolutePath() + "\"");
            return;
        }
        FSMigrationTool.say("Remove the migration database at \"" + dbDir.getAbsolutePath() + "\"? (Y/n)");
        String inString = null;
        try {
            inString = this.readline();
        }
        catch (IOException e) {
            FSMigrationTool.say("Sorry, that didn't work:" + e.getMessage());
            return;
        }
        if (!inString.equals("Y")) {
            FSMigrationTool.say("aborting...");
            return;
        }
        this.nukeDir(dbDir);
        FSMigrationTool.say("done");
    }

    protected File getDBDir() {
        ConfigurationNode node = XMLConfigUtil.findConfiguration((String)this.getSourceFile(), (String)this.getSourceConfigName(), (String)"service");
        OA2ConfigurationLoader sourceLoader = new OA2ConfigurationLoader(node);
        this.sourceSE = (OA2SE)sourceLoader.load();
        FileStore clientStore = (FileStore)this.sourceSE.getClientStore();
        return new File(clientStore.getStorageDirectory().getParentFile().getParentFile(), INGESTION_FILE_NAME);
    }

    protected void nukeDir(File dir) {
        File[] files;
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.nukeDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    protected boolean getArgs(InputLine inputLine) throws IOException {
        if (inputLine.hasArg(CONFIG_VERBOSE)) {
            this.setVerbose(true);
            inputLine.removeSwitch(CONFIG_VERBOSE);
        }
        this.resetIngestDB = inputLine.hasArg(CONFIG_RESET);
        inputLine.removeSwitch(CONFIG_RESET);
        if (!inputLine.hasArg(CONFIG_SOURCE_CFG)) {
            FSMigrationTool.say("missing -src parameter.");
            return false;
        }
        this.setSourceFile(inputLine.getNextArgFor(CONFIG_SOURCE_CFG));
        inputLine.removeSwitchAndValue(CONFIG_SOURCE_CFG);
        this.setup = inputLine.hasArg(CONFIG_SETUP);
        inputLine.removeSwitch(CONFIG_SETUP);
        if (inputLine.hasArg(CONFIG_TARGET_CFG)) {
            this.setTargetFile(inputLine.getNextArgFor(CONFIG_TARGET_CFG));
            inputLine.removeSwitchAndValue(CONFIG_TARGET_CFG);
        } else {
            this.setTargetFile(this.getSourceFile());
            this.sayv("No explicit target configuration, using the source configuration for both.");
        }
        if (!inputLine.hasArg(CONFIG_SOURCE_CFG_NAME)) {
            FSMigrationTool.say("missing -srcName parameter.");
            return false;
        }
        this.setSourceConfigName(inputLine.getNextArgFor(CONFIG_SOURCE_CFG_NAME));
        inputLine.removeSwitchAndValue(CONFIG_SOURCE_CFG_NAME);
        if (!inputLine.hasArg(CONFIG_TARGET_CFG_NAME)) {
            FSMigrationTool.say("missing -targetName parameter.");
            return false;
        }
        this.setTargetConfigName(inputLine.getNextArgFor(CONFIG_TARGET_CFG_NAME));
        inputLine.removeSwitchAndValue(CONFIG_TARGET_CFG_NAME);
        this.setNoTransactions(inputLine.hasArg(CONFIG_NO_TRANSACTIONS));
        inputLine.removeSwitch(CONFIG_NO_TRANSACTIONS);
        this.setPacerOn(!inputLine.hasArg(CONFIG_PACE_OFF));
        inputLine.removeSwitch(CONFIG_PACE_OFF);
        if (inputLine.hasArg(CONFIG_DO_UPKEEP)) {
            this.setUpkeepOn("true".equalsIgnoreCase(inputLine.getNextArgFor(CONFIG_DO_UPKEEP)));
            inputLine.removeSwitch(CONFIG_DO_UPKEEP);
        }
        if (inputLine.hasArg(CONFIG_BATCH_SIZE)) {
            this.setBatchSize(inputLine.getNextIntArg(new String[]{CONFIG_BATCH_SIZE}));
            inputLine.removeSwitchAndValue(CONFIG_BATCH_SIZE);
        }
        return true;
    }

    private void setupEcho(InputLine inputLine) throws IOException {
        if (inputLine.hasArg(CONFIG_ECHO_APPEND)) {
            this.setEchoAppend(inputLine.getNextArgFor(CONFIG_ECHO_APPEND).equals("true"));
            inputLine.removeSwitchAndValue(CONFIG_ECHO_APPEND);
        }
        if (inputLine.hasArg(CONFIG_ECHO_FILE)) {
            this.echoFileName = inputLine.getNextArgFor(CONFIG_ECHO_FILE);
            File echoFile = new File(this.echoFileName);
            boolean doEcho = false;
            if (echoFile.exists()) {
                if (echoFile.isFile()) {
                    if (!this.isEchoAppend()) {
                        echoFile.delete();
                    }
                    doEcho = true;
                } else {
                    doEcho = false;
                    FSMigrationTool.say("warning \"" + String.valueOf(echoFile) + "\" is a directory. No echoing can be done.");
                }
            } else {
                doEcho = true;
            }
            if (doEcho) {
                FSMigrationTool.say("logging to \"" + echoFile.getAbsolutePath() + "\", append mode = " + (this.isEchoAppend() ? "on" : "off"));
                echoWriter = new FileWriter(echoFile, this.isEchoAppend());
                echoWriter.write("\n" + RunSpacer + "\n");
                echoWriter.write("Starting migration at " + String.valueOf(new Date()) + "\n");
                echoWriter.write(RunSpacer + "\n");
            }
        }
    }

    public boolean isEchoAppend() {
        return this.echoAppend;
    }

    public void setEchoAppend(boolean echoAppend) {
        this.echoAppend = echoAppend;
    }

    public static void main(String[] args) throws Throwable {
        String[] v = new String[1 + args.length];
        v[0] = FSMigrationTool.class.getSimpleName();
        System.arraycopy(args, 0, v, 1, args.length);
        InputLine inputLine = new InputLine(v);
        if (args.length == 0 || inputLine.hasArg(CONFIG_HELP)) {
            FSMigrationTool.showHelp();
            return;
        }
        FSMigrationTool fsm = new FSMigrationTool();
        fsm.setupEcho(inputLine);
        fsm.doCleanup = inputLine.hasArg(CONFIG_CLEANUP);
        fsm.showConnect = inputLine.hasArg(CONFIG_SHOW_CONNECT);
        inputLine.removeSwitch(CONFIG_SHOW_CONNECT);
        if (fsm.doCleanup) {
            fsm.removeMigrationDB(inputLine);
            return;
        }
        if (!fsm.getArgs(inputLine)) {
            return;
        }
        if (fsm.loadEnvironments()) {
            fsm.doIt();
        }
        if (FSMigrationTool.echoOn()) {
            echoWriter.write(RunSpacer + "\n");
            echoWriter.write("End of migration run at " + String.valueOf(new Date()) + "\n");
            echoWriter.write(RunSpacer + "\n");
            echoWriter.flush();
            echoWriter.close();
        }
    }

    public static List<String> getAllConfigNames() throws IllegalAccessException {
        if (ALL_CONFIG_NAMES == null) {
            Field[] declaredFields;
            ALL_CONFIG_NAMES = new ArrayList<String>();
            for (Field field : declaredFields = FSMigrationTool.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("CONFIG_")) continue;
                ALL_CONFIG_NAMES.add(field.get(FSMigrationTool.class).toString());
            }
            Collections.sort(ALL_CONFIG_NAMES);
        }
        return ALL_CONFIG_NAMES;
    }

    protected static class HelpEntry {
        String name;
        String type;
        String description;
        String[] description2;
        String defaultValue = "-";

        public HelpEntry(String name, String type, String defaultValue, String description) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
        }
    }
}

