/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools.migrate;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.inject.Provider;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrateKeys;
import org.oa4mp.server.admin.oauth2.tools.migrate.MigrationEntry;

public class MigrateStore
extends SQLStore<MigrationEntry> {
    public MigrateStore(ConnectionPool connectionPool, Table table, Provider identifiableProvider, MapConverter converter) {
        super(connectionPool, table, identifiableProvider, converter);
    }

    protected MigrateKeys getKeys() {
        return (MigrateKeys)this.getMapConverter().getKeys();
    }

    public String getCreationTSField() {
        return this.getKeys().create_ts(new String[0]);
    }

    protected String getFetchStatement(int batchSize) {
        String s = "select * from " + this.getTable().getFQTablename() + " where " + this.getKeys().is_imported(new String[0]) + "=? AND " + this.getKeys().import_code(new String[0]) + "=? AND " + this.getKeys().store_type(new String[0]) + " =?";
        return s;
    }

    protected String countFetchStatement() {
        String s = "select count(*) from " + this.getTable().getFQTablename() + " where " + this.getKeys().is_imported(new String[0]) + " =? AND " + this.getKeys().import_code(new String[0]) + "=? AND " + this.getKeys().store_type(new String[0]) + " =?";
        return s;
    }

    protected String getIngestStatement() {
        String s = "insert into " + this.getTable().getFQTablename() + " (" + this.getKeys().path(new String[0]) + "," + this.getKeys().filename(new String[0]) + "," + this.getKeys().store_type(new String[0]) + "," + this.getKeys().import_code(new String[0]) + "," + this.getKeys().error_message(new String[0]) + "," + this.getKeys().is_imported(new String[0]) + ") values (?,?,?,?,?,false)";
        return s;
    }

    protected String getUpdateStatement() {
        String s = "update  " + this.getTable().getFQTablename() + "  set " + this.getKeys().is_imported(new String[0]) + "=?," + this.getKeys().import_code(new String[0]) + "=?," + this.getKeys().error_message(new String[0]) + "=?," + this.getKeys().import_ts(new String[0]) + "=? where " + this.getKeys().filename(new String[0]) + "=? AND " + this.getKeys().store_type(new String[0]) + "=?";
        return s;
    }

    public DerbyConnectionPool getConnectionPool() {
        return (DerbyConnectionPool)super.getConnectionPool();
    }

    public boolean exists() {
        File f = new File(this.getConnectionPool().getConnectionParameters().getDatabaseName());
        return f.exists();
    }

    public int resetImportCodes(String component) throws SQLException {
        boolean hasComponent;
        String resetCodeStatement = "update " + this.getTable().getFQTablename() + " set " + this.getKeys().import_code(new String[0]) + "=?";
        resetCodeStatement = resetCodeStatement + ", " + this.getKeys().error_message(new String[0]) + "=?";
        boolean bl = hasComponent = !StringUtils.isTrivial((String)component);
        if (hasComponent) {
            resetCodeStatement = resetCodeStatement + " where " + this.getKeys().store_type(new String[0]) + "=?";
        }
        ConnectionRecord connectionRecord = this.getConnectionPool().pop();
        Connection connection = this.getConnection().connection;
        int out = 0;
        try {
            PreparedStatement p = connection.prepareStatement(resetCodeStatement);
            p.setInt(1, 0);
            p.setNull(2, -1);
            if (hasComponent) {
                p.setString(3, component.toLowerCase());
            }
            out = p.executeUpdate();
            p.close();
            connection.close();
            this.releaseConnection(connectionRecord);
            return out;
        }
        catch (SQLException sqlException) {
            this.destroyConnection(connectionRecord);
            throw sqlException;
        }
    }
}

