/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools.migrate;

public interface MigrationConstants {
    public static final int IMPORT_CODE_NOT_DONE = 0;
    public static final int IMPORT_CODE_SUCCESS = 1;
    public static final int IMPORT_CODE_UPKEEP_TEST_ONLY = 2;
    public static final int IMPORT_CODE_UPKEEP_ARCHIVED = 3;
    public static final int IMPORT_CODE_FILE_NOT_FOUND = -1;
    public static final String IMPORT_MESSAGE_FILE_NOT_FOUND = "file not found";
    public static final int IMPORT_CODE_FILE_PERMISSION = -2;
    public static final String IMPORT_MESSAGE_FILE_PERMISSION = "does not have read access";
    public static final int IMPORT_CODE_FILE_IS_A_DIRECTORY = -3;
    public static final String IMPORT_MESSAGE_FILE_IS_A_DIRECTORY = "is a directory";
    public static final int IMPORT_CODE_PARSE_ERROR = -4;
    public static final String IMPORT_MESSAGE_PARSE_ERROR = "cannot parse entry";
    public static final int IMPORT_CODE_UNKNOWN_ERROR = -5;
    public static final String IMPORT_MESSAGE_UNKNOWN_ERROR = "unknown error";
    public static final String IMPORT_MESSAGE_UNKNOWN_ERROR_CODE = "unknown error code";
    public static final int IMPORT_CODE_EMPTY_FILE = -6;
    public static final String IMPORT_MESSAGE_EMPTY_FILE = "file is empty";
    public static final int IMPORT_CODE_COULD_NOT_READ = -7;
    public static final String IMPORT_MESSAGE_COULD_NOT_READ = "could not read file";
    public static final int IMPORT_CODE_UPKEEP_SKIPPED = -8;
    public static final String IMPORT_MESSAGE_UPKEEP_SKIPPED = "skipped by upkeep";
    public static final int IMPORT_CODE_OTHER_ERROR = -9;
    public static final String IMPORT_MESSAGE_OTHER_ERROR = "";
    public static final int IMPORT_CODE_MISSING_ID = -10;
    public static final String IMPORT_MESSAGE_MISSING_ID = "missing identifier: entry improperly structured";
    public static final int IMPORT_CODE_UPKEEP_DELETED = -11;
    public static final String IMPORT_MESSAGE_UPKEEP_DELETED = "deleted by upkeep";
    public static final int IMPORT_CODE_NO_CORRESPONDING_ENTRY = -12;
    public static final String IMPORT_MESSAGE_NO_CORRESPONDING_ENTRY = "no main entry for this object";
    public static final int[] ALL_FAILURE_CODES = new int[]{-1, -2, -3, -4, -5, -6, -7, -8, -11, -9, -10, -12};

    public static String getImportMessage(int importCode) {
        switch (importCode) {
            case -1: {
                return IMPORT_MESSAGE_FILE_NOT_FOUND;
            }
            case -6: {
                return IMPORT_MESSAGE_EMPTY_FILE;
            }
            case -3: {
                return IMPORT_MESSAGE_FILE_IS_A_DIRECTORY;
            }
            case -2: {
                return IMPORT_MESSAGE_FILE_PERMISSION;
            }
            case -4: {
                return IMPORT_MESSAGE_PARSE_ERROR;
            }
            case 0: {
                return null;
            }
            case -7: {
                return IMPORT_MESSAGE_COULD_NOT_READ;
            }
            case -9: {
                return IMPORT_MESSAGE_OTHER_ERROR;
            }
            case -5: {
                return IMPORT_MESSAGE_UNKNOWN_ERROR;
            }
            case -10: {
                return IMPORT_MESSAGE_MISSING_ID;
            }
            case -12: {
                return IMPORT_MESSAGE_NO_CORRESPONDING_ENTRY;
            }
            case -8: {
                return IMPORT_MESSAGE_UPKEEP_SKIPPED;
            }
            case -11: {
                return IMPORT_MESSAGE_UPKEEP_DELETED;
            }
        }
        return IMPORT_MESSAGE_UNKNOWN_ERROR_CODE;
    }
}

