/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.TrivialUsernameTransformer;
import edu.uiuc.ncsa.security.servlet.UsernameTransformer;
import edu.uiuc.ncsa.security.util.mail.MailUtil;
import edu.uiuc.ncsa.security.util.mail.MailUtilProvider;
import edu.uiuc.ncsa.security.util.pkcs.KeyPairQueue;
import java.net.URI;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.issuers.AGIssuer;
import org.oa4mp.delegation.server.issuers.ATIssuer;
import org.oa4mp.delegation.server.issuers.PAIssuer;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.ServiceEnvironment;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.api.storage.servlet.AuthorizationServletConfig;
import org.oa4mp.server.api.util.AbstractCLIApprover;

public class ServiceEnvironmentImpl
extends AbstractEnvironment
implements ServiceEnvironment {
    KeyPairQueue kpq = new KeyPairQueue();
    AuthorizationServletConfig authorizationServletConfig;
    AGIssuer agIssuer;
    URI serviceAddress;
    ATIssuer atIssuer;
    PAIssuer paIssuer;
    MessagesProvider messagesProvider;
    protected Provider<TransactionStore> tsp;
    protected Provider<ClientStore> csp;
    protected Provider<ClientApprovalStore> casp;
    protected Provider<PermissionsStore> psp;
    protected Provider<AGIssuer> agip;
    protected Provider<ATIssuer> atip;
    protected Provider<PAIssuer> paip;
    protected Provider<TokenForge> tfp;
    Map<String, String> messages;
    PermissionsStore permissionsStore = null;
    protected MailUtil mailUtil;
    protected ClientApprovalStore<ClientApproval> clientApprovalStore;
    protected ClientStore clientStore;
    protected TransactionStore<ServiceTransaction> transactionStore;
    MailUtilProvider mup;
    AbstractCLIApprover.ClientApprovalThread clientApprovalThread;
    int maxAllowedNewClientRequests = 100;
    UsernameTransformer usernameTransformer = new TrivialUsernameTransformer();

    public KeyPairQueue getKeyPairQueue() {
        return this.kpq;
    }

    @Override
    public KeyPair getKeyPair() {
        return this.kpq.pop();
    }

    @Override
    public AuthorizationServletConfig getAuthorizationServletConfig() {
        return this.authorizationServletConfig;
    }

    @Override
    public boolean hasAuthorizationServletConfig() {
        return this.authorizationServletConfig != null;
    }

    @Override
    public URI getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    public void setServiceAddress(URI serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    @Override
    public AGIssuer getAgIssuer() {
        if (this.agIssuer == null) {
            this.agIssuer = (AGIssuer)this.agip.get();
        }
        return this.agIssuer;
    }

    @Override
    public ATIssuer getAtIssuer() {
        if (this.atIssuer == null) {
            this.atIssuer = (ATIssuer)this.atip.get();
        }
        return this.atIssuer;
    }

    @Override
    public PAIssuer getPaIssuer() {
        if (this.paIssuer == null) {
            this.paIssuer = (PAIssuer)this.paip.get();
        }
        return this.paIssuer;
    }

    @Override
    public TokenForge getTokenForge() {
        return (TokenForge)this.tfp.get();
    }

    public ServiceEnvironmentImpl(MyLoggingFacade logger, Provider<TransactionStore> tsp, Provider<ClientStore> csp, int maxAllowedNewClientRequests, Provider<ClientApprovalStore> casp, MailUtilProvider mup, MessagesProvider messagesProvider, Provider<AGIssuer> agip, Provider<ATIssuer> atip, Provider<PAIssuer> paip, Provider<TokenForge> tfp, HashMap<String, String> constants, AuthorizationServletConfig ac, UsernameTransformer usernameTransformer, boolean isPingable, Provider<PermissionsStore> psp) {
        super(logger, constants);
        this.casp = casp;
        this.csp = csp;
        this.tsp = tsp;
        this.mup = mup;
        this.messagesProvider = messagesProvider;
        this.atip = atip;
        this.agip = agip;
        this.paip = paip;
        this.tfp = tfp;
        this.authorizationServletConfig = ac;
        this.maxAllowedNewClientRequests = maxAllowedNewClientRequests;
        this.usernameTransformer = usernameTransformer;
        this.setPingable(isPingable);
        this.psp = psp;
    }

    @Override
    public Map<String, String> getMessages() {
        if (this.messages == null) {
            if (this.messagesProvider == null) {
                this.messages = new HashMap<String, String>();
                this.messages.put("retryMessage", "Authentication failed.");
            } else {
                this.messages = this.messagesProvider.get();
            }
        }
        return this.messages;
    }

    @Override
    public PermissionsStore<Permission> getPermissionStore() {
        if (this.permissionsStore == null) {
            this.permissionsStore = (PermissionsStore)this.psp.get();
        }
        return this.permissionsStore;
    }

    public ClientApprovalStore getClientApprovalStore() {
        if (this.clientApprovalStore == null) {
            this.clientApprovalStore = (ClientApprovalStore)this.casp.get();
        }
        return this.clientApprovalStore;
    }

    public ClientStore getClientStore() {
        if (this.clientStore == null) {
            this.clientStore = (ClientStore)this.csp.get();
        }
        return this.clientStore;
    }

    @Override
    public MailUtil getMailUtil() {
        if (this.mailUtil == null) {
            this.mailUtil = this.mup.get();
            if (this.getMyLogger() != null) {
                this.mailUtil.setMyLogger(this.getMyLogger());
            }
        }
        return this.mailUtil;
    }

    @Override
    public TransactionStore<ServiceTransaction> getTransactionStore() {
        if (this.transactionStore == null) {
            this.transactionStore = (TransactionStore)this.tsp.get();
        }
        return this.transactionStore;
    }

    public boolean isPollingEnabled() {
        return this.clientApprovalThread != null;
    }

    public AbstractCLIApprover.ClientApprovalThread getClientApprovalThread() {
        return this.clientApprovalThread;
    }

    public void setClientApprovalThread(AbstractCLIApprover.ClientApprovalThread clientApprovalThread) {
        this.clientApprovalThread = clientApprovalThread;
    }

    @Override
    public int getMaxAllowedNewClientRequests() {
        return this.maxAllowedNewClientRequests;
    }

    @Override
    public UsernameTransformer getUsernameTransformer() {
        return this.usernameTransformer;
    }

    @Override
    public void setUsernameTransformer(UsernameTransformer usernameTransformer) {
        this.usernameTransformer = usernameTransformer;
    }

    @Override
    public AdminClientStore<AdminClient> getAdminClientStore() {
        throw new NotImplementedException("No admin client store in legacy code");
    }

    @Override
    public List<Store> listStores() {
        LinkedList<Store> stores = new LinkedList<Store>();
        stores.add((Store)this.getClientStore());
        stores.add(this.getPermissionStore());
        stores.add((Store)this.getTransactionStore());
        stores.add((Store)this.getAdminClientStore());
        stores.add((Store)this.getClientApprovalStore());
        return stores;
    }

    public static class MessagesProvider
    extends HierarchicalConfigProvider<Map<String, String>> {
        public MessagesProvider(ConfigurationNode config) {
            super(config);
        }

        protected boolean checkEvent(CfgEvent cfgEvent) {
            if (cfgEvent.getConfiguration().getName().equals("messages")) {
                this.setConfig(cfgEvent.getConfiguration());
                return true;
            }
            return false;
        }

        public Object componentFound(CfgEvent configurationEvent) {
            if (this.checkEvent(configurationEvent)) {
                return this.get();
            }
            return null;
        }

        public Map<String, String> get() {
            HashMap<String, String> messages = new HashMap<String, String>();
            messages.put("retryMessage", Configurations.getNodeValue((ConfigurationNode)this.getConfig(), (String)"retryMessage", (String)"Authentication failed."));
            return messages;
        }
    }
}

