/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.admin.adminClient;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;

public class AdminClient
extends BaseClient {
    public static int DEFAULT_MAX_NUMBER_OF_OIDC_CLIENTS = 50;
    public static String PUBLIC_KEY_KEY = "public_key";
    Identifier virtualIssuer = null;
    String issuer;
    String externalVIName;
    int maxClients = DEFAULT_MAX_NUMBER_OF_OIDC_CLIENTS;
    JSONObject config;
    boolean allowQDL = false;
    boolean allowQDLCodeBlocks = false;
    boolean notifyOnNewClientCreate = false;
    boolean listUsers = false;
    boolean listUserInOtherClients = false;
    boolean allowCustomIDs = false;
    boolean generateIDs = false;
    URI idHead = null;
    boolean useTimestampInIDs = true;
    boolean initializeFlows = false;

    public PublicKey getPublicKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (!this.hasConfig()) {
            return null;
        }
        if (!this.getConfig().containsKey((Object)PUBLIC_KEY_KEY)) {
            return null;
        }
        String raw = this.getConfig().getString(PUBLIC_KEY_KEY);
        if (raw.isEmpty()) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(raw);
        String x509 = new String(bytes);
        return KeyUtil.fromX509PEM((String)x509);
    }

    public void setPublicKey(PublicKey publicKey) {
        String key = KeyUtil.toX509PEM((PublicKey)publicKey);
        String encoded = Base64.getEncoder().encodeToString(key.getBytes());
        this.getConfig().put((Object)PUBLIC_KEY_KEY, (Object)encoded);
    }

    public boolean hasConfig() {
        return this.getConfig() != null && !this.getConfig().isEmpty();
    }

    public AdminClient(Identifier identifier) {
        super(identifier);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getExternalVIName() {
        return this.externalVIName;
    }

    public void setExternalVIName(String externalVIName) {
        this.externalVIName = externalVIName;
    }

    public Identifier getVirtualIssuer() {
        return this.virtualIssuer;
    }

    public void setVirtualIssuer(Identifier virtualIssuer) {
        this.virtualIssuer = virtualIssuer;
    }

    public boolean hasVirtualIssuer() {
        return this.virtualIssuer != null;
    }

    public JSONObject getConfig() {
        return this.config;
    }

    public void setConfig(JSONObject config) {
        this.config = config;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public void setMaxClients(int maxClients) {
        this.maxClients = maxClients;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdminClient)) {
            return false;
        }
        AdminClient ac = (AdminClient)((Object)obj);
        if (!BeanUtils.checkEquals((Object)this.getIssuer(), (Object)ac.getIssuer())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)this.getVirtualIssuer(), (Object)ac.getVirtualIssuer())) {
            return false;
        }
        if (this.getMaxClients() != ac.getMaxClients()) {
            return false;
        }
        return super.equals(obj);
    }

    public BaseClient clone() {
        AdminClient ac = new AdminClient(this.getIdentifier());
        this.populateClone(ac);
        return ac;
    }

    protected void populateClone(BaseClient client) {
        AdminClient c = (AdminClient)client;
        super.populateClone((BaseClient)c);
        c.setCreationTS(this.getCreationTS());
        c.setEmail(this.getEmail());
        c.setName(this.getName());
        c.setSecret(this.getSecret());
        c.setMaxClients(this.getMaxClients());
    }

    public boolean isAllowQDL() {
        return this.allowQDL;
    }

    public void setAllowQDL(boolean allowQDL) {
        this.allowQDL = allowQDL;
    }

    public boolean allowQDLCodeBlocks() {
        return this.allowQDLCodeBlocks;
    }

    public void setAllowQDLCodeBlocks(boolean allowQDLCodeBlocks) {
        this.allowQDLCodeBlocks = allowQDLCodeBlocks;
    }

    public String toString() {
        return "AdminClient{admin_id=" + String.valueOf(this.getIdentifier()) + ", virtualIssuer=" + String.valueOf(this.virtualIssuer) + ", issuer='" + this.issuer + "', externalVIName='" + this.externalVIName + "', maxClients=" + this.maxClients + ", config=" + String.valueOf(this.config) + ", allowQDL=" + this.allowQDL + ", allowQDLCodeBlocks=" + this.allowQDLCodeBlocks + ", notifyOnNewClientCreate=" + this.notifyOnNewClientCreate + ", listUsers=" + this.listUsers + ", listUserInOtherClients=" + this.listUserInOtherClients + ", allowCustomIDs=" + this.allowCustomIDs + ", generateIDs=" + this.generateIDs + ", idHead=" + String.valueOf(this.idHead) + ", useTimestampInIDs=" + this.useTimestampInIDs + "}";
    }

    public boolean isNotifyOnNewClientCreate() {
        return this.notifyOnNewClientCreate;
    }

    public void setNotifyOnNewClientCreate(boolean notifyOnNewClientCreate) {
        this.notifyOnNewClientCreate = notifyOnNewClientCreate;
    }

    public boolean isListUsers() {
        return this.listUsers;
    }

    public void setListUsers(boolean listUsers) {
        this.listUsers = listUsers;
    }

    public boolean isListUsersInOtherClients() {
        return this.listUserInOtherClients;
    }

    public void setListUsersInOtherClients(boolean listUserInOtherClients) {
        this.listUserInOtherClients = listUserInOtherClients;
    }

    public boolean isAllowCustomIDs() {
        return this.allowCustomIDs;
    }

    public void setAllowCustomIDs(boolean allowCustomIDs) {
        this.allowCustomIDs = allowCustomIDs;
    }

    public boolean isGenerateIDs() {
        return this.generateIDs;
    }

    public void setGenerateIDs(boolean generateIDs) {
        this.generateIDs = generateIDs;
    }

    public URI getIdHead() {
        return this.idHead;
    }

    public void setIdHead(URI idHead) {
        this.idHead = idHead;
    }

    public boolean isUseTimestampInIDs() {
        return this.useTimestampInIDs;
    }

    public void setUseTimestampInIDs(boolean useTimestampInIDs) {
        this.useTimestampInIDs = useTimestampInIDs;
    }

    public boolean canInitializeFlows() {
        return this.initializeFlows;
    }

    public void setInitializeFlows(boolean initializeFlows) {
        this.initializeFlows = initializeFlows;
    }
}

