/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.admin.adminClient;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import java.net.URI;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClientConverter;
import org.oa4mp.delegation.common.storage.clients.BaseClientKeys;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientKeys;

public class AdminClientConverter<V extends AdminClient>
extends BaseClientConverter<V> {
    public String getJSONComponentName() {
        return "admin";
    }

    public AdminClientConverter(AdminClientKeys keys, IdentifiableProvider<V> provider) {
        super((BaseClientKeys)keys, provider);
    }

    protected AdminClientKeys getACK() {
        return (AdminClientKeys)this.keys;
    }

    public V fromJSON(JSONObject json) {
        JSONObject config;
        AdminClient v = (AdminClient)super.fromJSON(json);
        v.setListUsers(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().listUsers(new String[0])));
        v.setListUsersInOtherClients(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().listUsersInOtherClients(new String[0])));
        v.setNotifyOnNewClientCreate(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().notifyOnNewClientCreate(new String[0])));
        v.setIssuer(this.getJsonUtil().getJSONValueString(json, this.getACK().issuer(new String[0])));
        v.setExternalVIName(this.getJsonUtil().getJSONValueString(json, this.getACK().vo(new String[0])));
        v.setVirtualIssuer(BasicIdentifier.newID((String)this.getJsonUtil().getJSONValueString(json, this.getACK().voURI(new String[0]))));
        v.setMaxClients(this.getJsonUtil().getJSONValueInt(json, this.getACK().maxClients(new String[0])));
        v.setAllowQDL(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().allowQDL(new String[0])));
        v.setInitializeFlows(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().initializeFlows(new String[0])));
        v.setGenerateIDs(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().generateIDs(new String[0])));
        v.setUseTimestampInIDs(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().useTimestampsInIds(new String[0])));
        v.setAllowCustomIDs(this.getJsonUtil().getJSONValueBoolean(json, this.getACK().allowCustomIDs(new String[0])));
        if (this.getJsonUtil().hasKey(json, this.getACK().idHead(new String[0]))) {
            v.setIdHead(URI.create(this.getJsonUtil().getJSONValueString(json, this.getACK().idHead(new String[0]))));
        }
        if ((config = (JSONObject)this.getJsonUtil().getJSONValue(json, this.getACK().config(new String[0]))) != null) {
            v.setConfig(config);
        }
        return (V)((Object)v);
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        AdminClient value = (AdminClient)super.fromMap(map, v);
        value.setExternalVIName(map.getString((Object)this.getACK().vo(new String[0])));
        try {
            value.setVirtualIssuer(BasicIdentifier.newID((String)map.getString((Object)this.getACK().voURI(new String[0]))));
        }
        catch (Throwable t) {
            throw new GeneralException("Error reading " + this.getACK().voURI(new String[0]) + " field in database: \"" + t.getMessage() + "\"");
        }
        value.setIssuer(map.getString((Object)this.getACK().issuer(new String[0])));
        if (map.containsKey((Object)this.getACK().allowCustomIDs(new String[0]))) {
            value.setAllowCustomIDs(map.getBoolean((Object)this.getACK().allowCustomIDs(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().generateIDs(new String[0]))) {
            value.setGenerateIDs(map.getBoolean((Object)this.getACK().generateIDs(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().initializeFlows(new String[0]))) {
            value.setInitializeFlows(map.getBoolean((Object)this.getACK().initializeFlows(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().useTimestampsInIds(new String[0]))) {
            value.setUseTimestampInIDs(map.getBoolean((Object)this.getACK().useTimestampsInIds(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().idHead(new String[0])) && map.get((Object)this.getACK().idHead(new String[0])) != null) {
            value.setIdHead(URI.create(map.getString((Object)this.getACK().idHead(new String[0]))));
        }
        if (map.containsKey((Object)this.getACK().allowQDL(new String[0]))) {
            value.setAllowQDL(map.getBoolean((Object)this.getACK().allowQDL(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().allowQDLCodeBlocks(new String[0]))) {
            value.setAllowQDLCodeBlocks(map.getBoolean((Object)this.getACK().allowQDLCodeBlocks(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().notifyOnNewClientCreate(new String[0]))) {
            value.setNotifyOnNewClientCreate(map.getBoolean((Object)this.getACK().notifyOnNewClientCreate(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().listUsers(new String[0]))) {
            value.setListUsers(map.getBoolean((Object)this.getACK().listUsers(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().listUsersInOtherClients(new String[0]))) {
            value.setListUsersInOtherClients(map.getBoolean((Object)this.getACK().listUsersInOtherClients(new String[0])));
        }
        if (!map.containsKey((Object)this.getACK().maxClients(new String[0])) || map.get((Object)this.getACK().maxClients(new String[0])) == null) {
            value.setMaxClients(AdminClient.DEFAULT_MAX_NUMBER_OF_OIDC_CLIENTS);
        } else {
            value.setMaxClients(map.getInteger((Object)this.getACK().maxClients(new String[0])));
        }
        if (map.containsKey((Object)this.getACK().config(new String[0]))) {
            String rawCfg = map.getString((Object)this.getACK().config(new String[0]));
            if (rawCfg != null && !rawCfg.isEmpty()) {
                value.setConfig(JSONObject.fromObject((Object)map.getString((Object)this.getACK().config(new String[0]))));
            } else {
                value.setConfig(new JSONObject());
            }
        }
        return (V)((Object)value);
    }

    public void toJSON(V client, JSONObject json) {
        super.toJSON(client, json);
        this.getJsonUtil().setJSONValue(json, this.getACK().vo(new String[0]), (Object)((AdminClient)((Object)client)).getExternalVIName());
        if (((AdminClient)((Object)client)).getVirtualIssuer() != null) {
            this.getJsonUtil().setJSONValue(json, this.getACK().voURI(new String[0]), (Object)((AdminClient)((Object)client)).getVirtualIssuer().toString());
        }
        this.getJsonUtil().setJSONValue(json, this.getACK().allowCustomIDs(new String[0]), (Object)((AdminClient)((Object)client)).isAllowCustomIDs());
        this.getJsonUtil().setJSONValue(json, this.getACK().generateIDs(new String[0]), (Object)((AdminClient)((Object)client)).isGenerateIDs());
        this.getJsonUtil().setJSONValue(json, this.getACK().initializeFlows(new String[0]), (Object)((AdminClient)((Object)client)).canInitializeFlows());
        this.getJsonUtil().setJSONValue(json, this.getACK().useTimestampsInIds(new String[0]), (Object)((AdminClient)((Object)client)).isUseTimestampInIDs());
        if (((AdminClient)((Object)client)).getIdHead() != null) {
            this.getJsonUtil().setJSONValue(json, this.getACK().idHead(new String[0]), (Object)((AdminClient)((Object)client)).getIdHead().toString());
        }
        this.getJsonUtil().setJSONValue(json, this.getACK().issuer(new String[0]), (Object)((AdminClient)((Object)client)).getIssuer());
        this.getJsonUtil().setJSONValue(json, this.getACK().maxClients(new String[0]), (Object)((AdminClient)((Object)client)).getMaxClients());
        this.getJsonUtil().setJSONValue(json, this.getACK().allowQDL(new String[0]), (Object)((AdminClient)((Object)client)).isAllowQDL());
        this.getJsonUtil().setJSONValue(json, this.getACK().notifyOnNewClientCreate(new String[0]), (Object)((AdminClient)((Object)client)).isNotifyOnNewClientCreate());
        this.getJsonUtil().setJSONValue(json, this.getACK().listUsers(new String[0]), (Object)((AdminClient)((Object)client)).isListUsers());
        this.getJsonUtil().setJSONValue(json, this.getACK().listUsersInOtherClients(new String[0]), (Object)((AdminClient)((Object)client)).isListUsersInOtherClients());
        if (((AdminClient)((Object)client)).getConfig() != null && !((AdminClient)((Object)client)).getConfig().isEmpty()) {
            json.put((Object)this.getACK().config(new String[0]), (Object)((AdminClient)((Object)client)).getConfig());
        }
    }

    public void toMap(V client, ConversionMap<String, Object> map) {
        map.put((Object)this.getACK().issuer(new String[0]), (Object)((AdminClient)((Object)client)).getIssuer());
        map.put((Object)this.getACK().vo(new String[0]), (Object)((AdminClient)((Object)client)).getExternalVIName());
        map.put((Object)this.getACK().voURI(new String[0]), (Object)((AdminClient)((Object)client)).getVirtualIssuer());
        map.put((Object)this.getACK().maxClients(new String[0]), (Object)((AdminClient)((Object)client)).getMaxClients());
        map.put((Object)this.getACK().allowQDL(new String[0]), (Object)((AdminClient)((Object)client)).isAllowQDL());
        map.put((Object)this.getACK().allowQDLCodeBlocks(new String[0]), (Object)((AdminClient)((Object)client)).allowQDLCodeBlocks());
        map.put((Object)this.getACK().generateIDs(new String[0]), (Object)((AdminClient)((Object)client)).isGenerateIDs());
        map.put((Object)this.getACK().allowCustomIDs(new String[0]), (Object)((AdminClient)((Object)client)).isAllowCustomIDs());
        map.put((Object)this.getACK().initializeFlows(new String[0]), (Object)((AdminClient)((Object)client)).canInitializeFlows());
        map.put((Object)this.getACK().useTimestampsInIds(new String[0]), (Object)((AdminClient)((Object)client)).isUseTimestampInIDs());
        if (((AdminClient)((Object)client)).getIdHead() != null) {
            map.put((Object)this.getACK().idHead(new String[0]), (Object)((AdminClient)((Object)client)).getIdHead().toString());
        }
        map.put((Object)this.getACK().notifyOnNewClientCreate(new String[0]), (Object)((AdminClient)((Object)client)).isNotifyOnNewClientCreate());
        map.put((Object)this.getACK().listUsers(new String[0]), (Object)((AdminClient)((Object)client)).isListUsers());
        map.put((Object)this.getACK().listUsersInOtherClients(new String[0]), (Object)((AdminClient)((Object)client)).isListUsersInOtherClients());
        if (((AdminClient)((Object)client)).getConfig() != null && !((AdminClient)((Object)client)).getConfig().isEmpty()) {
            map.put((Object)this.getACK().config(new String[0]), (Object)((AdminClient)((Object)client)).getConfig().toString(1));
        }
        super.toMap(client, map);
    }
}

