/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.admin.permissions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.permissions.PermissionStoreUtil;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;

public class PermissionFileStore<V extends Permission>
extends FileStore<V>
implements PermissionsStore<V> {
    public List<V> getMostRecent(int n, List<String> attributes) {
        throw new UnsupportedOperationException("get most recent not supported for permissions");
    }

    public PermissionFileStore(File directory, IdentifiableProvider<V> idp, MapConverter<V> cp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(directory, idp, cp, removeEmptyFiles, removeFailedFiles);
    }

    public PermissionFileStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> identifiableProvider, MapConverter<V> converter, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, identifiableProvider, converter, removeEmptyFiles, removeFailedFiles);
    }

    @Override
    public List<Identifier> getAdmins(Identifier clientID) {
        LinkedList<Identifier> admins = new LinkedList<Identifier>();
        for (Permission p : this.values()) {
            if (p.getClientID() == null || !p.getClientID().equals(clientID) || p.getAdminID() == null) continue;
            admins.add(p.getAdminID());
        }
        return admins;
    }

    @Override
    public List<Identifier> getClients(Identifier adminID) {
        LinkedList<Identifier> clients = new LinkedList<Identifier>();
        for (Permission p : this.values()) {
            if (p.getAdminID() == null || !p.getAdminID().equals(adminID) || p.getClientID() == null) continue;
            clients.add(p.getClientID());
        }
        return clients;
    }

    @Override
    public int getClientCount(Identifier adminID) {
        return this.getClients(adminID).size();
    }

    @Override
    public PermissionList get(Identifier adminID, Identifier clientID) {
        PermissionList permissions = new PermissionList();
        for (Permission p : this.values()) {
            if (p.getAdminID() == null || p.getClientID() == null || !p.getClientID().equals(clientID) || !p.getAdminID().equals(adminID)) continue;
            permissions.add(p);
        }
        return permissions;
    }

    @Override
    public PermissionList getErsatzChains(Identifier adminID, Identifier clientID) {
        return PermissionStoreUtil.getErsatzChains(this, adminID, clientID);
    }

    @Override
    public PermissionList getProvisioners(Identifier adminID, Identifier ersatzID) {
        return PermissionStoreUtil.getProvisioners(this, adminID, ersatzID);
    }

    @Override
    public boolean hasEntry(Identifier adminID, Identifier clientID) {
        return !this.get(adminID, clientID).isEmpty();
    }

    @Override
    public Permission getErsatzChain(Identifier adminID, Identifier clientID, Identifier ersatzID) {
        return PermissionStoreUtil.getErsatzChain(this, adminID, clientID, ersatzID);
    }

    @Override
    public List<Permission> getByAdminID(Identifier adminID) {
        return PermissionStoreUtil.getByAdminID(this, adminID);
    }

    @Override
    public List<Permission> getByClientID(Identifier clientID) {
        return PermissionStoreUtil.getByClientID(this, clientID);
    }

    @Override
    public List<Permission> getByErsatzID(Identifier ersatzID) {
        return PermissionStoreUtil.getByErsatzID(this, ersatzID);
    }
}

