/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.admin.permissions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.storage.MemoryStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionConverter;
import org.oa4mp.server.api.admin.permissions.PermissionKeys;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.permissions.PermissionStoreUtil;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;

public class PermissionMemoryStore<V extends Permission>
extends MemoryStore<V>
implements PermissionsStore<V> {
    HashMap<Identifier, List<IDTriple>> adminMap = new HashMap();
    HashMap<Identifier, List<IDTriple>> clientMap = new HashMap();

    public List<V> getMostRecent(int n, List<String> attributes) {
        throw new UnsupportedOperationException("get most recent not supported for permissions");
    }

    public PermissionMemoryStore(IdentifiableProvider<V> identifiableProvider) {
        super(identifiableProvider);
    }

    @Override
    public List<Identifier> getAdmins(Identifier clientID) {
        List<IDTriple> ids = this.clientMap.get(clientID);
        LinkedList<Identifier> admins = new LinkedList<Identifier>();
        if (ids == null) {
            return admins;
        }
        for (IDTriple idTriple : ids) {
            admins.add(idTriple.adminID);
        }
        return admins;
    }

    @Override
    public List<Identifier> getClients(Identifier adminID) {
        List<IDTriple> ids = this.adminMap.get(adminID);
        LinkedList<Identifier> clients = new LinkedList<Identifier>();
        if (ids == null) {
            return clients;
        }
        for (IDTriple idTriple : ids) {
            clients.add(idTriple.clientID);
        }
        return clients;
    }

    @Override
    public int getClientCount(Identifier adminID) {
        return this.getClients(adminID).size();
    }

    @Override
    public PermissionList get(Identifier adminID, Identifier clientID) {
        List<IDTriple> clients = this.adminMap.get(adminID);
        PermissionList permissions = new PermissionList();
        if (clients == null) {
            return permissions;
        }
        for (IDTriple id : clients) {
            if (id.clientID == null || !id.clientID.equals(clientID)) continue;
            permissions.add((Permission)((Object)this.get(id.pID)));
        }
        return permissions;
    }

    @Override
    public PermissionList getErsatzChains(Identifier adminID, Identifier clientID) {
        return PermissionStoreUtil.getErsatzChains(this, adminID, clientID);
    }

    @Override
    public Permission getErsatzChain(Identifier adminID, Identifier clientID, Identifier ersatzID) {
        return PermissionStoreUtil.getErsatzChain(this, adminID, clientID, ersatzID);
    }

    @Override
    public PermissionList getProvisioners(Identifier adminID, Identifier ersatzID) {
        return PermissionStoreUtil.getProvisioners(this, adminID, ersatzID);
    }

    @Override
    public boolean hasEntry(Identifier adminID, Identifier clientID) {
        return !this.get(adminID, clientID).isEmpty();
    }

    protected void addToClients(V p) {
        IDTriple idTriple = new IDTriple((Permission)((Object)p));
        List<IDTriple> clients = this.clientMap.get(((Permission)((Object)p)).getClientID());
        if (clients == null) {
            clients = new LinkedList<IDTriple>();
            this.clientMap.put(((Permission)((Object)p)).getClientID(), clients);
        }
        if (!this.clientMap.containsValue(idTriple)) {
            clients.add(idTriple);
        }
    }

    protected void addToAdmins(V p) {
        IDTriple idTriple = new IDTriple((Permission)((Object)p));
        List<IDTriple> admins = this.adminMap.get(((Permission)((Object)p)).getAdminID());
        if (admins == null) {
            admins = new LinkedList<IDTriple>();
            this.adminMap.put(((Permission)((Object)p)).getAdminID(), admins);
        }
        if (!this.adminMap.containsValue(idTriple)) {
            admins.add(idTriple);
        }
    }

    public void clear() {
        this.adminMap = new HashMap();
        this.clientMap = new HashMap();
        super.clear();
    }

    protected void removeFromClients(V p) {
        List<IDTriple> clients = this.clientMap.get(((Permission)((Object)p)).getClientID());
        if (clients == null) {
            return;
        }
        for (IDTriple triple : clients) {
            if (!triple.pID.equals(p.getIdentifier())) continue;
            clients.remove(triple);
        }
    }

    protected void removeFromAdmins(V p) {
        List<IDTriple> admins = this.adminMap.get(((Permission)((Object)p)).getAdminID());
        if (admins == null) {
            return;
        }
        for (IDTriple triple : admins) {
            if (!triple.pID.equals(p.getIdentifier())) continue;
            admins.remove(triple);
        }
    }

    public V put(Identifier key, V value2) {
        Object p;
        Permission value = (Permission)((Permission)((Object)value2)).clone();
        if (this.containsKey(key)) {
            p = (Permission)((Object)this.get(key));
            this.removeFromAdmins(p);
            this.removeFromClients(p);
            this.remove(key);
        }
        if ((p = this.get(value.getAdminID(), value.getClientID())).isEmpty()) {
            this.addToAdmins(value);
            this.addToClients(value);
            return (V)((Object)((Permission)((Object)super.put((Object)key, (Object)value))));
        }
        Iterator iterator = p.iterator();
        while (iterator.hasNext()) {
            Permission tempP = (Permission)((Object)iterator.next());
            if (!tempP.getIdentifier().equals(value.getIdentifier())) continue;
            this.remove(key);
            this.adminMap.remove(value.getAdminID());
            this.clientMap.remove(value.getClientID());
        }
        this.addToAdmins(value);
        this.addToClients(value);
        return (V)((Object)((Permission)((Object)super.put((Object)key, (Object)value))));
    }

    public V remove(Object key) {
        if (this.containsKey(key)) {
            Permission p = (Permission)((Object)this.get(key));
            this.removeFromAdmins(p);
            this.removeFromClients(p);
        }
        return (V)((Object)((Permission)((Object)super.remove(key))));
    }

    public XMLConverter<V> getXMLConverter() {
        PermissionKeys key = new PermissionKeys();
        return new PermissionConverter(key, this.identifiableProvider);
    }

    @Override
    public List<Permission> getByAdminID(Identifier adminID) {
        return PermissionStoreUtil.getByAdminID(this, adminID);
    }

    @Override
    public List<Permission> getByClientID(Identifier clientID) {
        return PermissionStoreUtil.getByClientID(this, clientID);
    }

    @Override
    public List<Permission> getByErsatzID(Identifier ersatzID) {
        return PermissionStoreUtil.getByErsatzID(this, ersatzID);
    }

    public static class IDTriple {
        Identifier pID;
        Identifier clientID;
        Identifier adminID;

        public IDTriple(Permission p) {
            this.pID = p.getIdentifier();
            this.adminID = p.getAdminID();
            this.clientID = p.getClientID();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IDTriple)) {
                return false;
            }
            IDTriple idTriple = (IDTriple)obj;
            if (!BeanUtils.checkEquals((Object)idTriple.clientID, (Object)this.clientID)) {
                return false;
            }
            if (!BeanUtils.checkEquals((Object)idTriple.adminID, (Object)this.adminID)) {
                return false;
            }
            return BeanUtils.checkEquals((Object)idTriple.pID, (Object)this.pID);
        }
    }
}

