/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.admin.permissions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.FSProvider;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.SQLStoreProvider;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.io.File;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.api.OA4MPConfigTags;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionConverter;
import org.oa4mp.server.api.admin.permissions.PermissionFileStore;
import org.oa4mp.server.api.admin.permissions.PermissionKeys;
import org.oa4mp.server.api.admin.permissions.PermissionMemoryStore;
import org.oa4mp.server.api.admin.permissions.PermissionProvider;
import org.oa4mp.server.api.admin.permissions.PermissionsTable;
import org.oa4mp.server.api.admin.permissions.SQLPermissionStore;

public class PermissionStoreProviders {
    protected static IdentifiableProviderImpl<? extends Permission> permissionProvider;
    protected static PermissionConverter<? extends Permission> permissionConverter;

    public static IdentifiableProviderImpl<? extends Permission> getPermissionProvider() {
        if (permissionProvider == null) {
            permissionProvider = new PermissionProvider<Permission>();
        }
        return permissionProvider;
    }

    public static void setPermissionProvider(IdentifiableProviderImpl<? extends Permission> permissionProvider) {
        PermissionStoreProviders.permissionProvider = permissionProvider;
    }

    public static PermissionConverter<? extends Permission> getPermissionConverter() {
        if (permissionConverter == null) {
            permissionConverter = new PermissionConverter<Permission>(new PermissionKeys(), (IdentifiableProvider<? extends Permission>)PermissionStoreProviders.getPermissionProvider());
        }
        return permissionConverter;
    }

    public static void setPermissionConverter(PermissionConverter<? extends Permission> permissionConverter) {
        PermissionStoreProviders.permissionConverter = permissionConverter;
    }

    public static FSPermissionStoreProvider getFSP(ConfigurationNode node) {
        return new FSPermissionStoreProvider(node);
    }

    public static SQLPermissionStoreProvider getMariaPS(ConfigurationNode node, ConnectionPoolProvider<? extends ConnectionPool> cpp) {
        return new SQLPermissionStoreProvider(node, "mariadb", cpp);
    }

    public static SQLPermissionStoreProvider getPostgresPS(ConfigurationNode node, ConnectionPoolProvider<? extends ConnectionPool> cpp) {
        return new SQLPermissionStoreProvider(node, "postgresql", cpp);
    }

    public static SQLPermissionStoreProvider getDerbyPS(ConfigurationNode node, ConnectionPoolProvider<? extends ConnectionPool> cpp) {
        return new SQLPermissionStoreProvider(node, "derby", cpp);
    }

    public static SQLPermissionStoreProvider getMysqlPS(ConfigurationNode node, ConnectionPoolProvider<? extends ConnectionPool> cpp) {
        return new SQLPermissionStoreProvider(node, "mysql", cpp);
    }

    public static MemoryPermissionStoreProvider<? extends PermissionMemoryStore> getM(ConfigurationNode node) {
        MemoryPermissionStoreProvider mpp = new MemoryPermissionStoreProvider(node);
        return mpp;
    }

    public static class MemoryPermissionStoreProvider<V>
    extends TypedProvider<PermissionMemoryStore>
    implements OA4MPConfigTags {
        public MemoryPermissionStoreProvider(ConfigurationNode config) {
            super(config, "memoryStore", "permissions");
        }

        public Object componentFound(CfgEvent configurationEvent) {
            if (this.checkEvent(configurationEvent)) {
                return this.get();
            }
            return null;
        }

        public PermissionMemoryStore get() {
            return new PermissionMemoryStore<Permission>((IdentifiableProvider<? extends Permission>)PermissionStoreProviders.getPermissionProvider());
        }
    }

    public static class SQLPermissionStoreProvider
    extends SQLStoreProvider<SQLPermissionStore>
    implements OA4MPConfigTags {
        public SQLPermissionStoreProvider(ConfigurationNode config, String type, ConnectionPoolProvider<? extends ConnectionPool> cpp) {
            super(config, cpp, type, "permissions", SQLPermissionStore.DEFAULT_TABLENAME, PermissionStoreProviders.getPermissionConverter());
        }

        public SQLPermissionStore newInstance(Table table) {
            SQLPermissionStore<? extends Permission> store = new SQLPermissionStore<Permission>(this.getConnectionPool(), table, (Provider<? extends Permission>)PermissionStoreProviders.getPermissionProvider(), (MapConverter<? extends Permission>)this.converter);
            return store;
        }

        public SQLPermissionStore get() {
            return this.newInstance(new PermissionsTable(new PermissionKeys(), this.getSchema(), this.getPrefix(), this.getTablename()));
        }
    }

    public static class FSPermissionStoreProvider
    extends FSProvider<PermissionFileStore>
    implements OA4MPConfigTags {
        public FSPermissionStoreProvider(ConfigurationNode config) {
            super(config, "fileStore", "permissions", PermissionStoreProviders.getPermissionConverter());
        }

        protected PermissionFileStore produce(File dataPath, File indexPath, boolean removeEmptyFiles, boolean removeFailedFiles) {
            return new PermissionFileStore<Permission>(dataPath, indexPath, (IdentifiableProvider<? extends Permission>)PermissionStoreProviders.getPermissionProvider(), (MapConverter<? extends Permission>)this.converter, removeEmptyFiles, removeFailedFiles);
        }
    }
}

