/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.admin.permissions;

import edu.uiuc.ncsa.security.core.Identifier;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;

public class PermissionStoreUtil {
    public static Permission getErsatzChain(PermissionsStore permissionsStore, Identifier adminID, Identifier clientID, Identifier ersatzID) {
        PermissionList pList = permissionsStore.getErsatzChains(adminID, clientID);
        for (Permission p : pList) {
            if (!p.canSubstitute() || !p.getErsatzChain().get(p.getErsatzChain().size() - 1).equals(ersatzID)) continue;
            return p;
        }
        return null;
    }

    public static PermissionList getErsatzChains(PermissionsStore<? extends Permission> pStore, Identifier adminID, Identifier clientID) {
        PermissionList permissions = new PermissionList();
        for (Identifier id : pStore.keySet()) {
            Permission permission = (Permission)((Object)pStore.get(id));
            if (!permission.canSubstitute() || !permission.getAdminID().equals(adminID) || !permission.getClientID().equals(clientID)) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public static PermissionList getProvisioners(PermissionsStore<? extends Permission> pStore, Identifier adminID, Identifier ersatzID) {
        PermissionList permissions = new PermissionList();
        for (Identifier id : pStore.keySet()) {
            Permission permission = (Permission)((Object)pStore.get(id));
            if (!permission.canSubstitute() || !permission.getAdminID().equals(adminID) || !permission.getErsatzChain().contains(ersatzID)) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public static PermissionList getByAdminID(PermissionsStore<? extends Permission> pStore, Identifier adminID) {
        PermissionList permissions = new PermissionList();
        for (Identifier id : pStore.keySet()) {
            Permission permission = (Permission)((Object)pStore.get(id));
            if (!permission.getAdminID().equals(adminID)) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public static PermissionList getByClientID(PermissionsStore<? extends Permission> pStore, Identifier clientID) {
        PermissionList permissions = new PermissionList();
        for (Identifier id : pStore.keySet()) {
            Permission permission = (Permission)((Object)pStore.get(id));
            if (!permission.getClientID().equals(clientID)) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public static PermissionList getByErsatzID(PermissionsStore<? extends Permission> pStore, Identifier ersatzID) {
        PermissionList permissions = new PermissionList();
        for (Identifier id : pStore.keySet()) {
            Permission permission = (Permission)((Object)pStore.get(id));
            if (!permission.getErsatzChain().contains(ersatzID)) continue;
            permissions.add(permission);
        }
        return permissions;
    }
}

