/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.admin.permissions;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Provider;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionKeys;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.permissions.PermissionStoreUtil;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;

public class SQLPermissionStore<V extends Permission>
extends SQLStore<V>
implements PermissionsStore<V> {
    public static String DEFAULT_TABLENAME = "permissions";
    PermissionKeys permissionKeys = new PermissionKeys();

    public String getCreationTSField() {
        return null;
    }

    public SQLPermissionStore() {
    }

    public SQLPermissionStore(ConnectionPool connectionPool, Table table, Provider<V> identifiableProvider, MapConverter<V> converter) {
        super(connectionPool, table, identifiableProvider, converter);
    }

    @Override
    public PermissionList get(Identifier adminID, Identifier clientID) {
        PermissionList allOfThem = new PermissionList();
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        PermissionKeys permissionKeys = new PermissionKeys();
        try {
            PreparedStatement stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename() + " where " + permissionKeys.clientID(new String[0]) + "=? AND " + permissionKeys.adminID(new String[0]) + "=?");
            stmt.setString(1, clientID.toString());
            if (adminID == null) {
                stmt.setNull(2, -16);
            } else {
                stmt.setString(2, adminID.toString());
            }
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                Permission newOne = (Permission)this.create();
                ColumnMap map = SQLPermissionStore.rsToMap((ResultSet)rs);
                this.populate(map, (Identifiable)newOne);
                allOfThem.add(newOne);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        return allOfThem;
    }

    @Override
    public PermissionList getProvisioners(Identifier adminID, Identifier ersatzID) {
        PermissionList allOfThem = new PermissionList();
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        PermissionKeys permissionKeys = new PermissionKeys();
        try {
            String searchTerm = "0 < LOCATE('" + String.valueOf(ersatzID) + "'," + permissionKeys.ersatzID(new String[0]) + ")";
            PreparedStatement stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename() + " where " + searchTerm + " AND " + permissionKeys.adminID(new String[0]) + "=? AND " + permissionKeys.substitute(new String[0]) + "=1");
            stmt.setString(1, adminID.toString());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                Permission newOne = (Permission)this.create();
                ColumnMap map = SQLPermissionStore.rsToMap((ResultSet)rs);
                this.populate(map, (Identifiable)newOne);
                allOfThem.add(newOne);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        return allOfThem;
    }

    @Override
    public PermissionList getErsatzChains(Identifier adminID, Identifier clientID) {
        PermissionList allOfThem = new PermissionList();
        if (clientID == null) {
            return allOfThem;
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        PermissionKeys permissionKeys = new PermissionKeys();
        try {
            PreparedStatement stmt;
            if (adminID == null) {
                stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename() + " where " + permissionKeys.clientID(new String[0]) + "=? AND " + permissionKeys.substitute(new String[0]) + "=1");
            } else {
                stmt = c.prepareStatement("select * from " + this.getTable().getFQTablename() + " where " + permissionKeys.clientID(new String[0]) + "=? AND " + permissionKeys.adminID(new String[0]) + "=? AND " + permissionKeys.substitute(new String[0]) + "=1");
                stmt.setString(2, adminID.toString());
            }
            stmt.setString(1, clientID.toString());
            if (adminID == null) {
                // empty if block
            }
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                Permission newOne = (Permission)this.create();
                ColumnMap map = SQLPermissionStore.rsToMap((ResultSet)rs);
                this.populate(map, (Identifiable)newOne);
                allOfThem.add(newOne);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        return allOfThem;
    }

    @Override
    public Permission getErsatzChain(Identifier adminID, Identifier clientID, Identifier ersatzID) {
        return PermissionStoreUtil.getErsatzChain(this, adminID, clientID, ersatzID);
    }

    @Override
    public int getClientCount(Identifier adminID) {
        ArrayList clients = new ArrayList();
        if (adminID == null) {
            return 0;
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        PermissionKeys permissionKeys = new PermissionKeys();
        try {
            PreparedStatement stmt = c.prepareStatement("select COUNT(*)  from " + this.getTable().getFQTablename() + " where " + permissionKeys.adminID(new String[0]) + "=?");
            stmt.setString(1, adminID.toString());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            rs.next();
            int totalClients = rs.getInt(1);
            rs.close();
            stmt.close();
            int n = totalClients;
            return n;
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
    }

    @Override
    public List<Identifier> getClients(Identifier adminID) {
        ArrayList<Identifier> clients = new ArrayList<Identifier>();
        if (adminID == null) {
            return clients;
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        PermissionKeys permissionKeys = new PermissionKeys();
        try {
            PreparedStatement stmt = c.prepareStatement("select " + permissionKeys.clientID(new String[0]) + "  from " + this.getTable().getFQTablename() + " where " + permissionKeys.adminID(new String[0]) + "=?");
            stmt.setString(1, adminID.toString());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                String clientID = rs.getString(permissionKeys.clientID(new String[0]));
                clients.add(BasicIdentifier.newID((String)clientID));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        return clients;
    }

    @Override
    public List<Identifier> getAdmins(Identifier clientID) {
        ArrayList<Identifier> admins = new ArrayList<Identifier>();
        HashSet<Identifier> uniqueIDs = new HashSet<Identifier>();
        if (clientID == null) {
            return admins;
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        PermissionKeys permissionKeys = new PermissionKeys();
        try {
            PreparedStatement stmt = c.prepareStatement("select " + permissionKeys.adminID(new String[0]) + "  from " + this.getTable().getFQTablename() + " where " + permissionKeys.clientID(new String[0]) + "=?");
            stmt.setString(1, clientID.toString());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                String adminID = rs.getString(permissionKeys.adminID(new String[0]));
                if (StringUtils.isTrivial((String)adminID)) continue;
                uniqueIDs.add(BasicIdentifier.newID((String)adminID));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        admins.addAll(uniqueIDs);
        return admins;
    }

    @Override
    public boolean hasEntry(Identifier adminID, Identifier clientID) {
        return !this.get(adminID, clientID).isEmpty();
    }

    @Override
    public List<Permission> getByAdminID(Identifier adminID) {
        return this.getByID(this.permissionKeys.adminID(new String[0]), adminID);
    }

    @Override
    public List<Permission> getByClientID(Identifier clientID) {
        return this.getByID(this.permissionKeys.clientID(new String[0]), clientID);
    }

    @Override
    public List<Permission> getByErsatzID(Identifier ersatzID) {
        return this.getByID(this.permissionKeys.ersatzID(new String[0]), ersatzID);
    }

    protected List<Permission> getByID(String colName, Identifier adminID) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        if (adminID == null) {
            return permissions;
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        try {
            PreparedStatement stmt = this.permissionKeys.ersatzID(new String[0]).equals(colName) ? c.prepareStatement("select *  from " + this.getTable().getFQTablename() + " where " + colName + " LIKE ?") : c.prepareStatement("select *  from " + this.getTable().getFQTablename() + " where " + colName + "=?");
            stmt.setString(1, adminID.toString());
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                Permission newOne = (Permission)this.create();
                ColumnMap map = SQLPermissionStore.rsToMap((ResultSet)rs);
                this.populate(map, (Identifiable)newOne);
                permissions.add(newOne);
            }
            rs.close();
            stmt.close();
            ArrayList<Permission> arrayList = permissions;
            return arrayList;
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            throw new GeneralException("Error: could not get database object", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
    }
}

