/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.myproxy.NoUsableMyProxyServerFoundException;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.Presentable;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringEscapeUtils;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.server.api.OA4MPServiceTransaction;
import org.oa4mp.server.api.storage.servlet.AuthenticationUtil;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.api.storage.servlet.PresentationState;

public abstract class AbstractAuthenticationServlet
extends OA4MPServlet
implements Presentable {
    public static final String AUTHORIZATION_ACTION_KEY = "action";
    public static final String AUTHORIZATION_USER_NAME_KEY = "AuthUserName";
    public static final String AUTHORIZATION_USER_NAME_VALUE = "userName";
    public static final String AUTHORIZATION_PASSWORD_KEY = "AuthPassword";
    public static final String AUTHORIZATION_ACTION_OK_VALUE = "ok";
    public static final String AUTHORIZATION_ACTION_DONE_VALUE = "done";
    public static final String AUTHORIZATION_ACTION_DF_CONSENT_VALUE = "df_consent";
    public static final int AUTHORIZATION_ACTION_DONE = 2;
    public static final int AUTHORIZATION_ACTION_DF_CONSENT = 3;
    public static final int AUTHORIZATION_ACTION_OK = 1;
    public static final int AUTHORIZATION_ACTION_START = 0;
    public static final String RETRY_MESSAGE = "retryMessage";
    public static String INITIAL_PAGE = "/authorize-init.jsp";
    public static String REMOTE_USER_INITIAL_PAGE = "/authorize-remote-user.jsp";
    public static String OK_PAGE = "/authorize-ok.jsp";
    public static String ERROR_PAGE = "/authorize-error.jsp";

    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }

    public abstract String createCallback(ServiceTransaction var1, Map<String, String> var2);

    public void prepare(PresentableState state) throws Throwable {
        AuthorizedState aState = (AuthorizedState)state;
        switch (aState.getState()) {
            case 1: {
                return;
            }
            case 0: {
                this.info("3.a. Starting authorization for grant =" + aState.getTransaction().getIdentifierString());
                this.setClientRequestAttributes(aState);
                return;
            }
        }
    }

    protected void setClientRequestAttributes(AuthorizedState aState) {
        HttpServletRequest request = aState.getRequest();
        request.setAttribute(AUTHORIZATION_USER_NAME_KEY, (Object)AUTHORIZATION_USER_NAME_KEY);
        request.setAttribute(AUTHORIZATION_PASSWORD_KEY, (Object)AUTHORIZATION_PASSWORD_KEY);
        request.setAttribute(AUTHORIZATION_ACTION_KEY, (Object)AUTHORIZATION_ACTION_KEY);
        request.setAttribute("actionOk", (Object)AUTHORIZATION_ACTION_OK_VALUE);
        request.setAttribute("authorizationGrant", (Object)aState.getTransaction().getIdentifierString());
        request.setAttribute("tokenKey", (Object)AbstractAuthenticationServlet.CONST((String)"oa4mp:token"));
        request.setAttribute("stateKey", (Object)"state");
        request.setAttribute("clientHome", (Object)StringEscapeUtils.escapeHtml((String)aState.getTransaction().getClient().getHomeUri()));
        request.setAttribute("clientName", (Object)StringEscapeUtils.escapeHtml((String)aState.getTransaction().getClient().getName()));
        request.setAttribute("actionToTake", (Object)(request.getContextPath() + "/authorize"));
    }

    protected String getInitialPage() {
        return INITIAL_PAGE;
    }

    protected String getRemoteUserInitialPage() {
        return REMOTE_USER_INITIAL_PAGE;
    }

    protected String getOkPage() {
        return OK_PAGE;
    }

    protected void doProxy(AuthorizedState state) throws Throwable {
    }

    public void present(PresentableState state) throws Throwable {
        AuthorizedState aState = (AuthorizedState)state;
        this.postprocess(new TransactionState(state.getRequest(), aState.getResponse(), null, (BasicTransaction)aState.getTransaction(), null));
        switch (aState.getState()) {
            case 0: {
                ServiceTransaction transaction = aState.getTransaction();
                if (!transaction.hasPromptKey() || transaction.getPrompt().equals("none")) {
                    // empty if block
                }
                if (AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getUseMode().equals("proxy")) {
                    this.doProxy(aState);
                    return;
                }
                String initPage = this.getInitialPage();
                this.info("*** STARTING present");
                if (AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getUseMode().equals("header")) {
                    initPage = this.getRemoteUserInitialPage();
                    this.info("*** PRESENT: Use headers enabled.");
                    String x = null;
                    if (AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName().equals("REMOTE_USER")) {
                        x = aState.getRequest().getRemoteUser();
                        this.info("*** got user name from request = " + x);
                    } else {
                        x = aState.getRequest().getHeader(AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName());
                        this.info("Got username from header \"" + AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName() + "\" + directly: " + x);
                    }
                    if (this.isEmpty(x)) {
                        if (AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().isRequireHeader()) {
                            throw new GeneralException("Error: configuration required using the header \"" + AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName() + "\" but this was not set. Cannot continue.");
                        }
                    } else {
                        aState.getTransaction().setUsername(x);
                        this.info("*** storing user name = " + x);
                        this.getTransactionStore().save((Identifiable)aState.getTransaction());
                        aState.getRequest().setAttribute(AUTHORIZATION_USER_NAME_VALUE, (Object)StringEscapeUtils.escapeHtml((String)x));
                    }
                } else {
                    this.info("*** PRESENT: Use headers DISABLED.");
                }
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)initPage);
                this.info("3.a. User information obtained for grant = " + String.valueOf(aState.getTransaction().getAuthorizationGrant()));
                break;
            }
            case 1: {
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)this.getOkPage());
                break;
            }
            default: {
                this.debug("Hit default case in AbstractAuthZ servlet");
            }
        }
    }

    public void handleError(PresentableState state, Throwable t) throws IOException, ServletException {
        AuthorizedState aState = (AuthorizedState)state;
        state.getResponse().setHeader("X-Frame-Options", "DENY");
        state.getRequest().setAttribute("client", (Object)aState.getTransaction().getClient());
        JSPUtil.handleException((Throwable)t, (HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)ERROR_PAGE);
    }

    protected String getParam(HttpServletRequest request, String key) {
        String x = null;
        x = request.getParameter(key);
        if (x != null) {
            return x;
        }
        Object oo = request.getAttribute(key);
        if (oo != null) {
            x = oo.toString();
        }
        return x;
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.info("starting request");
        String ag = this.getParam(request, AbstractAuthenticationServlet.CONST((String)"oa4mp:token"));
        ServiceTransaction trans = null;
        if (ag == null) {
            throw new GeneralException("Error: Invalid request -- no token. Request rejected.");
        }
        trans = this.getAndCheckTransaction(ag);
        AuthorizedState pState = new AuthorizedState(AbstractAuthenticationServlet.getState(request), request, response, trans);
        this.prepare(pState);
        this.preprocess(new TransactionState(request, response, null, (BasicTransaction)trans, null));
        switch (pState.getState()) {
            case 1: {
                trans.setAuthGrantValid(true);
                try {
                    this.createRedirect(request, response, trans);
                    ((OA4MPServiceTransaction)trans).setConsentPageOK(true);
                    this.getTransactionStore().save((Identifiable)trans);
                    return;
                }
                catch (ConnectionException ce) {
                    ce.printStackTrace();
                    request.setAttribute(RETRY_MESSAGE, (Object)AbstractAuthenticationServlet.getServiceEnvironment().getMessages().get(RETRY_MESSAGE));
                    pState.setState(0);
                    this.prepare(pState);
                    break;
                }
                catch (NoUsableMyProxyServerFoundException | GeneralSecurityException t) {
                    this.info("Prompting user to retry");
                    request.setAttribute(RETRY_MESSAGE, (Object)AbstractAuthenticationServlet.getServiceEnvironment().getMessages().get(RETRY_MESSAGE));
                    pState.setState(0);
                    this.prepare(pState);
                    break;
                }
            }
            case 0: {
                break;
            }
        }
        this.present(pState);
    }

    public static int getState(HttpServletRequest request) {
        String action = request.getParameter(AUTHORIZATION_ACTION_KEY);
        ServletDebugUtil.trace(AbstractAuthenticationServlet.class, (String)("action = " + action));
        if (action == null || action.length() == 0) {
            return 0;
        }
        switch (action) {
            case "ok": {
                return 1;
            }
            case "done": {
                return 2;
            }
            case "df_consent": {
                return 3;
            }
        }
        throw new GeneralException("Error: unknown authorization request action = \"" + action + "\"");
    }

    protected ServiceTransaction getAndCheckTransaction(String token) throws IOException {
        DateUtils.checkTimestamp((String)token);
        AuthorizationGrant grant = OA4MPServlet.getServiceEnvironment().getTokenForge().getAuthorizationGrant(new String[]{token});
        ServiceTransaction trans = (ServiceTransaction)OA4MPServlet.getServiceEnvironment().getTransactionStore().get(grant);
        if (trans == null) {
            this.warn("Error: no delegation request found for " + token);
            throw new GeneralException("Error: no delegation request found.");
        }
        this.checkAdminClientStatus(trans.getClient().getIdentifier());
        this.checkClientApproval((BaseClient)trans.getClient());
        return trans;
    }

    protected void createRedirect(HttpServletRequest request, HttpServletResponse response, ServiceTransaction trans) throws Throwable {
        String userName = null;
        String password = null;
        if (AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getUseMode().equals("header")) {
            String headerName = AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().getHeaderFieldName();
            if (this.isEmpty(headerName) || headerName.toLowerCase().equals("remote_user")) {
                userName = request.getRemoteUser();
            } else {
                Enumeration enumeration = request.getHeaders(headerName);
                if (!enumeration.hasMoreElements()) {
                    throw new GeneralException("Error: A custom header of \"" + headerName + "\" was specified for authorization, but no value was found.");
                }
                userName = enumeration.nextElement().toString();
                if (enumeration.hasMoreElements()) {
                    throw new GeneralException("Error: A custom header of \"" + headerName + "\" was specified for authorization, but multiple values were found.");
                }
            }
            if (AbstractAuthenticationServlet.getServiceEnvironment().getAuthorizationServletConfig().isRequireHeader()) {
                if (this.isEmpty(userName)) {
                    this.warn("Headers required, but none found.");
                    throw new GeneralException("Headers required, but none found.");
                }
            } else {
                if (this.isEmpty(userName)) {
                    userName = request.getParameter(AUTHORIZATION_USER_NAME_KEY);
                }
                trans.setUsername(userName);
            }
        } else {
            userName = request.getParameter(AUTHORIZATION_USER_NAME_KEY);
            password = request.getParameter(AUTHORIZATION_PASSWORD_KEY);
            this.checkUser(userName, password);
            trans.setUsername(userName);
        }
        userName = trans.getUsername();
        this.info("3.b. transaction has user name = " + userName);
        this.preprocess(new TransactionState(request, response, null, (BasicTransaction)trans, null));
        OA4MPServlet.getServiceEnvironment().getTransactionStore().save((Identifiable)trans);
        this.createRedirectInit(trans, userName, password);
        String cb = this.createCallback(trans, AbstractAuthenticationServlet.getFirstParameters(request));
        this.info("4.a. starting redirect to " + cb);
        response.sendRedirect(cb);
        this.info("4.b. Redirected to callback " + cb);
    }

    protected abstract void createRedirectInit(ServiceTransaction var1, String var2, String var3);

    public void checkUser(String username, String password) throws GeneralSecurityException {
        AuthenticationUtil.getInstance().checkUser(AbstractAuthenticationServlet.getServiceEnvironment(), username, password);
    }

    public static class UserLoginException
    extends GeneralException {
        String username;
        String password;

        public UserLoginException(String message, String username, String password) {
            super(message);
            this.username = username;
            this.password = password;
        }
    }

    public static class AuthorizedState
    extends PresentationState {
        ServiceTransaction transaction;

        public AuthorizedState(int state, HttpServletRequest request, HttpServletResponse response, ServiceTransaction transaction) {
            super(state, request, response);
            this.transaction = transaction;
        }

        public ServiceTransaction getTransaction() {
            return this.transaction;
        }
    }

    public static class MyHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw = new StringWriter();
        int internalStatus = 0;
        boolean exceptionEncountered = false;

        public MyHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            this.internalStatus = sc;
            super.setStatus(sc);
            if (200 > sc || sc >= 300) {
                this.setExceptionEncountered(true);
            }
        }

        public int getStatus() {
            return this.internalStatus;
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.sw.toString();
        }

        public boolean isExceptionEncountered() {
            return this.exceptionEncountered;
        }

        public void setExceptionEncountered(boolean exceptionEncountered) {
            this.exceptionEncountered = exceptionEncountered;
        }
    }
}

