/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.issuers.PAIssuer;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.request.PARequest;
import org.oa4mp.delegation.server.request.PAResponse;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;

public abstract class AbstractCertServlet
extends OA4MPServlet {
    protected PAIssuer getPAI() throws IOException {
        return AbstractCertServlet.getServiceEnvironment().getPaIssuer();
    }

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected void doDelegation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.info("6.a. Starting to process cert request");
        ServiceTransaction originalTransaction = this.getTransactionByGrantID(httpServletRequest);
        PARequest paRequest = new PARequest(httpServletRequest, originalTransaction);
        XMLMap backup = GenericStoreUtils.toXML((Store)this.getTransactionStore(), (Identifiable)originalTransaction);
        String cc = "client = " + String.valueOf(paRequest.getClient().getIdentifier());
        paRequest.setAccessToken(AbstractCertServlet.getServiceEnvironment().getTokenForge().getAccessToken(httpServletRequest));
        PAResponse paResponse = (PAResponse)this.getPAI().process((Request)paRequest);
        AccessToken accessToken = paResponse.getAccessToken();
        this.debug("6.a. " + cc);
        ServiceTransaction t = this.verifyAndGet((IssuerResponse)paResponse);
        this.info("6.a. Processing request for transaction " + String.valueOf(t.getIdentifier()));
        t.setAccessTokenValid(false);
        this.preprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t, backup));
        this.debug("6.a. protected asset:" + (t.getProtectedAsset() == null ? "(null)" : "ok") + ", " + cc);
        HashMap<String, String> username = new HashMap<String, String>();
        username.put("username", t.getUsername());
        username.putAll(paResponse.getParameters());
        paResponse.setAdditionalInformation(username);
        paResponse.setProtectedAsset(t.getProtectedAsset());
        this.debug("6.a. Added username \"" + t.getUsername() + "\" & cert for request from " + cc);
        this.getTransactionStore().save((Identifiable)t);
        this.info("6.b. Done with cert request " + cc);
        paResponse.write(httpServletResponse);
        this.info("6.b. Completed transaction " + t.getIdentifierString() + ", " + cc);
        this.postprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t, backup));
    }
}

