/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.TrivialUsernameTransformer;
import edu.uiuc.ncsa.security.servlet.UsernameTransformer;
import edu.uiuc.ncsa.security.servlet.mail.ServletMailUtilProvider;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.mail.MailUtilProvider;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.delegation.common.servlet.DBConfigLoader;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.transactions.TransactionMemoryStore;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.issuers.AGIssuer;
import org.oa4mp.delegation.server.issuers.ATIssuer;
import org.oa4mp.delegation.server.issuers.PAIssuer;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.ClientApprovalProvider;
import org.oa4mp.server.api.OA4MPServiceTransaction;
import org.oa4mp.server.api.ServiceEnvironmentImpl;
import org.oa4mp.server.api.admin.permissions.MultiDSPermissionStoreProvider;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionStoreProviders;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.api.admin.transactions.DSFSTransactionStoreProvider;
import org.oa4mp.server.api.admin.transactions.DSSQLTransactionStoreProvider;
import org.oa4mp.server.api.admin.transactions.DSTransactionProvider;
import org.oa4mp.server.api.admin.transactions.MultiDSTransactionStoreProvider;
import org.oa4mp.server.api.admin.transactions.TransactionConverter;
import org.oa4mp.server.api.storage.MultiDSClientApprovalStoreProvider;
import org.oa4mp.server.api.storage.MultiDSClientStoreProvider;
import org.oa4mp.server.api.storage.filestore.DSFSClientApprovalStoreProvider;
import org.oa4mp.server.api.storage.servlet.AuthorizationServletConfig;
import org.oa4mp.server.api.storage.servlet.ConfigurationLoaderInterface;
import org.oa4mp.server.api.storage.sql.provider.DSSQLClientApprovalStoreProvider;
import org.oa4mp.server.api.util.AbstractCLIApprover;
import org.oa4mp.server.api.util.ClientApprovalMemoryStore;
import org.oa4mp.server.api.util.ClientApproverConverter;

public abstract class AbstractConfigurationLoader<T extends ServiceEnvironmentImpl>
extends DBConfigLoader<T>
implements ConfigurationLoaderInterface {
    protected MultiDSClientStoreProvider csp;
    protected MultiDSClientApprovalStoreProvider casp;
    protected MailUtilProvider mup = null;
    protected MultiDSPermissionStoreProvider mpp;
    protected ServiceEnvironmentImpl.MessagesProvider messagesProvider = null;
    protected AuthorizationServletConfig authorizationServletConfig;
    protected Provider<TransactionStore> tsp;
    int maxAllowedNewClientRequests = -1;
    URI address;

    boolean getCfgBoolean(ConfigurationNode sn, String tagName, boolean defaultValue) {
        String x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)tagName);
        if (x == null || x.length() == 0) {
            return defaultValue;
        }
        if ("true".equals(x = x.trim().toLowerCase()) || "on".equals(x)) {
            return true;
        }
        if ("false".equals(x.trim()) || "off".equals(x)) {
            return false;
        }
        return defaultValue;
    }

    public AuthorizationServletConfig getAuthorizationServletConfig() {
        if (this.authorizationServletConfig == null) {
            List kids = this.cn.getChildren("authorizationServlet");
            String headerFieldName = null;
            boolean requiredHeader = false;
            boolean useHeader = false;
            boolean showLogon = true;
            boolean verifyUsername = true;
            boolean returnDnAsUsername = false;
            boolean convertDNToGlobusID = false;
            String useMode = "default";
            String authorizationURI = null;
            if (kids.isEmpty()) {
                this.authorizationServletConfig = new AuthorizationServletConfig();
            } else {
                ConfigurationNode sn = (ConfigurationNode)kids.get(0);
                String x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"use");
                if (!StringUtils.isTrivial((String)x)) {
                    useMode = x;
                }
                if (!StringUtils.isTrivial((String)(x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"useProxy"))) && x.equals("true")) {
                    useMode = "proxy";
                }
                if (!StringUtils.isTrivial((String)(x = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"useHeader"))) && x.equals("true")) {
                    useMode = "header";
                }
                authorizationURI = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"authorizationURI");
                switch (useMode) {
                    case "proxy": {
                        String cfgFile = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"cfgFile");
                        if (StringUtils.isTrivial((String)cfgFile)) {
                            throw new IllegalArgumentException("Missing config file for the authorization proxy.");
                        }
                        File f = new File(cfgFile);
                        if (!f.exists()) {
                            throw new IllegalArgumentException("The file \"" + cfgFile + "\" does not exist. Check your path.");
                        }
                        if (!f.isFile()) {
                            throw new IllegalArgumentException("\"" + cfgFile + "\" is not a file.");
                        }
                        if (!f.canRead()) {
                            throw new IllegalArgumentException("The file \"" + cfgFile + "\" cannot be read. Check your permissions");
                        }
                        String cfgName = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"cfgName");
                        Boolean localDFConsent = this.getCfgBoolean(sn, "localDFConsent", false);
                        this.authorizationServletConfig = new AuthorizationServletConfig(cfgFile, cfgName == null ? "" : cfgName, localDFConsent);
                        if (authorizationURI == null) break;
                        this.authorizationServletConfig.authorizationURI = authorizationURI;
                        break;
                    }
                    case "header": {
                        requiredHeader = this.getCfgBoolean(sn, "requireHeader", requiredHeader);
                        headerFieldName = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"headerFieldName");
                        if (StringUtils.isTrivial((String)headerFieldName)) {
                            headerFieldName = "REMOTE_USER";
                        }
                        returnDnAsUsername = this.getCfgBoolean(sn, "returnDnAsUsername", returnDnAsUsername);
                        showLogon = this.getCfgBoolean(sn, "showLogon", showLogon);
                        verifyUsername = this.getCfgBoolean(sn, "verifyUsername", verifyUsername);
                        convertDNToGlobusID = this.getCfgBoolean(sn, "convertDNToGlobusID", convertDNToGlobusID);
                        this.authorizationServletConfig = new AuthorizationServletConfig(authorizationURI, requiredHeader, headerFieldName, returnDnAsUsername, showLogon, verifyUsername, convertDNToGlobusID);
                        String rawDFC = Configurations.getFirstAttribute((ConfigurationNode)sn, (String)"localDFConsent");
                        Boolean localDFConsent = rawDFC == null ? Boolean.valueOf(!this.authorizationServletConfig.useExternalAuthorization()) : Boolean.valueOf(Boolean.parseBoolean(rawDFC));
                        DebugUtil.trace((Object)this, (String)("setting local consent to " + localDFConsent));
                        this.authorizationServletConfig.setLocalDFConsent(localDFConsent);
                        break;
                    }
                    case "default": {
                        this.authorizationServletConfig = new AuthorizationServletConfig();
                        break;
                    }
                    case "dedicated": {
                        this.authorizationServletConfig = new AuthorizationServletConfig("dedicated", authorizationURI);
                        break;
                    }
                    case "external": {
                        this.authorizationServletConfig = new AuthorizationServletConfig("external", authorizationURI);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized use mode \"" + useMode + "\" in authorizationServlet");
                    }
                }
            }
        }
        return this.authorizationServletConfig;
    }

    protected void initialize() {
        String spp;
        String scheme = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"scheme");
        if (scheme != null && !scheme.isEmpty()) {
            IdentifierProvider.setScheme((String)scheme);
        }
        if ((spp = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"schemeSpecificPart")) != null) {
            IdentifierProvider.setSchemeSpecificPart((String)spp);
        }
        DebugUtil.setInstance((MetaDebugUtil)this.getDebugger());
        this.myLogger.setClassName("oa4mp");
    }

    public AbstractConfigurationLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
        String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"disableDefaultStores");
        if (x != null) {
            this.isDefaultStoreDisabled(new boolean[]{Boolean.parseBoolean(x)});
        }
    }

    public AbstractConfigurationLoader(ConfigurationNode node) {
        this(node, null);
    }

    public Object[] loadPolling() {
        File pollingDir = null;
        Long pollingInt = 1000L;
        String pd = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"pollingDirectory");
        String pi = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"pollingInterval");
        if (pd != null && 0 < pd.length()) {
            pollingDir = new File(pd);
            if (!pollingDir.exists()) {
                this.info("WARNING: the given polling directory \"" + pd + "\" does not exist. Polling disabled.");
                pollingDir = null;
            } else if (pollingDir.isDirectory()) {
                this.info("polling directory set to \"" + pollingDir.getAbsolutePath() + "\"");
            } else {
                pollingDir = pollingDir.getParentFile();
                this.info("WARNING: the given polling directory \"" + pd + "\" does not exist. Polling set to " + pollingDir.getAbsolutePath());
            }
            if (pollingDir != null && pi != null) {
                try {
                    pollingInt = Long.parseLong(pi);
                    this.info("Polling interval set to " + pollingInt + " ms.");
                }
                catch (Throwable t) {
                    this.info("WARNING: the polling interval of \"" + pi + "\" could not be interpreted. Using default.");
                }
            }
        } else {
            this.info("No polling configured.");
        }
        if (pollingDir == null) {
            return null;
        }
        return new Object[]{pollingDir, pollingInt};
    }

    protected Provider<TransactionStore> getTSP() {
        if (this.tsp == null) {
            final DSTransactionProvider tp = new DSTransactionProvider();
            TransactionConverter tc = new TransactionConverter(tp, (TokenForge)this.getTokenForgeProvider().get(), (ClientStore<? extends Client>)((ClientStore<Client>)((ClientStore<? extends Client>)((ClientStore)this.getCSP().get()))));
            MultiDSTransactionStoreProvider storeProvider = new MultiDSTransactionStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get(), tp);
            storeProvider.addListener((CfgEventListener)new DSSQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider()), "mysql", this.getCSP(), (Provider<OA4MPServiceTransaction>)tp, (Provider<TokenForge>)this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new DSSQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider()), "mariadb", this.getCSP(), (Provider<OA4MPServiceTransaction>)tp, (Provider<TokenForge>)this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new DSSQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider()), "postgresql", this.getCSP(), (Provider<OA4MPServiceTransaction>)tp, (Provider<TokenForge>)this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new DSSQLTransactionStoreProvider(this.cn, (ConnectionPoolProvider<ConnectionPool>)((ConnectionPoolProvider<? extends ConnectionPool>)this.getDerbyConnectionPoolProvider()), "derby", this.getCSP(), (Provider<OA4MPServiceTransaction>)tp, (Provider<TokenForge>)this.getTokenForgeProvider(), (MapConverter)tc));
            storeProvider.addListener((CfgEventListener)new DSFSTransactionStoreProvider(this.cn, (IdentifiableProvider<OA4MPServiceTransaction>)tp, (Provider<TokenForge>)this.getTokenForgeProvider(), tc));
            storeProvider.addListener((CfgEventListener)new TypedProvider<TransactionStore>(this.cn, "memoryStore", "transactions"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public TransactionStore get() {
                    return new TransactionMemoryStore((IdentifiableProvider)tp);
                }
            });
            this.tsp = storeProvider;
        }
        return this.tsp;
    }

    protected abstract MultiDSClientStoreProvider getCSP();

    protected MultiDSPermissionStoreProvider getMpp() {
        if (this.mpp == null) {
            this.mpp = new MultiDSPermissionStoreProvider<Permission>(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get(), null, null, (IdentifiableProvider<? extends Permission>)PermissionStoreProviders.getPermissionProvider());
            this.mpp.addListener((CfgEventListener)PermissionStoreProviders.getM(this.cn));
            this.mpp.addListener((CfgEventListener)PermissionStoreProviders.getFSP(this.cn));
            this.mpp.addListener((CfgEventListener)PermissionStoreProviders.getMariaPS(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider()));
            this.mpp.addListener((CfgEventListener)PermissionStoreProviders.getPostgresPS(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider()));
            this.mpp.addListener((CfgEventListener)PermissionStoreProviders.getDerbyPS(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getDerbyConnectionPoolProvider()));
            this.mpp.addListener((CfgEventListener)PermissionStoreProviders.getMysqlPS(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider()));
        }
        return this.mpp;
    }

    protected MultiDSClientApprovalStoreProvider getCASP() {
        if (this.casp == null) {
            this.casp = new MultiDSClientApprovalStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            final ClientApprovalProvider caProvider = new ClientApprovalProvider();
            final ClientApproverConverter<ClientApproval> cp = new ClientApproverConverter<ClientApproval>(caProvider);
            this.casp.addListener((CfgEventListener)new DSFSClientApprovalStoreProvider(this.cn, cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider(), "mysql", cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider(), "mariadb", cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider(), "postgresql", cp));
            this.casp.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(this.cn, (ConnectionPoolProvider<? extends ConnectionPool>)this.getDerbyConnectionPoolProvider(), "derby", cp));
            this.casp.addListener((CfgEventListener)new TypedProvider<ClientApprovalStore>(this.cn, "memoryStore", "clientApprovals"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public ClientApprovalStore get() {
                    return new ClientApprovalMemoryStore<ClientApproval>(caProvider, cp);
                }
            });
        }
        return this.casp;
    }

    protected MailUtilProvider getMailUtilProvider() {
        if (this.mup == null) {
            this.mup = 0 < this.cn.getChildrenCount("mail") ? new ServletMailUtilProvider((ConfigurationNode)this.cn.getChildren("mail").get(0)) : new ServletMailUtilProvider();
        }
        return this.mup;
    }

    protected ServiceEnvironmentImpl.MessagesProvider getMP() {
        if (this.messagesProvider == null && 0 < this.cn.getChildrenCount("messages")) {
            this.messagesProvider = new ServiceEnvironmentImpl.MessagesProvider((ConfigurationNode)this.cn.getChildren("messages").get(0));
        }
        return this.messagesProvider;
    }

    public T createInstance() {
        this.initialize();
        return (T)new ServiceEnvironmentImpl((MyLoggingFacade)this.loggerProvider.get(), (Provider<TransactionStore>)this.getTransactionStoreProvider(), (Provider<ClientStore>)this.getClientStoreProvider(), this.getMaxAllowedNewClientRequests(), (Provider<ClientApprovalStore>)this.getClientApprovalStoreProvider(), this.getMailUtilProvider(), this.getMP(), (Provider<AGIssuer>)this.getAGIProvider(), (Provider<ATIssuer>)this.getATIProvider(), (Provider<PAIssuer>)this.getPAIProvider(), (Provider<TokenForge>)this.getTokenForgeProvider(), this.getConstants(), this.getAuthorizationServletConfig(), this.getUsernameTransformer(), this.getPingable(), (Provider<PermissionsStore>)this.getMpp());
    }

    protected boolean getPingable() {
        boolean isPingable = true;
        try {
            String y = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"pingable");
            if (y != null && y.length() != 0) {
                isPingable = Boolean.parseBoolean(y);
            }
        }
        catch (Throwable t) {
            this.warn("Could not parse pingable property. Using default of " + isPingable);
        }
        if (isPingable) {
            this.info("ping enabled");
        } else {
            this.info("ping disabled");
        }
        return isPingable;
    }

    public int getMaxAllowedNewClientRequests() {
        if (this.maxAllowedNewClientRequests < 0) {
            this.maxAllowedNewClientRequests = 100;
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"maxAllowedNewClientRequests");
            if (x != null) {
                try {
                    this.maxAllowedNewClientRequests = Integer.parseInt(x);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.maxAllowedNewClientRequests;
    }

    public URI getServiceAddress() {
        if (this.address == null) {
            String x = Configurations.getFirstAttribute((ConfigurationNode)this.cn, (String)"address");
            if (x == null) {
                this.warn("Warning: service address set to default. Do you need an \"address\" attribute in your service config. tag?");
                x = "http://localhost";
            }
            this.address = URI.create(x);
        }
        return this.address;
    }

    public UsernameTransformer getUsernameTransformer() {
        return new TrivialUsernameTransformer();
    }

    public T load() {
        this.info("loading configuration.");
        AbstractEnvironment se2 = this.createInstance();
        se2.setServiceAddress(this.getServiceAddress());
        this.getDebugger();
        se2.setDebugOn(DebugUtil.isEnabled());
        se2.info("Debugging is " + (se2.isDebugOn() ? "on" : "off"));
        Object[] polling = this.loadPolling();
        if (polling != null && 0L < (Long)polling[1]) {
            this.info("Loading polling for " + String.valueOf(polling[0]));
            AbstractCLIApprover.ClientApprovalThread cat = new AbstractCLIApprover.ClientApprovalThread(this.myLogger, (ServiceEnvironmentImpl)se2, (File)polling[0], (Long)polling[1]);
            se2.setClientApprovalThread(cat);
        }
        return (T)se2;
    }
}

