/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.UnapprovedClientException;
import org.oa4mp.delegation.server.request.AGRequest;
import org.oa4mp.delegation.server.request.AGResponse;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.server.api.storage.servlet.IssuerTransactionState;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;

public abstract class AbstractInitServlet
extends OA4MPServlet {
    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected ServiceTransaction doDelegation(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        Client client = this.getClient(req);
        ServiceTransaction transaction = this.newTransaction();
        transaction.setClient(client);
        try {
            String cid = "client=" + String.valueOf(client.getIdentifier());
            this.info("2.a. Starting a new cert request: " + cid);
            this.checkClientApproval((BaseClient)client);
            AGResponse agResponse = (AGResponse)this.getAGI().process((Request)new AGRequest(req, transaction));
            agResponse.setServiceTransaction(transaction);
            transaction = this.verifyAndGet((IssuerResponse)agResponse);
            this.getTransactionStore().save((Identifiable)transaction);
            this.info("Saved new transaction with id=" + transaction.getIdentifierString());
            Map params = agResponse.getParameters();
            XMLMap backup = GenericStoreUtils.toXML((Store)this.getTransactionStore(), (Identifiable)transaction);
            this.preprocess(new TransactionState(req, resp, params, (BasicTransaction)transaction, backup));
            this.debug("saved transaction for " + cid + ", trans id=" + transaction.getIdentifierString());
            agResponse.write(resp);
            this.info("2.b finished initial request for token =\"" + transaction.getIdentifierString() + "\".");
            this.postprocess(new IssuerTransactionState(req, resp, params, (BasicTransaction)transaction, backup, (IssuerResponse)agResponse));
            return transaction;
        }
        catch (Throwable t) {
            if (t instanceof UnapprovedClientException) {
                this.warn("Unapproved client: " + client.getIdentifierString());
            }
            throw t;
        }
    }
}

