/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.RetryException;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.NotificationListener;
import edu.uiuc.ncsa.security.servlet.Presentable;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.api.storage.servlet.PresentationState;
import org.oa4mp.server.api.util.NewClientEvent;
import org.oa4mp.server.api.util.NewClientListener;

public abstract class AbstractRegistrationServlet
extends OA4MPServlet
implements Presentable {
    public static final String CLIENT_NAME = "clientName";
    public static final String CLIENT_PUBLIC_KEY = "clientPublicKey";
    public static final String CLIENT_HOME_URL = "clientHomeUrl";
    public static final String CLIENT_ERROR_URL = "clientErrorUrl";
    public static final String CLIENT_EMAIL = "clientEmail";
    public static final String CLIENT_PROXY_LIMITED = "clientProxyLimited";
    public static final String CLIENT_IS_PUBLIC = "clientIsPublic";
    public static final String CLIENT_ACTION_KEY = "action";
    public static final String CLIENT_ACTION_REQUEST_VALUE = "request";
    protected static final int INITIAL_STATE = 0;
    protected static final int ERROR_STATE = -1;
    protected static final int REQUEST_STATE = 100;
    public static String INIT_PAGE = "/registration-init.jsp";
    public static String ERROR_PAGE = "/registration-error.jsp";
    public static String OK_PAGE = "/registration-ok.jsp";
    protected String emailPattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";

    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }

    public int getState(HttpServletRequest request) {
        String action = request.getParameter(CLIENT_ACTION_KEY);
        if (action == null || action.length() == 0) {
            return 0;
        }
        if (action.equals(CLIENT_ACTION_REQUEST_VALUE)) {
            return 100;
        }
        return -1;
    }

    protected void fireNewClientEvent(NewClientEvent newClientEvent) {
        for (NotificationListener notificationListener : notificationListeners) {
            if (!(notificationListener instanceof NewClientListener)) continue;
            ((NewClientListener)notificationListener).fireNewClientEvent(newClientEvent);
        }
    }

    public void prepare(PresentableState state) throws Throwable {
        this.preprocess(new TransactionState(state.getRequest(), state.getResponse(), null, null, null));
        switch (state.getState()) {
            case 0: {
                HttpServletRequest request = state.getRequest();
                String host = request.getRemoteAddr();
                if (StringUtils.isTrivial((String)host)) {
                    host = "none";
                }
                this.info("Processing new client registration request from <" + request.getRemoteAddr() + ">");
                request.setAttribute(CLIENT_NAME, (Object)CLIENT_NAME);
                request.setAttribute(CLIENT_PUBLIC_KEY, (Object)CLIENT_PUBLIC_KEY);
                request.setAttribute(CLIENT_HOME_URL, (Object)CLIENT_HOME_URL);
                request.setAttribute(CLIENT_ERROR_URL, (Object)CLIENT_ERROR_URL);
                request.setAttribute(CLIENT_EMAIL, (Object)CLIENT_EMAIL);
                request.setAttribute(CLIENT_PROXY_LIMITED, (Object)CLIENT_PROXY_LIMITED);
                request.setAttribute(CLIENT_IS_PUBLIC, (Object)CLIENT_IS_PUBLIC);
                request.setAttribute(CLIENT_PUBLIC_KEY, (Object)CLIENT_PUBLIC_KEY);
                request.setAttribute(CLIENT_ACTION_KEY, (Object)CLIENT_ACTION_KEY);
                request.setAttribute(CLIENT_ACTION_REQUEST_VALUE, (Object)CLIENT_ACTION_REQUEST_VALUE);
                request.setAttribute("actionToTake", (Object)(request.getContextPath() + request.getServletPath()));
                break;
            }
            case 100: {
                return;
            }
            default: {
                this.warn("Error: unknown action request.");
            }
        }
    }

    protected String getInitPage() {
        return INIT_PAGE;
    }

    protected String getErrorPage() {
        return ERROR_PAGE;
    }

    protected String getOKPage() {
        return OK_PAGE;
    }

    public void present(PresentableState state) throws Throwable {
        this.postprocess(new TransactionState(state.getRequest(), state.getResponse(), null, null, null));
        switch (state.getState()) {
            case 0: {
                JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)this.getInitPage());
                break;
            }
            case 100: {
                if (state instanceof ClientState) {
                    ClientState cState = (ClientState)state;
                    state.getRequest().setAttribute("client", (Object)cState.getClient());
                    JSPUtil.fwd((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)this.getOKPage());
                    break;
                }
                throw new IllegalStateException("Error: An instance of ClientState was expected, but got an instance of \"" + state.getClass().getName() + "\"");
            }
        }
    }

    public void handleError(PresentableState state, Throwable t) throws IOException, ServletException {
        state.getResponse().setHeader("X-Frame-Options", "DENY");
        JSPUtil.handleException((Throwable)t, (HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)this.getErrorPage());
    }

    protected String getValueTag(String key) {
        return key + "Value";
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        if (!request.isSecure()) {
            throw new ServletException("Unsupported protocol");
        }
        int state = this.getState(request);
        if (state == 0 && AbstractRegistrationServlet.getServiceEnvironment().getMaxAllowedNewClientRequests() <= AbstractRegistrationServlet.getServiceEnvironment().getClientApprovalStore().getPendingCount()) {
            this.error("Too many client approvals pending. Max allowed unapproved count is " + AbstractRegistrationServlet.getServiceEnvironment().getMaxAllowedNewClientRequests());
            AbstractRegistrationServlet.getServiceEnvironment().getMailUtil().sendMessage("Too many pending approvals", request.getServerName() + " has too many pending client approval requests outstanding. The server is configured for a limit of " + AbstractRegistrationServlet.getServiceEnvironment().getMaxAllowedNewClientRequests() + " and there are " + AbstractRegistrationServlet.getServiceEnvironment().getClientApprovalStore().getPendingCount() + " pending approvals in the store.", null);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tooManyClientRequests.jsp");
            return;
        }
        PresentationState pState = new PresentationState(state, request, response);
        try {
            this.prepare(pState);
            if (state == 100) {
                BaseClient client = this.addNewClient(request, response);
                this.save(client);
                pState = new ClientState(state, request, response, client);
            }
            this.present(pState);
        }
        catch (ClientRegistrationRetryException r) {
            AbstractRegistrationServlet.getServiceEnvironment().getClientStore().remove((Object)r.getClient().getIdentifier());
            this.setRetryParameters(request, r);
            if (request.getAttribute(this.getValueTag(CLIENT_PROXY_LIMITED)) != null && request.getAttribute(this.getValueTag(CLIENT_PROXY_LIMITED)).equals("on")) {
                request.setAttribute(this.getValueTag(CLIENT_PROXY_LIMITED), (Object)"checked");
            } else {
                request.removeAttribute(this.getValueTag(CLIENT_PROXY_LIMITED));
            }
            request.setAttribute(CLIENT_NAME, (Object)CLIENT_NAME);
            request.setAttribute(CLIENT_ACTION_KEY, (Object)CLIENT_ACTION_KEY);
            request.setAttribute(CLIENT_ACTION_REQUEST_VALUE, (Object)CLIENT_ACTION_REQUEST_VALUE);
            request.setAttribute("actionToTake", (Object)(request.getContextPath() + request.getServletPath()));
            request.setAttribute("retryMessage", (Object)StringEscapeUtils.escapeHtml((String)r.getMessage()));
            this.logOK(request);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getInitPage());
        }
        catch (Throwable t) {
            if (ServletDebugUtil.isEnabled()) {
                t.printStackTrace();
            }
            this.warn("Error registering a new client:" + t.getMessage());
            this.handleError(pState, t);
        }
    }

    protected void save(BaseClient client) {
        AbstractRegistrationServlet.getServiceEnvironment().getClientStore().save((Identifiable)((Client)client));
    }

    protected void setRetryParameters(HttpServletRequest request, RetryException r) {
        for (Object p : request.getParameterMap().keySet()) {
            if (p == null) continue;
            String key = p.toString();
            request.setAttribute(key, (Object)key);
            String escapedValue = StringEscapeUtils.escapeHtml((String)request.getParameter(key));
            request.setAttribute(this.getValueTag(key), (Object)escapedValue);
        }
    }

    protected String getParameter(HttpServletRequest req, String key) {
        return req.getParameter(key);
    }

    protected String getRequiredParam(HttpServletRequest req, String key, BaseClient client) {
        String x = this.getParameter(req, key);
        if (x == null || x.length() == 0) {
            throw new ClientRegistrationRetryException("Error: missing value for " + key, null, client);
        }
        return x;
    }

    boolean getBooleanParam(HttpServletRequest req, String key) {
        String x = req.getParameter(key);
        if (x == null || x.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(x);
    }

    protected BaseClient setupNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Client client = (Client)AbstractRegistrationServlet.getServiceEnvironment().getClientStore().create();
        this.info("creating entry for client=" + client.getIdentifierString());
        client.setName(this.getRequiredParam(request, CLIENT_NAME, (BaseClient)client));
        client.setHomeUri(this.getRequiredParam(request, CLIENT_HOME_URL, (BaseClient)client));
        String x = this.getRequiredParam(request, CLIENT_EMAIL, (BaseClient)client);
        Pattern p = Pattern.compile(this.emailPattern);
        Matcher m = p.matcher(x);
        if (!m.matches()) {
            throw new ClientRegistrationRetryException("The email address \"" + x + "\" is not valid.", null, (BaseClient)client);
        }
        client.setEmail(x);
        String limitedChecked = this.getParameter(request, CLIENT_PROXY_LIMITED);
        client.setProxyLimited(limitedChecked != null && limitedChecked.equals("on"));
        AbstractRegistrationServlet.getServiceEnvironment().getClientStore().save((Identifiable)client);
        this.info("Adding approval record for client=" + client.getIdentifierString());
        ClientApproval clientApproval = new ClientApproval(client.getIdentifier());
        clientApproval.setApproved(false);
        this.info("done with client registration, client=" + client.getIdentifierString());
        return client;
    }

    protected BaseClient addNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.setupNewClient(request, response);
    }

    public static class ClientRegistrationRetryException
    extends RetryException {
        BaseClient client;

        public BaseClient getClient() {
            return this.client;
        }

        public ClientRegistrationRetryException(String message, Throwable cause, BaseClient client) {
            super(message, cause);
            this.client = client;
        }
    }

    protected static class ClientState
    extends PresentationState {
        BaseClient client;

        ClientState(int state, HttpServletRequest request, HttpServletResponse response, BaseClient client) {
            super(state, request, response);
            this.client = client;
        }

        public BaseClient getClient() {
            return this.client;
        }
    }
}

