/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.oa4mp.delegation.server.OIDCDiscoveryTags;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;

public class DiscoveryServlet
extends OA4MPServlet
implements OIDCDiscoveryTags {
    public static final String DEFAULT_REGISTRATION_ENDPOINT = "oidc-cm";
    public static final String DISCOVERY_PATH = ".well-known";
    protected String discoveryPagePath = "/well-known.jsp";

    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        throw new NotImplementedException("Not implemented in discovery");
    }

    public String getDiscoveryPagePath() {
        return this.discoveryPagePath;
    }

    public void setDiscoveryPagePath(String discoveryPagePath) {
        this.discoveryPagePath = discoveryPagePath;
    }

    protected JSONObject setValues(HttpServletRequest httpServletRequest, JSONObject jsonObject) {
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        String requestURI = DiscoveryServlet.getRequestURI(httpServletRequest);
        Object authzEndpoint = !this.isEmpty(DiscoveryServlet.getServiceEnvironment().getAuthorizationServletConfig().getAuthorizationURI()) ? DiscoveryServlet.getServiceEnvironment().getAuthorizationServletConfig().getAuthorizationURI() : requestURI + "/authorize";
        jsonObject.put((Object)"authorization_endpoint", authzEndpoint);
        jsonObject.put((Object)"registration_endpoint", (Object)(requestURI + "/oidc-cm"));
        return jsonObject;
    }

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        JSONObject jsonObject = new JSONObject();
        jsonObject = this.setValues(httpServletRequest, jsonObject);
        String out = JSONUtils.valueToString((Object)jsonObject, (int)1, (int)0);
        httpServletResponse.setHeader("Content-Type", "application/json;charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(out);
        printWriter.close();
        printWriter.flush();
    }

    protected static String getRequestURI(HttpServletRequest request, boolean includePort) {
        Object requestURI = request.getScheme() + "://" + request.getServerName() + (String)(includePort ? ":" + request.getServerPort() : "") + request.getRequestURI();
        if (((String)requestURI).endsWith("/")) {
            requestURI = ((String)requestURI).substring(0, ((String)requestURI).length() - 1);
        }
        if (0 < ((String)requestURI).indexOf("/.well-known")) {
            requestURI = ((String)requestURI).substring(0, ((String)requestURI).indexOf("/.well-known"));
        }
        return requestURI;
    }

    protected static String getRequestURI(HttpServletRequest request) {
        return DiscoveryServlet.getRequestURI(request, true);
    }
}

