/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;

public class ErrorServlet
extends OA4MPServlet {
    public static final String MESSAGE = "message";
    public static final String IDENTIFIER = "identifier";
    public static final String STACK_TRACE = "stackTrace";
    public static final String CAUSE = "cause";

    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String cause = request.getParameter(CAUSE);
        String identifier = request.getParameter(IDENTIFIER);
        request.setAttribute(CAUSE, (Object)cause);
        request.setAttribute(IDENTIFIER, (Object)identifier);
        request.setAttribute(MESSAGE, (Object)URLDecoder.decode(request.getParameter(MESSAGE), "UTF-8"));
        String stackTrace = request.getParameter(STACK_TRACE);
        if (stackTrace == null || stackTrace.length() == 0) {
            stackTrace = "(none)";
        } else {
            try {
                stackTrace = new String(Base64.decodeBase64((String)stackTrace));
            }
            catch (Throwable x) {
                this.info("Could not decode stack trace for cause " + x.getClass().getName() + " msg=\"" + x.getMessage() + "\", trace:" + stackTrace);
                stackTrace = "(none)";
            }
        }
        request.setAttribute(STACK_TRACE, (Object)stackTrace);
        if (cause.equals(UnknownClientException.class.getSimpleName())) {
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/noClientErrorPage.jsp");
            return;
        }
        Client client = this.getClient(BasicIdentifier.newID((String)identifier));
        request.setAttribute("client", (Object)client);
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/errorPage2.jsp");
    }
}

