/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTimestampException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.HostUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.ExceptionHandlerThingie;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.server.UnapprovedClientException;

public class OA4MPExceptionHandler
implements ExceptionHandler {
    MyLoggingFacade logger;

    public MyLoggingFacade getLogger() {
        return this.logger;
    }

    public OA4MPExceptionHandler(MyLoggingFacade logger) {
        this.logger = logger;
    }

    public void handleException(ExceptionHandlerThingie xh) throws IOException, ServletException {
        Throwable t = xh.throwable;
        HttpServletRequest request = xh.request;
        HttpServletResponse response = xh.response;
        if (t instanceof NullPointerException) {
            this.getLogger().error("Null pointer", t);
            throw new GeneralException("Error: Null pointer encountered.");
        }
        if (t instanceof UnknownClientException || t instanceof UnapprovedClientException) {
            throw (GeneralException)t;
        }
        if (t instanceof InvalidTimestampException) {
            request.setAttribute("message", (Object)"Session expired. Please try again.");
            request.setAttribute("exception", (Object)(t.getCause() == null ? t : t.getCause()));
        } else {
            request.setAttribute("message", (Object)((t.getCause() == null ? t.getMessage() : t.getCause().getMessage()) + "\n"));
            request.setAttribute("exception", (Object)(t.getCause() == null ? t : t.getCause()));
        }
        request.setAttribute("clientIP", (Object)(request.getRemoteAddr() + "\n"));
        try {
            request.setAttribute("clientHost", (Object)(HostUtil.reverseLookup((String)request.getRemoteAddr()) + "\n"));
        }
        catch (UnknownHostException ux) {
            request.setAttribute("clientHost", (Object)"could not resolve client IP to a host\n");
        }
        if (t.getCause() != null) {
            if (t.getCause() instanceof FailedLoginException || t.getCause() instanceof LoginException) {
                JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/failedLogin.jsp");
                return;
            }
            if (t.getCause() instanceof ProtocolException) {
                JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/failedLogin.jsp");
                return;
            }
        }
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/oops.jsp");
    }
}

