/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.QueueWithSpare;
import edu.uiuc.ncsa.security.servlet.HeaderUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.storage.events.LastAccessedThread;
import edu.uiuc.ncsa.security.util.pkcs.KeyPairPopulationThread;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.oa4mp.delegation.common.servlet.TransactionFilter;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.UnapprovedClientException;
import org.oa4mp.delegation.server.issuers.AGIssuer;
import org.oa4mp.delegation.server.issuers.ATIssuer;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.api.ServiceEnvironment;
import org.oa4mp.server.api.ServiceEnvironmentImpl;
import org.oa4mp.server.api.storage.servlet.EnvServlet;
import org.oa4mp.server.api.util.AbstractCLIApprover;
import org.oa4mp.server.api.util.ClientDebugUtil;

public abstract class OA4MPServlet
extends EnvServlet
implements TransactionFilter {
    public static Cleanup<String, BasicTransaction> transactionCleanup;
    public static LastAccessedThread lastAccessedThread;
    public static KeyPairPopulationThread kpt;
    public static AbstractCLIApprover.ClientApprovalThread caThread;

    public static MetaDebugUtil createDebugger(BaseClient client) {
        if (client == null) {
            return DebugUtil.getInstance();
        }
        if (client.isDebugOn()) {
            ClientDebugUtil debugger = new ClientDebugUtil(client);
            debugger.setIsEnabled(true);
            debugger.setDebugLevel(1);
            debugger.setPrintTS(true);
            return debugger;
        }
        return DebugUtil.getInstance();
    }

    public abstract ServiceTransaction verifyAndGet(IssuerResponse var1) throws IOException;

    @Override
    public ServiceEnvironmentImpl loadProperties2() throws IOException {
        ServiceEnvironmentImpl se2 = super.loadProperties2();
        if (se2.isPollingEnabled()) {
            caThread = se2.getClientApprovalThread();
        }
        kpt = new KeyPairPopulationThread((QueueWithSpare)se2.getKeyPairQueue());
        return se2;
    }

    public AGIssuer getAGI() throws IOException {
        return OA4MPServlet.getServiceEnvironment().getAgIssuer();
    }

    protected ATIssuer getATI() throws IOException {
        return OA4MPServlet.getServiceEnvironment().getAtIssuer();
    }

    public static ServiceEnvironment getServiceEnvironment() {
        return (ServiceEnvironment)OA4MPServlet.getEnvironment();
    }

    @Override
    public void storeUpdates() throws IOException, SQLException {
        if (storeUpdatesDone) {
            return;
        }
        storeUpdatesDone = true;
        this.realStoreUpdates();
    }

    protected void realStoreUpdates() throws IOException, SQLException {
        ServletDebugUtil.trace((Object)((Object)this), (String)"starting store updates");
        this.processStoreCheck((Store)this.getTransactionStore());
        this.processStoreCheck((Store)OA4MPServlet.getServiceEnvironment().getClientStore());
        this.processStoreCheck((Store)OA4MPServlet.getServiceEnvironment().getClientApprovalStore());
    }

    protected void shutdownCleanup(Cleanup c) {
        if (c != null && !c.isStopThread()) {
            c.setStopThread(true);
            c.interrupt();
        }
    }

    public void destroy() {
        super.destroy();
        this.shutdownCleanup(transactionCleanup);
        if (caThread != null) {
            caThread.setStopThread(true);
        }
        if (kpt != null) {
            kpt.setStopThread(true);
        }
        if (lastAccessedThread != null) {
            lastAccessedThread.setStopThread(true);
        }
    }

    public TransactionStore getTransactionStore() throws IOException {
        return OA4MPServlet.getServiceEnvironment().getTransactionStore();
    }

    public Client getClient(HttpServletRequest req) {
        return this.getClient(this.getGrantIDFromRequest(req));
    }

    protected ServiceTransaction getTransactionByGrantID(HttpServletRequest request) throws IOException {
        Identifier id = this.getGrantIDFromRequest(request);
        ServletDebugUtil.trace((Object)((Object)this), (String)("getting transaction from id \"" + String.valueOf(id) + "\""));
        ServiceTransaction t = (ServiceTransaction)this.getTransactionStore().get((Object)id);
        ServletDebugUtil.trace((Object)((Object)this), (String)("got transaction \"" + String.valueOf(t) + "\""));
        return t;
    }

    protected Identifier getGrantIDFromRequest(HttpServletRequest req) {
        if (req.getParameter(OA4MPServlet.CONST((String)"oa4mp:client_id")) == null) {
            throw new UnknownClientException("Error: no client identifier has been supplied. Have you registered this client with the service?");
        }
        return BasicIdentifier.newID((String)req.getParameter(OA4MPServlet.CONST((String)"oa4mp:client_id")));
    }

    public Client getClient(Identifier identifier) {
        if (identifier == null) {
            throw new UnknownClientException("no client id");
        }
        Client c = (Client)OA4MPServlet.getServiceEnvironment().getClientStore().get((Object)identifier);
        if (c == null) {
            if (OA4MPServlet.getServiceEnvironment().getClientStore().size() == 0) {
                DebugUtil.trace((Object)((Object)this), (String)"CLIENT STORE HAS NO ENTRIES!");
                DebugUtil.trace((Object)((Object)this), (String)("client name is " + OA4MPServlet.getServiceEnvironment().getClientStore().getClass().getSimpleName()));
                DebugUtil.trace((Object)((Object)this), (String)("client store is a " + String.valueOf(OA4MPServlet.getServiceEnvironment().getClientStore())));
            }
            String ww = "Unknown client: \"" + identifier.toString() + "\"  cannot be found.";
            this.warn(ww + " Client store is " + String.valueOf(OA4MPServlet.getServiceEnvironment().getClientStore()));
            throw new UnknownClientException(ww + "  Is the value in the client config correct?", identifier);
        }
        this.checkClientApproval((BaseClient)c);
        return c;
    }

    public ServiceTransaction newTransaction() throws IOException {
        return (ServiceTransaction)OA4MPServlet.getServiceEnvironment().getTransactionStore().create();
    }

    protected ServiceTransaction getTransaction(AuthorizationGrant grant) throws IOException {
        return (ServiceTransaction)this.getTransactionStore().get(grant);
    }

    protected Client getClient(AuthorizationGrant authorizationGrant) throws IOException {
        ServiceTransaction transaction = this.getTransaction(authorizationGrant);
        return transaction.getClient();
    }

    public void checkClientApproval(BaseClient client) {
        ClientApproval clientApproval = (ClientApproval)OA4MPServlet.getServiceEnvironment().getClientApprovalStore().get((Object)client.getIdentifier());
        String ww = null;
        if (clientApproval == null) {
            ww = "The client with identifier \"" + String.valueOf(client.getIdentifier()) + "\" has not been approved. Request rejected. Please contact your administrator.";
        } else {
            switch (clientApproval.getStatus()) {
                case APPROVED: {
                    return;
                }
                case NONE: 
                case PENDING: {
                    ww = "The client with identifier \"" + String.valueOf(client.getIdentifier()) + "\" is pending approval. Request rejected. Please contact your administrator.";
                    break;
                }
                case REVOKED: {
                    ww = "The client with identifier \"" + String.valueOf(client.getIdentifier()) + "\" has been revoked. Request rejected. Please contact your administrator.";
                    break;
                }
                case DENIED: {
                    ww = "The client with identifier \"" + String.valueOf(client.getIdentifier()) + "\" has been denied. Request rejected. Please contact your administrator.";
                    break;
                }
                default: {
                    ww = "The client with identifier \"" + String.valueOf(client.getIdentifier()) + "\" has unknown status. Request rejected. Please contact your administrator.";
                }
            }
        }
        this.warn(ww);
        throw new UnapprovedClientException("Error: " + ww, client);
    }

    protected boolean isEmpty(String x) {
        return x == null || x.length() == 0;
    }

    public void preprocess(TransactionState state) throws Throwable {
    }

    public void postprocess(TransactionState state) throws Throwable {
        state.getResponse().setHeader("X-Frame-Options", "DENY");
        state.getResponse().setHeader("Cache-Control", "no-store");
    }

    public static Map<String, String> getFirstParameters(HttpServletRequest req) {
        return HeaderUtils.getFirstParameters((HttpServletRequest)req);
    }

    public String getFirstParameterValue(HttpServletRequest req, String key) {
        return HeaderUtils.getFirstParameterValue((HttpServletRequest)req, (String)key);
    }

    public void say(String x) {
        System.out.println(((Object)((Object)this)).getClass().getSimpleName() + ": " + x);
    }

    public void checkAdminClientStatus(Identifier clientID) {
        List<Identifier> adminIDs = OA4MPServlet.getServiceEnvironment().getPermissionStore().getAdmins(clientID);
        if (adminIDs == null || adminIDs.size() == 0) {
            return;
        }
        for (Identifier adminID : adminIDs) {
            if (OA4MPServlet.getServiceEnvironment().getClientApprovalStore().isApproved(adminID)) continue;
            throw new OA2GeneralError("unauthorized_client", "Admin client is not approved , access denied", 401, null);
        }
    }

    static {
        lastAccessedThread = null;
        caThread = null;
    }
}

