/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.LockingCleanup;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.cache.ValidTimestampPolicy;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.Initialization;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.mail.MailUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyPairPopulationThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import org.oa4mp.server.api.ServiceEnvironmentImpl;
import org.oa4mp.server.api.storage.servlet.OA4MPExceptionHandler;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.api.util.AbstractCLIApprover;
import org.oa4mp.server.api.util.NewClientNotifier;

public class OA4MPServletInitializer
implements Initialization {
    protected ExceptionHandler exceptionHandler;
    protected static boolean isInitRun = false;
    AbstractEnvironment environment;
    static boolean notifiersSet = false;
    AbstractServlet servlet;

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new OA4MPExceptionHandler(this.getEnvironment().getMyLogger());
        }
        return this.exceptionHandler;
    }

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    String getTemplate(File filename) throws IOException {
        String body = "";
        try {
            FileInputStream fr = new FileInputStream(filename);
            StringBuffer sb = new StringBuffer();
            int z = 0;
            while ((z = fr.read()) != -1) {
                sb.append((char)z);
            }
            body = sb.toString();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return body;
    }

    protected NewClientNotifier createNewClientNotifier(MailUtil mailUtil, MyLoggingFacade logger) {
        return new NewClientNotifier(mailUtil, logger);
    }

    public void setupNotifiers() throws IOException {
        if (notifiersSet) {
            return;
        }
        OA4MPServlet mps = (OA4MPServlet)this.getServlet();
        ServiceEnvironmentImpl env = (ServiceEnvironmentImpl)this.getEnvironment();
        MyLoggingFacade logger = env.getMyLogger();
        NewClientNotifier newClientNotifier = this.createNewClientNotifier(env.getMailUtil(), logger);
        OA4MPServlet.addNotificationListener(newClientNotifier);
        String fName = mps.getServletContext().getInitParameter("oa4mp:server.error.subject");
        if (fName == null) {
            logger.info("No error notification subject set. Skipping...");
            notifiersSet = true;
            return;
        }
        logger.info("Set error notification subject to " + fName);
        MailUtil x = new MailUtil(env.getMailUtil().getMailEnvironment());
        if (x.isEnabled()) {
            x.setSubjectTemplate(this.getTemplate(new File(fName)));
            x.setMessageTemplate(this.getTemplate(new File(fName)));
        }
        if ((fName = mps.getServletContext().getInitParameter("oa4mp:server.error.message")) == null) {
            logger.info("No error notification message body set. Skipping...");
            notifiersSet = true;
            return;
        }
        logger.info("Set error notification message body to " + fName);
        notifiersSet = true;
    }

    public void init() throws ServletException {
        KeyPairPopulationThread kpt;
        AbstractCLIApprover.ClientApprovalThread caThread;
        if (isInitRun) {
            return;
        }
        isInitRun = true;
        OA4MPServlet mps = (OA4MPServlet)this.getServlet();
        URI serviceAddress = mps.getServiceEnvironment().getServiceAddress();
        if (serviceAddress != null) {
            DebugUtil.setHost((String)serviceAddress.getHost());
        }
        for (Store s : mps.getServiceEnvironment().listStores()) {
            try {
                ServletDebugUtil.info((Object)this, (String)("updating store table for " + String.valueOf(s)));
                mps.processStoreCheck(s);
            }
            catch (Throwable e) {
                ServletDebugUtil.error((Object)this, (String)("could not update table for store " + String.valueOf(s)), (Throwable)e);
                if (!ServletDebugUtil.isEnabled()) continue;
                e.printStackTrace();
            }
        }
        ServiceEnvironmentImpl env = (ServiceEnvironmentImpl)this.getEnvironment();
        MyLoggingFacade logger = env.getMyLogger();
        logger.info("Cleaning up incomplete client registrations");
        if (OA4MPServlet.transactionCleanup == null) {
            LockingCleanup lc = new LockingCleanup(logger, "transaction cleanup");
            lc.setStopThread(false);
            lc.setStore(env.getTransactionStore());
            lc.addRetentionPolicy((RetentionPolicy)new ValidTimestampPolicy());
            OA4MPServlet.transactionCleanup = lc;
        }
        if ((caThread = OA4MPServlet.caThread) != null && !caThread.isAlive()) {
            caThread.setStopThread(false);
            caThread.start();
        }
        if ((kpt = OA4MPServlet.kpt) != null && !kpt.isAlive()) {
            kpt.setStopThread(false);
            kpt.start();
        }
        try {
            this.setupNotifiers();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new GeneralException("Error: could not set up notifiers ", e);
        }
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public AbstractServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(AbstractServlet servlet) {
        this.servlet = servlet;
    }
}

