/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.servlet;

import edu.uiuc.ncsa.security.core.exceptions.RetryException;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.server.api.storage.servlet.AbstractRegistrationServlet;
import org.oa4mp.server.api.util.NewClientEvent;

public class RegistrationServlet
extends AbstractRegistrationServlet {
    protected Client addNewClient(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Client client = (Client)super.addNewClient(request, response);
        client.setSecret(this.getRequiredParam(request, "clientPublicKey", (BaseClient)client));
        String x = this.getRequiredParam(request, "clientErrorUrl", (BaseClient)client);
        if (!x.toLowerCase().startsWith("https")) {
            throw new RetryException("The error uri \"" + x + "\" is not secure.");
        }
        client.setErrorUri(x);
        try {
            this.debug("decoding public key from PEM");
            KeyUtil.fromX509PEM((String)client.getSecret());
        }
        catch (Throwable t) {
            this.warn("could not decode public key for client=" + client.getIdentifierString() + ", message:" + t.getMessage());
            request.setAttribute("client", (Object)client);
            throw new RetryException("public key could not be parsed. " + t.getMessage());
        }
        this.fireNewClientEvent(new NewClientEvent((Object)this, (BaseClient)client));
        return client;
    }
}

