/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.sql;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.server.api.storage.sql.table.ClientApprovalTable;

public class SQLClientApprovalStore
extends SQLStore<ClientApproval>
implements ClientApprovalStore<ClientApproval> {
    public static final String DEFAULT_TABLENAME = "client_approvals";

    public String getCreationTSField() {
        return ((ClientApprovalKeys)this.getMapConverter().getKeys()).approvalTS(new String[0]);
    }

    public SQLClientApprovalStore(ConnectionPool connectionPool, Table table, IdentifiableProviderImpl<ClientApproval> identifiableProvider, MapConverter converter) {
        super(connectionPool, table, identifiableProvider, converter);
    }

    ClientApprovalTable getCAT() {
        return (ClientApprovalTable)this.getTable();
    }

    public boolean isApproved(Identifier identifier) {
        ClientApproval c = (ClientApproval)this.get(identifier);
        if (c == null) {
            return false;
        }
        return c.isApproved();
    }

    public int getUnapprovedCount() {
        int count = 0;
        String query = "Select " + this.getTable().getPrimaryKeyColumnName() + " from " + this.getTable().getFQTablename() + " where " + this.getCAT().ca().approved(new String[0]) + "=false ";
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        try {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ++count;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            if (DebugUtil.getDebugLevel() == 1) {
                e.printStackTrace();
            }
            DebugUtil.trace((String)"sql error", (Throwable)e);
            throw new GeneralException("Error getting the user ids", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        return count;
    }

    public int getPendingCount() {
        int count = 0;
        String query = "Select " + this.getTable().getPrimaryKeyColumnName() + " from " + this.getTable().getFQTablename() + " where " + this.getCAT().ca().approved(new String[0]) + "=false ";
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        try {
            PreparedStatement stmt = c.prepareStatement(query);
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ++count;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            if (DebugUtil.getDebugLevel() == 1) {
                e.printStackTrace();
            }
            DebugUtil.trace((String)"sql error", (Throwable)e);
            throw new GeneralException("Error getting the user ids", (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
        return count;
    }

    public List<Identifier> statusSearch(String status) {
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        ClientApprovalKeys keys = (ClientApprovalKeys)this.getMapConverter().getKeys();
        String idColName = keys.identifier(new String[0]);
        String searchString = "select " + idColName + " from " + this.getTable().getFQTablename() + " where " + keys.status(new String[0]) + " = ?";
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        try {
            PreparedStatement stmt = c.prepareStatement(searchString);
            stmt.setString(1, status);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                ids.add((Identifier)new BasicIdentifier(rs.getString(idColName)));
            }
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
        }
        catch (SQLException e) {
            this.destroyConnection(cr);
            if (DebugUtil.isEnabled()) {
                e.printStackTrace();
            }
            throw new GeneralException("Error getting client approval", (Throwable)e);
        }
        return ids;
    }
}

