/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.storage.sql;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.storage.cli.StoreArchiver;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.inject.Provider;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.storage.BaseClientSQLStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.ServiceEnvironment;
import org.oa4mp.server.api.admin.permissions.PermissionKeys;
import org.oa4mp.server.api.admin.permissions.SQLPermissionStore;
import org.oa4mp.server.api.storage.sql.SQLClientApprovalStore;

public class SQLClientStore<V extends Client>
extends BaseClientSQLStore<V>
implements ClientStore<V> {
    public static final String DEFAULT_TABLENAME = "clients";

    public SQLClientStore(ConnectionPool connectionPool, Table table, Provider<V> idp, MapConverter converter) {
        super(connectionPool, table, idp, converter);
    }

    public MapConverter<V> getMapConverter() {
        return this.converter;
    }

    public void save(V value) {
        value.setLastModifiedTS((Date)new Timestamp(new Date().getTime()));
        super.save(value);
    }

    public long updateHook(String action, AbstractEnvironment environment, List<Identifier> identifiers) {
        if (identifiers.isEmpty()) {
            return 0L;
        }
        long counter = 0L;
        ServiceEnvironment serviceEnvirnoment = (ServiceEnvironment)environment;
        SQLPermissionStore permissionStore = (SQLPermissionStore)serviceEnvirnoment.getPermissionStore();
        SQLClientApprovalStore approvalStore = (SQLClientApprovalStore)serviceEnvirnoment.getClientApprovalStore();
        PermissionKeys permissionKeys = (PermissionKeys)permissionStore.getMapConverter().getKeys();
        switch (action) {
            case "none": {
                return 0L;
            }
            case "test": 
            case "retain": {
                return identifiers.size();
            }
            case "archive": {
                StoreArchiver pStoreArchiver = new StoreArchiver((Store)permissionStore);
                StoreArchiver aStoreArchiver = new StoreArchiver((Store)approvalStore);
                ConnectionRecord pCR = permissionStore.getConnection();
                ConnectionRecord aCR = approvalStore.getConnection();
                try {
                    PreparedStatement pArchiveStmt = pCR.connection.prepareStatement(pStoreArchiver.createVersionStatement());
                    PreparedStatement aArchiveStmt = aCR.connection.prepareStatement(aStoreArchiver.createVersionStatement());
                    for (Identifier identifier : identifiers) {
                        pStoreArchiver.addToBatch(pArchiveStmt, identifier);
                        aStoreArchiver.addToBatch(aArchiveStmt, identifier);
                    }
                    counter += (long)pArchiveStmt.executeUpdate();
                    counter += (long)aArchiveStmt.executeUpdate();
                    permissionStore.releaseConnection(pCR);
                    approvalStore.releaseConnection(aCR);
                }
                catch (SQLException sqlException) {
                    if (DebugUtil.isEnabled()) {
                        sqlException.printStackTrace();
                    }
                    permissionStore.getConnectionPool().destroy(pCR);
                    approvalStore.getConnectionPool().destroy(aCR);
                }
            }
            case "delete": {
                String permissionStmt = "delete from " + permissionStore.getTable().getFQTablename() + " where " + permissionKeys.clientID(new String[0]) + "=?";
                String approvalStmt = "delete from " + approvalStore.getTable().getFQTablename() + " where " + permissionKeys.clientID(new String[0]) + "=?";
                ConnectionRecord pCR = permissionStore.getConnection();
                ConnectionRecord aCR = approvalStore.getConnection();
                try {
                    PreparedStatement pStmt = pCR.connection.prepareStatement(permissionStmt);
                    PreparedStatement aStmt = pCR.connection.prepareStatement(approvalStmt);
                    for (Identifier identifier : identifiers) {
                        pStmt.setString(1, identifier.toString());
                        pStmt.addBatch();
                        aStmt.setString(1, identifier.toString());
                        aStmt.addBatch();
                    }
                    long rc = pStmt.executeUpdate();
                    rc += (long)aStmt.executeUpdate();
                    if (action.equals("delete")) {
                        counter += rc;
                    }
                    permissionStore.releaseConnection(pCR);
                    approvalStore.releaseConnection(aCR);
                    break;
                }
                catch (SQLException sqlException) {
                    if (DebugUtil.isEnabled()) {
                        sqlException.printStackTrace();
                    }
                    permissionStore.getConnectionPool().destroy(pCR);
                    approvalStore.getConnectionPool().destroy(aCR);
                }
            }
        }
        return counter;
    }
}

