/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.util;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.MemoryStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.server.api.util.ClientApproverConverter;

public class ClientApprovalMemoryStore<V extends ClientApproval>
extends MemoryStore<V>
implements ClientApprovalStore<V> {
    MapConverter converter;

    public ClientApprovalMemoryStore(IdentifiableProviderImpl<V> vIdentifiableProvider, ClientApproverConverter converter) {
        super(vIdentifiableProvider);
        this.converter = converter;
    }

    public boolean isApproved(Identifier identifier) {
        ClientApproval ca = (ClientApproval)this.get(identifier);
        if (ca == null) {
            return false;
        }
        return ((ClientApproval)this.get(identifier)).isApproved();
    }

    public int getUnapprovedCount() {
        int count = 0;
        for (Identifier key : this.keySet()) {
            if (!this.isApproved(key)) continue;
            ++count;
        }
        return count;
    }

    public int getPendingCount() {
        int count = 0;
        for (Identifier key : this.keySet()) {
            ClientApproval approval = (ClientApproval)this.get(key);
            if (approval.getStatus() != ClientApproval.Status.PENDING) continue;
            ++count;
        }
        return count;
    }

    public XMLConverter<V> getXMLConverter() {
        return this.converter;
    }

    public MapConverter getMapConverter() {
        return this.converter;
    }

    public List<Identifier> statusSearch(String status) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier identifier : this.keySet()) {
            if (!((ClientApproval)this.get(identifier)).getStatus().getStatus().equals(status)) continue;
            identifiers.add(identifier);
        }
        return identifiers;
    }

    public List<V> getMostRecent(int n, List<String> attributes) {
        return GenericStoreUtils.getMostRecent((Store)this, (int)n, attributes);
    }
}

