/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.util;

import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import java.util.Date;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.server.storage.ClientApproval;

public class ClientApproverConverter<V extends ClientApproval>
extends MapConverter<V> {
    public ClientApproverConverter(IdentifiableProviderImpl<V> identifiableProvider) {
        super((SerializationKeys)new ClientApprovalKeys(), identifiableProvider);
    }

    public ClientApproverConverter(SerializationKeys keys, IdentifiableProviderImpl<V> identifiableProvider) {
        super(keys, identifiableProvider);
    }

    protected ClientApprovalKeys getCAKeys() {
        return (ClientApprovalKeys)this.keys;
    }

    public V fromMap(ConversionMap<String, Object> map, V ca) {
        ca = (ClientApproval)super.fromMap(map, ca);
        ca.setApproved(map.getBoolean((Object)this.getCAKeys().approved(new String[0])));
        ca.setApprover(map.getString((Object)this.getCAKeys().approver(new String[0])));
        ca.setApprovalTimestamp(map.getDate((Object)this.getCAKeys().approvalTS(new String[0])));
        String status = map.getString((Object)this.getCAKeys().status(new String[0]));
        if (status == null) {
            ca.setStatus(ClientApproval.Status.NONE);
        } else {
            ClientApproval.Status status1 = ClientApproval.Status.resolveByStatusValue((String)status);
            ca.setStatus(status1);
        }
        return ca;
    }

    public void toMap(V value, ConversionMap<String, Object> map) {
        super.toMap(value, map);
        map.put((Object)this.getCAKeys().approver(new String[0]), (Object)value.getApprover());
        if (value.getApprovalTimestamp() == null) {
            value.setApprovalTimestamp(new Date());
        }
        map.put((Object)this.getCAKeys().approvalTS(new String[0]), (Object)value.getApprovalTimestamp());
        map.put((Object)this.getCAKeys().approved(new String[0]), (Object)value.isApproved());
        if (value.getStatus() == null) {
            map.put((Object)this.getCAKeys().status(new String[0]), (Object)ClientApproval.Status.NONE);
        } else {
            map.put((Object)this.getCAKeys().status(new String[0]), (Object)value.getStatus().getStatus());
        }
    }
}

