/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.api.util;

import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import java.util.Date;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.ServiceTransaction;

public class ClientDebugUtil
extends MetaDebugUtil {
    BaseClient client;
    ServiceTransaction transaction = null;
    String tID = null;

    public ClientDebugUtil(BaseClient client) {
        this.client = client;
    }

    public void printIt(int level, Class callingClass, String message) {
        if (level <= this.getDebugLevel()) {
            if (this.host == null || this.host.isEmpty()) {
                this.printIt((this.isPrintTS() ? Iso8601.date2String((Date)new Date()) : "") + " " + callingClass.getSimpleName() + " " + ClientDebugUtil.toLabel((int)level) + ": [" + this.client.getIdentifierString() + "] " + message);
            } else {
                this.printIt((this.isPrintTS() ? Iso8601.date2String((Date)new Date()) : "") + " " + this.host + " " + callingClass.getSimpleName() + " " + ClientDebugUtil.toLabel((int)level) + ": " + message);
            }
        }
    }

    public ServiceTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(ServiceTransaction transaction) {
        this.transaction = transaction;
    }

    public boolean hasTransaction() {
        return this.transaction != null;
    }

    String tID() {
        if (this.tID == null) {
            String p = this.transaction.getIdentifier().getUri().getPath();
            this.tID = p.substring(p.lastIndexOf("/"));
        }
        return this.tID;
    }

    public BaseClient getClient() {
        return this.client;
    }

    public void setClient(BaseClient client) {
        this.client = client;
    }
}

