/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.installer;

import java.io.IOException;
import java.util.Map;
import org.oa4mp.installer.AbstractInstaller;

public class OA4MPServerInstaller
extends AbstractInstaller {
    protected static final String HOST_FLAG = "-host";
    protected static final String PORT_FLAG = "-port";
    public static String NO_PORT = "-1";
    String host = "localhost";
    int port = 8443;

    protected Map<String, String> setupTemplates() throws IOException {
        super.setupTemplates();
        if (!(this.getArgMap().isInstall() || this.getArgMap().isUpgrade() || this.getArgMap().isRemove())) {
            return this.getTemplates();
        }
        Object h = this.getHost();
        if (this.hasPort()) {
            h = (String)h + ":" + this.getPort();
        }
        this.getTemplates().put("${OA4MP_HOST}", h);
        return this.getTemplates();
    }

    public String getStoreTileDirectory() {
        return "/tiles/";
    }

    protected void setupArgMap(String[] args) {
        super.setupArgMap(args);
        block8: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "-host": {
                    this.getArgMap().put((Object)HOST_FLAG, (Object)arg);
                    continue block8;
                }
                case "-port": {
                    this.getArgMap().put((Object)PORT_FLAG, (Object)arg);
                }
            }
        }
    }

    protected String getHost() {
        if (this.getArgMap().containsKey((Object)HOST_FLAG)) {
            return (String)this.getArgMap().get((Object)HOST_FLAG);
        }
        return this.host;
    }

    protected boolean hasPort() {
        if (!this.getArgMap().containsKey((Object)PORT_FLAG)) {
            return true;
        }
        return !this.getArgMap().get((Object)PORT_FLAG).equals(NO_PORT);
    }

    protected int getPort() {
        if (this.getArgMap().containsKey((Object)PORT_FLAG)) {
            return Integer.parseInt((String)this.getArgMap().get((Object)PORT_FLAG));
        }
        return this.port;
    }

    protected void printMoreArgHelp() throws IOException {
        super.printMoreArgHelp();
        this.say("-host = the host for the service. Default is localhost");
        this.say("-port = the port for the service. Default is " + this.port + ". If you set it to -1, no port is used.");
    }

    protected void printMoreExamplesHelp() throws IOException {
        super.printMoreExamplesHelp();
        this.say("Example of doing an install");
        this.say("java -jar installer.jar install -dir $OA4MP_HOME -host issuer.bgsu.edu-port -1");
        this.say("The host for all of the OA4MP endpoints is set to issuer.bgsu.edu");
        this.say("Compare with");
        this.say("java -jar installer.jar install -dir $OA4MP_HOME -host issuer.bgsu.edu");
        this.say("The host for all of the OA4MP endpoints is set to issuer.bgsu.edu:" + this.port + "  since that is the default port for SSL.");
        this.say("\n\nExample of doing an upgrade");
        this.say("java -jar installer.jar  upgrade -dir $OA4MP_HOME");
        this.say("This upgrades all components, but does not touch any .xml (config) files or scripts.");
        this.say("Note that update is a synonym");
        this.say("\n\nExample of preparing an extension file for preprocessing. ");
        this.say("This is used if you want to apply scripts to the server right after boot, for instance.");
        this.say("Your file should use the template of ${OA4MP_HOME} every place it needs to refer to the");
        this.say("(new) installation. So the example might be a QDL ini file that needs the path to the current");
        this.say("server configuration to do some setup before starting the server:");
        this.say("[cfg]");
        this.say("file := '${OA4MP_HOME}etc/cfg.xml';");
        this.say("name := 'default';");
    }

    public static void main(String[] args) {
        try {
            OA4MPServerInstaller OA4MPServerInstaller2 = new OA4MPServerInstaller();
            boolean doProcessing = OA4MPServerInstaller2.init(args);
            if (OA4MPServerInstaller2.getArgMap().isShowHelp()) {
                OA4MPServerInstaller2.showHelp();
                return;
            }
            if (doProcessing) {
                OA4MPServerInstaller2.process();
                if (OA4MPServerInstaller2.getArgMap().isInstall()) {
                    OA4MPServerInstaller2.say(OA4MPServerInstaller2.getMessage("/oa4mp/success.txt"));
                }
            }
            OA4MPServerInstaller2.shutdown();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected String getDerbySetupScriptPath() {
        return (String)this.getTemplates().get("${OA4MP_HOME}") + "etc/oa4mp-derby.sql";
    }
}

