package org.oa4mp.server.loader.oauth2.storage.vi;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredSQLStore;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;

import javax.inject.Provider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

/**
 * <p>Created by Jeff Gaynor<br>
 * on 2/19/21 at  4:48 PM
 */
public class SQLVIStore<V extends VirtualIssuer> extends MonitoredSQLStore<V> implements VIStore<V> {
    public SQLVIStore(ConnectionPool connectionPool, Table table, Provider<V> identifiableProvider, MapConverter<V> converter) {
        super(connectionPool, table, identifiableProvider, converter);
    }

    @Override
    public V findByPath(String component) {
        String pathQuery = "select * from " + getTable().getFQTablename()
                + " where "
                + ((VISerializationKeys) getMapConverter().getKeys()).discoveryPath()
                + " = ?";
        ConnectionRecord cr = getConnection();
        Connection c = cr.connection;

        V vo = null;
        try {
            PreparedStatement stmt = c.prepareStatement(pathQuery);
            stmt.setString(1, component);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            // Now we have to pull in all the values.
            if (!rs.next()) {
                rs.close();
                stmt.close();
                releaseConnection(cr);
                return null;   // returning a null fulfills contract for this being a map.
            }

            ColumnMap map = rsToMap(rs);
            rs.close();
            stmt.close();
            vo = create();
            populate(map, vo);
            releaseConnection(cr);
        } catch (SQLException e) {
            destroyConnection(cr);
            throw new GeneralException("Error getting virtual issuer with path component \"" + component + "\"", e);
        }
        return vo;
    }

    @Override
    public void save(V value) {
        value.setLastModifiedTS(new Date());
        super.save(value);
    }

    @Override
    public void update(V value) {
        value.setLastModifiedTS(new Date());
        super.update(value);
    }

    @Override
    public String getCreationTSField() {
        return ((VISerializationKeys)getMapConverter().getKeys()).creationTS();
    }
}

