/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.UsernameTransformer;
import edu.uiuc.ncsa.security.util.json.JSONEntry;
import edu.uiuc.ncsa.security.util.json.JSONStore;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.mail.MailUtilProvider;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Provider;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.delegation.server.issuers.AGIssuer;
import org.oa4mp.delegation.server.issuers.ATIssuer;
import org.oa4mp.delegation.server.issuers.PAIssuer;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.ServiceEnvironmentImpl;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientStore;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.api.storage.servlet.AuthorizationServletConfig;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.cm.CMConfigs;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.servlet.DIServiceConfig;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628ServletConfig;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VIStore;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;
import org.oa4mp.server.loader.qdl.scripting.OA2QDLEnvironment;

public class OA2SE
extends ServiceEnvironmentImpl {
    boolean cleanupFailOnErrors;
    boolean monitorEnabled;
    long monitorInterval = -1L;
    Collection<LocalTime> monitorAlarms = null;
    boolean cleanupLockingEnabled = false;
    Collection<LocalTime> cleanupAlarms;
    MetaDebugUtil debugger;
    boolean demoModeEnabled = false;
    String notifyACEventEmailAddresses = null;
    long cleanupInterval = -1L;
    RFC8628ServletConfig rfc8628ServletConfig;
    boolean printTSInDebug = true;
    boolean safeGC = true;
    boolean qdlStrictACLs = false;
    long maxATLifetime = -1L;
    long maxRTLifetime = -1L;
    VIStore VIStore;
    TXStore txStore;
    OA2QDLEnvironment qdlEnvironment;
    CMConfigs cmConfigs = null;
    protected Provider<JSONStore> jsonStoreProvider;
    JSONStore<? extends JSONEntry> jsonStore;
    boolean ccfEnabled = true;
    boolean rfc8693Enabled = false;
    boolean rfc8628Enabled = false;
    protected Provider<AdminClientStore> acs;
    AdminClientStore adminClientStore = null;
    boolean utilServletEnabled = true;
    String issuer;
    protected JSONWebKeys jsonWebKeys;
    long maxIdTokenLifetime = 0L;
    long idTokenLifetime = 0L;
    long maxClientRefreshTokenLifetime = 0L;
    boolean twoFactorSupportEnabled = false;
    boolean refreshTokenEnabled = false;
    int clientSecretLength = 64;
    protected ClaimSource claimSource;
    Collection<String> scopes;
    LDAPConfiguration ldapConfiguration2;
    boolean oidcEnabled = true;
    long accessTokenLifetime = OA2ConfigurationLoader.ACCESS_TOKEN_LIFETIME_DEFAULT;
    long refreshTokenLifetime = OA2ConfigurationLoader.REFRESH_TOKEN_LIFETIME_DEFAULT;
    long maxAuthorizationGrantLifetime;
    long authorizationGrantLifetime = OA2ConfigurationLoader.AUTHORIZATION_GRANT_LIFETIME_DEFAULT;
    boolean rfc7636Required = false;
    long rtGracePeriod = -1L;
    boolean useProxyForCerts = false;
    protected List<Store> storeList = null;
    boolean allowPromptNone = false;
    DIServiceConfig DIServiceConfig = null;

    public OA2SE(MyLoggingFacade logger, Provider<TransactionStore> tsp, Provider<TXStore> txStoreProvider, Provider<VIStore> voStoreProvider, Provider<ClientStore> csp, int maxAllowedNewClientRequests, long agLifetime, long maxAGLifetime, long idTokenLifetime, long maxIDTokenLifetime, long maxATLifetime, long atLifetime, long rtLifetime, long maxRTLifetime, Provider<ClientApprovalStore> casp, MailUtilProvider mup, ServiceEnvironmentImpl.MessagesProvider messagesProvider, Provider<AGIssuer> agip, Provider<ATIssuer> atip, Provider<PAIssuer> paip, Provider<TokenForge> tfp, HashMap<String, String> constants, AuthorizationServletConfig ac, UsernameTransformer usernameTransformer, boolean isPingable, Provider<PermissionsStore> psp, Provider<AdminClientStore> acs, int clientSecretLength, Collection<String> scopes, ClaimSource claimSource, LDAPConfiguration ldapConfiguration2, boolean isRefreshTokenEnabled, boolean twoFactorSupportEnabled, long maxClientRefreshTokenLifetime, JSONWebKeys jsonWebKeys, String issuer, boolean utilServletEnabled, boolean oidcEnabled, CMConfigs cmConfigs, OA2QDLEnvironment qdlEnvironment, boolean rfc8693Enabled, boolean qdlStrictACLs, boolean safeGC, boolean cleanupLockingEnabled, boolean cleanupFailOnErrors, RFC8628ServletConfig rfc8628ServletConfig, boolean rfc8628Enabled, boolean printTSInDebug, long cleanupInterval, Collection<LocalTime> cleanupAlarms, String notifyACEventEmailAddresses, boolean rfc7636Required, boolean demoModeEnabled, long rtGracePeriod, boolean isMonitorEnabled, long monitorInterval, Collection<LocalTime> monitorAlarms, boolean clientCredentialFlowEnabled, MetaDebugUtil debugger, boolean allowPromptNone, DIServiceConfig DIServiceConfig2) {
        super(logger, tsp, csp, maxAllowedNewClientRequests, casp, mup, messagesProvider, agip, atip, paip, tfp, constants, ac, usernameTransformer, isPingable, psp);
        this.ccfEnabled = clientCredentialFlowEnabled;
        if (0L < agLifetime) {
            this.authorizationGrantLifetime = agLifetime;
        }
        if (0L < atLifetime) {
            this.accessTokenLifetime = atLifetime;
        }
        this.maxAuthorizationGrantLifetime = maxAGLifetime;
        if (clientSecretLength < 0) {
            throw new MyConfigurationException("The client secret length (=" + clientSecretLength + ") is invalid. It must be a positive integer.");
        }
        this.allowPromptNone = allowPromptNone;
        this.clientSecretLength = clientSecretLength;
        this.scopes = scopes;
        this.claimSource = claimSource;
        OA2Scopes.ScopeUtil.setScopes(scopes);
        this.refreshTokenEnabled = isRefreshTokenEnabled;
        if (this.refreshTokenEnabled) {
            logger.info("Refresh token support enabled");
        } else {
            logger.info("No refresh token support.");
        }
        this.ldapConfiguration2 = ldapConfiguration2;
        this.twoFactorSupportEnabled = twoFactorSupportEnabled;
        this.maxClientRefreshTokenLifetime = maxClientRefreshTokenLifetime;
        this.jsonWebKeys = jsonWebKeys;
        this.issuer = issuer;
        if (claimSource instanceof BasicClaimsSourceImpl) {
            ((BasicClaimsSourceImpl)claimSource).setOa2SE(this);
        }
        this.acs = acs;
        this.utilServletEnabled = utilServletEnabled;
        this.oidcEnabled = oidcEnabled;
        this.cmConfigs = cmConfigs;
        this.qdlEnvironment = qdlEnvironment;
        this.rfc8693Enabled = rfc8693Enabled;
        this.txStore = (TXStore)txStoreProvider.get();
        this.VIStore = (VIStore)voStoreProvider.get();
        this.maxIdTokenLifetime = maxIDTokenLifetime;
        this.idTokenLifetime = idTokenLifetime;
        this.maxATLifetime = maxATLifetime;
        this.maxRTLifetime = maxRTLifetime;
        this.qdlStrictACLs = qdlStrictACLs;
        this.safeGC = safeGC;
        this.cleanupLockingEnabled = cleanupLockingEnabled;
        this.rfc8628Enabled = rfc8628Enabled;
        this.printTSInDebug = printTSInDebug;
        this.rfc8628ServletConfig = rfc8628ServletConfig;
        this.cleanupInterval = cleanupInterval;
        this.notifyACEventEmailAddresses = notifyACEventEmailAddresses;
        this.rfc7636Required = rfc7636Required;
        this.demoModeEnabled = demoModeEnabled;
        this.debugger = debugger;
        this.cleanupAlarms = cleanupAlarms;
        this.rtGracePeriod = rtGracePeriod;
        this.monitorInterval = monitorInterval;
        this.monitorAlarms = monitorAlarms;
        this.monitorEnabled = isMonitorEnabled;
        this.cleanupFailOnErrors = cleanupFailOnErrors;
        this.DIServiceConfig = DIServiceConfig2;
    }

    public boolean isCleanupFailOnErrors() {
        return this.cleanupFailOnErrors;
    }

    public boolean isMonitorEnabled() {
        return this.monitorEnabled;
    }

    public void setMonitorEnabled(boolean monitorEnabled) {
        this.monitorEnabled = monitorEnabled;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(long monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public Collection<LocalTime> getMonitorAlarms() {
        return this.monitorAlarms;
    }

    public void setMonitorAlarms(Collection<LocalTime> monitorAlarms) {
        this.monitorAlarms = monitorAlarms;
    }

    public boolean isCleanupLockingEnabled() {
        return this.cleanupLockingEnabled;
    }

    public void setCleanupLockingEnabled(boolean cleanupLockingEnabled) {
        this.cleanupLockingEnabled = cleanupLockingEnabled;
    }

    public Collection<LocalTime> getCleanupAlarms() {
        return this.cleanupAlarms;
    }

    public boolean hasCleanupAlarms() {
        return this.cleanupAlarms != null && !this.cleanupAlarms.isEmpty();
    }

    public MetaDebugUtil getDebugger() {
        return this.debugger;
    }

    public void setDebugger(MetaDebugUtil debugger) {
        this.debugger = debugger;
    }

    public boolean isDemoModeEnabled() {
        return this.demoModeEnabled;
    }

    public void setDemoModeEnabled(boolean demoModeEnabled) {
        this.demoModeEnabled = demoModeEnabled;
    }

    public String getNotifyACEventEmailAddresses() {
        return this.notifyACEventEmailAddresses;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public boolean hasMonitorAlarams() {
        return this.monitorAlarms != null && !this.monitorAlarms.isEmpty();
    }

    public boolean hasMonitorInterval() {
        return 0L < this.monitorInterval;
    }

    public RFC8628ServletConfig getRfc8628ServletConfig() {
        return this.rfc8628ServletConfig;
    }

    public boolean isPrintTSInDebug() {
        return this.printTSInDebug;
    }

    public boolean isSafeGC() {
        return this.safeGC;
    }

    public void setSafeGC(boolean safeGC) {
        this.safeGC = safeGC;
    }

    public boolean isQdlStrictACLs() {
        return this.qdlStrictACLs;
    }

    public long getMaxATLifetime() {
        return this.maxATLifetime;
    }

    public long getMaxRTLifetime() {
        return this.maxRTLifetime;
    }

    public VIStore getVIStore() {
        return this.VIStore;
    }

    public TXStore getTxStore() {
        return this.txStore;
    }

    public void setTxStore(TXStore txStore) {
        this.txStore = txStore;
    }

    public OA2QDLEnvironment getQDLEnvironment() {
        return this.qdlEnvironment;
    }

    public void setQDLEnvironment(OA2QDLEnvironment qdlEnvironment) {
        this.qdlEnvironment = qdlEnvironment;
    }

    public CMConfigs getCmConfigs() {
        return this.cmConfigs;
    }

    public JSONStore<? extends JSONEntry> getJSONStore() {
        if (this.jsonStore == null) {
            this.jsonStore = (JSONStore)this.jsonStoreProvider.get();
        }
        return this.jsonStore;
    }

    public boolean isRfc8693Enabled() {
        return this.rfc8693Enabled;
    }

    public void setRfc8693Enabled(boolean rfc8693Enabled) {
        this.rfc8693Enabled = rfc8693Enabled;
    }

    public boolean isCCFEnabled() {
        return this.ccfEnabled;
    }

    public void setCCFEnabled(boolean ccfEnabled) {
        this.ccfEnabled = ccfEnabled;
    }

    public boolean isRfc8628Enabled() {
        return this.rfc8628Enabled;
    }

    public void setRfc8628Enabled(boolean rfc8628Enabled) {
        this.rfc8628Enabled = rfc8628Enabled;
    }

    public AdminClientStore<AdminClient> getAdminClientStore() {
        if (this.adminClientStore == null) {
            this.adminClientStore = (AdminClientStore)this.acs.get();
        }
        return this.adminClientStore;
    }

    public boolean isUtilServletEnabled() {
        return this.utilServletEnabled;
    }

    public void setUtilServletEnabled(boolean utilServletEnabled) {
        this.utilServletEnabled = utilServletEnabled;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JSONWebKeys getJsonWebKeys() {
        return this.jsonWebKeys;
    }

    public void setJsonWebKeys(JSONWebKeys jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    public boolean isTwoFactorSupportEnabled() {
        return this.twoFactorSupportEnabled;
    }

    public long getMaxClientRefreshTokenLifetime() {
        return this.maxClientRefreshTokenLifetime;
    }

    public long getMaxIdTokenLifetime() {
        return this.maxIdTokenLifetime;
    }

    public long getIdTokenLifetime() {
        return this.idTokenLifetime;
    }

    public boolean isRefreshTokenEnabled() {
        return this.refreshTokenEnabled;
    }

    public void setRefreshTokenEnabled(boolean refreshTokenEnabled) {
        this.refreshTokenEnabled = refreshTokenEnabled;
    }

    public int getClientSecretLength() {
        return this.clientSecretLength;
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Collection<String> scopes) {
        this.scopes = scopes;
    }

    public ClaimSource getClaimSource() {
        return this.claimSource;
    }

    public void setClaimSource(ClaimSource claimSource) {
        this.claimSource = claimSource;
    }

    public boolean hasScopeHandler() {
        return this.claimSource != null;
    }

    public LDAPConfiguration getLdapConfiguration() {
        return this.ldapConfiguration2;
    }

    public void setLdapConfiguration(LDAPConfiguration ldapConfiguration2) {
        this.ldapConfiguration2 = ldapConfiguration2;
    }

    public boolean isOIDCEnabled() {
        return this.oidcEnabled;
    }

    public long getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(long accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public void setRefreshTokenLifetime(long refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public long getRefreshTokenLifetime() {
        return this.refreshTokenLifetime;
    }

    public long getMaxAuthorizationGrantLifetime() {
        return this.maxAuthorizationGrantLifetime;
    }

    public long getAuthorizationGrantLifetime() {
        return this.authorizationGrantLifetime;
    }

    public void setAuthorizationGrantLifetime(long authorizationGrantLifetime) {
        this.authorizationGrantLifetime = authorizationGrantLifetime;
    }

    public VirtualIssuer getVI(Identifier clientID) {
        if (clientID == null) {
            return null;
        }
        List adminIDs = this.getPermissionStore().getAdmins(clientID);
        if (adminIDs == null || adminIDs.isEmpty()) {
            return null;
        }
        switch (adminIDs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                AdminClient ac = (AdminClient)this.getAdminClientStore().get(adminIDs.get(0));
                if (ac == null || ac.getVirtualIssuer() == null) {
                    return null;
                }
                DebugUtil.trace((Object)((Object)this), (String)("got admin client " + ac.getIdentifierString()));
                VirtualIssuer vi = (VirtualIssuer)((Object)this.getVIStore().get(ac.getVirtualIssuer()));
                DebugUtil.trace((Object)((Object)this), (String)("got vi  " + (vi == null ? "(none)" : vi.getIdentifierString())));
                if (vi == null) {
                    return null;
                }
                if (!vi.isValid()) {
                    throw new GeneralException("invalid virtual issuer \"" + vi.getIdentifierString() + "\"");
                }
                return vi;
            }
            case 2: {
                throw new NFWException("too many admins for this client.");
            }
        }
        return null;
    }

    public List<Store> listStores() {
        List stores = super.listStores();
        stores.add(this.getTxStore());
        stores.add(this.getVIStore());
        return stores;
    }

    public boolean isRfc7636Required() {
        return this.rfc7636Required;
    }

    public void setRfc7636Required(boolean rfc7636Required) {
        this.rfc7636Required = rfc7636Required;
    }

    public long getRtGracePeriod() {
        return this.rtGracePeriod;
    }

    public void setRtGracePeriod(long rtGracePeriod) {
        this.rtGracePeriod = rtGracePeriod;
    }

    public boolean isRTGracePeriodEnabled() {
        return this.rtGracePeriod != OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_DISABLED;
    }

    public boolean isUseProxyForCerts() {
        return this.useProxyForCerts;
    }

    public void setUseProxyForCerts(boolean useProxyForCerts) {
        this.useProxyForCerts = useProxyForCerts;
    }

    public List<Store> getAllStores() {
        if (this.storeList == null) {
            this.storeList = new ArrayList<Store>();
            this.storeList.add((Store)this.getAdminClientStore());
            this.storeList.add((Store)this.getClientStore());
            this.storeList.add((Store)this.getClientApprovalStore());
            this.storeList.add((Store)this.getPermissionStore());
            this.storeList.add(this.getVIStore());
            this.storeList.add((Store)this.getTransactionStore());
            this.storeList.add(this.getTxStore());
        }
        return this.storeList;
    }

    public boolean isAllowPromptNone() {
        return this.allowPromptNone;
    }

    public void setAllowPromptNone(boolean allowPromptNone) {
        this.allowPromptNone = allowPromptNone;
    }

    public DIServiceConfig getDIServiceConfig() {
        return this.DIServiceConfig;
    }
}

