/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.configuration.TemplateUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.delegation.server.jwt.AccessTokenHandlerInterface;
import org.oa4mp.delegation.server.jwt.IDTokenHandlerInterface;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadHandler;
import org.oa4mp.server.loader.oauth2.claims.Groups;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;
import org.oa4mp.server.loader.oauth2.claims.ScopeTemplateUtil;
import org.oa4mp.server.loader.oauth2.servlet.ClientUtils;
import org.oa4mp.server.loader.oauth2.servlet.OA2DiscoveryServlet;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;
import org.oa4mp.server.loader.oauth2.tokens.AccessTokenConfig;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationPath;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationTemplate;
import org.oa4mp.server.loader.oauth2.tokens.AuthorizationTemplates;

public class AbstractAccessTokenHandler
extends AbstractPayloadHandler
implements AccessTokenHandlerInterface,
IDTokenHandlerInterface {
    public static final String AT_DEFAULT_HANDLER_TYPE = "default";
    public static final String AT_BASIC_HANDLER_TYPE = "access";
    JSONObject userMetaData;

    public AbstractAccessTokenHandler(PayloadHandlerConfigImpl payloadHandlerConfig) {
        super(payloadHandlerConfig);
    }

    public JSONObject getPayload() {
        if (this.payload == null) {
            this.payload = this.transaction.getATData();
            if (this.payload == null) {
                this.payload = new JSONObject();
            }
        }
        return this.payload;
    }

    public JSONObject getUserMetaData() {
        return this.userMetaData;
    }

    public void setUserMetaData(JSONObject userMetaData) {
        this.userMetaData = userMetaData;
    }

    public void init() throws Throwable {
        this.setAccountingInformation();
    }

    public void addRequestState(ScriptRunRequest req) throws Throwable {
        if (req.getArgs().containsKey("claims")) {
            this.getUserMetaData().putAll((Map)req.getArgs().get("claims"));
        }
        if (req.getArgs().containsKey("access_token")) {
            this.getPayload().putAll((Map)req.getArgs().get("access_token"));
        }
        req.getArgs().put("access_token", this.getPayload());
        req.getArgs().put("claims", this.getUserMetaData());
    }

    @Override
    public void handleResponse(ScriptRunResponse resp) throws Throwable {
        super.handleResponse(resp);
        switch (resp.getReturnCode()) {
            case 1: {
                this.setUserMetaData((JSONObject)resp.getReturnedValues().get("claims"));
                this.setExtendedAttributes((JSONObject)resp.getReturnedValues().get("eas"));
                this.setPayload((JSONObject)resp.getReturnedValues().get("access_token"));
                List sources = (List)resp.getReturnedValues().get("claim_sources");
                this.transaction.setClaimsSources(sources);
                return;
            }
            case 0: {
                return;
            }
        }
    }

    public void checkClaims() throws Throwable {
    }

    public String resolveTemplates(boolean isQuery) {
        if (!this.transaction.getFlowStates().at_do_templates) {
            return null;
        }
        AuthorizationTemplates templates = this.getATConfig().getTemplates();
        if (templates.size() == 0) {
            return null;
        }
        List<String> requestedAudience = null;
        if (this.transaction.hasUseTemplates()) {
            requestedAudience = this.transaction.getUseTemplates();
        } else if (this.transaction.hasAudience()) {
            requestedAudience = this.transaction.getAudience();
        }
        if (requestedAudience == null || requestedAudience.isEmpty()) {
            switch (this.getATConfig().getAudience().size()) {
                case 0: {
                    throw new IllegalStateException(" The client has no configured audiences and none were requested. Cannot resolve scopes.");
                }
                case 1: {
                    if (requestedAudience == null) {
                        requestedAudience = new ArrayList<String>();
                    }
                    requestedAudience.add(this.getATConfig().getAudience().get(0));
                    break;
                }
                default: {
                    throw new IllegalStateException(" The client is configured with multiple audiences, but none were requested. Cannot resolve scopes.");
                }
            }
        }
        HashMap<String, List<String>> groupMap = new HashMap<String, List<String>>();
        HashMap<Object, Object> claimsNoGroups = new HashMap<Object, Object>();
        for (Object claimKey : this.getUserMetaData().keySet()) {
            Object claim = this.getUserMetaData().get(claimKey);
            if (claim instanceof JSONArray) {
                ArrayList<String> groupKeys = new ArrayList<String>();
                JSONArray array = (JSONArray)claim;
                for (int i = 0; i < array.size(); ++i) {
                    Object jo;
                    Object unknownThingie = array.get(i);
                    if (!(unknownThingie instanceof JSONObject) || !(jo = (JSONObject)unknownThingie).containsKey((Object)Groups.GROUP_ENTRY_NAME)) continue;
                    groupKeys.add(jo.getString(Groups.GROUP_ENTRY_NAME));
                }
                if (groupKeys.isEmpty()) continue;
                groupMap.put(claimKey.toString(), groupKeys);
                continue;
            }
            claimsNoGroups.put(claimKey, claim);
        }
        HashSet<String> computedScopes = new HashSet<String>();
        for (String aud : requestedAudience) {
            if (!templates.containsKey(aud)) {
                throw new IllegalStateException(" The requested audience \"" + aud + "\" is not valid for this client. Cannot resolve scopes.");
            }
            AuthorizationTemplate template = (AuthorizationTemplate)templates.get(aud);
            for (AuthorizationPath authorizationPath : template.getPaths()) {
                List<String> z = ScopeTemplateUtil.replaceTemplate(authorizationPath.toPath(), groupMap, claimsNoGroups);
                computedScopes.addAll(z);
            }
        }
        TXRecord txRecord = this.getPhCfg().getTxRecord();
        ArrayList<String> requestedCapabilities = new ArrayList<String>();
        Collection<String> requestedScopes = null;
        requestedScopes = isQuery ? (txRecord != null && txRecord.hasScopes() ? txRecord.getScopes() : this.transaction.getScopes()) : (txRecord != null && txRecord.hasScopes() ? txRecord.getScopes() : this.transaction.getATReturnedOriginalScopes());
        ArrayList<String> badRequests = new ArrayList<String>();
        ArrayList<String> foundCapabilities = new ArrayList<String>();
        for (String x : computedScopes) {
            if (x.contains(":")) continue;
            if (requestedScopes.contains(x)) {
                foundCapabilities.add(x);
            } else {
                for (String bad : requestedScopes) {
                    if (!bad.startsWith(x + ":")) continue;
                    badRequests.add(bad);
                }
            }
            requestedCapabilities.add(x);
        }
        computedScopes.removeAll(requestedCapabilities);
        requestedScopes.remove(badRequests);
        Collection<String> actualScopes = ScopeTemplateUtil.doCompareTemplates(computedScopes, requestedScopes, isQuery);
        if (isQuery) {
            actualScopes.addAll(foundCapabilities);
        } else if (this.transaction.hasATReturnedOriginalScopes()) {
            for (String fc : foundCapabilities) {
                if (!this.transaction.getATReturnedOriginalScopes().contains(fc)) continue;
                actualScopes.addAll(foundCapabilities);
            }
        }
        String s = OA2Scopes.ScopeUtil.toString(actualScopes);
        return s;
    }

    protected AccessTokenConfig getATConfig() {
        return (AccessTokenConfig)this.getPhCfg().getClientConfig();
    }

    public List<ClaimSource> getSources() throws Throwable {
        return this.transaction.getClaimSources(this.oa2se);
    }

    public void finish(boolean doTemplates, boolean isQuery) throws Throwable {
        String scopes;
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)this.client);
        debugger.trace((Object)this, "starting AT handler finish with transaction =" + this.transaction.summary());
        JSONObject atData = this.getPayload();
        if (this.getPhCfg().hasTXRecord()) {
            TXRecord txRecord = this.getPhCfg().getTxRecord();
            if ("urn:ietf:params:oauth:token-type:access_token".equals(txRecord.getTokenType())) {
                atData.put((Object)"jti", (Object)txRecord.getIdentifierString());
            }
        } else {
            debugger.trace((Object)this, "update condition");
            if (this.transaction.getAccessToken() != null) {
                atData.put((Object)"jti", (Object)this.transaction.getAccessToken().getToken());
                debugger.trace((Object)this, "update condition: TRUE, at=" + String.valueOf(atData.get("jti")));
            }
        }
        if (doTemplates && (scopes = this.resolveTemplates(isQuery)) != null) {
            atData.put((Object)"scope", (Object)scopes);
        }
        if (!atData.containsKey((Object)"iss")) {
            atData.put((Object)"iss", (Object)this.transaction.getUserMetaData().getString("iss"));
        }
        if (!atData.containsKey((Object)"sub")) {
            if (this.getATConfig().hasSubject()) {
                String newSubject = TemplateUtil.replaceAll((String)this.getATConfig().getSubject(), (Map)atData);
                atData.put((Object)"sub", (Object)newSubject);
            } else {
                atData.put((Object)"sub", (Object)this.transaction.getUserMetaData().getString("sub"));
            }
        }
        this.refreshAccountingInformation();
        this.doServerVariables(atData, this.getUserMetaData());
        this.setPayload(atData);
        if (this.getPhCfg().hasTXRecord()) {
            this.getPhCfg().getTxRecord().setToken(this.getPayload());
        }
        debugger.trace((Object)this, "done  w/ AT handler finish with transaction =" + this.transaction.summary());
    }

    public void finish(String execPhase) throws Throwable {
        boolean isQuery = false;
        switch (execPhase) {
            case "pre_auth": 
            case "post_auth": 
            case "init": 
            case "pre_token": 
            case "post_token": {
                isQuery = true;
                break;
            }
            default: {
                isQuery = false;
            }
        }
        this.finish(true, isQuery);
    }

    public AccessTokenImpl getSignedPayload(JSONWebKey key) {
        return this.getSignedPayload(key, MyOtherJWTUtil2.DEFAULT_TYPE);
    }

    public AccessTokenImpl getSignedPayload(JSONWebKey key, String headerType) {
        if (key == null) {
            this.oa2se.warn(" Null or missing key for signing encountered processing client \"" + this.client.getIdentifierString() + "\"");
            throw new IllegalArgumentException(" Missing JSON web key. Cannot sign access token.");
        }
        if (this.getPayload().isEmpty()) {
            return null;
        }
        if (this.getPayload().size() == 1) {
            String k = String.valueOf(this.getPayload().keySet().iterator().next());
            String v = String.valueOf(this.getPayload().get(k));
            this.oa2se.info("Single value access token for client \"" + this.client.getIdentifierString() + "\" found. Setting token value to " + v);
            AccessTokenImpl accessToken = new AccessTokenImpl(URI.create(v));
            return accessToken;
        }
        if (!this.getPayload().containsKey((Object)"jti")) {
            throw new IllegalStateException(" no JTI. Cannot create access token");
        }
        try {
            String at = MyOtherJWTUtil2.createJWT((JSONObject)this.getPayload(), (JSONWebKey)key, (String)headerType);
            return TokenFactory.createAT((String)at);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            e.printStackTrace();
            throw new GeneralException("Could not create signed token for payload" + this.getPayload().toString(1), e);
        }
    }

    @Override
    public void saveState(String execPhase) throws Throwable {
        if (execPhase.equals("post_auth")) {
            this.transaction.setATData(this.getPayload());
            this.transaction.setAccessTokenLifetime(this.getPayload().getLong("exp") * 1000L);
        }
        super.saveState(execPhase);
    }

    public void setAccountingInformation() {
        VirtualIssuer vo;
        JSONObject atData = this.getPayload();
        String issuer = "";
        issuer = StringUtils.isTrivial((String)this.getATConfig().getIssuer()) ? ((vo = this.oa2se.getVI(this.client.getIdentifier())) == null ? OA2DiscoveryServlet.getIssuer(this.request) : (!StringUtils.isTrivial((String)vo.getAtIssuer()) ? vo.getAtIssuer() : (StringUtils.isTrivial((String)vo.getIssuer()) ? vo.getIssuer() : OA2DiscoveryServlet.getIssuer(this.request)))) : this.getATConfig().getIssuer();
        atData.put((Object)"iss", (Object)issuer);
        if (this.transaction.hasAudience()) {
            atData.put((Object)"aud", this.transaction.getAudience());
        } else if (this.getATConfig().getAudience() != null && !this.getATConfig().getAudience().isEmpty()) {
            atData.put((Object)"aud", this.getATConfig().getAudience());
        } else {
            VirtualIssuer vi = this.oa2se.getVI(this.client.getIdentifier());
            if (vi == null) {
                atData.put((Object)"aud", (Object)this.transaction.getClient().getIdentifierString());
            } else {
                atData.put((Object)"aud", (Object)vi.getAtIssuer());
            }
        }
        if (this.getATConfig().hasSubject()) {
            String newSubject = TemplateUtil.replaceAll((String)this.getATConfig().getSubject(), (Map)atData);
            atData.put((Object)"sub", (Object)newSubject);
        }
        this.refreshAccountingInformation();
    }

    public void refreshAccountingInformation() {
        JSONObject atData = this.getPayload();
        long lifetime = ClientUtils.computeATLifetime(this.transaction, this.client, this.oa2se);
        long issuedAt = System.currentTimeMillis();
        long expiresAt = issuedAt + lifetime;
        atData.put((Object)"exp", (Object)(expiresAt / 1000L));
        atData.put((Object)"nbf", (Object)((issuedAt - 5000L) / 1000L));
        atData.put((Object)"iat", (Object)(issuedAt / 1000L));
        if (this.hasTXRecord()) {
            this.getTXRecord().setLifetime(lifetime);
            this.getTXRecord().setExpiresAt(expiresAt);
            this.getTXRecord().setIssuedAt(issuedAt);
        }
    }

    public AccessToken getAccessToken() {
        return this.transaction.getAccessToken();
    }

    public void setAccessToken(AccessToken accessToken) {
        this.transaction.setAccessToken(accessToken);
    }
}

