/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import edu.uiuc.ncsa.security.util.scripting.ScriptSet;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.qdl.scripting.QDLRuntimeEngine;
import org.qdl_lang.scripting.AnaphorUtil;

public abstract class AbstractPayloadConfig
implements Serializable {
    public static String TYPE_KEY = "type";
    public static String ID_KEY = "id";
    public static String VERSIONS_KEY = "versions";
    public static String CREATE_TS_KEY = "creation_ts";
    public static String LIFETIME_KEY = "lifetime";
    public static String SUBJECT_KEY = "subject";
    protected String type = null;
    List<String> versions;
    String id;
    Date creationTS;
    JSON rawScripts = null;
    ScriptSet scriptSet;
    Long lifetime = -1L;
    String subject = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationTS() {
        if (this.creationTS == null) {
            this.creationTS = new Date();
        }
        return this.creationTS;
    }

    public void setCreationTS(Date creationTS) {
        this.creationTS = creationTS;
    }

    public void fromJSON(JSONObject jsonObject) {
        if (jsonObject.containsKey((Object)LIFETIME_KEY)) {
            Object rawLifetime = jsonObject.get(LIFETIME_KEY);
            this.lifetime = rawLifetime instanceof String ? XMLConfigUtil.getValueSecsOrMillis((String)((String)rawLifetime), (boolean)false) : Long.valueOf(jsonObject.getLong(LIFETIME_KEY));
        }
        if (jsonObject.containsKey((Object)SUBJECT_KEY)) {
            this.setSubject(jsonObject.getString(SUBJECT_KEY));
        }
        if (jsonObject.containsKey((Object)QDLRuntimeEngine.CONFIG_TAG)) {
            try {
                this.rawScripts = jsonObject.getJSONObject(QDLRuntimeEngine.CONFIG_TAG);
            }
            catch (JSONException jsonException) {
                this.rawScripts = jsonObject.getJSONArray(QDLRuntimeEngine.CONFIG_TAG);
            }
            if (this.rawScripts == null) {
                throw new IllegalArgumentException("error: no recognizable scripts found for \"" + jsonObject.getString(QDLRuntimeEngine.CONFIG_TAG) + "\"");
            }
            this.setScriptSet(AnaphorUtil.createScripts((JSON)this.rawScripts));
        }
        if (!jsonObject.containsKey((Object)TYPE_KEY)) {
            throw new IllegalStateException("Error: Missing type for access token handler configuration");
        }
        this.type = jsonObject.getString(TYPE_KEY);
        if (jsonObject.containsKey((Object)VERSIONS_KEY)) {
            this.versions = jsonObject.getJSONArray(VERSIONS_KEY);
        }
        if (jsonObject.containsKey((Object)ID_KEY)) {
            this.id = jsonObject.getString(ID_KEY);
        }
        if (jsonObject.containsKey((Object)CREATE_TS_KEY)) {
            try {
                Calendar calendar = Iso8601.string2Date((String)jsonObject.getString(CREATE_TS_KEY));
                this.creationTS = calendar.getTime();
            }
            catch (ParseException pe) {
                this.creationTS = new Date();
            }
        }
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        if (this.type != null) {
            json.put((Object)TYPE_KEY, (Object)this.type);
        }
        if (this.lifetime != null) {
            json.put((Object)LIFETIME_KEY, (Object)this.lifetime);
        }
        if (this.versions != null) {
            json.put((Object)VERSIONS_KEY, this.versions);
        }
        if (this.hasSubject()) {
            json.put((Object)SUBJECT_KEY, (Object)this.getSubject());
        }
        if (!StringUtils.isTrivial((String)this.id)) {
            json.put((Object)ID_KEY, (Object)this.id);
        }
        json.put((Object)CREATE_TS_KEY, (Object)Iso8601.date2String((Date)this.getCreationTS()));
        json.put((Object)QDLRuntimeEngine.CONFIG_TAG, (Object)this.rawScripts);
        return json;
    }

    public ScriptSet getScriptSet() {
        if (this.scriptSet == null) {
            this.scriptSet = new ScriptSet();
        }
        return this.scriptSet;
    }

    public void setScriptSet(ScriptSet scriptSet) {
        this.scriptSet = scriptSet;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public Long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(Long lifetime) {
        this.lifetime = lifetime;
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }
}

