/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.configuration.TemplateUtil;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.jwt.PayloadHandler;
import org.oa4mp.delegation.server.jwt.PayloadHandlerConfig;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;

public abstract class AbstractPayloadHandler
implements PayloadHandler,
OA2Scopes {
    protected OA2ServiceTransaction transaction;
    protected OA2SE oa2se;
    protected HttpServletRequest request;
    protected OA2Client client;
    PayloadHandlerConfigImpl phCfg;
    JSONObject extendedAttributes = null;
    int responseCode = 0;
    protected JSONObject payload;

    public PayloadHandlerConfigImpl getPhCfg() {
        return this.phCfg;
    }

    public boolean hasTXRecord() {
        return this.getPhCfg().hasTXRecord();
    }

    public TXRecord getTXRecord() {
        return this.getPhCfg().getTxRecord();
    }

    public AbstractPayloadHandler(PayloadHandlerConfigImpl payloadHandlerConfig) {
        this.phCfg = payloadHandlerConfig;
        this.oa2se = this.phCfg.getOa2se();
        this.client = this.phCfg.getClient();
        this.transaction = this.phCfg.getTransaction();
        this.request = this.phCfg.getRequest();
        ServletDebugUtil.trace((Object)this, (String)("payload handler cfg=" + String.valueOf(this.phCfg)));
        ServletDebugUtil.trace((Object)this, (String)("transaction =" + this.transaction.summary()));
        ServletDebugUtil.trace((Object)this, (String)("has OA2SE? " + (this.oa2se != null)));
    }

    public void setExtendedAttributes(JSONObject extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    public JSONObject getExtendedAttributes() {
        return this.transaction.getExtendedAttributes();
    }

    protected boolean isEmpty(String x) {
        return x == null || 0 == x.length();
    }

    public JSONObject execute(ClaimSource source, JSONObject claims) throws Throwable {
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)this.transaction.getClient());
        if (!source.isEnabled()) {
            debugger.trace((Object)this, "source disabled");
            return claims;
        }
        if (source instanceof BasicClaimsSourceImpl) {
            ((BasicClaimsSourceImpl)source).setOa2SE(this.oa2se);
        }
        if (this.request == null) {
            return source.process(claims, (ServiceTransaction)this.transaction);
        }
        return source.process(claims, this.request, (ServiceTransaction)this.transaction);
    }

    public void refresh() throws Throwable {
    }

    public void setPhCfg(PayloadHandlerConfig phCfg) {
        this.phCfg = (PayloadHandlerConfigImpl)phCfg;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void handleResponse(ScriptRunResponse resp) throws Throwable {
        this.responseCode = resp.getReturnCode();
    }

    protected String listToString(List list) {
        Object requestedScopes = "";
        if (list == null | list.isEmpty()) {
            return requestedScopes;
        }
        boolean firstPass = true;
        for (Object x : list) {
            if (x == null) continue;
            if (firstPass) {
                firstPass = false;
                requestedScopes = x.toString();
                continue;
            }
            requestedScopes = (String)requestedScopes + " " + x.toString();
        }
        return requestedScopes;
    }

    public boolean hasScript() {
        if (this.getPhCfg() == null) {
            return false;
        }
        return this.getPhCfg().getScriptSet() != null && !this.getPhCfg().getScriptSet().isEmpty();
    }

    protected void doServerVariables(JSONObject targetClaims, JSONObject userMetaData) {
        JSONObject serverVariableTemplates = new JSONObject();
        if (userMetaData != null) {
            serverVariableTemplates.putAll((Map)userMetaData);
        }
        long now = System.currentTimeMillis();
        serverVariableTemplates.put((Object)"client_id", (Object)this.getPhCfg().getTransaction().getClient().getIdentifierString());
        serverVariableTemplates.put((Object)"host", (Object)this.getPhCfg().getOa2se().getServiceAddress().toString());
        serverVariableTemplates.put((Object)"now", (Object)now);
        serverVariableTemplates.put((Object)"now_iso", (Object)Iso8601.date2String((long)now));
        serverVariableTemplates.put((Object)"now_sec", (Object)Iso8601.date2String((long)(now / 1000L)));
        if (serverVariableTemplates.containsKey((Object)"eppn")) {
            serverVariableTemplates.put((Object)"eppn_2", (Object)serverVariableTemplates.getString("eppn").substring(0, serverVariableTemplates.getString("eppn").indexOf("@")));
        }
        this.doSubstitution("sub", targetClaims, serverVariableTemplates);
        this.doSubstitution("resource", targetClaims, serverVariableTemplates);
        this.doSubstitution("iss", targetClaims, serverVariableTemplates);
        this.doSubstitution("aud", targetClaims, serverVariableTemplates);
    }

    protected void doSubstitution(String key, JSONObject targetClaims, JSONObject x) {
        if (!targetClaims.containsKey((Object)key)) {
            return;
        }
        String obj = targetClaims.getString(key);
        if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object y = jsonArray.get(i);
                if (!(y instanceof String)) continue;
                String s = obj;
                String newSubject = TemplateUtil.replaceAll((String)s, (Map)x);
                jsonArray.set(i, (Object)newSubject);
            }
            targetClaims.put((Object)key, (Object)jsonArray);
        } else if (obj instanceof String) {
            String s = obj;
            String newSubject = TemplateUtil.replaceAll((String)s, (Map)x);
            targetClaims.put((Object)key, (Object)newSubject);
        }
    }

    public void saveState(String execPhase) throws Throwable {
        if (this.hasTXRecord()) {
            this.getTXRecord().setToken(this.getPayload());
        }
    }

    public void setPayload(JSONObject payload) {
        this.payload = payload;
    }
}

