/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.server.UnsupportedScopeException;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.GroupHandler;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class BasicClaimsSourceImpl
implements ClaimSource {
    private static final long serialVersionUID = -6997152589138221711L;
    ClaimSourceConfiguration configuration = null;
    transient OA2SE oa2SE;
    Collection<String> scopes;
    protected GroupHandler groupHandler = null;

    public List<String> getOmitList() {
        if (this.hasConfiguration()) {
            return this.getConfiguration().getOmitList();
        }
        return new LinkedList<String>();
    }

    public void setOmitList(List<String> omitList) {
        this.getConfiguration().setOmitList(omitList);
    }

    public void setConfiguration(ClaimSourceConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClaimSourceConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ClaimSourceConfiguration();
        }
        return this.configuration;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public BasicClaimsSourceImpl(OA2SE oa2SE) {
        this.oa2SE = oa2SE;
    }

    public BasicClaimsSourceImpl() {
    }

    public BasicClaimsSourceImpl(QDLStem stem) {
        this.fromQDL(stem);
    }

    public BasicClaimsSourceImpl(QDLStem stem, OA2SE oa2SE) {
        this(stem);
        this.setOa2SE(oa2SE);
    }

    public boolean isEnabled() {
        if (this.getConfiguration() == null) {
            return false;
        }
        return this.getConfiguration().isEnabled();
    }

    public OA2SE getOa2SE() {
        return this.oa2SE;
    }

    public void setOa2SE(OA2SE oa2SE) {
        this.oa2SE = oa2SE;
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public JSONObject process(JSONObject claims, ServiceTransaction transaction) throws UnsupportedScopeException {
        return this.process(claims, null, transaction);
    }

    public JSONObject process(JSONObject claims, HttpServletRequest request, ServiceTransaction transaction) throws UnsupportedScopeException {
        OA2ServiceTransaction t = (OA2ServiceTransaction)transaction;
        this.realProcessing(claims, request, (ServiceTransaction)t);
        return claims;
    }

    public GroupHandler getGroupHandler() {
        if (this.groupHandler == null) {
            this.groupHandler = new GroupHandler();
        }
        return this.groupHandler;
    }

    public void setGroupHandler(GroupHandler groupHandler) {
        this.groupHandler = groupHandler;
    }

    protected JSONObject realProcessing(JSONObject claims, HttpServletRequest request, ServiceTransaction transaction) throws UnsupportedScopeException {
        return claims;
    }

    public void setScopes(Collection<String> scopes) {
        this.scopes = scopes;
    }

    public Collection<String> getClaims() {
        HashSet<String> claims = new HashSet<String>();
        claims.add("iss");
        claims.add("sub");
        claims.add("aud");
        claims.add("iat");
        claims.add("email");
        claims.add("exp");
        return claims;
    }

    public boolean isRunOnlyAtAuthorization() {
        return false;
    }

    public void fromQDL(QDLStem stem) {
        if (stem.containsKey((Object)"id")) {
            this.getConfiguration().setId(stem.getString("id"));
        }
        if (stem.containsKey((Object)"fail_on_error")) {
            this.getConfiguration().setFailOnError(stem.getBoolean("fail_on_error").booleanValue());
        }
        if (stem.containsKey((Object)"notify_on_fail")) {
            this.getConfiguration().setNotifyOnFail(stem.getBoolean("notify_on_fail").booleanValue());
        }
        if (stem.containsKey((Object)"enabled")) {
            this.getConfiguration().setEnabled(stem.getBoolean("enabled").booleanValue());
        }
        if (stem.containsKey((Object)"name")) {
            this.getConfiguration().setName(stem.getString("name"));
        }
        if (stem.containsKey((Object)"retry_count")) {
            this.getConfiguration().setRetryCount(Math.toIntExact(stem.getLong("retry_count")));
        }
        if (stem.containsKey((Object)"retry_wait")) {
            this.getConfiguration().setMaxWait(stem.getLong("retry_wait").longValue());
        }
    }

    public QDLStem toQDL() {
        QDLStem stem = new QDLStem();
        this.addToStem(stem, "type", "basic");
        this.addToStem(stem, "id", this.getConfiguration().getId());
        this.addToStem(stem, "fail_on_error", this.getConfiguration().isFailOnError());
        this.addToStem(stem, "enabled", this.getConfiguration().isEnabled());
        this.addToStem(stem, "notify_on_fail", this.getConfiguration().isNotifyOnFail());
        this.addToStem(stem, "name", this.getConfiguration().getName());
        this.addToStem(stem, "retry_count", this.getConfiguration().getRetryCount());
        this.addToStem(stem, "retry_wait", this.getConfiguration().getMaxWait());
        return stem;
    }

    protected void addToStem(QDLStem stem, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String && StringUtils.isTrivial((String)((String)value))) {
            return;
        }
        StemUtility.put((QDLStem)stem, (Object)key, (Object)value);
    }
}

