/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfigurationUtil;
import org.oa4mp.delegation.server.server.claims.ClaimSourceFactory;
import org.oa4mp.delegation.server.server.claims.ClaimSourceFactoryRequest;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.LDAPClaimSourceFactoryRequest;
import org.oa4mp.server.loader.oauth2.claims.LDAPClaimsSource;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;

public class ClaimSourceFactoryImpl
extends ClaimSourceFactory {
    public ClaimSource create(ClaimSourceFactoryRequest request) {
        if (request instanceof LDAPClaimSourceFactoryRequest) {
            ServletDebugUtil.trace((Object)((Object)this), (String)(".create: request = " + String.valueOf(request)));
            LDAPClaimSourceFactoryRequest req = (LDAPClaimSourceFactoryRequest)request;
            LDAPClaimsSource h = new LDAPClaimsSource(req.getLdapConfiguration(), req.getLogger());
            h.setScopes(req.getScopes());
            return h;
        }
        BasicClaimsSourceImpl h = new BasicClaimsSourceImpl();
        h.setConfiguration(request.getConfiguration());
        h.setScopes(request.getScopes());
        return h;
    }

    protected static ClaimSource processDefaultConfig(ClaimSourceConfigurationUtil claimSourceConfigurationUtil, JSONObject json, OA2SE oa2SE, OA2ServiceTransaction transaction) {
        ClaimSourceConfiguration cfg = claimSourceConfigurationUtil.fromJSON(null, json);
        DebugUtil.trace(ClaimSourceFactoryImpl.class, (String)("Got default configuration for server id=" + cfg.getId() + ", name=" + cfg.getName()));
        ClaimSourceFactoryRequest req = new ClaimSourceFactoryRequest(oa2SE.getMyLogger(), cfg, transaction.getScopes());
        ClaimSource claimSource = ClaimSourceFactory.newInstance((ClaimSourceFactoryRequest)req);
        DebugUtil.trace(ClaimSourceFactoryImpl.class, (String)("creating claim source, claims Source=  " + String.valueOf(claimSource)));
        DebugUtil.trace(ClaimSourceFactoryImpl.class, (String)("  , OA2SE  " + String.valueOf((Object)oa2SE)));
        if (claimSource instanceof BasicClaimsSourceImpl) {
            ((BasicClaimsSourceImpl)claimSource).setOa2SE(oa2SE);
        }
        return claimSource;
    }

    protected static ClaimSource processLDAPConfig(LDAPConfigurationUtil ldapConfigurationUtil, JSONObject json, OA2SE oa2SE, OA2ServiceTransaction transaction) {
        LDAPConfiguration cfg = ldapConfigurationUtil.fromJSON(json);
        DebugUtil.trace(ClaimSourceFactoryImpl.class, (String)("Got LDAP configuration for server " + cfg.getServer()));
        LDAPClaimSourceFactoryRequest req = new LDAPClaimSourceFactoryRequest(oa2SE.getMyLogger(), cfg, transaction.getScopes());
        ClaimSource claimSource = ClaimSourceFactory.newInstance((ClaimSourceFactoryRequest)req);
        if (claimSource instanceof BasicClaimsSourceImpl) {
            DebugUtil.trace(ClaimSourceFactoryImpl.class, (String)("Scope handler\"" + claimSource.getClass().getSimpleName() + "\" is configured."));
            ((BasicClaimsSourceImpl)claimSource).setOa2SE(oa2SE);
            DebugUtil.trace(ClaimSourceFactoryImpl.class, (String)"setting scope handler environment #2");
        }
        return claimSource;
    }
}

