/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.server.UnsupportedScopeException;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class FSClaimSource
extends BasicClaimsSourceImpl {
    public static String FILE_PATH_KEY = "filePath";
    public static String FILE_CLAIM_KEY = "claimKey";
    public static String USE_DEFAULT_KEY = "useDefault";
    public static String DEFAULT_CLAIM_KEY = "defaultClaim";
    public static String DEFAULT_ALL_CLAIMS_KEY = "claims";
    Boolean useDefaultClaims = null;
    String rawJSON = null;

    public FSClaimSource(QDLStem stem) {
        super(stem);
    }

    public FSClaimSource(QDLStem stem, OA2SE oa2SE) {
        super(stem, oa2SE);
    }

    public FSClaimSource(ClaimSourceConfiguration config) {
        this.setConfiguration(config);
    }

    public boolean isUseDefaultClaims() {
        if (this.useDefaultClaims == null) {
            Object rawX = this.getConfiguration().getProperty(USE_DEFAULT_KEY);
            if (rawX == null) {
                return false;
            }
            String rawS = rawX.toString();
            if (StringUtils.isTrivial((String)rawS)) {
                return false;
            }
            this.useDefaultClaims = Boolean.parseBoolean(rawS);
        }
        return this.useDefaultClaims;
    }

    public String getDefaultClaimName() {
        Object raw = this.getConfiguration().getProperty(DEFAULT_CLAIM_KEY);
        if (raw == null) {
            return null;
        }
        return raw.toString();
    }

    @Override
    protected JSONObject realProcessing(JSONObject claims, HttpServletRequest request, ServiceTransaction transaction) throws UnsupportedScopeException {
        JSONObject jsonObject;
        if (this.getConfiguration().getProperty(DEFAULT_ALL_CLAIMS_KEY) == null) {
            try {
                if (this.rawJSON == null) {
                    this.rawJSON = this.readFile();
                }
            }
            catch (IOException e) {
                DebugUtil.error((Object)this, (String)("Error reading file \"" + e.getMessage() + "\"."), (Throwable)e);
                throw new GeneralException((Throwable)e);
            }
            jsonObject = JSONObject.fromObject((Object)this.rawJSON);
        } else {
            jsonObject = (JSONObject)this.getConfiguration().getProperty(DEFAULT_ALL_CLAIMS_KEY);
        }
        JSONObject json = this.getConfiguration().getProperty(FILE_CLAIM_KEY) == null ? jsonObject.getJSONObject(transaction.getUsername()) : jsonObject.getJSONObject((String)claims.get(this.getConfiguration().getProperty(FILE_CLAIM_KEY)));
        if (this.isUseDefaultClaims() && (json == null || json.isEmpty())) {
            if (this.getDefaultClaimName() == null) {
                throw new GeneralException("ERROR: \"" + DEFAULT_CLAIM_KEY + "\" has not been set.");
            }
            if (jsonObject.containsKey((Object)this.getDefaultClaimName())) {
                json = jsonObject.getJSONObject(this.getDefaultClaimName());
            }
        }
        claims.putAll((Map)json);
        claims.remove("comment");
        return super.realProcessing(claims, request, transaction);
    }

    public void setRawJSON(String rawJSON) {
        this.rawJSON = rawJSON;
    }

    protected String readFile() throws IOException {
        Object rawfilePath = this.getConfiguration().getProperty(FILE_PATH_KEY);
        if (rawfilePath == null) {
            throw new GeneralException("ERROR:No \"" + FILE_PATH_KEY + "\" set for this claim source.");
        }
        String filePath = rawfilePath.toString();
        if (filePath.isEmpty()) {
            throw new GeneralException("ERROR:No \"" + FILE_PATH_KEY + "\" set for this claim source.");
        }
        File f = new File(filePath);
        if (!f.exists()) {
            throw new GeneralException("ERROR:File \"" + String.valueOf(f) + "\" does not exist on this system.");
        }
        if (!f.isFile()) {
            throw new GeneralException("ERROR: \"" + String.valueOf(f) + "\" is not a file.");
        }
        if (!f.canRead()) {
            throw new GeneralException("ERROR: \"" + String.valueOf(f) + "\" cannot be read.");
        }
        FileReader fileReader = new FileReader(f);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StringBuffer lines = new StringBuffer();
        String inLine = bufferedReader.readLine();
        while (inLine != null) {
            lines.append(inLine + "\n");
            inLine = bufferedReader.readLine();
        }
        bufferedReader.close();
        return lines.toString();
    }

    @Override
    public boolean isRunOnlyAtAuthorization() {
        return false;
    }

    @Override
    public void fromQDL(QDLStem stem) {
        super.fromQDL(stem);
        ClaimSourceConfiguration cfg = this.getConfiguration();
        HashMap<String, Object> xp = new HashMap<String, Object>();
        xp.put(FILE_PATH_KEY, stem.getString("file_path"));
        if (stem.containsKey((Object)"claim_key")) {
            xp.put(FILE_CLAIM_KEY, stem.getString("claim_key"));
        }
        if (stem.containsKey((Object)"use_default")) {
            xp.put(USE_DEFAULT_KEY, stem.getBoolean("use_default"));
        }
        if (stem.containsKey((Object)"default_claim")) {
            xp.put(DEFAULT_CLAIM_KEY, stem.getString("default_claim"));
        }
        if (stem.containsKey((Object)"claims")) {
            xp.put(DEFAULT_ALL_CLAIMS_KEY, stem.getStem("claims").toJSON());
        }
        cfg.setProperties(xp);
    }

    @Override
    public QDLStem toQDL() {
        QDLStem stem = super.toQDL();
        this.addToStem(stem, "type", "file");
        this.addToStem(stem, "file_path", this.getConfiguration().getProperty(FILE_PATH_KEY));
        this.addToStem(stem, "claim_key", this.getConfiguration().getProperty(FILE_CLAIM_KEY));
        this.addToStem(stem, "use_default", this.isUseDefaultClaims());
        this.addToStem(stem, "default_claim", this.getDefaultClaimName());
        if (this.getConfiguration().getProperty(DEFAULT_ALL_CLAIMS_KEY) != null) {
            JSONObject jsonObject = (JSONObject)this.getConfiguration().getProperty(DEFAULT_ALL_CLAIMS_KEY);
            QDLStem x = new QDLStem();
            x.fromJSON(jsonObject);
            StemUtility.put((QDLStem)stem, (Object)"claims", (Object)x);
        }
        return stem;
    }
}

