/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.server.UnsupportedScopeException;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.qdl_lang.variables.QDLStem;

public class HTTPHeaderClaimsSource
extends BasicClaimsSourceImpl {
    public static final String PREFIX_KEY = "prefix";
    public String caput = "OIDC_CLAIM_";

    public HTTPHeaderClaimsSource(ClaimSourceConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public HTTPHeaderClaimsSource() {
    }

    public HTTPHeaderClaimsSource(QDLStem stem) {
        super(stem);
    }

    public String getCaput() {
        return this.caput;
    }

    public void setCaput(String caput) {
        this.caput = caput;
    }

    @Override
    protected JSONObject realProcessing(JSONObject claims, HttpServletRequest request, ServiceTransaction transaction) throws UnsupportedScopeException {
        String prefix = (String)this.getConfiguration().getProperty(PREFIX_KEY);
        if (prefix != null) {
            this.caput = prefix;
        }
        DebugUtil.trace((Object)this, (String)("Omit list = " + String.valueOf(this.getOmitList())));
        Enumeration headerNames = request.getHeaderNames();
        String caput = this.getCaput();
        if (caput == null) {
            caput = "";
        }
        int caputLength = caput.length();
        while (headerNames.hasMoreElements()) {
            String name = headerNames.nextElement().toString();
            DebugUtil.trace((Object)this, (String)("processing claim " + name));
            if (!name.startsWith(caput)) continue;
            String key = name.substring(caputLength);
            String value = request.getHeader(name);
            if (!this.getOmitList().contains(key)) {
                DebugUtil.trace((Object)this, (String)("adding claim " + key + "=" + value));
                claims.put((Object)key, (Object)value);
                continue;
            }
            DebugUtil.trace((Object)this, (String)("OMITTING claim " + key + "=" + value + ", as per omit list"));
        }
        return super.realProcessing(claims, request, transaction);
    }

    @Override
    public JSONObject process(JSONObject claims, ServiceTransaction transaction) throws UnsupportedScopeException {
        throw new NotImplementedException("A servlet request must be supplied for this handler");
    }

    @Override
    public boolean isRunOnlyAtAuthorization() {
        return true;
    }

    @Override
    public void fromQDL(QDLStem arg) {
        super.fromQDL(arg);
        HashMap<String, String> xp = new HashMap<String, String>();
        ClaimSourceConfiguration cfg = new ClaimSourceConfiguration();
        if (arg.containsKey((Object)PREFIX_KEY)) {
            xp.put(PREFIX_KEY, arg.getString(PREFIX_KEY));
        }
        cfg.setProperties(xp);
        this.setConfiguration(cfg);
    }

    @Override
    public QDLStem toQDL() {
        QDLStem arg = super.toQDL();
        this.addToStem(arg, "type", "filter");
        this.addToStem(arg, PREFIX_KEY, this.getCaput());
        return arg;
    }
}

