/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.OA2RedirectableError;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.jwt.IDTokenHandlerInterface;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.delegation.server.server.claims.OA2Claims;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.loader.oauth2.claims.AbstractPayloadHandler;
import org.oa4mp.server.loader.oauth2.claims.PayloadHandlerConfigImpl;
import org.oa4mp.server.loader.oauth2.servlet.ClientUtils;
import org.oa4mp.server.loader.oauth2.servlet.OA2DiscoveryServlet;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.vi.VirtualIssuer;

public class IDTokenHandler
extends AbstractPayloadHandler
implements IDTokenHandlerInterface {
    protected String issuer;
    public static final String ID_TOKEN_DEFAULT_HANDLER_TYPE = "default";
    public static final String ID_TOKEN_BASIC_HANDLER_TYPE = "identity";
    boolean IDP_DEBUG_ON = false;
    Collection<String> scopes = null;

    public IDTokenHandler(PayloadHandlerConfigImpl payloadHandlerConfig) {
        super(payloadHandlerConfig);
        if (payloadHandlerConfig.getRequest() != null) {
            this.setIssuer(payloadHandlerConfig.getRequest());
        }
    }

    public JSONObject getPayload() {
        if (this.payload == null) {
            this.payload = this.transaction.getUserMetaData();
            if (this.payload == null) {
                this.payload = new JSONObject();
            }
        }
        return this.payload;
    }

    public JSONObject getUserMetaData() {
        return this.getPayload();
    }

    public void setUserMetaData(JSONObject userMetaData) {
        this.setPayload(userMetaData);
    }

    protected void setIssuer(HttpServletRequest request) {
        this.issuer = null;
        VirtualIssuer vo = this.oa2se.getVI(this.transaction.getClient().getIdentifier());
        DebugUtil.trace((Object)this, (String)("vi = " + String.valueOf((Object)vo)));
        if (vo != null) {
            this.issuer = vo.getIssuer();
            if (!StringUtils.isTrivial((String)this.issuer)) {
                return;
            }
        }
        List admins = this.oa2se.getPermissionStore().getAdmins(this.transaction.getClient().getIdentifier());
        for (Identifier adminID : admins) {
            AdminClient ac = (AdminClient)this.oa2se.getAdminClientStore().get((Object)adminID);
            if (ac == null || StringUtils.isTrivial((String)ac.getIssuer())) continue;
            this.issuer = ac.getIssuer();
            DebugUtil.trace((Object)this, (String)("got issuer from admin client \"" + ac.getIdentifierString() + "\" =" + this.issuer));
            break;
        }
        if (StringUtils.isTrivial((String)this.issuer)) {
            this.issuer = ((OA2Client)this.transaction.getClient()).getIssuer();
            DebugUtil.trace((Object)this, (String)("got issuer from  client \"" + this.transaction.getClient().getIdentifierString() + "\" =" + this.issuer));
        }
        if (StringUtils.isTrivial((String)this.issuer)) {
            this.issuer = OA2DiscoveryServlet.getIssuer(request);
            DebugUtil.trace((Object)this, (String)("got issuer from  discovery servlet  =" + this.issuer));
        }
        DebugUtil.trace((Object)this, (String)("RETURNED issuer  =" + this.issuer));
    }

    public void init() throws Throwable {
        JSONObject claims = this.getUserMetaData();
        DebugUtil.trace((Object)this, (String)"Starting to process basic claims");
        this.setClaimIfNeeded(claims, "iss", this.issuer);
        this.setClaimIfNeeded(claims, "sub", this.transaction.getUsername());
        this.setClaimIfNeeded(claims, "aud", this.transaction.getClient().getIdentifierString());
        this.setClaimIfNeeded(claims, "jti", ((OA2TokenForge)this.oa2se.getTokenForge()).getIDToken(new String[0]).getToken());
        this.setAccountingInformation();
        this.checkRequiredScopes(this.transaction);
        if (this.client.isPublicClient()) {
            return;
        }
        DebugUtil.trace((Object)this, (String)"Starting to process server default claims");
        if (this.oa2se != null && this.oa2se.getClaimSource() != null && this.oa2se.getClaimSource().isEnabled() && this.oa2se.getClaimSource().isRunOnlyAtAuthorization()) {
            DebugUtil.trace((Object)this, (String)("Service environment has a claims source enabled=" + String.valueOf(this.oa2se.getClaimSource())));
            this.oa2se.getClaimSource().process(claims, this.request, (ServiceTransaction)this.transaction);
        } else {
            DebugUtil.trace((Object)this, (String)"Service environment has a claims no source enabled during authorization");
        }
    }

    private void setClaimIfNeeded(JSONObject claims, String claimName, Object claimValue) {
        if (!claims.containsKey((Object)claimName)) {
            claims.put((Object)claimName, claimValue);
        }
    }

    public void refreshAccountingInformation() {
        this.NEWrefreshAccountingInformation();
    }

    protected void NEWrefreshAccountingInformation() {
        DebugUtil.trace((Object)this, (String)"Refreshing the accounting information for the claims");
        this.getUserMetaData().put((Object)"iat", (Object)(System.currentTimeMillis() / 1000L));
        this.getUserMetaData().put((Object)"nbf", (Object)(System.currentTimeMillis() / 1000L));
        long idtLifetime = ClientUtils.computeIDTLifetime(this.transaction, this.client, this.oa2se);
        long expiresAt = System.currentTimeMillis() + idtLifetime;
        this.getUserMetaData().put((Object)"exp", (Object)(expiresAt / 1000L));
        if (!this.getUserMetaData().containsKey((Object)"sub") && this.getPhCfg().getClientConfig().hasSubject()) {
            this.getUserMetaData().put((Object)"sub", (Object)this.getPhCfg().getClientConfig().getSubject());
        }
        DebugUtil.trace((Object)this, (String)("saving the transaction with claims:\n" + this.getUserMetaData().toString(1)));
    }

    public void setAccountingInformation() {
        DebugUtil.trace((Object)this, (String)"Setting the accounting information for the claims");
        if (this.transaction.getNonce() != null && 0 < this.transaction.getNonce().length()) {
            this.getUserMetaData().put((Object)"nonce", (Object)this.transaction.getNonce());
        }
        if (this.transaction.hasAuthTime()) {
            this.getUserMetaData().put((Object)"auth_time", (Object)(this.transaction.getAuthTime().getTime() / 1000L));
        }
        this.refreshAccountingInformation();
    }

    public void addRequestState(ScriptRunRequest req) throws Throwable {
        JSONObject json;
        if (req.getArgs().containsKey("claims")) {
            this.getUserMetaData().putAll((Map)req.getArgs().get("claims"));
        }
        if (req.getArgs().containsKey("claim_sources")) {
            List sources = (List)req.getArgs().get("claim_sources");
            sources.addAll(this.transaction.getClaimSources(this.oa2se));
            this.transaction.setClaimsSources(sources);
        }
        req.getArgs().put("claim_sources", this.getSources());
        req.getArgs().put("claims", this.getUserMetaData());
        if (this.getPhCfg().request != null && !(json = OA2HeaderUtils.headerToJSON((HttpServletRequest)this.getPhCfg().request, Arrays.asList("authorization", "cookie", "host"))).isEmpty()) {
            req.getArgs().put("auth_headers", json);
        }
    }

    @Override
    public void handleResponse(ScriptRunResponse resp) throws Throwable {
        super.handleResponse(resp);
        switch (resp.getReturnCode()) {
            case 1: {
                this.setUserMetaData((JSONObject)resp.getReturnedValues().get("claims"));
                List sources = (List)resp.getReturnedValues().get("claim_sources");
                this.transaction.setClaimsSources(sources);
                return;
            }
            case 0: {
                return;
            }
        }
    }

    public void checkClaims() throws Throwable {
        if (this.oa2se.isOIDCEnabled() && this.client.isPublicClient()) {
            this.checkClaim(this.getUserMetaData(), "sub");
        }
        ArrayList<String> keysToRemove = new ArrayList<String>();
        JSONObject claims = this.getUserMetaData();
        for (Object e : claims.keySet()) {
            String k;
            if (e == null) {
                keysToRemove.add(null);
            }
            if ((k = e.toString()).isEmpty()) {
                keysToRemove.add("");
            }
            if (claims.get(e) != null && !claims.getString(k).isEmpty()) continue;
            keysToRemove.add(k);
        }
        for (String string : keysToRemove) {
            DebugUtil.trace((Object)this, (String)("Removed empty claim \"" + string + "\""));
            claims.remove(string);
        }
    }

    public List<ClaimSource> getSources() throws Throwable {
        return this.transaction.getClaimSources(this.oa2se);
    }

    public void finish(String execPhase) throws Throwable {
        this.refreshAccountingInformation();
        if (!this.getUserMetaData().containsKey((Object)"aud")) {
            this.getUserMetaData().put((Object)"aud", (Object)this.transaction.getClient().getIdentifierString());
        }
        if (!this.getUserMetaData().containsKey((Object)"iss")) {
            this.getUserMetaData().put((Object)"iss", (Object)this.transaction.getClient().getIdentifierString());
        }
        Collection basicScopes = OA2Scopes.ScopeUtil.getBasicScopes();
        HashSet<String> x = new HashSet<String>();
        x.addAll(this.getScopes());
        x.retainAll(basicScopes);
        x.retainAll(this.transaction.getClient().getScopes());
        if (x.contains("org.cilogon.userinfo") || !((OA2Client)this.transaction.getClient()).useStrictScopes()) {
            this.permissiveFinish(x, execPhase);
            return;
        }
        this.restrictiveFinish(x, execPhase);
    }

    public Collection<String> getScopes() {
        if (this.scopes == null) {
            if (this.hasTXRecord() && this.getTXRecord().getScopes() != null && !this.getTXRecord().getScopes().isEmpty()) {
                this.scopes = this.getTXRecord().getScopes();
                Collection metadataScopes = OA2Scopes.ScopeUtil.intersection((Collection)OA2Scopes.ScopeUtil.getBasicScopes(), this.scopes);
                if (metadataScopes.size() == 0) {
                    metadataScopes = OA2Scopes.ScopeUtil.intersection((Collection)OA2Scopes.ScopeUtil.getBasicScopes(), this.transaction.getScopes());
                    this.scopes.addAll(metadataScopes);
                }
            } else {
                this.scopes = this.transaction.getScopes();
            }
        }
        return this.scopes;
    }

    protected void restrictiveFinish(Collection<String> scopes, String execPhase) throws Throwable {
        String[] requiredClaims;
        JSONObject finalClaims = new JSONObject();
        JSONObject currentClaims = new JSONObject();
        currentClaims.putAll((Map)this.getUserMetaData());
        for (String r : requiredClaims = new String[]{"iss", "aud", "exp", "iat", "jti", "nonce", "auth_time"}) {
            this.setCurrentClaim(currentClaims, finalClaims, r);
        }
        finalClaims.put((Object)"azp", (Object)this.transaction.getClient().getIdentifierString());
        if (scopes.contains("openid")) {
            this.setCurrentClaim(currentClaims, finalClaims, "sub");
            this.setCurrentClaim(currentClaims, finalClaims, "acr");
            this.setCurrentClaim(currentClaims, finalClaims, "amr");
        }
        if (scopes.contains("email")) {
            this.setCurrentClaim(currentClaims, finalClaims, "email");
            this.setCurrentClaim(currentClaims, finalClaims, "email_verified");
        }
        if (scopes.contains("phone")) {
            this.setCurrentClaim(currentClaims, finalClaims, "phone_number");
            this.setCurrentClaim(currentClaims, finalClaims, "phone_number_verified");
        }
        if (scopes.contains("profile")) {
            this.setCurrentClaim(currentClaims, finalClaims, "name");
            this.setCurrentClaim(currentClaims, finalClaims, "given_name");
            this.setCurrentClaim(currentClaims, finalClaims, "family_name");
            this.setCurrentClaim(currentClaims, finalClaims, "middle_name");
            this.setCurrentClaim(currentClaims, finalClaims, "nickname");
            this.setCurrentClaim(currentClaims, finalClaims, "display_name");
            this.setCurrentClaim(currentClaims, finalClaims, "preferred_username");
        }
        if (scopes.contains("address")) {
            this.setCurrentClaim(currentClaims, finalClaims, "address");
        }
        if (scopes.contains("org.oa4mp:userinfo")) {
            for (String claim : OA2Claims.USER_INFO_CLAIMS) {
                this.setCurrentClaim(currentClaims, finalClaims, claim);
            }
            if (this.transaction.getScopes().contains("edu.uiuc.ncsa.myproxy.getcert")) {
                this.setCurrentClaim(currentClaims, finalClaims, "cert_subject_dn");
            }
        }
        this.setUserMetaData(finalClaims);
    }

    protected void permissiveFinish(Collection<String> configuredScopes, String execPhase) throws Throwable {
        Collection<String> requestedScopes = this.transaction.getScopes();
        if (this.oa2se.isOIDCEnabled()) {
            if (configuredScopes.contains("openid")) {
                // empty if block
            }
            this.checkClaim(this.getUserMetaData(), "sub");
        }
        if (!configuredScopes.contains("email")) {
            this.getUserMetaData().remove("email");
            this.getUserMetaData().remove("email_verified");
        }
        if (!configuredScopes.contains("phone")) {
            this.getUserMetaData().remove("phone_number");
            this.getUserMetaData().remove("phone_number_verified");
        }
        if (!configuredScopes.contains("profile")) {
            this.getUserMetaData().remove("name");
            this.getUserMetaData().remove("middle_name");
            this.getUserMetaData().remove("nickname");
            this.getUserMetaData().remove("given_name");
            this.getUserMetaData().remove("family_name");
            this.getUserMetaData().remove("preferred_username");
            this.getUserMetaData().remove("display_name");
        }
        if (!requestedScopes.contains("edu.uiuc.ncsa.myproxy.getcert")) {
            this.getUserMetaData().remove("cert_subject_dn");
        }
        if (requestedScopes.contains("org.cilogon.userinfo")) {
            return;
        }
        if (!requestedScopes.contains("org.oa4mp:userinfo")) {
            for (String claim : OA2Claims.USER_INFO_CLAIMS) {
                this.getUserMetaData().remove(claim);
            }
        }
    }

    protected void setCurrentClaim(JSONObject currentClaims, JSONObject finalClaims, String key) {
        if (currentClaims.containsKey((Object)key) && currentClaims.get(key) != null) {
            finalClaims.put((Object)key, currentClaims.get(key));
        }
    }

    @Override
    public void saveState(String execPhase) throws Throwable {
        if (execPhase.equals("post_auth")) {
            this.transaction.setUserMetaData(this.getUserMetaData());
        }
        super.saveState(execPhase);
    }

    protected void checkRequiredScopes(OA2ServiceTransaction t) throws Throwable {
        if (this.oa2se.isOIDCEnabled()) {
            if (t.getOA2Client().isPublicClient() && !t.getScopes().contains("openid")) {
                throw new OA2RedirectableError("invalid_scope", "invalid scope: no open id scope", 401, t.getRequestState(), t.getCallback(), (BaseClient)t.getClient());
            }
            if (t.getOA2Client().useStrictScopes() && t.getOA2Client().getScopes().contains("openid") && !t.getScopes().contains("openid")) {
                throw new OA2RedirectableError("invalid_scope", "invalid scope: no open id scope", 401, t.getRequestState(), t.getCallback(), (BaseClient)t.getClient());
            }
        }
    }

    protected void checkClaim(JSONObject claims, String claimKey) {
        if (claims.containsKey((Object)claimKey)) {
            if (this.isEmpty(claims.getString(claimKey))) {
                throw new OA2GeneralError("server_error", "Missing " + claimKey + " claim", 500, null);
            }
        } else {
            throw new OA2GeneralError("server_error", "Missing " + claimKey + " claim", 500, null);
        }
    }

    @Override
    public JSONObject execute(ClaimSource source, JSONObject claims) throws Throwable {
        if (this.client.isPublicClient()) {
            return claims;
        }
        return super.execute(source, claims);
    }

    public IDTokenImpl getSignedPayload(JSONWebKey key) {
        return this.getSignedPayload(key, null);
    }

    public IDTokenImpl getSignedPayload(JSONWebKey key, String headerType) {
        String idTokken = null;
        try {
            idTokken = this.client.isSignTokens() ? JWTUtil.createJWT((JSONObject)this.getPayload(), (JSONWebKey)key) : JWTUtil.createJWT((JSONObject)this.getPayload());
            return TokenFactory.createIDT((String)idTokken);
        }
        catch (Throwable e) {
            throw new IllegalStateException("cannot create ID token", e);
        }
    }
}

