/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.Logable;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.server.UnsupportedScopeException;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.claims.GroupElement;
import org.oa4mp.server.loader.oauth2.claims.Groups;
import org.oa4mp.server.loader.oauth2.claims.LDAPException;
import org.oa4mp.server.loader.oauth2.servlet.GroupHandler;
import org.oa4mp.server.loader.oauth2.servlet.NCSAGroupHandler;
import org.qdl_lang.variables.QDLSet;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class LDAPClaimsSource
extends BasicClaimsSourceImpl
implements Logable {
    private static final long serialVersionUID = 7590118446767325062L;
    protected boolean loggingEnabled = false;
    transient MyLoggingFacade myLogger = null;
    protected transient LdapContext context = null;
    String currentServerAddress = null;
    boolean debug = false;

    public LDAPClaimsSource() {
    }

    public LDAPClaimsSource(QDLStem stem) {
        super(stem);
    }

    public LDAPClaimsSource(QDLStem stem, OA2SE oa2SE) {
        super(stem, oa2SE);
    }

    public LDAPClaimsSource(LDAPConfiguration ldapConfiguration, MyLoggingFacade myLogger) {
        if (ldapConfiguration == null) {
            throw new LDAPException("null ldap config");
        }
        this.setConfiguration((ClaimSourceConfiguration)ldapConfiguration);
        this.myLogger = myLogger;
        if (myLogger != null) {
            this.loggingEnabled = true;
        }
    }

    public LDAPClaimsSource(OA2SE oa2SE) {
        super(oa2SE);
        if (oa2SE == null) {
            throw new LDAPException("null service env");
        }
        this.myLogger = oa2SE.getMyLogger();
        this.loggingEnabled = this.myLogger != null;
    }

    public String getSearchName(JSONObject claims, HttpServletRequest request, ServiceTransaction transaction) {
        String dbgname = ".getSearchName(id=" + this.getLDAPCfg().getId() + ", search name key=" + this.getLDAPCfg().getSearchNameKey() + ")";
        DebugUtil.trace((Object)this, (String)dbgname);
        LDAPConfigurationUtil ldapConfigurationUtil = new LDAPConfigurationUtil();
        JSONObject xxx = ldapConfigurationUtil.toJSON(this.getLDAPCfg());
        if (xxx.getJSONObject("ldap").containsKey((Object)"ssl")) {
            xxx.getJSONObject("ldap").getJSONObject("ssl").put((Object)"keystore", (Object)"");
        }
        if (this.getLDAPCfg().getSearchNameKey() == null) {
            this.warn(dbgname + "No search name given for LDAP query. Using default of username");
            return transaction.getUsername();
        }
        if (this.getLDAPCfg().getSearchNameKey().equals("username")) {
            DebugUtil.trace((Object)this, (String)(dbgname + " searching using the username"));
            return transaction.getUsername();
        }
        if (!claims.containsKey((Object)this.getLDAPCfg().getSearchNameKey()) || claims.get(this.getLDAPCfg().getSearchNameKey()) == null) {
            String message = "no recognized search name key was found in the claims for config with id=" + this.getLDAPCfg().getId() + ". Requested was \"" + this.getLDAPCfg().getSearchNameKey() + "\"";
            DebugUtil.trace((Object)this, (String)message);
            throw new LDAPException(message);
        }
        String searchName = (String)claims.get(this.getLDAPCfg().getSearchNameKey());
        if (searchName == null || searchName.isEmpty()) {
            throw new LDAPException("No search name found for LDAP query.");
        }
        DebugUtil.trace((Object)this, (String)(".getSearchName(id=" + this.getLDAPCfg().getId() + ", returning " + searchName));
        return searchName;
    }

    protected boolean isNCSA() {
        ServletDebugUtil.trace((Object)this, (String)("checking if is NCSA LDAP claims source for \"" + this.currentServerAddress + "\""));
        return this.currentServerAddress.endsWith(".ncsa.illinois.edu");
    }

    protected MyLoggingFacade getMyLogger() {
        return this.myLogger;
    }

    public void handleException(Throwable throwable, MetaDebugUtil debugger) {
        debugger.trace((Object)this, "LDAP error (" + throwable.getClass().getSimpleName() + "):" + throwable.getMessage());
        throwable.printStackTrace();
        if (throwable instanceof NamingException) {
            String msg = throwable.getClass().getSimpleName() + " talking to LDAP:" + throwable.getMessage();
            debugger.warn((Object)this, msg);
            if (this.getConfiguration().isNotifyOnFail()) {
                this.warn(msg);
            }
            if (this.getConfiguration().isFailOnError()) {
                throw new LDAPException(msg, throwable);
            }
            return;
        }
        debugger.error((Object)this, "Error accessing LDAP", throwable);
        if (this.getLDAPCfg().isFailOnError()) {
            String message;
            String string = message = throwable instanceof NullPointerException ? "(null pointer)" : throwable.getMessage();
            if (this.getMyLogger() != null) {
                this.getMyLogger().warn("Could not get LDAP information:" + message);
            }
            if (this.getLDAPCfg().isNotifyOnFail()) {
                String subjectTemplate = "Error on ${host} contacting LDAP server";
                String messageTemplate = "The following error message was received attempting to contact the LDAP server at ${ldap_host}:\n\n${message}\n\n. The operation did not complete.";
                HashMap<String, String> replacements = new HashMap<String, String>();
                String x = "localhost";
                if (this.getOa2SE() != null) {
                    URI address = this.getOa2SE().getServiceAddress();
                    if (address != null) {
                        x = address.getHost();
                    }
                    replacements.put("host", x);
                    replacements.put("ldap_host", this.getLDAPCfg().getServer());
                    replacements.put("message", throwable.getMessage());
                    this.getOa2SE().getMailUtil().sendMessage(subjectTemplate, messageTemplate, replacements);
                }
            }
            throw new LDAPException("Could not communicate with LDAP server: \"" + (throwable.getMessage() == null ? "(no message)" : throwable.getMessage()) + "\"");
        }
    }

    protected Groups processNCSAGroups() {
        Groups groups = new Groups();
        return groups;
    }

    @Override
    public boolean isEnabled() {
        if (this.getConfiguration() == null) {
            return false;
        }
        return super.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONObject realProcessing(JSONObject claims, HttpServletRequest request, ServiceTransaction transaction) throws UnsupportedScopeException {
        String name = "realProcessing(id=" + this.getLDAPCfg().getId() + "):";
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)transaction.getClient());
        debugger.trace((Object)this, name + " preparing to do processing, cfg:\n" + this.getLDAPCfg().toJSON().toString(1));
        debugger.trace((Object)this, name + " initial claims:\n" + claims.toString(1));
        if (!this.isEnabled()) {
            debugger.trace((Object)this, name + " Claims source not enabled.");
            return claims;
        }
        if (!this.isLoggedOn()) {
            this.logon(debugger);
            if (!this.isLoggedOn() && !this.getLDAPCfg().isFailOnError()) {
                debugger.trace((Object)this, name + " logon FAILED!");
                return claims;
            }
        }
        try {
            String searchName = this.getSearchName(claims, request, transaction);
            debugger.trace((Object)this, name + " search name=\"" + searchName + "\"");
            if (searchName != null) {
                JSONObject tempMap = this.simpleSearch(this.context, searchName, this.getLDAPCfg().getSearchAttributes(), debugger);
                claims.putAll((Map)tempMap);
            } else {
                this.info("No search name encountered for LDAP query. No search performed.");
            }
            this.context.close();
        }
        catch (Throwable throwable) {
            debugger.trace((Object)this, name + " Error getting search name \"" + throwable.getMessage() + "\"", throwable);
            this.handleException(throwable, debugger);
        }
        finally {
            this.closeConnection();
        }
        debugger.trace((Object)this, name + " claims=" + String.valueOf(claims));
        return claims;
    }

    protected boolean isLoggedOn() {
        return this.context != null;
    }

    public LDAPConfiguration getLDAPCfg() {
        return (LDAPConfiguration)this.getConfiguration();
    }

    public void logon(MetaDebugUtil debugUtil) {
        this.context = this.createConnection(debugUtil);
    }

    public Hashtable<String, String> createEnv(String host, LDAPConfiguration cfg) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        Object providerUrl = host.trim();
        if (!host.startsWith("ldaps://")) {
            providerUrl = "ldaps://" + (String)providerUrl;
        }
        if (0 <= cfg.getPort()) {
            providerUrl = (String)providerUrl + ":" + cfg.getPort();
        }
        env.put("java.naming.provider.url", (String)providerUrl);
        env.put("com.sun.jndi.ldap.read.timeout", "10000");
        switch (cfg.getAuthType()) {
            case 1: {
                env.put("java.naming.security.authentication", "none");
                env.put("java.naming.security.protocol", "ssl");
                break;
            }
            case 10: {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", cfg.getSecurityPrincipal());
                env.put("java.naming.security.credentials", cfg.getPassword());
                env.put("javax.security.sasl.server.authentication", "true");
                env.put("java.naming.security.protocol", "ssl");
                break;
            }
            case 100: {
                env.put("java.naming.security.authentication", "strong");
                env.put("java.naming.security.principal", cfg.getSecurityPrincipal());
                env.put("java.naming.security.credentials", cfg.getPassword());
                env.put("java.naming.security.protocol", "ssl");
                break;
            }
        }
        return env;
    }

    public LdapContext createConnection(MetaDebugUtil debugger) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getLDAPCfg().getServer(), ",");
        InitialDirContext dirContext = null;
        int retryCount = Math.max(1, this.getLDAPCfg().getRetryCount());
        Throwable lastException = null;
        for (int i = 0; i < retryCount; ++i) {
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    this.currentServerAddress = stringTokenizer.nextToken().trim();
                    dirContext = new InitialDirContext(this.createEnv(this.currentServerAddress, this.getLDAPCfg()));
                    debugger.trace((Object)this, "Found LDAP server for address=\"" + this.currentServerAddress + "\"");
                    return (LdapContext)dirContext.lookup(this.getLDAPCfg().getSearchBase());
                }
                catch (Throwable e) {
                    String msg = e.getClass().getSimpleName() + " failure for LDAP server # " + i + ": " + e.getMessage();
                    debugger.trace((Object)this, msg, e);
                    lastException = e;
                }
            }
            if (0L >= this.getLDAPCfg().getMaxWait()) continue;
            try {
                Thread.currentThread();
                Thread.sleep(this.getLDAPCfg().getMaxWait());
                continue;
            }
            catch (InterruptedException e) {
                if (DebugUtil.isEnabled()) {
                    e.printStackTrace();
                }
                this.info("sleep in " + this.getClass().getSimpleName() + " + interrupted:" + e.getMessage());
            }
        }
        this.handleException(lastException, debugger);
        return null;
    }

    @Override
    public Collection<String> getClaims() {
        Collection<String> claims = super.getClaims();
        for (String key : this.getLDAPCfg().getSearchAttributes().keySet()) {
            LDAPConfigurationUtil.AttributeEntry ae = (LDAPConfigurationUtil.AttributeEntry)this.getLDAPCfg().getSearchAttributes().get(key);
            claims.add(ae.targetName);
        }
        return claims;
    }

    protected String getSearchFilterAttribute(MetaDebugUtil debugger) {
        debugger.trace((Object)this, "search attribute in LDAP is " + this.getLDAPCfg().getSearchFilterAttribute());
        if (this.getLDAPCfg().getSearchFilterAttribute() == null) {
            return "uid";
        }
        return this.getLDAPCfg().getSearchFilterAttribute();
    }

    public JSONObject simpleSearch(LdapContext ctx, String userID, Map<String, LDAPConfigurationUtil.AttributeEntry> attributes, MetaDebugUtil debugger) throws NamingException {
        if (ctx == null) {
            throw new LDAPException("could not create the LDAP context on " + String.valueOf(new Date()) + " server=" + this.getLDAPCfg().getServer() + ", base=" + this.getLDAPCfg().getSearchBase());
        }
        SearchControls searchControls = new SearchControls();
        if (attributes == null || attributes.isEmpty()) {
            searchControls.setReturningAttributes(null);
        } else {
            Object searchAttributes = attributes.keySet().toArray(new String[0]);
            searchControls.setReturningAttributes((String[])searchAttributes);
        }
        if (this.getLDAPCfg().hasSearchScope()) {
            switch (this.getLDAPCfg().getSearchScope()) {
                case "object": {
                    searchControls.setSearchScope(0);
                    break;
                }
                case "one_level": {
                    searchControls.setSearchScope(1);
                    break;
                }
                case "subtree": {
                    searchControls.setSearchScope(2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown search scope \"" + this.getLDAPCfg().getSearchScope() + "\"");
                }
            }
        }
        Object filter = !StringUtils.isTrivial((String)this.getLDAPCfg().getAdditionalFilter()) ? this.getLDAPCfg().getAdditionalFilter() : "(" + this.getSearchFilterAttribute(debugger) + "=" + userID + ")";
        String contextName = this.getLDAPCfg().getContextName();
        if (contextName == null) {
            contextName = "";
        }
        debugger.trace((Object)this, "filter = " + (String)filter);
        NamingEnumeration<SearchResult> e = ctx.search(contextName, (String)filter, searchControls);
        return this.toJSON(attributes, e, userID);
    }

    protected JSONObject toJSON(Map<String, LDAPConfigurationUtil.AttributeEntry> attributes, NamingEnumeration e, String userName) throws NamingException {
        JSONObject json = new JSONObject();
        if (!e.hasMoreElements()) {
            DebugUtil.trace((Object)this, (String)"LDAP SEARCH RESULT IS EMPTY");
        }
        if (attributes.isEmpty()) {
            return this.doEmptyAttrs(e);
        }
        while (e.hasMoreElements()) {
            SearchResult entry = (SearchResult)e.next();
            Attributes a = entry.getAttributes();
            for (String attribID : attributes.keySet()) {
                JSONArray jsonAttribs;
                Attribute attribute = a.get(attribID);
                if (attribute == null) continue;
                if (attributes.get((Object)attribID).isGroup) {
                    jsonAttribs = new JSONArray();
                    for (int i = 0; i < attribute.size(); ++i) {
                        jsonAttribs.add(attribute.get(i));
                    }
                    GroupHandler gg = null;
                    gg = this.isNCSA() ? new NCSAGroupHandler(this, userName) : this.getGroupHandler();
                    Groups groups = gg.parse(jsonAttribs);
                    json.put((Object)attributes.get((Object)attribID).targetName, (Object)groups.toJSON());
                    continue;
                }
                if (attribute.size() == 1) {
                    if (attributes.get((Object)attribID).isList) {
                        jsonAttribs = new JSONArray();
                        jsonAttribs.add(attribute.get(0));
                        json.put((Object)attributes.get((Object)attribID).targetName, (Object)jsonAttribs);
                        continue;
                    }
                    json.put((Object)attributes.get((Object)attribID).targetName, attribute.get(0));
                    continue;
                }
                jsonAttribs = new JSONArray();
                for (int i = 0; i < attribute.size(); ++i) {
                    jsonAttribs.add(attribute.get(i));
                }
                json.put((Object)attributes.get((Object)attribID).targetName, (Object)jsonAttribs);
            }
        }
        return json;
    }

    private JSONObject doEmptyAttrs(NamingEnumeration e) throws NamingException {
        JSONObject all = new JSONObject();
        while (e.hasMoreElements()) {
            SearchResult entry = (SearchResult)e.next();
            Attributes attributes = entry.getAttributes();
            NamingEnumeration<? extends Attribute> aNE = attributes.getAll();
            while (aNE.hasMoreElements()) {
                Attribute attribute = aNE.next();
                JSONArray array = new JSONArray();
                for (int i = 0; i < attribute.size(); ++i) {
                    array.add(attribute.get(i));
                }
                all.put((Object)attribute.getID(), (Object)array);
            }
        }
        return all;
    }

    protected void closeConnection() {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (Throwable t) {
                if (this.isDebugOn()) {
                    t.printStackTrace();
                }
                this.info("Exception trying to close LDAP connection: " + t.getMessage());
            }
        }
    }

    protected void sayit(String x) {
        System.err.println(x);
    }

    public void debug(String x) {
        if (this.loggingEnabled) {
            this.getMyLogger().debug(x);
        } else {
            this.sayit(x);
        }
    }

    public boolean isDebugOn() {
        if (this.loggingEnabled) {
            return this.getMyLogger().isDebugOn();
        }
        return this.debug;
    }

    public void setDebugOn(boolean setOn) {
        if (this.loggingEnabled) {
            this.getMyLogger().setDebugOn(setOn);
        }
        this.debug = setOn;
    }

    public void info(String x) {
        if (this.loggingEnabled) {
            this.getMyLogger().info(x);
        } else {
            this.sayit(x);
        }
    }

    public void warn(String x) {
        if (this.loggingEnabled) {
            this.getMyLogger().warn(x);
        } else {
            this.sayit(x);
        }
    }

    public void error(String x, Throwable e) {
        if (this.loggingEnabled) {
            this.getMyLogger().error(x, e);
        } else {
            this.sayit(x);
            e.printStackTrace();
        }
    }

    public void error(String x) {
        if (this.loggingEnabled) {
            this.getMyLogger().error(x);
        } else {
            this.sayit(x);
        }
    }

    public String toString() {
        return "LDAPClaimsSource{" + (this.configuration == null ? "(no config)" : this.configuration.getName()) + "}";
    }

    public static Groups get_NEW_Gid(LDAPConfiguration cfg2, String username) throws Throwable {
        Context dirContext;
        LDAPConfiguration cfg;
        block5: {
            cfg = cfg2.clone();
            cfg.setSearchBase("ou=Groups,dc=ncsa,dc=illinois,dc=edu");
            LDAPClaimsSource claimsSource = new LDAPClaimsSource(cfg, null);
            StringTokenizer stringTokenizer = new StringTokenizer(cfg.getServer(), ",");
            dirContext = null;
            while (true) {
                dirContext = new InitialDirContext(claimsSource.createEnv(stringTokenizer.nextToken(), cfg));
                continue;
                break;
            }
            finally {
                if (!stringTokenizer.hasMoreTokens()) break block5;
            }
        }
        LdapContext ctx = (LdapContext)dirContext.lookup(cfg.getSearchBase());
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{"cn", "gidNumber"});
        String filter = "(&(uniqueMember=" + cfg.getSearchFilterAttribute() + "=" + username + ",ou=People,dc=ncsa,dc=illinois,dc=edu))";
        NamingEnumeration<SearchResult> e = ctx.search(cfg.getContextName(), filter, searchControls);
        Groups groups = new Groups();
        while (e.hasMoreElements()) {
            SearchResult entry = e.next();
            Attributes a = entry.getAttributes();
            GroupElement groupElement = LDAPClaimsSource.convertToEntry(a);
            groups.put(groupElement);
        }
        ctx.close();
        return groups;
    }

    protected static GroupElement convertToEntry(Attributes a) throws NamingException {
        String xxx;
        JSONObject json = new JSONObject();
        Attribute attribute = a.get("gidNumber");
        int gid = -1;
        if (attribute != null && (xxx = String.valueOf(attribute.get(0))) != null && !xxx.isEmpty()) {
            gid = Integer.parseInt(xxx);
        }
        if (-1 < gid) {
            json.put((Object)"id", (Object)gid);
        }
        attribute = a.get("cn");
        String id = attribute.getID() + ":";
        String groupName = attribute.toString().substring(id.length()).trim();
        if (groupName.isEmpty()) {
            throw new NFWException("The group name somehow was empty. This implies the LDAP entry has changed or is incorrect");
        }
        GroupElement g = null;
        g = gid == -1 ? new GroupElement(groupName) : new GroupElement(groupName, gid);
        return g;
    }

    @Override
    public void fromQDL(QDLStem arg) {
        QDLSet groups;
        System.out.println("LDAPClaimsSource::fromQDL:\n" + arg.toString(1));
        LDAPConfiguration ldapCfg = new LDAPConfiguration();
        this.setConfiguration((ClaimSourceConfiguration)ldapCfg);
        super.fromQDL(arg);
        LDAPConfigurationUtil cUtil = new LDAPConfigurationUtil();
        ldapCfg.setSearchNameKey(arg.getString("claim_name"));
        ldapCfg.setServer(arg.getString("address"));
        if (arg.containsKey((Object)"ldap_name")) {
            ldapCfg.setSearchFilterAttribute(arg.getString("ldap_name"));
        }
        if (arg.containsKey((Object)"search_scope")) {
            ldapCfg.setSearchScope(arg.getString("search_scope"));
        }
        if (arg.containsKey((Object)"enabled")) {
            ldapCfg.setEnabled(arg.getBoolean("enabled").booleanValue());
        } else {
            ldapCfg.setEnabled(true);
        }
        if (arg.containsKey((Object)"filter")) {
            ldapCfg.setAdditionalFilter(arg.getString("filter"));
        } else {
            ldapCfg.setAdditionalFilter("");
        }
        if (arg.containsKey((Object)"context")) {
            ldapCfg.setContextName(arg.getString("context"));
        } else {
            ldapCfg.setContextName("");
        }
        if (arg.containsKey((Object)"port")) {
            ldapCfg.setPort(arg.getLong("port").intValue());
        } else {
            ldapCfg.setPort(636);
        }
        ldapCfg.setAuthType(cUtil.getAuthType(arg.getString("auth_type")));
        if (ldapCfg.getAuthType() == 10) {
            ldapCfg.setPassword(arg.getString("password"));
            ldapCfg.setSecurityPrincipal(arg.getString("username"));
        }
        ldapCfg.setSearchBase(arg.getString("search_base"));
        QDLStem renames = null;
        if (arg.containsKey((Object)"rename")) {
            renames = arg.get("rename").asStem();
        }
        QDLSet lists = null;
        if (arg.containsKey((Object)"lists")) {
            QDLStem listNames = arg.get("lists").asStem();
            lists = listNames.values();
        } else {
            lists = new ArrayList();
        }
        if (arg.containsKey((Object)"groups")) {
            QDLStem groupStem = arg.get("groups").asStem();
            groups = groupStem.values();
        } else {
            groups = new ArrayList();
        }
        if (arg.containsKey((Object)"search_attributes")) {
            QDLStem searchAttr = arg.get("search_attributes").asStem();
            HashMap<String, LDAPConfigurationUtil.AttributeEntry> attrs = new HashMap<String, LDAPConfigurationUtil.AttributeEntry>();
            for (Object key : searchAttr.keySet()) {
                String attrName = String.valueOf(searchAttr.get(key));
                boolean isGroup = groups.contains(attrName);
                boolean isList = lists.contains(attrName);
                if (isList && isGroup) {
                    throw new IllegalArgumentException("You cannot have a \"" + attrName + "\" be both a group and a list. ");
                }
                String rename = attrName;
                if (renames != null && renames.containsKey((Object)attrName)) {
                    rename = renames.getString(attrName);
                }
                LDAPConfigurationUtil.AttributeEntry attributeEntry = new LDAPConfigurationUtil.AttributeEntry(attrName, rename, isList, isGroup);
                attrs.put(attrName, attributeEntry);
            }
            if (!attrs.isEmpty()) {
                ldapCfg.setSearchAttributes(attrs);
            }
        }
    }

    @Override
    public QDLStem toQDL() {
        QDLStem stem = super.toQDL();
        LDAPConfigurationUtil cUtil = new LDAPConfigurationUtil();
        LDAPConfiguration cfg2 = (LDAPConfiguration)this.getConfiguration();
        this.addToStem(stem, "type", "ldap");
        this.addToStem(stem, "claim_name", cfg2.getSearchNameKey());
        this.addToStem(stem, "address", cfg2.getServer());
        this.addToStem(stem, "search_base", cfg2.getSearchBase());
        this.addToStem(stem, "context", cfg2.getContextName());
        this.addToStem(stem, "filter", cfg2.getAdditionalFilter());
        this.addToStem(stem, "port", new Long(cfg2.getPort()));
        this.addToStem(stem, "auth_type", cUtil.getAuthName(cfg2.getAuthType()));
        this.addToStem(stem, "ldap_name", cfg2.getSearchFilterAttribute());
        if (cfg2.hasSearchScope()) {
            StemUtility.put((QDLStem)stem, (Object)"search_scope", (Object)cfg2.getSearchScope());
        }
        if (cfg2.getAuthType() == 10) {
            StemUtility.put((QDLStem)stem, (Object)"password", (Object)cfg2.getPassword());
            StemUtility.put((QDLStem)stem, (Object)"username", (Object)cfg2.getSecurityPrincipal());
        }
        if (cfg2.getSearchAttributes() != null && !cfg2.getSearchAttributes().isEmpty()) {
            ArrayList<String> groups = new ArrayList<String>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> isList = new ArrayList<String>();
            QDLStem renames = new QDLStem();
            for (String key : cfg2.getSearchAttributes().keySet()) {
                LDAPConfigurationUtil.AttributeEntry attributeEntry = (LDAPConfigurationUtil.AttributeEntry)cfg2.getSearchAttributes().get(key);
                names.add(attributeEntry.sourceName);
                if (attributeEntry.targetName != null && !attributeEntry.targetName.equals(attributeEntry.sourceName)) {
                    StemUtility.put((QDLStem)renames, (Object)attributeEntry.sourceName, (Object)attributeEntry.targetName);
                }
                if (attributeEntry.isGroup) {
                    groups.add(attributeEntry.sourceName);
                }
                if (attributeEntry.isList) {
                    isList.add(attributeEntry.sourceName);
                }
                QDLStem nameStem = new QDLStem();
                nameStem.addList(names);
                StemUtility.put((QDLStem)stem, (Object)"search_attributes", (Object)nameStem);
                if (groups.size() != 0) {
                    QDLStem groupStem = new QDLStem();
                    groupStem.addList(groups);
                    StemUtility.put((QDLStem)stem, (Object)"groups", (Object)groupStem);
                }
                if (isList.size() != 0) {
                    QDLStem listStem = new QDLStem();
                    listStem.addList(isList);
                    StemUtility.put((QDLStem)stem, (Object)"lists", (Object)listStem);
                }
                if (renames.size() == 0) continue;
                StemUtility.put((QDLStem)stem, (Object)"rename", (Object)renames);
            }
        }
        return stem;
    }

    @Override
    public ClaimSourceConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new LDAPConfiguration();
        }
        return this.configuration;
    }
}

