/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.LDAPClaimsSource;
import org.qdl_lang.variables.QDLStem;

public class NCSALDAPClaimSource
extends LDAPClaimsSource {
    public static final String DEFAULT_SEACH_NAME = "uid";
    String rawDefaultConfig = " {\n        \"ldap\": {\n          \"id\": \"ncsa-default\",\n          \"name\": \"ncsa-default\",\n          \"address\": \"ldap4.ncsa.illinois.edu, ldap2.ncsa.illinois.edu,ldap1.ncsa.illinois.edu\",\n          \"port\": 636,\n          \"enabled\": true,\n          \"authorizationType\": \"none\",\n          \"failOnError\": false,\n          \"notifyOnFail\": false,\n          \"searchAttributes\": [\n            {\n              \"name\": \"mail\",\n              \"returnAsList\": false,\n              \"returnName\": \"email\"\n            },\n            {\n              \"name\": \"cn\",\n              \"returnAsList\": false,\n              \"returnName\": \"name\"\n            },\n            {\n              \"name\": \"uidNumber\",\n              \"returnAsList\": false,\n              \"returnName\": \"uidNumber\"\n            },\n            {\n              \"name\": \"uid\",\n              \"returnAsList\": false,\n              \"returnName\": \"uid\"\n            },\n            {\n              \"name\": \"memberOf\",\n              \"isGroup\": true,\n              \"returnAsList\": false,\n              \"returnName\": \"isMemberOf\"\n            }\n          ],\n          \"searchBase\": \"ou=People,dc=ncsa,dc=illinois,dc=edu\",\n          \"searchName\": \"uid\",\n          \"searchFilterAttribute\": \"uid\",\n          \"contextName\": \"\",\n          \"ssl\": {\n            \"keystore\": {},\n            \"tlsVersion\": \"TLS\",\n            \"useJavaTrustStore\": true,\n          }\n        }\n      }";

    public NCSALDAPClaimSource() {
    }

    public NCSALDAPClaimSource(QDLStem stem) {
        super(stem);
    }

    public NCSALDAPClaimSource(QDLStem stem, OA2SE oa2SE) {
        super(stem, oa2SE);
    }

    public NCSALDAPClaimSource(String claimName) {
        ServletDebugUtil.trace((Object)this, (String)"In constructor.");
        if (claimName != null && !claimName.isEmpty()) {
            this.getLDAPCfg().setSearchFilterAttribute(claimName);
        } else {
            this.getLDAPCfg().setSearchFilterAttribute("sub");
        }
        ServletDebugUtil.trace((Object)this, (String)("Set the search filter attribute =\"" + this.getLDAPCfg().getSearchFilterAttribute() + "\"."));
    }

    public NCSALDAPClaimSource(LDAPConfiguration ldapConfiguration, MyLoggingFacade myLogger) {
        super(ldapConfiguration, myLogger);
    }

    public NCSALDAPClaimSource(OA2SE oa2SE) {
        super(oa2SE);
    }

    protected void createDefaultConfig() {
        if (!this.hasConfiguration()) {
            LDAPConfigurationUtil util = new LDAPConfigurationUtil();
            JSONObject cfg = JSONObject.fromObject((Object)this.rawDefaultConfig);
            LDAPConfiguration x = util.fromJSON(cfg);
            ServletDebugUtil.trace((Object)this, (String)"In init(). Setting default configuration");
            this.setConfiguration((ClaimSourceConfiguration)x);
        }
    }

    @Override
    public ClaimSourceConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.createDefaultConfig();
        }
        return this.configuration;
    }

    @Override
    public String toString() {
        return "NCSALDAPClaimSource{currentServerAddress='" + this.currentServerAddress + "'}";
    }
}

