/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import edu.uiuc.ncsa.security.util.scripting.ScriptRuntimeEngine;
import edu.uiuc.ncsa.security.util.scripting.ScriptingConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.server.claims.ClaimSource;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.oauth2.flows.FlowStates2;
import org.oa4mp.server.loader.oauth2.servlet.OA2DiscoveryServlet;
import org.oa4mp.server.loader.oauth2.state.ScriptRuntimeEngineFactory;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;

public class OA2ClaimsUtil
implements ScriptingConstants {
    boolean deepDebugOn = true;
    protected OA2ServiceTransaction transaction;
    OA2SE oa2se;
    ScriptRuntimeEngine scriptRuntimeEngine = null;

    public OA2ClaimsUtil(OA2SE oa2se, OA2ServiceTransaction transaction) {
        this.oa2se = oa2se;
        this.transaction = transaction;
    }

    public ScriptRuntimeEngine getScriptRuntimeEngine() {
        if (this.scriptRuntimeEngine == null) {
            this.scriptRuntimeEngine = ScriptRuntimeEngineFactory.createRTE(this.oa2se, this.transaction, this.getOA2Client().getConfig());
        }
        return this.scriptRuntimeEngine;
    }

    public JSONObject setAccountingInformation(HttpServletRequest request, JSONObject claims) {
        this.dbg(this, "Starting to process basic claims");
        if (this.transaction.hasAuthTime()) {
            claims.put((Object)"auth_time", (Object)Long.toString(this.transaction.getAuthTime().getTime() / 1000L));
        }
        claims.put((Object)"exp", (Object)(System.currentTimeMillis() / 1000L + 900L));
        claims.put((Object)"iat", (Object)(System.currentTimeMillis() / 1000L));
        if (this.transaction.hasAuthTime()) {
            claims.put((Object)"auth_time", (Object)Long.toString(this.transaction.getAuthTime().getTime() / 1000L));
        }
        if (this.transaction.getNonce() != null && 0 < this.transaction.getNonce().length()) {
            claims.put((Object)"nonce", (Object)this.transaction.getNonce());
        }
        return claims;
    }

    public JSONObject initializeClaims(HttpServletRequest request, JSONObject claims) {
        this.dbg(this, "Starting to process basic claims");
        String issuer = null;
        List admins = this.oa2se.getPermissionStore().getAdmins(this.transaction.getClient().getIdentifier());
        for (Identifier adminID : admins) {
            AdminClient ac = (AdminClient)this.oa2se.getAdminClientStore().get((Object)adminID);
            if (ac == null || ac.getIssuer() == null) continue;
            issuer = ac.getIssuer();
            break;
        }
        if (issuer == null) {
            issuer = ((OA2Client)this.transaction.getClient()).getIssuer();
        }
        if (issuer == null) {
            issuer = OA2DiscoveryServlet.getIssuer(request);
        }
        claims.put((Object)"iss", (Object)issuer);
        claims.put((Object)"sub", (Object)this.transaction.getUsername());
        claims.put((Object)"aud", (Object)this.transaction.getClient().getIdentifierString());
        return this.setAccountingInformation(request, claims);
    }

    protected void checkRequiredScopes(OA2ServiceTransaction t) throws Throwable {
        if (this.oa2se.isOIDCEnabled()) {
            if (t.getOA2Client().isPublicClient() && !t.getScopes().contains("openid")) {
                throw new OA2GeneralError("invalid_scope", "invalid scope: no open id scope", 401, null, (BaseClient)t.getClient());
            }
            if (t.getOA2Client().useStrictScopes() && t.getOA2Client().getScopes().contains("openid") && !t.getScopes().contains("openid")) {
                throw new OA2GeneralError("invalid_scope", "invalid scope: no open id scope", 401, null, (BaseClient)t.getClient());
            }
        }
    }

    protected ScriptRunRequest newSRR(final OA2ServiceTransaction transaction, final String phase) {
        ScriptRunRequest initReq = new ScriptRunRequest(){
            String p;
            {
                this.p = phase;
            }

            public Map<String, Object> getArgs() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("claims", transaction.getUserMetaData());
                JSONObject proxyState = transaction.getProxyState();
                if (proxyState.isEmpty()) {
                    map.put("proxy_claims", new JSONObject());
                } else {
                    proxyState.getJSONObject("claims");
                    map.put("proxy_claims", proxyState.getJSONObject("claims"));
                }
                map.put("scopes", transaction.getScopes());
                map.put("audience", transaction.getAudience());
                map.put("resource", transaction.getResource());
                map.put("eas", transaction.getExtendedAttributes());
                map.put("flow_states", (Object)transaction.getFlowStates());
                map.put("claim_sources", transaction.getClaimSources(OA2ClaimsUtil.this.oa2se));
                return map;
            }

            public String getAction() {
                return this.p;
            }

            public boolean returnArgs() {
                return true;
            }

            public String getResponseArgName() {
                return "";
            }

            public boolean hasReturnedValue() {
                return false;
            }
        };
        return initReq;
    }

    protected void handleSREResponse(ScriptRunResponse scriptRunResponse) throws IOException {
        switch (scriptRunResponse.getReturnCode()) {
            case 1: {
                this.transaction.setUserMetaData((JSONObject)scriptRunResponse.getReturnedValues().get("claims"));
                this.transaction.setFlowStates((FlowStates2)((Object)scriptRunResponse.getReturnedValues().get("flow_states")));
                this.transaction.setClaimsSources((List)scriptRunResponse.getReturnedValues().get("claim_sources"));
            }
            case 0: {
                return;
            }
        }
        throw new NotImplementedException("Error: other script runtime reponses not implemented yet.");
    }

    public JSONObject processAuthorizationClaims(HttpServletRequest request) throws Throwable {
        JSONObject claims = this.transaction.getUserMetaData();
        if (claims == null) {
            claims = new JSONObject();
        }
        claims = this.initializeClaims(request, claims);
        this.transaction.setUserMetaData(claims);
        OA2Client client = this.getOA2Client();
        this.checkRequiredScopes(this.transaction);
        this.dbg(this, "Done with basic claims = " + claims.toString(1));
        if (this.transaction.getOA2Client().isPublicClient()) {
            this.oa2se.getTransactionStore().save((Identifiable)this.transaction);
            return claims;
        }
        this.dbg(this, "Starting to process server default claims");
        if (this.oa2se != null && this.oa2se.getClaimSource() != null && this.oa2se.getClaimSource().isEnabled() && this.oa2se.getClaimSource().isRunOnlyAtAuthorization()) {
            DebugUtil.trace((Object)this, (String)("Service environment has a claims source enabled=" + String.valueOf(this.oa2se.getClaimSource())));
            this.oa2se.getClaimSource().process(claims, request, (ServiceTransaction)this.transaction);
        } else {
            this.dbg(this, "Service environment has a claims no source enabled during authorization");
        }
        this.dbg(this, "Starting to process Client runtime and sources at authorization.");
        if (client.getConfig() == null || client.getConfig().isEmpty()) {
            return claims;
        }
        this.dbg(this, "executing runtime");
        FlowStates2 flowStates = new FlowStates2();
        this.transaction.setFlowStates(flowStates);
        List<Object> claimsSources = new ArrayList();
        ScriptRunRequest scriptRunRequest = null;
        if (this.getScriptRuntimeEngine() != null) {
            scriptRunRequest = this.newSRR(this.transaction, "init");
            this.handleSREResponse(this.getScriptRuntimeEngine().run(scriptRunRequest));
            flowStates = this.transaction.getFlowStates();
            claimsSources = this.transaction.getClaimSources(this.oa2se);
            claims = this.transaction.getUserMetaData();
        }
        this.dbg(this, "processing flows");
        if (flowStates.getClaims) {
            this.dbg(this, "Doing preprocessing");
            this.dbg(this, "Claims allowed, creating sources from configuration");
            if (this.getScriptRuntimeEngine() != null) {
                scriptRunRequest = this.newSRR(this.transaction, "pre_auth");
                this.handleSREResponse(this.getScriptRuntimeEngine().run(scriptRunRequest));
                flowStates = this.transaction.getFlowStates();
                claimsSources = this.transaction.getClaimSources(this.oa2se);
                claims = this.transaction.getUserMetaData();
            }
            if (!claimsSources.isEmpty()) {
                for (int i = 0; i < claimsSources.size(); ++i) {
                    ClaimSource claimSource = (ClaimSource)claimsSources.get(i);
                    if (claimSource.isRunOnlyAtAuthorization()) {
                        claimSource.process(claims, request, (ServiceTransaction)this.transaction);
                    }
                    if (!flowStates.acceptRequests) {
                        this.transaction.setUserMetaData(claims);
                        this.transaction.setFlowStates(flowStates);
                        this.oa2se.getTransactionStore().save((Identifiable)this.transaction);
                        throw new OA2GeneralError("access_denied", "access denied", 401, null, (BaseClient)this.transaction.getOA2Client());
                    }
                    this.dbg(this, "user info for claim source #" + String.valueOf(claimSource) + " = " + claims.toString(1));
                }
            }
        }
        this.transaction.setUserMetaData(claims);
        this.transaction.setFlowStates(flowStates);
        if (this.getScriptRuntimeEngine() != null) {
            scriptRunRequest = this.newSRR(this.transaction, "post_auth");
            this.handleSREResponse(this.getScriptRuntimeEngine().run(scriptRunRequest));
            this.transaction.setScriptState(this.getScriptRuntimeEngine().serializeState(this.transaction.getScriptStateSerializationVersion()));
            this.transaction.setScriptStateSerialzationVersion("2.1");
        }
        this.oa2se.getTransactionStore().save((Identifiable)this.transaction);
        return this.transaction.getUserMetaData();
    }

    protected OA2Client getOA2Client() {
        return this.transaction.getOA2Client();
    }

    public JSONObject processClaims() throws Throwable {
        JSONObject claims = this.transaction.getUserMetaData();
        if (claims == null) {
            claims = new JSONObject();
        }
        if (this.transaction.getOA2Client().isPublicClient()) {
            return claims;
        }
        FlowStates2 flowStates = this.transaction.getFlowStates();
        if (!flowStates.acceptRequests) {
            throw new OA2GeneralError("access_denied", "access denied", 401, null, (BaseClient)this.transaction.getOA2Client());
        }
        OA2Client client = this.getOA2Client();
        if (client.getConfig() == null || client.getConfig().isEmpty()) {
            return claims;
        }
        List<ClaimSource> claimsSources = this.transaction.getClaimSources(this.oa2se);
        ScriptRunRequest scriptRunRequest = null;
        if (this.getScriptRuntimeEngine() != null) {
            this.getScriptRuntimeEngine().deserializeState(this.transaction.getScriptState(), this.transaction.getScriptStateSerializationVersion());
            scriptRunRequest = this.newSRR(this.transaction, "pre_token");
            this.handleSREResponse(this.getScriptRuntimeEngine().run(scriptRunRequest));
            flowStates = this.transaction.getFlowStates();
            claimsSources = this.transaction.getClaimSources(this.oa2se);
            claims = this.transaction.getUserMetaData();
        }
        this.dbg(this, "BEFORE invoking claim sources, claims are = " + claims.toString(1));
        if (flowStates.getClaims) {
            DebugUtil.trace((Object)this, (String)"Claims allowed, creating sources from configuration");
            if (!claimsSources.isEmpty()) {
                for (int i = 0; i < claimsSources.size(); ++i) {
                    BasicClaimsSourceImpl b;
                    ClaimSource claimSource = claimsSources.get(i);
                    if (claimSource.isRunOnlyAtAuthorization()) continue;
                    if (claimSource instanceof BasicClaimsSourceImpl && (b = (BasicClaimsSourceImpl)claimSource).getOa2SE() == null) {
                        b.setOa2SE(this.oa2se);
                    }
                    DebugUtil.trace((Object)this, (String)("Before invoking claim source, new claims = " + claims.toString(1)));
                    claimSource.process(claims, (ServiceTransaction)this.transaction);
                    DebugUtil.trace((Object)this, (String)("After invoking claim source, new claims = " + claims.toString(1)));
                }
            }
        }
        this.dbg(this, "Ready for post-processing");
        if (this.getScriptRuntimeEngine() != null) {
            scriptRunRequest = this.newSRR(this.transaction, "post_token");
            this.handleSREResponse(this.getScriptRuntimeEngine().run(scriptRunRequest));
            claims = this.transaction.getUserMetaData();
            flowStates = this.transaction.getFlowStates();
        }
        this.checkRequiredClaims(claims);
        this.oa2se.getTransactionStore().save((Identifiable)this.transaction);
        this.dbg(this, "Done with special claims=" + claims.toString(1));
        if (!flowStates.acceptRequests) {
            this.dbg(this, "Access denied for user name = " + this.transaction.getUsername());
            throw new OA2GeneralError("access_denied", "access denied", 401, null, (BaseClient)this.transaction.getOA2Client());
        }
        return this.transaction.getUserMetaData();
    }

    protected void checkRequiredClaim(JSONObject claims, String claimKey) {
        if (claims.containsKey((Object)claimKey)) {
            if (this.isEmpty(claims.getString(claimKey))) {
                throw new OA2GeneralError("server_error", "Missing " + claimKey + " claim", 500, null);
            }
        } else {
            throw new OA2GeneralError("server_error", "Missing " + claimKey + " claim", 500, null);
        }
    }

    protected void checkRequiredClaims(JSONObject claims) {
        if (this.oa2se.isOIDCEnabled()) {
            this.checkRequiredClaim(claims, "sub");
        }
        for (Object key : claims.keySet()) {
            String k;
            if (key == null) {
                DebugUtil.error((Object)this, (String)"Null claim key encountered.");
                claims.remove(null);
            }
            if ((k = key.toString()).isEmpty()) {
                DebugUtil.error((Object)this, (String)"Empty claim key encountered.");
                claims.remove(key);
            }
            if (claims.get(key) != null && !claims.getString(k).isEmpty()) continue;
            DebugUtil.trace((Object)this, (String)("Removed empty claim \"" + String.valueOf(key) + "\""));
            claims.remove(key);
        }
    }

    protected boolean isEmpty(String x) {
        return x == null || 0 == x.length();
    }

    protected void dbg(Object c, String x) {
        if (this.deepDebugOn) {
            DebugUtil.trace((Object)c, (String)x);
        }
    }
}

