/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.loader.oauth2.claims;

import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.server.UnsupportedScopeException;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.server.loader.oauth2.claims.BasicClaimsSourceImpl;
import org.oa4mp.server.loader.qdl.scripting.OA2State;
import org.oa4mp.server.loader.qdl.scripting.QDLRuntimeEngine;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.QDLValue;

public class QDLHeadersClaimsSource
extends BasicClaimsSourceImpl {
    public static final String PREFIX_KEY = "prefix";
    public static final String REGEX_KEY = "regex";
    String prefix;
    String regex;
    OA2State oa2State;

    public QDLHeadersClaimsSource(ClaimSourceConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public QDLHeadersClaimsSource() {
    }

    public QDLHeadersClaimsSource(QDLStem stem) {
        super(stem);
    }

    public String getPrefix() {
        if (this.prefix == null) {
            this.prefix = "oidc_claim_";
        }
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRegex() {
        return this.regex != null;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public OA2State getOa2State() {
        return this.oa2State;
    }

    public void setOa2State(OA2State oa2State) {
        this.oa2State = oa2State;
    }

    public boolean hasOA2State() {
        return this.oa2State != null;
    }

    @Override
    protected JSONObject realProcessing(JSONObject claims, HttpServletRequest request, ServiceTransaction transaction) throws UnsupportedScopeException {
        if (!this.hasOA2State()) {
            return claims;
        }
        QDLStem authHeaders = this.getOa2State().getValue(QDLRuntimeEngine.AUTH_HEADERS_VAR).asStem();
        if (authHeaders == null || authHeaders.isEmpty()) {
            return claims;
        }
        QDLStem out = new QDLStem();
        for (Object k : authHeaders.keySet()) {
            if (!(k instanceof String)) continue;
            String key = (String)k;
            if (this.isRegex()) {
                if (!key.matches(this.getRegex())) continue;
                out.put(key, authHeaders.get(key));
                continue;
            }
            if (!key.startsWith(this.getPrefix())) continue;
            QDLValue v = authHeaders.get(key);
            StemUtility.put((QDLStem)out, (Object)key.substring(this.getPrefix().length()), (Object)v);
        }
        claims.putAll((Map)((JSONObject)out.toJSON()));
        return claims;
    }

    @Override
    public JSONObject process(JSONObject claims, ServiceTransaction transaction) throws UnsupportedScopeException {
        throw new NotImplementedException("A servlet request must be supplied for this handler");
    }

    @Override
    public boolean isRunOnlyAtAuthorization() {
        return true;
    }

    @Override
    public QDLStem toQDL() {
        QDLStem arg = super.toQDL();
        StemUtility.put((QDLStem)arg, (Object)"type", (Object)"header");
        if (!StringUtils.isTrivial((String)this.getPrefix())) {
            if (this.isRegex()) {
                StemUtility.put((QDLStem)arg, (Object)REGEX_KEY, (Object)this.getPrefix());
            } else {
                StemUtility.put((QDLStem)arg, (Object)PREFIX_KEY, (Object)this.getPrefix());
            }
        }
        return arg;
    }

    @Override
    public void fromQDL(QDLStem arg) {
        super.fromQDL(arg);
        HashMap<String, String> xp = new HashMap<String, String>();
        ClaimSourceConfiguration cfg = new ClaimSourceConfiguration();
        if (arg.containsKey((Object)PREFIX_KEY)) {
            this.setPrefix(arg.getString(PREFIX_KEY).toLowerCase());
            xp.put(PREFIX_KEY, arg.getString(PREFIX_KEY));
        }
        if (arg.containsKey((Object)REGEX_KEY)) {
            this.setRegex(arg.getString(REGEX_KEY));
            xp.put(REGEX_KEY, arg.getString(REGEX_KEY));
        }
        cfg.setProperties(xp);
        this.setConfiguration(cfg);
    }
}

